/*
 * Decompiled with CFR 0.152.
 */
package org.encog.plugin.system;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.encog.plugin.EncogPluginLogging1;

public class SystemLoggingPlugin
implements EncogPluginLogging1 {
    private int currentLevel = 4;
    private boolean logConsole = false;

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    @Override
    public final int getLogLevel() {
        return this.currentLevel;
    }

    @Override
    public final String getPluginDescription() {
        return "This is the built in logging for Encog, it logs to either a file or System.out";
    }

    @Override
    public final String getPluginName() {
        return "HRI-System-Logging";
    }

    @Override
    public final int getPluginType() {
        return 1;
    }

    @Override
    public final void log(int level, String message) {
        if (this.currentLevel <= level) {
            Date now = new Date();
            StringBuilder line = new StringBuilder();
            line.append(now.toString());
            line.append(" [");
            switch (level) {
                case 3: {
                    line.append("CRITICAL");
                    break;
                }
                case 2: {
                    line.append("ERROR");
                    break;
                }
                case 1: {
                    line.append("INFO");
                    break;
                }
                case 0: {
                    line.append("DEBUG");
                    break;
                }
                default: {
                    line.append("?");
                }
            }
            line.append("][");
            line.append(Thread.currentThread().getName());
            line.append("]: ");
            line.append(message);
            if (this.logConsole) {
                if (this.currentLevel > 2) {
                    System.err.println(line.toString());
                } else {
                    System.out.println(line.toString());
                }
            }
        }
    }

    @Override
    public final void log(int level, Throwable t) {
        this.log(level, SystemLoggingPlugin.getStackTrace(t));
    }

    public final void setLogLevel(int level) {
        this.currentLevel = level;
    }

    public final void startConsoleLogging() {
        this.stopLogging();
        this.logConsole = true;
        this.setLogLevel(0);
    }

    public final void stopLogging() {
        this.logConsole = false;
    }

    @Override
    public int getPluginServiceType() {
        return 1;
    }
}

