/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import org.encog.ml.data.MLDataSet;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.ContainsFlat;

public final class EncogValidate {
    public static void validateNetworkForTraining(ContainsFlat network, MLDataSet training) {
        int inputCount = network.getFlat().getInputCount();
        int outputCount = network.getFlat().getOutputCount();
        if (inputCount != training.getInputSize()) {
            throw new NeuralNetworkError("The input layer size of " + inputCount + " must match the training input size of " + training.getInputSize() + ".");
        }
        if (training.getIdealSize() > 0 && outputCount != training.getIdealSize()) {
            throw new NeuralNetworkError("The output layer size of " + outputCount + " must match the training input size of " + training.getIdealSize() + ".");
        }
    }

    private EncogValidate() {
    }
}

