/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.time;

import java.util.Date;
import java.util.GregorianCalendar;

public class NumericDateUtil {
    public static final int YEAR_OFFSET = 10000;
    public static final int MONTH_OFFSET = 100;
    public static final int HOUR_OFFSET = 10000;
    public static final int MINUTE_OFFSET = 100;

    public static long date2Long(Date time) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(time);
        int month = gc.get(2) + 1;
        int day = gc.get(5);
        int year = gc.get(1);
        return day + month * 100 + year * 10000;
    }

    public static Date long2Date(long l) {
        long rest = l;
        int year = (int)(rest / 10000L);
        int month = (int)((rest -= (long)(year * 10000)) / 100L);
        int day = (int)(rest -= (long)(month * 100));
        GregorianCalendar gc = new GregorianCalendar(year, month, day);
        return gc.getTime();
    }

    public static Date stripTime(Date time) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(time);
        int month = gc.get(2) + 1;
        int day = gc.get(5);
        int year = gc.get(1);
        GregorianCalendar gc2 = new GregorianCalendar(year, month, day);
        return gc2.getTime();
    }

    public static boolean haveSameDate(Date d1, Date d2) {
        GregorianCalendar gc1 = new GregorianCalendar();
        gc1.setTime(d1);
        GregorianCalendar gc2 = new GregorianCalendar();
        gc2.setTime(d2);
        return gc1.get(5) == gc2.get(5) && gc1.get(5) == gc2.get(5) && gc1.get(1) == gc2.get(1);
    }

    public static Date int2Time(Date date, int i) {
        int rest = i;
        int hour = rest / 10000;
        int minute = (rest -= hour * 10000) / 100;
        int second = rest -= minute * 100;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        int month = gc.get(2) + 1;
        int day = gc.get(5);
        int year = gc.get(1);
        return new GregorianCalendar(year, month, day, hour, minute, second).getTime();
    }

    public static int time2Int(Date time) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(time);
        int hour = gc.get(10);
        int minute = gc.get(12);
        int second = gc.get(13);
        return second + minute * 100 + hour * 10000;
    }

    public static int getYear(long date) {
        return (int)(date / 10000L);
    }

    public static int getMonth(long l) {
        long rest = l;
        int year = (int)(rest / 10000L);
        return (int)((rest -= (long)(year * 10000)) / 100L);
    }

    public static int getMinutePeriod(int time, int period) {
        int rest = time;
        int hour = rest / 10000;
        int minute = (rest -= hour * 10000) / 100;
        int minutes = minute + hour * 60;
        return minutes / period;
    }

    public static long combine(long date, int time) {
        return date * 1000000L + (long)time;
    }

    public static int GetDayOfWeek(long p) {
        Date t = NumericDateUtil.long2Date(p);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(t);
        switch (gc.get(7)) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return -1;
    }
}

