/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import net.java.sen.util.CSVParser;

public class CompoundWordTableCompiler {
    private static final String COMPOUND_CSV_FILENAME = "compound.csv";
    private static final String COMPOUND_TABLE_FILENAME = "compound.sen";
    private static final int PART_OF_SPEECH_START = 2;
    private static final int PART_OF_SPEECH_SIZE = 7;

    public static void buildTable(BufferedReader reader, int partOfSpeechStart, int partOfSpeechSize, String tableFilename) throws IOException {
        String t;
        int line = 0;
        HashMap<String, String> compoundTable = new HashMap<String, String>();
        StringBuffer buffer = new StringBuffer();
        while ((t = reader.readLine()) != null) {
            int i;
            CSVParser parser = new CSVParser(t);
            String[] csv = parser.nextTokens();
            if (csv.length < partOfSpeechSize + partOfSpeechStart) {
                throw new RuntimeException("format error:" + line);
            }
            buffer.setLength(0);
            for (i = partOfSpeechStart; i < partOfSpeechStart + partOfSpeechSize - 1; ++i) {
                buffer.append(csv[i]);
                buffer.append(',');
            }
            buffer.append(csv[partOfSpeechStart + partOfSpeechSize - 1]);
            buffer.append(',');
            for (i = partOfSpeechStart + partOfSpeechSize; i < csv.length - 2; ++i) {
                buffer.append(csv[i]);
                buffer.append(',');
            }
            buffer.append(csv[csv.length - 2]);
            compoundTable.put(buffer.toString(), csv[csv.length - 1]);
        }
        reader.close();
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(tableFilename));
        os.writeObject(compoundTable);
        os.close();
    }

    public static void main(String[] args) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(COMPOUND_CSV_FILENAME), "UTF-8"));
            CompoundWordTableCompiler.buildTable(reader, 2, 7, COMPOUND_TABLE_FILENAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

