var gscr = null;
var fld = null;
var player = null;
var enemy;
var mainTimer = null;
var keydisp = null;

var SCR_WIDTH = 672;
var SCR_HEIGHT = 432;

var TILE_X = 24;
var TILE_Y = 24
var PLAYER_STEP = 6;
var ENEMY_STEP = 3;

var GOLD_X = 16;
var GOLD_Y = 16;

var DIG_TIMEOUT = 162;
var CAUGHT_TIMEOUT = 90;

var ANS_COUNT = null;
var ans_index = null;
var ansid = null;

function preStart()
{
	var ajxAnsCount = new Ajax.Request(
			"./dimg/count", 
			{
				method: 'get', 
				onComplete: ansCountResponse
			});
}

function ansCountResponse(req)
{
	ANS_COUNT = req.responseText - 0;
	ans_index = Math.floor(Math.random()*ANS_COUNT);

	var ajxAnsID = new Ajax.Request(
			"./dimg/id-"+ans_index, 
			{
				method: 'get', 
				onComplete: ansIdResponse
			});
}

function ansIdResponse(req)
{
	ansid = req.responseText;
	ansid = ansid.replace(/[^0-9a-zA-Z_]/g,"");
	checkPrepared();
}

function checkPrepared()
{
	if (ans_index != null && ansid != null)
	{
		$("ldprompt").style.display = "none";
		$("starttrg").style.display = "";
	}
}

function init()
{
	if (void(0) == document.createElementNS)
		document.createElementNS = function(ns,tag){return document.createElement(tag)};
		
	gscr = new GameScreen( $("rscreen") );	
	window.setTimeout("init_2()", 10);
	
}

function init_2()
{
	fld = new Field(gscr, 28, 18);
	keydisp = new KeyDispatcher( document );
	
	player = new PlayerRunner(fld);
	enemy = new EnemyRunner(fld, player);

	player.init();
	player.runner.pos.x = 24;
	player.runner.pos.y = 216;
	player.runner.updatePosition();
	
	enemy.init();
	enemy.runner.pos.x = 624;
	enemy.runner.pos.y = 216;
	enemy.runner.updatePosition();

	mainTimer = window.setTimeout("tick()", 40);
}

function resumePlayer(f)
{
	if (f==void(0))
	{
		gscr.blackout(true);
		mainTimer = window.setTimeout("resumePlayer(true)", 500);
	}
	else
	{
		player.init();
		player.runner.pos.x = 24;
		player.runner.pos.y = 216;
		player.runner.updatePosition();

		enemy.init();
		enemy.runner.pos.x = 624;
		enemy.runner.pos.y = 216;
		enemy.runner.updatePosition();
		
		gscr.blackout(false);
		mainTimer = window.setTimeout("tick()", 40);
	}
}

function completeGame(f)
{
	if (f==void(0))
	{
		window.setTimeout("completeGame(0)", 50);
	}
	else
	{
		if (f<7)
		{
			gscr.frush((f&1)!=0);
		}

		if (f == 10)
		{
			gscr.whiteout(true);
			for(c in fld.chips)
			{
				if (fld.chips[c].charObj)
					fld.chips[c].charObj.dispose();
			}
			
			showIcons(0);
			return;
		}
		window.setTimeout("completeGame(" + (++f) + ")", 200);
	}
}

function showIcons(f)
{
	if ((f%2) == 0)
	{
		var idx = Math.floor(f/2);
		
		if (idx < player.holder.count)
		{
			var hobj = player.holder.golds[idx];

			var cx = GOLD_X * (hobj.g.gobjIndex%8);
			var cy = GOLD_Y * (hobj.g.gobjIndex>>3);
			
			cy += 60;
			cx += (SCR_WIDTH - GOLD_X*8)/2;

			hobj.x = cx;
			hobj.y = cy;
			hobj.onTickEnd = function(o){
				o.g.changeFront();
			};
			
			player.holder.startTick(hobj);
		}
	}
	
	player.holder.tick();
	if (player.holder.toCount == 0)
	{
		var p = document.createElementNS("http://www.w3.org/1999/xhtml", "p");
		p.className = "answer";
		
		var a = document.createElementNS("http://www.w3.org/1999/xhtml", "a");
		a.setAttribute("href", "http://d.hatena.ne.jp/"+ansid+"/");
		a.appendChild( document.createTextNode("id:"+ansid) );

		var img = document.createElementNS("http://www.w3.org/1999/xhtml", "img");
		img.setAttribute("src", "http://www.hatena.ne.jp/users/"+ansid.substring(0,2)+"/"+ansid+"/profile.gif");
		p.appendChild(img);

		p.appendChild(a);
		
		gscr.overlay.appendChild(p);
		
		return;
	}
	
	window.setTimeout("showIcons(" + (++f) + ")", 30);
}

function tick()
{
	keydisp.checkTimeout(40);
	var nextproc = player.tick(keydisp.keyState);
	enemy.tick();
	fld.tick();
	
	player.updatePosition();
	enemy.updatePosition();

	if (nextproc != null)
		nextproc();
	else
		mainTimer = window.setTimeout("tick()", 40);
}

////////////////////////////////////////////////////////////////////

function GameScreen(el)
{
	this.elem = el;
	this.init();
}

function GameScreen_init()
{
	this.elem.style.backgroundColor = "#000";
	this.elem.style.position = "relative";
	this.elem.style.textAlign = "left";
	$A( this.elem.childNodes ).each((function(ch){
		this.elem.removeChild(ch);
	}).bind(this) );
	
	this.overlay = document.createElementNS("http://www.w3.org/1999/xhtml", "div");
	this.overlay.style.position = "absolute";
	this.overlay.style.left = "0";
	this.overlay.style.top = "0";
	this.overlay.style.textAlign = "center";
	this.overlay.style.width  = SCR_WIDTH+ "px";
	this.overlay.style.height = SCR_HEIGHT+ "px";
	this.overlay.style.zIndex = 1;
	
	this.elem.appendChild(this.overlay);
}
GameScreen.prototype.init = GameScreen_init;

function GameScreen_blackout(b)
{
	this.overlay.style.backgroundColor = b?"#000":"";
}
GameScreen.prototype.blackout = GameScreen_blackout;

function GameScreen_whiteout(b)
{
	this.overlay.style.backgroundColor = b?"#fff":"";
}
GameScreen.prototype.whiteout = GameScreen_whiteout;

function GameScreen_frush(b)
{
	this.elem.style.backgroundColor = b?"#fff":"#000";
}
GameScreen.prototype.frush = GameScreen_frush;

//-------------------------------------

function Field(scr,c,r)
{
	this.gscreen = scr;
	this.cols = c;
	this.rows = r;
	this.pxWidth = c*TILE_X;
	this.chips = new Array();
	this.chips.at = (function(x,y){return this.chips[x+y*this.cols];}).bind(this) ;
	this.goldsCount = 0;
	this.tickObjs = new Object();
	
	this.init();
	makeField(this);
	
}

function makeGoal(f)
{
	f.putChipAt(2,0,0);
	f.putChipAt(2,27,0);

	f.setAsGoal(0,0);
	f.setAsGoal(27,0);
}

function makeField(f)
{
	var i;
	f.makeGoal = makeGoal;
	for (i = 0;i < 28;i++)
	{
		f.putChipAt(1,i,15);
		f.putChipAt(4,i,16);
	}

	for (i = 0;i < 5;i++)
	{
		f.putChipAt(1,1,14-i);
		f.putChipAt(1,26,14-i);
	}

	for (i = 0;i < 14;i++)
	{
		f.putChipAt(2,0,14-i);
		f.putChipAt(2,27,14-i);
	}

	for (i = 0;i < 26;i++)
	{
		f.putChipAt(3,1+i,1);
		f.putChipAt(3,1+i,8);
	}

	f.putChipAt(2,3,8);
	f.putChipAt(2,4,8);
	f.putChipAt(2,5,8);

	f.putChipAt(2,9,8);
	f.putChipAt(2,10,8);
	f.putChipAt(2,11,8);

	f.putChipAt(2,15,8);
	f.putChipAt(2,16,8);
	f.putChipAt(2,17,8);

	f.putChipAt(2,20,8);
	f.putChipAt(2,21,8);
	f.putChipAt(2,22,8);
	f.putChipAt(2,23,8);

	///////
	f.putChipAt(2,2,10);
	f.putChipAt(1,3,10);
	f.putChipAt(1,4,11);
	f.putChipAt(2,5,11);
	f.putChipAt(2,6,11);
	f.putChipAt(1,7,12);
	f.putChipAt(2,8,12);
	f.putChipAt(1,9,12);
	f.putChipAt(2,10,13);
	f.putChipAt(2,11,13);
	f.putChipAt(1,12,13);

	f.putChipAt(2,15,13);
	f.putChipAt(2,16,13);
	f.putChipAt(2,17,13);
	f.putChipAt(2,18,12);
	f.putChipAt(1,19,12);
	f.putChipAt(2,20,12);
	f.putChipAt(1,21,11);
	f.putChipAt(1,22,11);
	f.putChipAt(1,23,11);
	f.putChipAt(2,24,10);
	f.putChipAt(1,25,10);
	f.putChipAt(1,26,10);
////////////////////
	f.putObjAt(1,13,13);
	f.putObjAt(1,14,13);
////////////////////
	f.putObjAt(1,10,12);
	f.putObjAt(1,11,12);
	f.putObjAt(1,12,12);

	f.putObjAt(1,15,12);
	f.putObjAt(1,16,12);
	f.putObjAt(1,17,12);
////////////////////
	f.putObjAt(1,7,11);
	f.putObjAt(1,8,11);
	f.putObjAt(1,9,11);

	f.putObjAt(1,18,11);
	f.putObjAt(1,19,11);
	f.putObjAt(1,20,11);

////////////////////
	f.putObjAt(1,2,2);
	f.putObjAt(1,2,3);
	f.putObjAt(1,2,4);
	f.putObjAt(1,2,5);
	f.putObjAt(1,2,6);

	f.putObjAt(1,5,2);
	f.putObjAt(1,5,3);
	f.putObjAt(1,5,4);
	f.putObjAt(1,5,5);
	f.putObjAt(1,5,6);

	f.putObjAt(1,3,4);
	f.putObjAt(1,4,4);
////////////////////
	f.putObjAt(1,7,4);
	f.putObjAt(1,7,5);

	f.putObjAt(1,8,3);
	f.putObjAt(1,9,3);
	f.putObjAt(1,8,6);
	f.putObjAt(1,9,6);
	f.putObjAt(1,9,4);
	f.putObjAt(1,9,5);
////////////////////
	f.putObjAt(1,12,2);
	f.putObjAt(1,12,3);
	f.putObjAt(1,12,4);
	f.putObjAt(1,12,5);
	f.putObjAt(1,12,6);

	f.putObjAt(1,11,3);
	f.putObjAt(1,13,3);
////////////////////
	f.putObjAt(1,15,4);
	f.putObjAt(1,15,5);

	f.putObjAt(1,16,3);
	f.putObjAt(1,16,4);
	f.putObjAt(1,16,6);

	f.putObjAt(1,17,4);
	f.putObjAt(1,17,6);
////////////////////
	f.putObjAt(1,19,3);
	f.putObjAt(1,19,4);
	f.putObjAt(1,19,5);
	f.putObjAt(1,19,6);
	f.putObjAt(1,20,3);
	f.putObjAt(1,21,4);
	f.putObjAt(1,21,5);
	f.putObjAt(1,21,6);
////////////////////
	f.putObjAt(1,23,4);
	f.putObjAt(1,23,5);

	f.putObjAt(1,24,3);
	f.putObjAt(1,25,3);
	f.putObjAt(1,24,6);
	f.putObjAt(1,25,6);
	f.putObjAt(1,25,4);
	f.putObjAt(1,25,5);
}

function Field_reputObjAt(c, x, y)
{
	var chip = this.chips.at(x, y);
	if (chip.mapObject != null)
	{
		return false;
	}
	
	chip.putObject(c);
	
	return true;
}
Field.prototype.reputObjAt = Field_reputObjAt;

function Field_putObjAt(type, x, y)
{
	var url = null;
	
	if (type == Field.FOBJ_GOLD)
	{
		var c = new CharacterObj(gscr.elem, "./dimg/p"+ans_index+".png", GOLD_X, GOLD_Y);
		c.padding = 4;
		c.createView("./images/o0.gif");
		c.type = Field.FOBJ_GOLD;
		c.gobjIndex = this.goldsCount;
		c.setFramePos(c.gobjIndex, 0);
		this.goldsCount++;
	
		this.chips.at(x, y).putObject(c);
	}
}
Field.prototype.putObjAt = Field_putObjAt;

function Field_setAsGoal(x, y)
{
	this.chips.at(x, y).goal = true;
	this.chips.at(x, y).charObj.changeFront("./images/exit.gif");
}
Field.prototype.setAsGoal = Field_setAsGoal;

function Field_putChipAt(type, x, y)
{
	var url = null;
	
	switch(type)
	{
	case Field.FCHIP_NWALL: url="./images/f1.gif"; break;
	case Field.FCHIP_RD:    url="./images/f2.gif"; break;
	case Field.FCHIP_BAR:   url="./images/f3.gif"; break;
	case Field.FCHIP_ROBUST:url="./images/f4.png"; break;
	}
	
	if (url == null)
		return;
	
	
	
	var c = new CharacterObj(gscr.elem, url, TILE_X, TILE_Y);
	c.createView();
	this.chips.at(x, y).setCharObj(c);
	this.chips.at(x, y).type = type;
}
Field.prototype.putChipAt = Field_putChipAt;

function Field_onCompleted()
{
	this.makeGoal(this);
}
Field.prototype.onCompleted = Field_onCompleted;

function Field_init()
{
	var x, y;
	for (x = 0;x < this.cols;x++)
	{
		for (y = 0;y < this.rows;y++)
		{
			this.chips[x+y*this.cols] = new FieldChip(this, x, y);
		}
	}
	this.makeGoal = function(){};
}
Field.prototype.init = Field_init;

function Field_tick()
{
	for (i in this.tickObjs)
	{
		this.tickObjs[i].tick();
	}
}
Field.prototype.tick = Field_tick;

Field.FCHIP_NULL  = 0;
Field.FCHIP_NWALL = 1;
Field.FCHIP_RD    = 2;
Field.FCHIP_BAR   = 3;
Field.FCHIP_ROBUST= 4;
Field.FCHIP_DWALL = 5;

Field.FOBJ_GOLD   = 1;

Field.isStandable = function (t) {
	if (t.locked)
		return true;
	return (t.type != Field.FCHIP_NULL) && (t.type != Field.FCHIP_BAR) && (t.type != Field.FCHIP_DWALL);
};

Field.isThroughable = function (t) {

	return (t != Field.FCHIP_NWALL) && (t != Field.FCHIP_ROBUST);
};

function FieldChip(f, tx, ty)
{
	this.parentFld = f;
	this.charObj = null;
	this.tileX = tx;
	this.tileY = ty;
	this.chipid = tx+","+ty;
	this.type = 0;
	this.mapObject = null;
	this.digCount = 0;
	this.locked = false;
	this.goal = false;
}

function FieldChip_setCharObj(co)
{
	if (this.charObj != null)
		this.charObj.dispose();

	this.charObj = co;
	co.setViewPos(this.tileX*TILE_X, this.tileY*TILE_Y);
}
FieldChip.prototype.setCharObj = FieldChip_setCharObj;

function FieldChip_putObject(mo)
{
	this.mapObject = mo;
	mo.setViewPos(this.tileX*TILE_X, this.tileY*TILE_Y);
}
FieldChip.prototype.putObject = FieldChip_putObject;

function FieldChip_removeObject()
{
	var ret = this.mapObject;
	this.mapObject = null;
	return ret;
}
FieldChip.prototype.removeObject = FieldChip_removeObject;

function FieldChip_getAbove()
{
	return this.parentFld.chips.at( this.tileX, this.tileY-1 );
}
FieldChip.prototype.getAbove = FieldChip_getAbove;

function FieldChip_dig()
{
	if (this.digCount > 0)
		return;
	if (this.type != Field.FCHIP_NWALL)
		return;
		
	var ab = this.getAbove();
	if (ab == void(0)) return;
	
	if (!Field.isThroughable(ab.type))
		return;
	
	this.parentFld.tickObjs[this.chipid] = this;
	this.type = Field.FCHIP_DWALL;
	this.digCount = 1;
	this.framePos = 0;
}
FieldChip.prototype.dig = FieldChip_dig;

function FieldChip_grab()
{
	var ret = null;
	if (this.mapObject != null)
	{
		ret = this.mapObject;
		this.removeObject();
	}
	return ret;
}
FieldChip.prototype.grab = FieldChip_grab;

function FieldChip_tick()
{
	if (this.digCount > 0)
	{
		switch(this.digCount)
		{
		case 1:
		case 3:
		case 5:
			this.charObj.setFramePos(++this.framePos, 0);
			break;
		case (DIG_TIMEOUT-11):
		case (DIG_TIMEOUT-6):
		case (DIG_TIMEOUT-1):
			this.charObj.setFramePos(--this.framePos, 0);
			break;
		}
		
		if (this.digCount == DIG_TIMEOUT)
		{
			this.type = Field.FCHIP_NWALL;
			this.digCount = 0;
			delete this.parentFld.tickObjs[this.chipid];
			return;
		}
		
		this.digCount++;
	}
}
FieldChip.prototype.tick = FieldChip_tick;

function FieldChip_lock()
{
	this.locked = true;
}
FieldChip.prototype.lock = FieldChip_lock;

function FieldChip_unlock()
{
	this.locked = false;
}
FieldChip.prototype.unlock = FieldChip_unlock;

//-------------------------------------

function Runner(f)
{
	this.field = f;
	this.charObj = new CharacterObj(this.field.gscreen.elem, "./images/runner.gif", TILE_X, TILE_Y);
	this.charObj.createView();
	this.onEachTile = null;
	this.step = PLAYER_STEP;
	
	this.pos = new Object();
	this.v = new Object();

	this.init();
	
	
	
	return this;
}

function Runner_init()
{
	this.freeze = 0;
	this.tickcount = 0;
	this.animationCount = 0;
	this.frame = 0;
	this.dirLeft = false;

	this.state = Runner.STATE_STAND;
	this.frameorgY = 0;
	this.dcount = 0;
	this.viewOfsY = 0;

	this.pos.x = 0;
	this.pos.y = 0;

	this.v.x = 0;
	this.v.y = 0;
}
Runner.prototype.init = Runner_init;

var HANGMOV_FRAMES = new Array(8, 5, 7, 6);
function Runner_tick()
{
	this.v.x = 0;
	this.v.y = 0;

	var foottile  = this.getFootTile();
	var footrtile  = this.getFootRightTile();
	
	var lefttile  = this.getLeftTile();
	var righttile = this.getRightTile();
	var toptile  = this.getTopTile();
	switch(this.state)
	{
	case Runner.STATE_STAND:
		if (foottile != null)
		{
			if (!Field.isStandable(foottile) && !Field.isStandable(footrtile))
				this.state = Runner.STATE_FALLING;
		}
		break;
	case Runner.STATE_CLIMBMOV:
	case Runner.STATE_RUNNING:
	case Runner.STATE_HANGMOVING:
		if (lefttile != null)
		{
			if (!Field.isThroughable(lefttile.type) && this.dirLeft) break;
		}
		if (righttile != null)
		{
			if (!Field.isThroughable(righttile.type) && !this.dirLeft) break;
		}
		this.v.x = this.dirLeft ? -this.step : this.step;
		break;
	case Runner.STATE_FALLING:
		this.v.y = this.step;
	
		if (Field.isStandable(foottile) || Field.isStandable(footrtile))
		{
			this.state = Runner.STATE_STAND;
			this.v.y = 0;
		}
	
		break;
	case Runner.STATE_ESCAPE:
		this.v.y = -this.step;
		break;
	
	case Runner.STATE_CLIMBDOWN:
		if (!Field.isThroughable(foottile.type)) break;
		this.v.y = this.step;
		break;
	case Runner.STATE_CLIMBUP:
		if (toptile != null)
		{
			if (!Field.isThroughable(toptile.type)) break;
		}
		this.v.y = -this.step;
		break;
	case Runner.STATE_REVIVAL:
		if (this.dcount > 0)
		{
			this.dcount--;
			this.viewOfsY = -this.dcount;
		}
		
		if (this.dcount == 0)
			this.state = Runner.STATE_FALLING;
		break;
	}


	switch(this.state)
	{
	case Runner.STATE_STAND:
		if (this.freeze > 0)
			this.frame = 2;
		else
			this.frame = 0;
		break;
	case Runner.STATE_RUNNING:
		this.frame = 1 + (this.animationCount%4);
		this.animationCount += (this.tickcount&1);
		break;
	case Runner.STATE_HANGING:
		this.frame = 8;
		break;
	case Runner.STATE_CLIMBING:
		this.frame = 5;
		break;
	case Runner.STATE_CAUGHT:
		this.frame = 8;
		break;
	case Runner.STATE_REVIVAL:
		this.frame = (this.tickcount&1);
		break;
	case Runner.STATE_DEAD:
		if (this.dcount > 10)
		{
			this.frame = 9;
		}
		else
		{
			this.frame = 8 + (this.animationCount&1);
			this.animationCount += (this.tickcount&1);
		}
		this.dcount++;
		break;
	case Runner.STATE_CLIMBUP:
	case Runner.STATE_CLIMBDOWN:
	case Runner.STATE_CLIMBMOV:
		this.frame = 5 + ((this.animationCount>>1)%2);
		this.animationCount += (this.tickcount&1);
		break;
	case Runner.STATE_HANGMOVING:
		this.frame = HANGMOV_FRAMES[this.animationCount%4];
		this.animationCount += (this.tickcount&1);
		break;
	case Runner.STATE_FALLING:
		this.frame = 3;
		break;
	}
	
	this.tickcount++;	
	
	if (this.freeze > 0)
		this.freeze--;
	
	if (this.state == Runner.STATE_REVIVAL)
		this.charObj.setFramePos(this.frame, 4);
	else
		this.charObj.setFramePos(this.frame, this.frameorgY + (this.dirLeft ? 1 : 0));
}
Runner.prototype.tick = Runner_tick;

function Runner_updatePosition()
{
	if (!this.atTileY() && this.state == Runner.STATE_RUNNING)
		this.v.y--;
		
	this.pos.x += this.v.x;
	this.pos.y += this.v.y;

	
	if ((this.pos.x+TILE_X) > this.field.pxWidth)
		this.pos.x = this.field.pxWidth-TILE_X;
	if (this.pos.x < 0)
		this.pos.x = 0;
	if (this.pos.y < 0)
		this.pos.y = 0;

	var foottile = this.getFootTile();
	var bodytile = this.getBodyTile();
	
	if (bodytile.type == Field.FCHIP_NWALL && this.dcount == 0)
		this.die();

	if (this.atTileX() && this.atTileY())
	{
		if (this.onEachTile != null)
			this.onEachTile(this, bodytile);
	}

	switch(this.state)
	{
	case Runner.STATE_ESCAPE:
		if (this.atTileY())
			this.state = Runner.STATE_STAND;
		break;
	
	case Runner.STATE_STAND:
	case Runner.STATE_FALLING:
		if (this.atTileY())
		{
			if (bodytile.type == Field.FCHIP_BAR)
				this.state = Runner.STATE_HANGING;
		}
		break;
	case Runner.STATE_HANGMOVING:
		if (this.atHalfTileX())
			this.state = Runner.STATE_HANGING;
		if (this.atTileX())
		{
			if (bodytile.type != Field.FCHIP_BAR)
				this.state = Runner.STATE_STAND;
		}
		break;
	case Runner.STATE_RUNNING:
		if (this.atHalfTileX())
			this.state = Runner.STATE_STAND;
			
		if (this.atTileX())
		{
			if (foottile != null)
			{
				if (!Field.isStandable(foottile) && bodytile.type != Field.FCHIP_RD)
					this.state = Runner.STATE_FALLING;
			}
			if (bodytile.type == Field.FCHIP_BAR)
				this.state = Runner.STATE_HANGING;
		}

		break;
	}
	this.checkRadder();
	
	this.charObj.setViewPos(this.pos.x, this.pos.y + this.viewOfsY);
}
Runner.prototype.updatePosition = Runner_updatePosition;

function Runner_die()
{
	if (this.state == Runner.STATE_DEAD)
		return;
		
	this.dcount = 0;
	this.state = Runner.STATE_DEAD;
}
Runner.prototype.die = Runner_die;

function Runner_resume(x,y,w)
{
	this.dcount = w;
	this.pos.x = x;
	this.pos.y = y;
	this.state = Runner.STATE_REVIVAL;
}
Runner.prototype.resume = Runner_resume;

function Runner_shot(dirLeft)
{
	if (this.freeze > 0)
		return;

	if (!this.atTileY())
		return;
	
	if (this.state == Runner.STATE_STAND || this.state == Runner.STATE_HANGING || this.state == Runner.STATE_CLIMBING)
	{
		var spos = dirLeft ? -(TILE_X/2+1) : (TILE_X/2+1);
		
		if (!this.atTileX())
			spos = Math.floor(spos/2);
		
		var chip =  this.field.chips.at(Math.floor((this.pos.x+(TILE_X/2)+spos)/TILE_X), Math.floor((this.pos.y+TILE_Y)/TILE_Y));
		if (chip == void(0)) return;
		
		if (chip.type != Field.FCHIP_NWALL)
			return;
		
		this.freeze = 8;
		this.dirLeft = dirLeft;
		
		chip.dig();
		
	
	}
}
Runner.prototype.shot = Runner_shot;

function Runner_run(dirLeft)
{
	if (this.freeze > 0)
		return;
		
	if (this.state == Runner.STATE_STAND)
	{
		this.state = Runner.STATE_RUNNING;
		this.dirLeft = dirLeft;
	}

	if (this.state == Runner.STATE_HANGING)
	{
		this.state = Runner.STATE_HANGMOVING;
		this.dirLeft = dirLeft;
	}

	if (this.state == Runner.STATE_CLIMBING)
	{
		this.state = Runner.STATE_CLIMBMOV;
		this.dirLeft = dirLeft;
	}
}
Runner.prototype.run = Runner_run;

function Runner_checkRadder()
{
	var bodytile = this.getBodyTile();
	if (bodytile.type != Field.FCHIP_RD)
	{
		if (this.state == Runner.STATE_CLIMBING || this.state == Runner.STATE_CLIMBDOWN || this.state == Runner.STATE_CLIMBUP || this.state == Runner.STATE_CLIMBMOV)
		{
			if (this.atHalfTileX() && this.atHalfTileY())
			{
				this.state = Runner.STATE_STAND;
				
				var foottile = this.getFootTile();
				if (!Field.isStandable(foottile))
					this.state = Runner.STATE_FALLING;
				
				if (this.atTileY())
				{
					if (bodytile.type == Field.FCHIP_BAR)
						this.state = Runner.STATE_HANGING;
				}
				
			}
		}
		

		return;
	}
		
	var foottile = this.getFootTile();

	switch(this.state)
	{
	case Runner.STATE_CLIMBMOV:
		if (this.atHalfTileX())
			this.state = Runner.STATE_CLIMBING;
		break;
	case Runner.STATE_CLIMBDOWN:
	case Runner.STATE_CLIMBUP:
		if (this.atHalfTileY())
			this.state = Runner.STATE_CLIMBING;
		
		//fallthrough
	case Runner.STATE_CLIMBING:
		if (Field.isStandable(foottile) && foottile.type != Field.FCHIP_RD && this.atTileY())
			this.state = Runner.STATE_STAND;
		break;
	
	case Runner.STATE_RUNNING:
	case Runner.STATE_STAND:
		if (this.atTileX())
		{
			if (foottile != null)
			{
				if (!Field.isStandable(foottile) || foottile.type == Field.FCHIP_RD)
					this.state = Runner.STATE_CLIMBING;
			}
		}
		break;
	}
}
Runner.prototype.checkRadder = Runner_checkRadder;

function Runner_goDown()
{
	if (this.freeze > 0)
		return;
		
	var foottile = this.getFootTile();
	
	if (!this.atTileX())
	{
		this.run(this.dirLeft);
		return;
	}
	
	if (this.state == Runner.STATE_HANGING && !Field.isStandable(foottile))
	{
		this.state = Runner.STATE_FALLING;
		return;
	}
	
	if (this.state == Runner.STATE_CLIMBING)
	{
		this.state = Runner.STATE_CLIMBDOWN;
		return;
	}

	if (this.state == Runner.STATE_STAND && foottile.type == Field.FCHIP_RD)
	{
		this.state = Runner.STATE_CLIMBDOWN;
		return;
	}
}
Runner.prototype.goDown = Runner_goDown;

function Runner_goUp()
{
	if (this.freeze > 0)
		return;
		
	var bodytile = this.getBodyTile();
	
	if (!this.atTileX())
	{
		this.run(this.dirLeft);
		return;
	}

	if (this.state == Runner.STATE_CLIMBING)
	{
		this.state = Runner.STATE_CLIMBUP;
		return;
	}

	if (this.state == Runner.STATE_STAND && bodytile.type == Field.FCHIP_RD)
	{
		this.state = Runner.STATE_CLIMBUP;
		return;
	}

}
Runner.prototype.goUp = Runner_goUp;

function Runner_getFootTile()
{
	var ret =  this.field.chips.at(Math.floor(this.pos.x/TILE_X), Math.floor((this.pos.y+TILE_Y)/TILE_Y));
	if (ret == void(0)) return null;
	return ret;
}
Runner.prototype.getFootTile = Runner_getFootTile;

function Runner_getFootRightTile()
{
	var ret =  this.field.chips.at(Math.floor((this.pos.x+(TILE_X>>1))/TILE_X), Math.floor((this.pos.y+TILE_Y)/TILE_Y));
	if (ret == void(0)) return null;
	return ret;
}
Runner.prototype.getFootRightTile = Runner_getFootRightTile;

function Runner_getTopTile()
{
	var ret =  this.field.chips.at(Math.floor(this.pos.x/TILE_X), Math.floor((this.pos.y-1)/TILE_Y));
	if (ret == void(0)) return null;
	return ret;
}
Runner.prototype.getTopTile = Runner_getTopTile;

function Runner_getLeftTile()
{
	var ret =  this.field.chips.at(Math.floor((this.pos.x-1)/TILE_X), Math.floor((this.pos.y+TILE_Y/2)/TILE_Y));
	if (ret == void(0)) return null;
	return ret;
}
Runner.prototype.getLeftTile = Runner_getLeftTile;

function Runner_getRightTile()
{
	var ret =  this.field.chips.at(Math.floor((this.pos.x+TILE_X)/TILE_X), Math.floor((this.pos.y+TILE_Y/2)/TILE_Y));
	if (ret == void(0)) return null;
	return ret;
}
Runner.prototype.getRightTile = Runner_getRightTile;

function Runner_getBodyTile()
{
	var ret =  this.field.chips.at(Math.floor((this.pos.x+TILE_X/2-4)/TILE_X), Math.floor((this.pos.y+TILE_Y/2+5)/TILE_Y));
	if (ret == void(0)) return null;

	if ((this.state == Runner.STATE_CLIMBING || this.state == Runner.STATE_CLIMBMOV || this.state == Runner.STATE_CLIMBDOWN || this.state == Runner.STATE_CLIMBUP) && ret.type != Field.FCHIP_RD)
	{
		var body_t =  this.field.chips.at(Math.floor((this.pos.x+TILE_X/2-4)/TILE_X), Math.floor((this.pos.y+TILE_Y/2-4)/TILE_Y));
		if (body_t != null){ if (body_t.type == Field.FCHIP_RD)	ret = body_t;}
		
		var body_r =  this.field.chips.at(Math.floor((this.pos.x+TILE_X/2+4)/TILE_X), Math.floor((this.pos.y+TILE_Y/2-4)/TILE_Y));
		if (body_r != null){ if (body_r.type == Field.FCHIP_RD)	ret = body_r;}
		
		var body_rb =  this.field.chips.at(Math.floor((this.pos.x+TILE_X/2+4)/TILE_X), Math.floor((this.pos.y+TILE_Y/2+5)/TILE_Y));
		if (body_rb != null){ if (body_rb.type == Field.FCHIP_RD)	ret = body_rb;}
	}

	return ret;
}
Runner.prototype.getBodyTile = Runner_getBodyTile;


function Runner_atHalfTileX() {	return (this.pos.x%(TILE_X>>1) == 0); }
Runner.prototype.atHalfTileX = Runner_atHalfTileX;

function Runner_atTileX() {	return (this.pos.x%TILE_X == 0); }
Runner.prototype.atTileX = Runner_atTileX;

function Runner_atHalfTileY() {	return (this.pos.y%(TILE_Y>>1) == 0); }
Runner.prototype.atHalfTileY = Runner_atHalfTileY;

function Runner_atTileY() {	return (this.pos.y%TILE_Y == 0); }
Runner.prototype.atTileY = Runner_atTileY;

Runner.STATE_STAND   = 0;
Runner.STATE_RUNNING = 1;
Runner.STATE_FALLING = 2;
Runner.STATE_HANGING = 3;
Runner.STATE_HANGMOVING = 4;
Runner.STATE_CLIMBING  = 5;
Runner.STATE_CLIMBUP   = 6;
Runner.STATE_CLIMBDOWN = 7;
Runner.STATE_CLIMBMOV  = 8;
Runner.STATE_CAUGHT    = 9;
Runner.STATE_DEAD      = 10;
Runner.STATE_REVIVAL   = 11;
Runner.STATE_ESCAPE    = 12;

//-------------------------------------

function EnemyRunner(f, p)
{
	this.player = p;
	this.runner = new Runner(f);
	this.runner.onEachTile = this.onEachTile.bind(this);
	this.runner.tick();
	this.lockChip = null;
	this.sgold = null;
	
	this.init();
	
	return this;
}

function EnemyRunner_unlockCurrent()
{
	if (this.lockChip != null)
	{
		this.lockChip.unlock();
		this.lockChip = null;
	}
}
EnemyRunner.prototype.unlockCurrent = EnemyRunner_unlockCurrent;

function EnemyRunner_init()
{
	this.unlockCurrent();
	this.ccount = 0;
	
	this.runner.init();
	this.runner.step = ENEMY_STEP;
	this.runner.frameorgY = 2;
	
	this.runner.tick();
}
EnemyRunner.prototype.init = EnemyRunner_init;

function EnemyRunner_tick()
{
	if (!this.player.started)
		return;
		
	switch(this.runner.state)
	{
		case Runner.STATE_DEAD:
			this.unlockCurrent();
			if (this.runner.dcount > 120)
				this.runner.resume(24, 48, 30);
			break;
		case Runner.STATE_CAUGHT:
			if (this.ccount > (CAUGHT_TIMEOUT-15))
			{
				this.runner.viewOfsY = -(this.ccount&1)*2;
			}
			if (this.ccount == CAUGHT_TIMEOUT)
			{
				this.runner.viewOfsY = 0;
				if (Field.isThroughable(this.runner.getTopTile().type))
				{
					this.runner.state = Runner.STATE_ESCAPE;
				}
			}
			
			this.ccount++;
			break;
			
		default:
		{
			var cx = this.runner.pos.x + TILE_X/2;
			var cy = this.runner.pos.y + TILE_Y/2;
			if (this.player.runner.pos.x <= cx && (this.player.runner.pos.x+TILE_X) > cx && this.player.runner.pos.y <= cy && (this.player.runner.pos.y+TILE_Y) > cy)
			{
				this.player.runner.die();
			}
			
			var dy = this.player.runner.pos.y - this.runner.pos.y;
			if (Math.abs(dy) > 72 || (this.runner.state == Runner.STATE_CLIMBING && dy < 24))
			{
				if (dy < 0)
					this.runner.goUp();
				else
					this.runner.goDown();
			}
		}
		break;
	}
	var dx = this.player.runner.pos.x - this.runner.pos.x;
	this.runner.run(dx < 0);
	
	this.runner.tick();
}
EnemyRunner.prototype.tick = EnemyRunner_tick;

function EnemyRunner_updatePosition()
{
	this.runner.updatePosition();
}
EnemyRunner.prototype.updatePosition = EnemyRunner_updatePosition;

function EnemyRunner_onEachTile(_this, bodytile)
{
	if (this.lockChip != null)
		this.lockChip.unlock();
	
	if (_this.state != Runner.STATE_DEAD && _this.state != Runner.STATE_REVIVAL)
	{
		bodytile.lock();
		this.lockChip = bodytile;
	}

	if (this.sgold == null)
	{
		if (Math.random() < 0.2)
		{	
			var mobj = bodytile.grab();
			if (mobj != null)
			{
				if (mobj.type == Field.FOBJ_GOLD)
				{
					mobj.hide();
					this.sgold = mobj;
				}
			}	
		}
	}
		
	if (_this.state == Runner.STATE_FALLING)
	{
		if (bodytile.type == Field.FCHIP_DWALL)
		{
			this.ccount = 0;
			_this.state = Runner.STATE_CAUGHT;
			
			if(this.sgold != null)
			{
				var ab = bodytile.getAbove();
				if (ab != void(0))
				{			
					if (Field.isThroughable(ab.type))
					{
						if (_this.field.reputObjAt(this.sgold, ab.tileX, ab.tileY))
						{
							this.sgold.show();
							this.sgold = null;
						}
					}
				}
			}
		}
	}
}
EnemyRunner.prototype.onEachTile = EnemyRunner_onEachTile;

//-------------------------------------

function PlayerRunner(f)
{
	this.started = false;
	this.runner = new Runner(f);
	this.runner.onEachTile = this.onEachTile.bind(this);
	this.keyState = 0;
	this.holder = new GoldHolder(f.gscreen, 32, 408);
	this.goal = false;
	return this;
}

function PlayerRunner_tick(keystate)
{
	if (this.goal)
		return completeGame;
		
	if ((keystate&0xff) != 0)
		this.started = true;
/*
	if ((keystate & KeyDispatcher.KEY_RIGHT) != 0 && (keystate & KeyDispatcher.KEY_LEFT) != 0 && (keystate & KeyDispatcher.KEY_UP) != 0)
	{
		for (xx=0;xx < 28;xx++)
		{
			for (yy=0;yy < 15;yy++)
			{

	var mobj = this.runner.field.chips.at(xx,yy).grab();
	if (mobj != null)
	{
		if (mobj.type == Field.FOBJ_GOLD)
		{
			this.holder.add(mobj);
			
			if (this.holder.count == this.runner.field.goldsCount)
				this.runner.field.onCompleted();
		}
	}	

			}
		}
	}

*/		
	if ((keystate & KeyDispatcher.KEY_RIGHT) != 0)
		this.runner.run(false);
	if ((keystate & KeyDispatcher.KEY_LEFT) != 0)
		this.runner.run(true);

	if ((keystate & KeyDispatcher.KEY_DOWN) != 0)
		this.runner.goDown();
	if ((keystate & KeyDispatcher.KEY_UP) != 0)
		this.runner.goUp();

	if ((keystate & KeyDispatcher.KEY_TRG2) != 0)
		this.runner.shot(false);
	if ((keystate & KeyDispatcher.KEY_TRG1) != 0)
		this.runner.shot(true);

	this.runner.tick();
	this.holder.tick();
	
	if (this.runner.dcount > 50)
		return resumePlayer;
	
	return null;
}
PlayerRunner.prototype.tick = PlayerRunner_tick;

function PlayerRunner_init()
{
	this.started = false;
	this.runner.init();
}
PlayerRunner.prototype.init = PlayerRunner_init;

function PlayerRunner_updatePosition()
{
	this.runner.updatePosition();
}
PlayerRunner.prototype.updatePosition = PlayerRunner_updatePosition;

function PlayerRunner_onEachTile(_this, bodytile)
{
	var mobj = bodytile.grab();
	if (mobj != null)
	{
		if (mobj.type == Field.FOBJ_GOLD)
		{
			this.holder.add(mobj);
			
			if (this.holder.count == this.runner.field.goldsCount)
				this.runner.field.onCompleted();
		}
	}	
	
	if (bodytile.goal)
	{
		this.goal = true;
	}
}
PlayerRunner.prototype.onEachTile = PlayerRunner_onEachTile;

//-------------------------------------

function GoldHolder(gscr, x, y)
{
	this.gscr = gscr;
	this.golds = new Array();
	this.tickObjs = new Object();
	this.posX = x;
	this.posY = y;
	this.nextX = x;
	this.count = 0;
	this.toCount = 0;
	
	return this;
}

function GoldHolder_add(g)
{
	var hobj = new Object();
	hobj.holder = this;
	hobj.g = g;
	hobj.x = this.nextX;
	hobj.y = this.posY;
	hobj.gid = this.golds.length;
	hobj.onTickEnd = null;
	g.elem.style.zIndex = hobj.gid+10;
	
	this.nextX += 9;
	
	this.golds.push(hobj);
	this.startTick(hobj);

	this.count++;
}
GoldHolder.prototype.add = GoldHolder_add;

function GoldHolder_startTick(hobj)
{
	this.tickObjs[hobj.gid] = hobj;
	this.toCount++;
}
GoldHolder.prototype.startTick = GoldHolder_startTick;

function GoldHolder_tick()
{
	for(i in this.tickObjs)
	{
		var o = this.tickObjs[i];
		
		var dx = o.x - o.g.sx;
		var dy = o.y - o.g.sy;

		if (dx != 0 || dy != 0)	
		{
			dx *= 0.4;
			dy *= 0.4;
			var n2 = ((dx*dx)+(dy*dy));


			if (n2 > 1600)
			{
				n2 = Math.sqrt(n2)
				dx *= 40/n2
				dy *= 40/n2
			}

			o.g.sx += dx;
			o.g.sy += dy;
			if (Math.abs(dx) < 2 && Math.abs(dy) < 2)
			{
				o.g.sx = o.x;
				o.g.sy = o.y;
				if (o.onTickEnd != null)
				{
					o.onTickEnd(o);
					o.onTickEnd = null;
				}
				
				delete this.tickObjs[i];
				this.toCount--;
			}
		}
	
		o.g.setViewPos(o.g.sx, o.g.sy);
		
	}
}
GoldHolder.prototype.tick = GoldHolder_tick;

//-------------------------------------
function CharacterObj_changeFront(frontimage)
{
	this.elem.setAttribute("src", (frontimage==void(0)) ? "./images/null.gif" : frontimage);
}
CharacterObj.prototype.changeFront = CharacterObj_changeFront;

function CharacterObj_createView(frontimage)
{

	this.elem = document.createElementNS("http://www.w3.org/1999/xhtml", "img");
	
	this.container.appendChild(this.elem);
	
	this.elem.setAttribute("src", (frontimage==void(0)) ? "./images/null.gif" : frontimage);
	this.elem.style.background = "url("+this.chipsURL+") no-repeat";
	this.elem.style.width  = this.cWidth+"px";
	this.elem.style.height = this.cHeight+"px";
	this.elem.style.position = "absolute";
	this.elem.style.display = "block";
	
	this.elem.style.left = this.sx + "px";
	this.elem.style.top  = this.sy + "px";
}
CharacterObj.prototype.createView = CharacterObj_createView;

function CharacterObj_setViewPos(x,y)
{
	this.sx = x;
	this.sy = y;
	if (this.elem != null)
	{
		this.elem.style.left = (this.padding+this.sx) + "px";
		this.elem.style.top  = (this.padding+this.sy) + "px";
	}
}
CharacterObj.prototype.setViewPos = CharacterObj_setViewPos;

function CharacterObj_dispose()
{
	if (this.elem != null)
		this.elem.parentNode.removeChild(this.elem);
}
CharacterObj.prototype.dispose = CharacterObj_dispose;

function CharacterObj_setFramePos(x,y)
{
	if (this.elem != null)
		this.elem.style.backgroundPosition = -x*this.cWidth + "px " + (-y*this.cHeight) + "px";
}
CharacterObj.prototype.setFramePos = CharacterObj_setFramePos;

function CharacterObj_hide()
{
	if (this.elem != null)
		this.elem.style.visibility = "hidden";
}
CharacterObj.prototype.hide = CharacterObj_hide;

function CharacterObj_show()
{
	if (this.elem != null)
		this.elem.style.visibility = "";
}
CharacterObj.prototype.show = CharacterObj_show;

function CharacterObj(c, u, cw, ch)
{
	this.padding = 0;
	this.container = c;
	this.chipsURL = u;
	this.elem = null;
	this.cWidth = cw;
	this.cHeight = ch;
	
	this.sx = 0;
	this.sy = 0;
}
