#! /usr/bin/env python

# Pango is a library for rendering internationalized texts
import pango

import gtk
import gtk.glade

from os import system

class GUI:
	def __init__(self, runaslib=True):
		# Load Glade XML
		self.xml = gtk.glade.XML("demolauncher/gui.glade")
		
		# Get Window
		self.w = self.xml.get_widget('window1')
		self.w.connect("delete_event", gtk.main_quit)
		
		# Get Windows child
		self.w_child = self.w.get_child()
		
		# Get our Label
		self.label = self.xml.get_widget('label1')
		
		# Connect functions to Buttons
		b1 = self.xml.get_widget('button1')
		b1.connect('clicked', self.start_demo1)

		b2 = self.xml.get_widget('button2')
		b2.connect('clicked', self.start_demo2)

		b3 = self.xml.get_widget('button3')
		b3.connect('clicked', self.start_demo3)

		# self.widget will be attached to the Activity
		# This can be any GTK widget except a window
		self.widget = self.w_child

		if not runaslib:
			self.w.show_all()
			gtk.main()

	def start_demo1(self, *args):
		system("python demos/demo6_throw_and_settings.py &")
		gtk.main_quit()
		
	def start_demo2(self, *args):
		system("python demos/demo7_elasticbox.py &")
		gtk.main_quit()

	def start_demo3(self, *args):
		system("python demos/demo8_gravityfun.py &")
		gtk.main_quit()
		
if __name__ == '__main__':
	GUI(False)
