/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.output;

import com.sun.xml.internal.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.internal.bind.v2.runtime.Name;
import com.sun.xml.internal.bind.v2.runtime.output.Encoded;
import com.sun.xml.internal.bind.v2.runtime.output.Pcdata;
import com.sun.xml.internal.bind.v2.runtime.output.UTF8XmlOutput;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public final class IndentingUTF8XmlOutput
extends UTF8XmlOutput {
    private final Encoded indent8;
    private final int unitLen;
    private int depth = 0;
    private boolean seenText = false;

    public IndentingUTF8XmlOutput(OutputStream outputStream, String string, Encoded[] encodedArray, CharacterEscapeHandler characterEscapeHandler) {
        super(outputStream, encodedArray, characterEscapeHandler);
        if (string != null) {
            Encoded encoded = new Encoded(string);
            this.indent8 = new Encoded();
            this.indent8.ensureSize(encoded.len * 8);
            this.unitLen = encoded.len;
            for (int i = 0; i < 8; ++i) {
                System.arraycopy(encoded.buf, 0, this.indent8.buf, this.unitLen * i, this.unitLen);
            }
        } else {
            this.indent8 = null;
            this.unitLen = 0;
        }
    }

    @Override
    public void beginStartTag(int n, String string) throws IOException {
        this.indentStartTag();
        super.beginStartTag(n, string);
    }

    @Override
    public void beginStartTag(Name name) throws IOException {
        this.indentStartTag();
        super.beginStartTag(name);
    }

    private void indentStartTag() throws IOException {
        this.closeStartTag();
        if (!this.seenText) {
            this.printIndent();
        }
        ++this.depth;
        this.seenText = false;
    }

    @Override
    public void endTag(Name name) throws IOException {
        this.indentEndTag();
        super.endTag(name);
    }

    @Override
    public void endTag(int n, String string) throws IOException {
        this.indentEndTag();
        super.endTag(n, string);
    }

    private void indentEndTag() throws IOException {
        --this.depth;
        if (!this.closeStartTagPending && !this.seenText) {
            this.printIndent();
        }
        this.seenText = false;
    }

    private void printIndent() throws IOException {
        this.write(10);
        int n = this.depth % 8;
        this.write(this.indent8.buf, 0, n * this.unitLen);
        n >>= 3;
        while (n > 0) {
            this.indent8.write(this);
            --n;
        }
    }

    @Override
    public void text(String string, boolean bl) throws IOException {
        this.seenText = true;
        super.text(string, bl);
    }

    @Override
    public void text(Pcdata pcdata, boolean bl) throws IOException {
        this.seenText = true;
        super.text(pcdata, bl);
    }

    @Override
    public void endDocument(boolean bl) throws IOException, SAXException, XMLStreamException {
        this.write(10);
        super.endDocument(bl);
    }
}

