/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ByteLookupTable
extends LookupTable {
    byte[][] data;

    public ByteLookupTable(int n, byte[][] byArray) {
        super(n, byArray.length);
        this.numComponents = byArray.length;
        this.numEntries = byArray[0].length;
        this.data = new byte[this.numComponents][];
        for (int i = 0; i < this.numComponents; ++i) {
            this.data[i] = byArray[i];
        }
    }

    public ByteLookupTable(int n, byte[] byArray) {
        super(n, byArray.length);
        this.numComponents = 1;
        this.numEntries = byArray.length;
        this.data = new byte[1][];
        this.data[0] = byArray;
    }

    public final byte[][] getTable() {
        return this.data;
    }

    @Override
    public int[] lookupPixel(int[] nArray, int[] nArray2) {
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        if (this.numComponents == 1) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i] - this.offset;
                if (n < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                nArray2[i] = this.data[0][n];
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i] - this.offset;
                if (n < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                nArray2[i] = this.data[i][n];
            }
        }
        return nArray2;
    }

    public byte[] lookupPixel(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            byArray2 = new byte[byArray.length];
        }
        if (this.numComponents == 1) {
            for (int i = 0; i < byArray.length; ++i) {
                int n = (byArray[i] & 0xFF) - this.offset;
                if (n < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                byArray2[i] = this.data[0][n];
            }
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                int n = (byArray[i] & 0xFF) - this.offset;
                if (n < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                byArray2[i] = this.data[i][n];
            }
        }
        return byArray2;
    }
}

