/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.Image;
import com.sun.prism.MediaFrame;
import com.sun.prism.MultiTexture;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.gl.GLContext;
import com.sun.prism.impl.BaseTexture;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.PrismTrace;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

class ES2Texture
extends BaseTexture {
    final ES2Context context;
    private int texID;
    private Texture.WrapMode wrapMode = Texture.WrapMode.REPEAT;
    private boolean linearFilterMode = true;

    ES2Texture(ES2Context eS2Context, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, Disposer.Record record) {
        super(pixelFormat, n2, n3, n4, n5, n6, n7, record);
        this.context = eS2Context;
        this.texID = n;
    }

    private ES2Texture(ES2Context eS2Context, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(eS2Context, pixelFormat, n, n2, n3, n4, n5, n6, n7, new ES2TextureDisposerRecord(eS2Context, n));
        PrismTrace.textureCreated(n, n2, n3, pixelFormat.getBytesPerPixelUnit());
    }

    static int nextPowerOfTwo(int n, int n2) {
        int n3;
        if (n > n2) {
            return 0;
        }
        for (n3 = 1; n3 < n; n3 *= 2) {
        }
        return n3;
    }

    static ES2Texture create(ES2Context eS2Context, PixelFormat pixelFormat, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (!eS2Context.getResourceFactory().isFormatSupported(pixelFormat)) {
            throw new UnsupportedOperationException("Pixel format " + (Object)((Object)pixelFormat) + " not supported on this device");
        }
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format requires multitexturing: " + (Object)((Object)pixelFormat));
        }
        boolean bl2 = bl && !ES2Pipeline.glFactory.isGL2() && eS2Context.isEdgeSmoothingSupported(pixelFormat);
        int n9 = n;
        int n10 = n2;
        if (bl2) {
            n8 = 2;
            n7 = 2;
            n6 = n9 + 4;
            n5 = n10 + 4;
        } else {
            n8 = 0;
            n7 = 0;
            n6 = n9;
            n5 = n10;
        }
        GLContext gLContext = eS2Context.getGLContext();
        int n11 = gLContext.getMaxTextureSize();
        if (gLContext.canCreateNonPowTwoTextures()) {
            n4 = n6 <= n11 ? n6 : 0;
            n3 = n5 <= n11 ? n5 : 0;
        } else {
            n4 = ES2Texture.nextPowerOfTwo(n6, n11);
            n3 = ES2Texture.nextPowerOfTwo(n5, n11);
        }
        if (n4 == 0 || n3 == 0) {
            throw new RuntimeException("Requested texture dimensions (" + n + "x" + n2 + ") " + "require dimensions (" + n4 + "x" + n3 + ") " + "that exceed maximum texture size (" + n11 + ")");
        }
        int n12 = PrismSettings.minTextureSize;
        n4 = Math.max(n4, n12);
        n3 = Math.max(n3, n12);
        int n13 = gLContext.getBoundTexture();
        int n14 = gLContext.genAndBindTexture();
        ES2Texture.uploadPixels(eS2Context.getGLContext(), 50, null, pixelFormat, n4, n3, n8, n7, 0, 0, n9, n10, 0, true);
        gLContext.texParamsMinMax(52);
        gLContext.setBoundTexture(n13);
        return new ES2Texture(eS2Context, pixelFormat, n14, n4, n3, n8, n7, n9, n10);
    }

    public static Texture create(ES2Context eS2Context, MediaFrame mediaFrame) {
        mediaFrame.holdFrame();
        int n = mediaFrame.getEncodedWidth();
        int n2 = mediaFrame.getEncodedHeight();
        PixelFormat pixelFormat = mediaFrame.getPixelFormat();
        if (mediaFrame.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            int n3 = mediaFrame.getEncodedWidth();
            int n4 = mediaFrame.getEncodedHeight();
            int n5 = mediaFrame.planeCount();
            MultiTexture multiTexture = new MultiTexture(pixelFormat, mediaFrame.getWidth(), mediaFrame.getHeight());
            for (int i = 0; i < n5; ++i) {
                int n6 = n3;
                int n7 = n4;
                if (i == 2 || i == 1) {
                    n6 /= 2;
                    n7 /= 2;
                }
                ES2Texture eS2Texture = ES2Texture.create(eS2Context, PixelFormat.BYTE_ALPHA, n6, n7, false);
                multiTexture.setTexture(eS2Texture, i);
            }
            mediaFrame.releaseFrame();
            return multiTexture;
        }
        GLContext gLContext = eS2Context.getGLContext();
        int n8 = gLContext.getMaxTextureSize();
        int n9 = mediaFrame.getEncodedHeight();
        n = mediaFrame.getEncodedWidth();
        n2 = n9;
        pixelFormat = mediaFrame.getPixelFormat();
        if (!gLContext.canCreateNonPowTwoTextures()) {
            n = ES2Texture.nextPowerOfTwo(n, n8);
            n2 = ES2Texture.nextPowerOfTwo(n2, n8);
        }
        int n10 = PrismSettings.minTextureSize;
        n = Math.max(n, n10);
        n2 = Math.max(n2, n10);
        int n11 = gLContext.getBoundTexture();
        int n12 = gLContext.genAndBindTexture();
        ES2Texture.uploadPixels(eS2Context.getGLContext(), 50, mediaFrame, n, n2, true);
        gLContext.texParamsMinMax(52);
        gLContext.setBoundTexture(n11);
        ES2Texture eS2Texture = new ES2Texture(eS2Context, pixelFormat, n12, n, n2, 0, 0, mediaFrame.getWidth(), mediaFrame.getHeight());
        mediaFrame.releaseFrame();
        return eS2Texture;
    }

    private static void uploadPixels(GLContext gLContext, int n, Buffer buffer, PixelFormat pixelFormat, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17 = 1;
        boolean bl2 = ES2Pipeline.glFactory.isGL2();
        switch (pixelFormat) {
            case BYTE_BGRA_PRE: 
            case INT_ARGB_PRE: {
                n17 = 4;
                n16 = 40;
                n15 = 41;
                if (!bl2) {
                    n14 = 40;
                    n15 = 40;
                    n14 = 21;
                    break;
                }
                n14 = 22;
                break;
            }
            case BYTE_RGB: {
                n16 = bl2 ? 40 : 42;
                n15 = 42;
                n14 = 21;
                break;
            }
            case BYTE_GRAY: {
                n16 = 43;
                n15 = 43;
                n14 = 21;
                break;
            }
            case BYTE_ALPHA: {
                n16 = 44;
                n15 = 44;
                n14 = 21;
                break;
            }
            case FLOAT_XYZW: {
                n17 = 4;
                n16 = bl2 ? 45 : 40;
                n15 = 40;
                n14 = 20;
                break;
            }
            case BYTE_APPLE_422: {
                n17 = 2;
                n16 = 42;
                n15 = 46;
                n14 = 24;
                break;
            }
            default: {
                throw new InternalError("Image format not supported: " + (Object)((Object)pixelFormat));
            }
        }
        if (!bl2 && n16 != n15) {
            throw new InternalError("On ES 2.0 device, internalFormat must match pixelFormat");
        }
        if (bl) {
            gLContext.pixelStorei(60, 1);
            if (pixelFormat == PixelFormat.FLOAT_XYZW && n16 == 40) {
                gLContext.texImage2D(n, 0, 40, n2, n3, 0, n15, n14, null);
            } else {
                if (bl2) {
                    n13 = 44;
                    n12 = 21;
                    n11 = 1;
                } else {
                    n13 = n15;
                    n12 = n14;
                    n11 = pixelFormat.getBytesPerPixelUnit();
                }
                ByteBuffer byteBuffer = null;
                if (n8 != n2 || n9 != n3) {
                    int n18 = n2 * n3 * n11;
                    byteBuffer = BufferUtil.newByteBuffer(n18);
                }
                if (bl2) {
                    gLContext.pixelStorei(61, 0);
                    gLContext.pixelStorei(62, 0);
                    gLContext.pixelStorei(63, 0);
                    gLContext.pixelStorei(60, n17);
                }
                gLContext.texImage2D(n, 0, n16, n2, n3, 0, n13, n12, byteBuffer);
            }
        }
        if (buffer != null) {
            n13 = n10 / pixelFormat.getBytesPerPixelUnit();
            if (!(bl2 || n6 == 0 && n7 == 0 && n8 == n13)) {
                buffer = Image.createPackedBuffer(buffer, pixelFormat, n6, n7, n8, n9, n10);
                n7 = 0;
                n6 = 0;
                n10 = n8;
                n13 = n10 / pixelFormat.getBytesPerPixelUnit();
            }
            gLContext.pixelStorei(60, n17);
            if (bl2) {
                if (n8 == n13) {
                    gLContext.pixelStorei(61, 0);
                } else {
                    gLContext.pixelStorei(61, n13);
                }
            }
            n12 = buffer.position();
            n11 = ES2Texture.getBufferElementSizeLog(buffer);
            int n19 = pixelFormat.getBytesPerPixelUnit() >> n11;
            buffer.position(n6 * n19 + n7 * (n10 >> n11));
            gLContext.texSubImage2D(n, 0, n4, n5, n8, n9, n15, n14, buffer);
            buffer.position(n12);
        }
    }

    private static void uploadPixels(GLContext gLContext, int n, MediaFrame mediaFrame, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6;
        int n7;
        mediaFrame.holdFrame();
        int n8 = 1;
        int n9 = mediaFrame.getEncodedWidth();
        int n10 = n7 = mediaFrame.getEncodedHeight();
        ByteBuffer byteBuffer = mediaFrame.getBuffer();
        switch (mediaFrame.getPixelFormat()) {
            case INT_ARGB_PRE: {
                n8 = 4;
                n6 = 40;
                n5 = 41;
                if (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
                    n4 = 22;
                    break;
                }
                n4 = 23;
                break;
            }
            case BYTE_APPLE_422: {
                n8 = 2;
                n6 = 42;
                n5 = 46;
                n4 = 24;
                break;
            }
            default: {
                mediaFrame.releaseFrame();
                throw new InternalError("Invalid video image format " + (Object)((Object)mediaFrame.getPixelFormat()));
            }
        }
        if (bl) {
            gLContext.pixelStorei(60, 1);
            ByteBuffer byteBuffer2 = null;
            if (n9 != n2 || n10 != n3) {
                int n11 = n2 * n3;
                byteBuffer2 = BufferUtil.newByteBuffer(n11);
            }
            gLContext.texImage2D(n, 0, n6, n2, n3, 0, 44, 21, byteBuffer2);
        }
        if (byteBuffer != null) {
            gLContext.pixelStorei(60, n8);
            gLContext.pixelStorei(61, mediaFrame.strideForPlane(0) / n8);
            byteBuffer.position(mediaFrame.offsetForPlane(0));
            gLContext.texSubImage2D(n, 0, 0, 0, n9, mediaFrame.getHeight(), n5, n4, byteBuffer.slice());
        }
        mediaFrame.releaseFrame();
    }

    public static int getBufferElementSizeLog(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return 0;
        }
        if (buffer instanceof IntBuffer || buffer instanceof FloatBuffer) {
            return 2;
        }
        throw new InternalError("Unsupported Buffer type: " + buffer.getClass());
    }

    void updateWrapState() {
        Texture.WrapMode wrapMode = this.getWrapMode();
        if (this.wrapMode != wrapMode) {
            GLContext gLContext = this.context.getGLContext();
            int n = gLContext.getBoundTexture();
            if (n != this.texID) {
                gLContext.setBoundTexture(this.texID);
            }
            gLContext.updateWrapState(this.texID, wrapMode);
            if (n != this.texID) {
                gLContext.setBoundTexture(n);
            }
            this.wrapMode = wrapMode;
        }
    }

    void updateFilterState() {
        boolean bl = this.getLinearFiltering();
        if (this.linearFilterMode != bl) {
            GLContext gLContext = this.context.getGLContext();
            int n = gLContext.getBoundTexture();
            if (n != this.texID) {
                gLContext.setBoundTexture(this.texID);
            }
            gLContext.updateFilterState(this.texID, bl);
            if (n != this.texID) {
                gLContext.setBoundTexture(n);
            }
            this.linearFilterMode = bl;
        }
    }

    @Override
    public long getNativeSourceHandle() {
        return this.texID;
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        this.checkUpdateParams(buffer, pixelFormat, n, n2, n3, n4, n5, n6, n7);
        if (!bl) {
            this.context.flushVertexBuffer();
        }
        if (this.texID != 0) {
            GLContext gLContext = this.context.getGLContext();
            int n8 = gLContext.getActiveTextureUnit();
            int n9 = gLContext.getBoundTexture();
            boolean bl2 = false;
            for (int i = 0; i < 2; ++i) {
                if (gLContext.getBoundTexture(i) != this.texID) continue;
                bl2 = true;
                if (n8 == i) break;
                gLContext.setActiveTextureUnit(i);
                break;
            }
            if (!bl2) {
                gLContext.setBoundTexture(this.texID);
            }
            ES2Texture.uploadPixels(gLContext, 50, buffer, pixelFormat, this.getPhysicalWidth(), this.getPhysicalHeight(), this.getContentX() + n, this.getContentY() + n2, n3, n4, n5, n6, n7, false);
            if (n8 != gLContext.getActiveTextureUnit()) {
                gLContext.setActiveTextureUnit(n8);
            }
            if (n9 != gLContext.getBoundTexture()) {
                gLContext.setBoundTexture(n9);
            }
        }
    }

    @Override
    public void update(MediaFrame mediaFrame, boolean bl) {
        if (!bl) {
            this.context.flushVertexBuffer();
        }
        if (this.texID != 0) {
            GLContext gLContext = this.context.getGLContext();
            int n = gLContext.getActiveTextureUnit();
            int n2 = gLContext.getBoundTexture();
            boolean bl2 = false;
            for (int i = 0; i < 2; ++i) {
                if (gLContext.getBoundTexture(i) != this.texID) continue;
                bl2 = true;
                if (n == i) break;
                gLContext.setActiveTextureUnit(i);
                break;
            }
            if (!bl2) {
                gLContext.setBoundTexture(this.texID);
            }
            ES2Texture.uploadPixels(gLContext, 50, mediaFrame, this.getPhysicalWidth(), this.getPhysicalHeight(), false);
            if (n != gLContext.getActiveTextureUnit()) {
                gLContext.setActiveTextureUnit(n);
            }
            if (n2 != gLContext.getBoundTexture()) {
                gLContext.setBoundTexture(n2);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.texID != 0) {
            Disposer.disposeRecord(this.disposerRecord);
            this.texID = 0;
        }
    }

    static class ES2TextureDisposerRecord
    implements Disposer.Record {
        final ES2Context context;
        private int texID;

        ES2TextureDisposerRecord(ES2Context eS2Context, int n) {
            this.context = eS2Context;
            this.texID = n;
        }

        void traceDispose() {
        }

        @Override
        public void dispose() {
            if (this.texID != 0) {
                this.traceDispose();
                GLContext gLContext = this.context.getGLContext();
                for (int i = 0; i < gLContext.getNumBoundTexture(); ++i) {
                    if (this.texID != gLContext.getBoundTexture(i)) continue;
                    this.context.flushVertexBuffer();
                    gLContext.updateActiveTextureUnit(i);
                    gLContext.setBoundTexture(0);
                }
                gLContext.deleteTexture(this.texID);
                this.texID = 0;
            }
        }
    }
}

