/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.util.MetadataUtil;
import com.sun.xml.internal.ws.util.pipe.AbstractSchemaValidationTube;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.ws.WebServiceException;
import org.xml.sax.SAXException;

public class ClientSchemaValidationTube
extends AbstractSchemaValidationTube {
    private static final Logger LOGGER = Logger.getLogger(ClientSchemaValidationTube.class.getName());
    private final Schema schema;
    private final Validator validator;
    private final boolean noValidation;
    private final WSDLPort port;

    public ClientSchemaValidationTube(WSBinding wSBinding, WSDLPort wSDLPort, Tube tube) {
        super(wSBinding, tube);
        this.port = wSDLPort;
        if (wSDLPort != null) {
            Source[] sourceArray;
            String string = wSDLPort.getOwner().getParent().getLocation().getSystemId();
            AbstractSchemaValidationTube.MetadataResolverImpl metadataResolverImpl = new AbstractSchemaValidationTube.MetadataResolverImpl(this);
            Map<String, SDDocument> map = MetadataUtil.getMetadataClosure(string, metadataResolverImpl, true);
            metadataResolverImpl = new AbstractSchemaValidationTube.MetadataResolverImpl(this, map.values());
            for (Source source : sourceArray = this.getSchemaSources(map.values(), metadataResolverImpl)) {
                LOGGER.fine("Constructing client validation schema from = " + source.getSystemId());
            }
            if (sourceArray.length != 0) {
                this.noValidation = false;
                this.sf.setResourceResolver(metadataResolverImpl);
                try {
                    this.schema = this.sf.newSchema(sourceArray);
                }
                catch (SAXException sAXException) {
                    throw new WebServiceException(sAXException);
                }
                this.validator = this.schema.newValidator();
                return;
            }
        }
        this.noValidation = true;
        this.schema = null;
        this.validator = null;
    }

    @Override
    protected Validator getValidator() {
        return this.validator;
    }

    @Override
    protected boolean isNoValidation() {
        return this.noValidation;
    }

    protected ClientSchemaValidationTube(ClientSchemaValidationTube clientSchemaValidationTube, TubeCloner tubeCloner) {
        super(clientSchemaValidationTube, tubeCloner);
        this.port = clientSchemaValidationTube.port;
        this.schema = clientSchemaValidationTube.schema;
        this.validator = this.schema.newValidator();
        this.noValidation = clientSchemaValidationTube.noValidation;
    }

    @Override
    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new ClientSchemaValidationTube(this, tubeCloner);
    }

    @Override
    public NextAction processRequest(Packet packet) {
        if (this.isNoValidation() || !this.feature.isOutbound() || !packet.getMessage().hasPayload() || packet.getMessage().isFault()) {
            return super.processRequest(packet);
        }
        try {
            this.doProcess(packet);
        }
        catch (SAXException sAXException) {
            throw new WebServiceException(sAXException);
        }
        return super.processRequest(packet);
    }

    @Override
    public NextAction processResponse(Packet packet) {
        if (this.isNoValidation() || !this.feature.isInbound() || packet.getMessage() == null || !packet.getMessage().hasPayload() || packet.getMessage().isFault()) {
            return super.processResponse(packet);
        }
        try {
            this.doProcess(packet);
        }
        catch (SAXException sAXException) {
            throw new WebServiceException(sAXException);
        }
        return super.processResponse(packet);
    }
}

