/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Locale;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeAbsence;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;

final class PskKeyExchangeModesExtension {
    static final HandshakeProducer chNetworkProducer = new PskKeyExchangeModesProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new PskKeyExchangeModesConsumer();
    static final HandshakeAbsence chOnLoadAbsence = new PskKeyExchangeModesOnLoadAbsence();
    static final HandshakeAbsence chOnTradeAbsence = new PskKeyExchangeModesOnTradeAbsence();
    static final SSLStringizer pkemStringizer = new PskKeyExchangeModesStringizer();

    PskKeyExchangeModesExtension() {
    }

    private static final class PskKeyExchangeModesOnTradeAbsence
    implements HandshakeAbsence {
        private PskKeyExchangeModesOnTradeAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            SSLExtension.SSLExtensionSpec sSLExtensionSpec = (SSLExtension.SSLExtensionSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_PRE_SHARED_KEY);
            if (sSLExtensionSpec != null) {
                serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "pre_shared_key key extension is offered without a psk_key_exchange_modes extension");
            }
        }
    }

    private static final class PskKeyExchangeModesOnLoadAbsence
    implements HandshakeAbsence {
        private PskKeyExchangeModesOnLoadAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (serverHandshakeContext.isResumption) {
                serverHandshakeContext.isResumption = false;
                serverHandshakeContext.resumingSession = null;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("abort session resumption, no supported psk_dhe_ke PSK key exchange mode", new Object[0]);
                }
            }
        }
    }

    private static final class PskKeyExchangeModesProducer
    implements HandshakeProducer {
        private PskKeyExchangeModesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.PSK_KEY_EXCHANGE_MODES)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("Ignore unavailable psk_key_exchange_modes extension", new Object[0]);
                }
                return null;
            }
            byte[] byArray = new byte[]{1, 1};
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.PSK_KEY_EXCHANGE_MODES, PskKeyExchangeModesSpec.DEFAULT);
            return byArray;
        }
    }

    private static final class PskKeyExchangeModesConsumer
    implements SSLExtension.ExtensionConsumer {
        private PskKeyExchangeModesConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            PskKeyExchangeModesSpec pskKeyExchangeModesSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.PSK_KEY_EXCHANGE_MODES)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable psk_key_exchange_modes extension", new Object[0]);
                }
                if (serverHandshakeContext.isResumption && serverHandshakeContext.resumingSession != null) {
                    serverHandshakeContext.isResumption = false;
                    serverHandshakeContext.resumingSession = null;
                }
                return;
            }
            try {
                pskKeyExchangeModesSpec = new PskKeyExchangeModesSpec(byteBuffer);
            }
            catch (IOException iOException) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.PSK_KEY_EXCHANGE_MODES, pskKeyExchangeModesSpec);
            if (serverHandshakeContext.isResumption && !pskKeyExchangeModesSpec.contains(PskKeyExchangeMode.PSK_DHE_KE)) {
                serverHandshakeContext.isResumption = false;
                serverHandshakeContext.resumingSession = null;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("abort session resumption, no supported psk_dhe_ke PSK key exchange mode", new Object[0]);
                }
            }
        }
    }

    private static final class PskKeyExchangeModesStringizer
    implements SSLStringizer {
        private PskKeyExchangeModesStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new PskKeyExchangeModesSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    static final class PskKeyExchangeModesSpec
    implements SSLExtension.SSLExtensionSpec {
        private static final PskKeyExchangeModesSpec DEFAULT = new PskKeyExchangeModesSpec(new byte[]{PskKeyExchangeMode.PSK_DHE_KE.id});
        final byte[] modes;

        PskKeyExchangeModesSpec(byte[] byArray) {
            this.modes = byArray;
        }

        PskKeyExchangeModesSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 2) {
                throw new SSLProtocolException("Invalid psk_key_exchange_modes extension: insufficient data");
            }
            this.modes = Record.getBytes8(byteBuffer);
        }

        boolean contains(PskKeyExchangeMode pskKeyExchangeMode) {
            if (this.modes != null) {
                for (byte by : this.modes) {
                    if (pskKeyExchangeMode.id != by) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"ke_modes\": '['{0}']'", Locale.ENGLISH);
            if (this.modes == null || this.modes.length == 0) {
                Object[] objectArray = new Object[]{"<no PSK key exchange modes specified>"};
                return messageFormat.format(objectArray);
            }
            StringBuilder stringBuilder = new StringBuilder(64);
            boolean bl = true;
            for (byte by : this.modes) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(PskKeyExchangeMode.nameOf(by));
            }
            Object[] objectArray = new Object[]{stringBuilder.toString()};
            return messageFormat.format(objectArray);
        }
    }

    static enum PskKeyExchangeMode {
        PSK_KE(0, "psk_ke"),
        PSK_DHE_KE(1, "psk_dhe_ke");

        final byte id;
        final String name;

        private PskKeyExchangeMode(byte by, String string2) {
            this.id = by;
            this.name = string2;
        }

        static PskKeyExchangeMode valueOf(byte by) {
            for (PskKeyExchangeMode pskKeyExchangeMode : PskKeyExchangeMode.values()) {
                if (pskKeyExchangeMode.id != by) continue;
                return pskKeyExchangeMode;
            }
            return null;
        }

        static String nameOf(byte by) {
            for (PskKeyExchangeMode pskKeyExchangeMode : PskKeyExchangeMode.values()) {
                if (pskKeyExchangeMode.id != by) continue;
                return pskKeyExchangeMode.name;
            }
            return "<UNKNOWN PskKeyExchangeMode TYPE: " + (by & 0xFF) + ">";
        }
    }
}

