/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class Serializer {
    Writer writer_;
    OutputStream result_;
    NodeList nodeList_;
    private static final char[] CN_END;
    private static final char[] CN_START;
    private static final char[] CD_END;
    private static final char[] CD_START;
    private static final char[] PI_END;
    private static final char[] PI_START;
    private static final char[] CR_QOUT;
    private static final char[] CR_GT;
    private static final char[] CR_LT;
    private static final char[] CR_XA;
    private static final char[] CR_X9;
    private static final char[] CR_AMP;
    private static final char[] CR_XD;

    public void serialize() throws IOException {
        int n = 0;
        while (n < this.nodeList_.getLength()) {
            this.renderNode(this.nodeList_.item(n));
            ++n;
        }
        this.writer_.flush();
    }

    private void renderText(Text text) throws IOException {
        String string = text.getNodeValue();
        if (string != null && string.length() > 0) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < string.length()) {
                switch (string.charAt(n3)) {
                    case '&': {
                        this.writer_.write(string, n, n2);
                        n += n2 + 1;
                        n2 = 0;
                        this.writer_.write(CR_AMP);
                        break;
                    }
                    case '<': {
                        this.writer_.write(string, n, n2);
                        n += n2 + 1;
                        n2 = 0;
                        this.writer_.write(CR_LT);
                        break;
                    }
                    case '>': {
                        this.writer_.write(string, n, n2);
                        n += n2 + 1;
                        n2 = 0;
                        this.writer_.write(CR_GT);
                        break;
                    }
                    case '\r': {
                        this.writer_.write(string, n, n2);
                        n += n2 + 1;
                        n2 = 0;
                        this.writer_.write(CR_XD);
                        break;
                    }
                    default: {
                        ++n2;
                        break;
                    }
                }
                ++n3;
            }
            if (n2 > 0) {
                this.writer_.write(string, n, n2);
            }
        }
    }

    private void renderProcessingInstruction(ProcessingInstruction processingInstruction) throws IOException {
        this.writer_.write(PI_START);
        this.writer_.write(processingInstruction.getTarget());
        String string = processingInstruction.getData();
        if (string != null && string.length() > 0) {
            this.writer_.write(32);
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == '\r') {
                    this.writer_.write(CR_XD);
                } else {
                    this.writer_.write(string.charAt(n));
                }
                ++n;
            }
        }
        this.writer_.write(PI_END);
    }

    private void renderNode(Node node) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                this.renderElement((Element)node);
                break;
            }
            case 2: {
                this.renderAttr((Attr)node);
                break;
            }
            case 3: {
                this.renderText((Text)node);
                break;
            }
            case 4: {
                this.renderCData((CDATASection)node);
                break;
            }
            case 7: {
                this.renderProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.renderComment((Comment)node);
                break;
            }
            case 11: {
                NodeList nodeList = node.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    this.renderNode(nodeList.item(n));
                    ++n;
                }
                break;
            }
        }
    }

    private void renderElement(Element element) throws IOException {
        this.writer_.write(60);
        this.writer_.write(element.getNodeName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            this.renderAttr((Attr)namedNodeMap.item(n));
            ++n;
        }
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() > 0) {
            this.writer_.write(62);
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                this.renderNode(nodeList.item(n2));
                ++n2;
            }
            this.writer_.write(60);
            this.writer_.write(47);
            this.writer_.write(element.getNodeName());
            this.writer_.write(62);
        } else {
            this.writer_.write(47);
            this.writer_.write(62);
        }
    }

    private void renderComment(Comment comment) throws IOException {
        String string = comment.getNodeValue();
        if (string != null && string.length() > 0) {
            int n;
            this.writer_.write(CN_START);
            int n2 = 0;
            while ((n = string.indexOf("-->", n2)) != -1) {
                this.writer_.write(string, n2, ++n - n2);
                this.writer_.write(32);
                n2 = n;
            }
            this.writer_.write(string, n2, string.length() - n2);
            this.writer_.write(CN_END);
        }
    }

    private void renderCData(CDATASection cDATASection) throws IOException {
        String string = cDATASection.getNodeValue();
        if (string != null && string.length() > 0) {
            int n;
            this.writer_.write(CD_START);
            int n2 = 0;
            while ((n = string.indexOf("]]>", n2)) != -1) {
                this.writer_.write(string, n2, (n += 2) - n2);
                this.writer_.write(CD_END);
                this.writer_.write(CD_START);
                n2 = n;
            }
            this.writer_.write(string, n2, string.length() - n2);
            this.writer_.write(CD_END);
        }
    }

    private void renderAttr(Attr attr) throws IOException {
        this.writer_.write(32);
        this.writer_.write(attr.getNodeName());
        this.writer_.write(61);
        this.writer_.write(34);
        String string = attr.getNodeValue();
        if (string != null && string.length() > 0) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < string.length()) {
                switch (string.charAt(n3)) {
                    case '&': {
                        this.writer_.write(string, n, n2);
                        n += n2 + 1;
                        n2 = 0;
                        this.writer_.write(CR_AMP);
                        break;
                    }
                    case '<': {
                        this.writer_.write(string, n, n2);
                        n += n2 + 1;
                        n2 = 0;
                        this.writer_.write(CR_LT);
                        break;
                    }
                    case '>': {
                        this.writer_.write(string, n, n2);
                        n += n2 + 1;
                        n2 = 0;
                        this.writer_.write(CR_GT);
                        break;
                    }
                    case '\"': {
                        this.writer_.write(string, n, n2);
                        n += n2 + 1;
                        n2 = 0;
                        this.writer_.write(CR_QOUT);
                        break;
                    }
                    case '\t': {
                        this.writer_.write(string, n, n2);
                        n += n2 + 1;
                        n2 = 0;
                        this.writer_.write(CR_X9);
                        break;
                    }
                    case '\n': {
                        this.writer_.write(string, n, n2);
                        n += n2 + 1;
                        n2 = 0;
                        this.writer_.write(CR_XA);
                        break;
                    }
                    case '\r': {
                        this.writer_.write(string, n, n2);
                        n += n2 + 1;
                        n2 = 0;
                        this.writer_.write(CR_XD);
                        break;
                    }
                    default: {
                        ++n2;
                        break;
                    }
                }
                ++n3;
            }
            if (n2 > 0) {
                this.writer_.write(string, n, n2);
            }
        }
        this.writer_.write(34);
    }

    public Serializer(NodeList nodeList, OutputStream outputStream) {
        this.nodeList_ = nodeList;
        this.result_ = outputStream;
        try {
            this.writer_ = new OutputStreamWriter(this.result_, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    static {
        CR_XD = new char[]{'&', '#', 'x', 'D', ';'};
        CR_AMP = new char[]{'&', 'a', 'm', 'p', ';'};
        CR_X9 = new char[]{'&', '#', 'x', '9', ';'};
        CR_XA = new char[]{'&', '#', 'x', 'A', ';'};
        CR_LT = new char[]{'&', 'l', 't', ';'};
        CR_GT = new char[]{'&', 'g', 't', ';'};
        CR_QOUT = new char[]{'&', 'q', 'u', 'o', 't', ';'};
        PI_START = new char[]{'<', '?'};
        PI_END = new char[]{'?', '>'};
        CD_START = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
        CD_END = new char[]{']', ']', '>'};
        CN_START = new char[]{'<', '!', '-', '-'};
        CN_END = new char[]{'-', '-', '>'};
    }
}

