/*****************************************************************************
  Module: auddev.h - Defines the MMDeviceCap and MMDeviceList classes.
  Copyright (C) 1999  Andrew L. Sandoval

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/
/* Module: auddev.h                                                          */
/* Developer: Andrew L. Sandoval                                             */
/* Purpose: Defines the MMDeviceCap and MMDeviceList classes which show      */
/* available waveIn devices.                                                 */
/*****************************************************************************/

#pragma warning(disable:4786)

#include <iostream>
#include <string>
#include <vector>
#include <map>
#include <sstream>
#include <windows.h>
#include <mmsystem.h>
#include <mmreg.h>

using namespace std;

class MMDeviceCap
{
private:
	UINT id;
	WAVEINCAPS caps;
	
public:
	MMDeviceCap(UINT dev_id, const LPWAVEINCAPS const in);
	MMDeviceCap(UINT dev_id);

	const WORD wMid() const                { return caps.wMid; };
	const WORD wPid() const                { return caps.wPid; };
	const MMVERSION vDriverVersion() const { return caps.vDriverVersion; };
	const char * szPname() const           { return caps.szPname; };
	const DWORD dwFormats() const          { return caps.dwFormats; };
	const WORD wChannels() const           { return caps.wChannels; };
	const WORD wReserved1() const          { return caps.wReserved1; };
	const UINT getId() const               { return id; };
	const LPWAVEINCAPS getCaps() const     { return const_cast<const LPWAVEINCAPS>(&caps); };

	MMDeviceCap& operator=(const MMDeviceCap &mdc);
	bool operator==(const MMDeviceCap &mdc);
	bool operator==(const WAVEINCAPS &wic);
private:
	MMDeviceCap() : id(0) { };
};

typedef map<unsigned int, MMDeviceCap *> CAPMAP;

class MMDeviceList
{
private:
	UINT numDevs;
	CAPMAP index;

public:
	MMDeviceList();
	~MMDeviceList();
	ostream& print(ostream &o);
	const MMDeviceCap* const getCaps(unsigned int id);
};

ostream& operator<<(ostream &o, MMDeviceList &l);
