/*
   strncasecmp_P.S
   Case insensitive compare

   Contributors:
     Created by Reiner Patommel

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/
#include "macros.inc"

#define s1_hi r25
#define s1_lo r24
#define s2_hi r23
#define s2_lo r22
#define len_hi r21
#define len_lo r20
#define cht r19
#define tmp r18

#define ret_hi r25
#define ret_lo r24

; int strncasecmp_P(const char *s1, const char flash *s2, size_t len)

    .text
    .global _U(strncasecmp_P)
    .type   _U(strncasecmp_P), @function
_U(strncasecmp_P):
    LOAD_Z(s2_lo, s2_hi)
    LOAD_X(s1_lo, s1_hi)
.strncasecmp_P_loop:
    SUBI      len_lo, lo8(1)
    SBCI      len_hi, hi8(1)
    BRCS      .strncasecmp_P_equal
    LD        ret_lo, X+               ; load *s1
    LPM_R0_ZP                          ; load *s2
    MOV       tmp, r0                  ; copy of *s2 to tmp
    MOV       cht, r0                  ; copy of *s2 to cht
    ORI       cht, 0x20                ; make it lower case
    CPI       cht, 'a'                 ; test on [a .. z]
    BRLT      .strncasecmp_P_tst
    CPI       cht, 'z'+1
    BRGE      .strncasecmp_P_tst
    ORI       tmp, 0x20                ; we got an alpha in s2
    ORI       ret_lo, 0x20             ; make *s1, *s2 lower case
   .strncasecmp_P_tst:
    SUB       ret_lo, tmp
    BRNE      .strncasecmp_P_done
    TST       r0
    BRNE      .strncasecmp_P_loop
.strncasecmp_P_equal:
    SUB       ret_lo, ret_lo
.strncasecmp_P_done:
; ret_hi = SREG.C ? 0xFF : 0
    SBC       ret_hi, ret_hi
    RET
.strncasecmp_P_end:
    .size   _U(strncasecmp_P), .strncasecmp_P_end - _U(strncasecmp_P)

