/*
     kalc: A Scientific RPN Calculator
     Copyright (C) 1999-2000 Eduardo M Kalinowski (ekalin@iname.com)

     This program is free software. You may redistribute it, but only in
     its whole, unmodified form. You are allowed to make changes to this
     program, but you must not redistribute the changed version.

     This program is distributed in the hope it will be useful, but there
     is no warranty.

     For details, see the COPYING file.
*/

#ifndef __CMD_TIME_H
#define __CMD_TIME_H 1

#define __createMDY(m, d, y) ((m) + (d)*1e-2 + (y)*1e-6)

#define __TOhms(x) ((x) - .4*((x) - floor(x)) - .004*(60*(x) - floor(60*(x))))
#define __hmsTO(x) ((x) + ((x) - floor(x))/1.5 + (100*(x) - floor(100*(x)))/90)


Object _f_TOhms(Object n, int *err);
Object _f_hmsTO(Object n, int *err);
Object _f_dateAdd(Object n, Object p, int *err);
Object _f_ddays(Object n, Object p, int *err);
Object _f_hmsAdd(Object n, Object p, int *err);
Object _f_hmsSub(Object n, Object p, int *err);
Object _f_dow(Object n, int *err);
Object _f_dowstr(Object n, int *err);
Object _f_tstr(Object n, Object p, int *err);

void __extractMDY(double mdy, int *m, int *d, int *y);
int __dow(int m, int d, int y);

#endif /* __CMD_TIME_H */
