% Gua de Programacin del Mdulos del Ncleo Linux -*- LaTeX -*-
% Copyright (C) 1998-1999 por Ori Pomerantz
%
% Este fichero es libremente distribuible, pero debes mantener este copyright
% en todas las copias, y debe ser distribuido solamente como parte de
% la "Gua de Programacin de Mdulos del Ncleo Linux". El uso de
% este fichero est cubierto por el Copyright del documento entero, en 
% el fichero "copyright.tex".
%

% m4 Macros para un fichero fuente (uso m4 para poder incluir un fichero con el modo verbatim)

define(`sourcesample', `
\vskip 2ex
\addcontentsline{toc}{section}{$1}
{\large\bf $1}
\index{$1, source file}\index{source}\index{source!$1}

\begin{verbatim}
include(../source/$2/$1)
\end{verbatim}
')

% El estilo del documento
% Versiones viejas
%\documentstyle[times,indentfirst,epsfig,twoside,linuxdoc,lotex]{report}
%\documentclass[times,indentfirst,epsfig,a4paper,linuxdoc,twoside,lotex]{book}
\documentclass[a4paper,spanish]{report}
\usepackage{times,indentfirst,epsfig,linuxdoc,lotex}
% Cabeceras en Espaol
\usepackage[latin1]{inputenc}
\usepackage{babel}
% Queremos un ndice.
\makeindex

% Definiciones Especficas del Documento
\newcommand{\myversion}[0]{1.1.0}
\newcommand{\myyear}[0]{1999}
\newcommand{\mydate}[0]{26 Abril \myyear}
\newcommand{\bookname}[0]{Gua de Programacin de Mdulos del Ncleo Linux}

%  Definiciones Especficas del Autor

\newcommand{\mycorreoe}{mpg@simple-tech.com}
\newcommand{\myname}{Ori Pomerantz}
\newcommand{\myaddress}{\myname\\
                        Apt. \#1032\\
                        2355 N Hwy 360\\
                        Grand Prairie\\
                        TX 75050\\
                        USA}

\typeout{ * \bookname, \mycorreoe }
\typeout{ * Versin \myversion, \mydate.}


% Banderas Condicionales. Establcelas basndote en cmo ests formateando el libro.
% Para la edicin Slackware:
\def\igsslack{1}
% Para la edicin ASCII plana:
%\def\igsascii{0}

% Hack de jr, porque latex2html no sabe leer doclinux.sty
\makeatletter
\renewcommand{\lbr}{$\langle$}                  % Signo menor que '<'
\renewcommand{\rbr}{$\rangle$}                  % Signo mayor que '>'
\renewcommand{\tldpes}{{\tt http://www.es.tldp.org}}
\makeatother



% Establece la infomacin del ttulo.
\title{\bookname}
\years{\myyear}
\author{\large \myname}
\abstract{Versin \myversion, \mydate. \\
\vskip 1ex
Este libro trata sobre cmo escribir Mdulos del Ncleo Linux. Se espera que sea de utilidad
para programadores que saben C y quieren aprender a
escribir mdulos del ncleo. Est escrito a la manera de un manual de
instrucciones ``Cmo'' (How-To), con ejemplos de todas las tcnicas
importantes.
\\
\vskip 1ex
Aunque este libro toca muchos puntos del diseo del ncleo, no se
supone que venga a cumplir dicho propsito; hay otros libros sobre
el tema, tanto impresos como en el proyecto de documentacin de Linux.
\\
\vskip 1ex
Usted puede copiar y redistribuir libremente este libro bajo
ciertas condiciones. Por favor, lea los enunciados del copyright y de la
distribucin.
}


% esto es 'especial' para dvips
%\special{papersize=7in,9in}
%\setlength\paperwidth  {7in}
%\setlength\paperheight {9in}

% Tabla de contenidos
\setcounter{secnumdepth}{5}
\setcounter{tocdepth}{2}

% Inicialmente, nmeracin romana sin nmeros.
\pagenumbering{roman}
\pagestyle{empty}  
\sloppy

%%
%% fin del prembulo
%%


\begin{document}
\raggedbottom{}
\setlength{\parskip}{0pt}      %quita los espacios entre prrafos

\maketitle

include(copyright.m4)
include(copyright-es.m4)

\setcounter{page}{0}
\pagestyle{headings}
\tableofcontents

% Me gusta que mis introducciones empiecen en el captulo 0.
\setcounter{chapter}{-1}

% No ms numeracin Romana!
\setcounter{page}{0}
\pagenumbering{arabic}
% Por fin, el principio REAL
\chapter{Introduccin}\label{introduction}

As que quieres escribir un mdulo del ncleo. Sabes C, has
escrito algunos programas corrientes que se ejecutan  como procesos, y
ahora quieres ir donde est la verdadera accin, donde un simple
puntero salvaje puede destruir tu sistema de ficheros y  donde un volcado
de memoria (core dump) significa un reinicio de la mquina.

Bueno, pues bienvenido al club. A m, en una ocasin un puntero salvaje me hizo un estropicio en
un directorio importante bajo DOS (gracias que ahora significa {\bf
D}ead {\bf O}perating {\bf S}ystem; Sistema Operativo Muerto), y no veo por qu vivir bajo
Linux debera ser algo ms seguro que esto\index{DOS}.


{\bf Advertencia:} He escrito esto y verificado el programa bajo versiones
2.0.35 y 2.2.3 del ncleo funcionando en un Pentium. Para la mayor
parte, debera funcionar en otras CPUs y en otras versiones del
ncleo siempre que sean 2.0.x o 2.2.x, pero no puedo 
prometer nada. Una excepcin es el captulo~\ref{int-handler}, que
no debera funcionar en ninguna arquitectura excepto x86.



\section{Quin debera leer esto}\label{who-should-read}

Este documento es para personas que quieran escribir mdulos del
ncleo. Aunque tratar en varios sitios sobre cmo se hacen las cosas
en el ncleo, ste no es mi propsito. Hay fuentes bastante buenas
que hacen un trabajo mejor que el que yo pudiera haber
hecho.

Este documento tambin es para personas que saben escribir
mdulos del ncleo pero que no se han adaptado a la versin 2.2 de
ste. Si eres una de estas personas, te sugiero que mires en el
apndice~\ref{ver-changes} todas las diferencias que he
encontrado mientras actualizaba los ejemplos. La lista est lejos de
ser amplia, pero creo que cubre la mayora de las funcionalidades
bsicas y te bastar para empezar.

El ncleo es un magnfico trabajo de programacin, y creo que todo
programador debera leer al menos algunos ficheros fuente del
ncleo y entenderlos. Dicho esto, tambin creo en el valor de jugar
primero con el sistema y hacer las preguntas despus. Cuando aprendo un
nuevo lenguaje de programacin, no empiezo leyendo el cdigo de la
biblioteca, sino escribiendo un pequeo programa ``hola, mundo''. No
veo por qu el jugar con el ncleo tendra que ser diferente.


\section{Un apunte sobre el estilo}\label{style-note}

Me gusta poner tantas bromas como sea posible en la documentacin.
Estoy escribiendo esto porque me gusta, y asumo que la mayora de vosotros
estis leyendo esto por el mismo motivo. Si quieres saltarte este punto, %fuzzy. FVD
ignora todo el texto normal y lee el cdigo fuente. Prometo poner todos
los detalles importantes en destacado.


\section{Cambios}\label{changes}

\subsection{Nuevo en la versin 1.0.1}

\begin{enumerate}
\item{\bf Seccin de cambios}, \ref{changes}.
\item{\bf Cmo encontrar el nmero menor del dispositivo}, \ref{char-dev-file}.
\item{\bf Arreglada la explicacin de la diferencia entre
        caracteres y ficheros de dispositivo}, \ref{char-dev-file}
\item{\bf Makefiles para los mdulos del ncleo}, \ref{makefile}.
\item{\bf Multiproceso simtrico}, \ref{smp}.
\item{\bf Un Captulo de ``Malas Ideas'' }, \ref{bad-ideas}.
\end{enumerate}


\subsection{Nuevo en la versin 1.1.0}

\begin{enumerate}
\item{\bf Soporte para la versin 2.2 del ncleo}, todo sobre el sitio.
\item{\bf Ficheros fuente para varias versiones del ncleo}, \ref{kernel-ver}.
\item{\bf Cambios entre 2.0 y 2.2}, \ref{ver-changes}.
\item{\bf Mdulos del ncleo en varios ficheros fuente}, \ref{multi-file}.
\item{\bf Sugerencia de no dejar mdulos que implementan 
        llamadas al sistema que pueden ser quitadas}, \ref{sys-call}.
\end{enumerate}


\section{Agradecimientos}\label{acknowledgments}

Quisiera agradecer a Yoav Weiss por tantas discusiones e ideas 
tiles, as como por encontrar fallos en este documento antes de su
publicacin. Por supuesto, cualquier error remanente es slo 
culpa ma.

El esqueleto \TeX{} para este libro fue descaradamente robado de la gua
``Linux Installation and Getting Started'', donde el trabajo de \TeX{} fue
realizado por Matt Welsh.

Mi gratitud a Linus Torvalds, Richard Stallman y al resto de las personas que
me dieron la posibilidad de ejecutar un sistema operativo de  calidad en mi
ordenador y obtener el cdigo fuente sin decirlo (vale, de acuerdo:          %fuzzy.FVD
entonces por qu lo dije?).

\subsection{Para la versin 1.0.1}

No he podido relacionar aqu a todo el mundo que me escribi un correo-e, y si te he
dejado fuera lo siento por adelantado. Las siguientes personas fueron
especialmente tiles:

\begin{itemize}

\item{\bf Frodo Looijaard, de Holanda} Por un montn de sugerencias
        tiles, y sobre informacin sobre los ncleos 2.1.x.
\item{\bf Stephen Judd, de Nueva Zelanda} Correcciones tipogrficas.
\item{\bf Magnus Ahltorp, de Suiza} Corrigiendo un fallo mo
	 sobre la diferencia entre dispositivos de bloque y de carcter.

\end{itemize}


\subsection{Para la versin 1.1.0}

\begin{itemize}

\item{\bf Emmanuel Papirakis, de Qubec, Canad} Por portar todos los
        ejemplos a la versin 2.2 del ncleo.
\item{\bf Frodo Looijaard, de Holanda} Por decirme cmo crear un mdulo
        del ncleo con varios ficheros (\ref{multi-file}).


\end{itemize}

Por supuesto, cualesquiera errores remanentes son mos, y si piensas que
stos hacen el libro inutilizable eres bienvenido a apuntarte a recibir
un reintegro total del dinero que me has pagado por l.


\chapter{Hola, mundo}\label{hello-world}

Cuando el primer programador de las cavernas cincel el primer programa en las
paredes de la primera computadora de las cavernas, era un programa para
imprimir la cadena de caracteres ``Hola, mundo'' en las pinturas de los
Antlopes. Los libros de texto de los romanos sobre programacin empezaban con el programa
``Salut, Mundi''. No s qu puede ocurrirle al que rompa esta tradicin, 
y creo que es ms seguro no averiguarlo\index{hola mundo}\index{salut mundi}.

Un mdulo del ncleo tiene que tener por lo menos dos funciones: {\tt init\_module}
que se llama cuando el mdulo se inserta en el ncleo, y {\tt cleanup\_module}
que se llama justo antes de ser quitado.
Tpicamente, {\tt init\_module} o bien registra un manejador para algo que tiene que ver con el ncleo, o 
reemplaza una de las funciones del ncleo con su propio cdigo (normalmente cdigo para
hacer algo y luego llamar a la funcin original). La funcin {\tt cleanup\_module} 
se supone que deshace lo que {\tt init\_module} ha hecho, de forma que el mdulo pueda
ser descargado de una forma segura\index{init\_module}\index{cleanup\_module}.


sourcesample(hello.c, 01_hello)

\section{Makefiles para los mdulos del ncleo}\label{makefile}\index{makefile}

Un mdulo del ncleo no es un ejecutable independiente, sino un fichero objeto 
que ser enlazado dentro del ncleo en tiempo de ejecucin. En consecuencia,
deberan ser compilados con la bandera {\tt -c}. Tambin, todos los mdulos del
ncleo deberan ser compilados con ciertos smbolos 
definidos\index{compilando}.

\begin{itemize}

\item{\tt \_\_KERNEL\_\_} : Esto le dice a los ficheros de cabeceras que este cdigo
        se ejecutar en modo kernel (ncleo), y no como parte de un proceso de usuario (modo
        usuario\index{\_\_KERNEL\_\_}).

\item{\tt MODULE} : Esto le dice a los ficheros de cabeceras que le den las definiciones
        apropiadas para un mdulo del ncleo\index{MODULE}.

\item{\tt LINUX} : Tcnicamente hablando, esto no es necesario. Sin embargo, 
        si quisieras escribir un mdulo serio que se compile
        en ms de un sistema operativo, sers feliz si lo haces. Esto te
        permitir hacer compilacin condicional en las partes que son
        dependientes del S. O.\index{LINUX}.
\end{itemize}


Hay otros smbolos que tienen que ser incluidos, o no, dependiendo de las
banderas con las que se haya compilado el ncleo. Si no ests seguro de cmo
fue compilado el ncleo, mira en 
{\tt /usr/include/linux/config.h}\index{config.h}%
\index{configuracin del ncleo}\index{configuracin}%
\index{configuracin!ncleo}


\begin{itemize}

\item{\tt \_\_SMP\_\_} : Multiproceso simtrico. Esto tiene que estar definido si
        el ncleo fue compilado para soportar multiproceso simtrico (incluso
        si slo se est ejecutando en una CPU). Si usas Multiproceso simtrico,
        hay otras cosas que tienes que hacer (ver captulo~\ref{smp}%
\index{\_\_SMP\_\_}).

\item{\tt CONFIG\_MODVERSIONS} : Si CONFIG\_MODVERSIONS estaba habilitado,
        necesitas tenerlo definido cuando compiles el mdulo del ncleo e 
        incluir {\tt /usr/include/linux/modversions.h}. Esto tambin puede
        ser realizado por el propio cdigo\index{CONFIG\_MODVERSIONS}%
\index{modversions.h}.

\end{itemize}


sourcesample(Makefile, 01_hello)

As que ahora slo falta hacer {\tt su} a root (no compilaste
como root, a que no? Viviendo en el lmite\footnote{El motivo por el que prefiero no
compilar como root es que cuanto menos cosas se hagan como root ms seguro estar el 
equipo. Trabajo en seguridad informtica, as que soy un paranoico}\ldots), y
entonces haz {\tt insmod hello} y {\tt rmmod hello} para la satisfaccin de tu alma. Mientras
lo haces, observa la presencia de tu nuevo mdulo del ncleo en 
{\tt /proc/modules}\index{insmod}\index{rmmod}\index{/proc/modules}%
\index{root}.

Por cierto: el motivo por el que Makefile recomienda no hacer {\tt insmod}
desde X es porque cuando el ncleo tiene que imprimir un mensaje con {\tt printk},
lo enva a la consola. Cuando no utilizas X, va al terminal virtual que ests
usando (el que escogiste con Alt-F$<$n$>$) y lo ves. Si utilizas X, en cambio, hay
dos posibilidades:  que tengas una consola abierta con {\tt xterm -C}, en cuyo caso la salida
ser enviada all, o que no, en cuyo caso la salida ir al terminal virtual 7 (el que est
``cubierto'' por X)\index{X}\index{X!porqu las deberas evitar}%
\index{xterm -C}\index{consola}\index{terminal virtual}%
\index{virtual}\index{virtual!terminal}\index{printk}.

Si tu ncleo se vuelve inestable ser ms probable que cojas los
mensajes de depuracin sin las X. Fuera de X, {\tt printk} va
directamente desde el ncleo a la consola. En X, en cambio, 
los {\tt printk}s van a un proceso de modo usuario ({\tt xterm -C}).
Cuando este proceso recibe tiempo de CPU, se supone que lo enva al proceso
servidor de X. Entonces, cuando el servidor X recibe la CPU, se supone que
lo muestra; pero un ncleo inestable normalmente significa que el sistema
se va a estrellar o a reiniciar, por lo tanto no quieres que se retrasen los 
mensajes de error, los que podran explicarte qu es lo que fue mal,
durante mucho ms tiempo del que necesitas. 



\section{Mdulos del ncleo de varios ficheros}\label{multi-file}%
\index{varios ficheros fuente}%
\index{ficheros fuente}\index{ficheros fuente!varios}

A veces tiene sentido dividir el mdulo del ncleo en varios
ficheros de cdigo. En este caso, tienes que hacer lo siguiente:

\begin{enumerate}

\item{En todos lo ficheros fuente menos en uno, aade la lnea
        {\tt \#define \_\_NO\_VERSION\_\_}. Esto es importante porque
        {\tt module.h} normalmente incluye la definicin de
        {\tt kernel\_version}, una variable global con la
        versin del ncleo para la que se compila el mdulo. Si 
        necesitas {\tt version.h}, tienes que incluirla, porque
        {\tt module.h} no lo har por ti con {\tt \_\_NO\_VERSION\_\_}%
\index{\_\_NO\_VERSION\_\_}\index{module.h}\index{version.h}%
\index{kernel\_version}.}

\item{Compila todos los ficheros fuente de la forma normal.}

\item{Combina todos los ficheros objeto en uno solo. Bajo x86, hazlo con
        {\tt ld -m elf\_i386 -r -o $<$nombre del mdulo$>$.o 
        $<$primer fichero fuente$>$.o $<$segundo fichero fuente$>$.o}\index{ld}%
\index{elf\_i386}.}

\end{enumerate}

He aqu un ejemplo de mdulo de este tipo.

sourcesample(start.c, 01_hello/multifile)
sourcesample(stop.c, 01_hello/multifile)
sourcesample(Makefile, 01_hello/multifile)


\chapter{Ficheros de dispositivos de carcter}\label{char-dev-file}%
\index{ficheros de dispositivos de carcter}%
\index{carcter}\index{carcter!ficheros de dispositivos}

As que ahora somos unos valientes programadores del ncleo y sabemos 
escribir mdulos que no hacen nada. Estamos orgullosos
de nosotros mismos y llevamos la cabeza bien alta. Pero
de algn modo sentimos que falta algo. Los mdulos catatnicos no son muy
divertidos. 

Hay dos formas principales de que un mdulo del ncleo se comunique con
los procesos. Una es a travs de los ficheros de dispositivos (como los
que estn en el directorio {\tt /dev}) y la otra es usar el sistema de ficheros 
proc. Ya que uno de los principales motivos para escribir algo en el ncleo
es soportar algn tipo de dispositivo de hardware, empezaremos con los
ficheros de dispositivos\index{/dev}.

El propsito original de los ficheros de dispositivo es permitir a los
procesos comunicarse con los controladores de dispositivos en el ncleo, 
y a travs de ellos con los dispositivos fsicos (mdems, terminales, etc.).
La forma en la que esto se implementa  es la 
siguiente\index{fsicos}%
\index{fsicos!dispositivos}\index{dispositivos fsicos}%
\index{modem}\index{terminal}.

A cada controlador de dispositivo, que es responsable de algn tipo
de hardware, se le asigna su propio nmero mayor. La lista de los controladores 
y de sus nmeros mayores est disponible en {\tt /proc/devices}. A cada dispositivo
fsico administrado por un controlador de dispositivo se le asigna un nmero menor. 
El directorio {\tt /dev} se supone que incluye un fichero especial, llamado
fichero de dispositivo, para cada uno de estos dispositivos, tanto si est  
realmente instalado en el sistema como si no\index{mayor}\index{mayor!nmero}%
\index{nmero}\index{nmero!mayor (del controlador de dispositivo)}%
\index{menor}\index{menor!nmero}%
\index{nmero}\index{nmero!mayor (del dispositivo fsico)}.

Por ejemplo, si haces {\tt ls -l /dev/hd[ab]*}, vers todas las particiones
de discos duros IDE que posiblemente estn conectadas a una mquina. Date cuenta de que
todos ellos usan el mismo nmero mayor, 3, pero el nmero menor cambia de uno
a otro {\em Nota: Esto es as suponiendo que ests usando una arquitectura PC. No s
nada sobre dispositivos en Linux ejecutndose en otras arquitecturas}.%
\index{IDE}\index{IDE!discos duros}%
\index{particin}\index{particin!de un disco duro}%
\index{disco duro}\index{disco duro!particiones de}

Cuando el sistema se instal, todos esos ficheros de dispositivos se
crearon mediante la orden {\tt mknod}. No existe un motivo tcnico por el que
tienen que estar en el directorio {\tt /dev}, es slo una convencin til.
Cuando creamos un fichero de dispositivo con el propsito de prueba, como aqu %fuzzy.FVD
para un ejercicio, probablemente tenga ms sentido colocarlo en el directorio
en donde compilas el mdulo del ncleo\index{mknod}\index{/dev}.

Los dispositivos estn divididos en dos tipos: los dispositivos de carcter
y los dispositivos de bloque. La diferencia es que los dispositivos de
bloque tienen un bfer para las peticiones, por lo tanto
pueden escoger en qu orden las van a responder. Esto es importante
en el caso de los dispositivos de almacenamiento, donde es ms rpido leer
o escribir sectores que estn cerca entre s, que aquellos
que estn ms desperdigados. Otra diferencia es que los dispositivos de
bloque slo pueden aceptar bloques de entrada y de salida (cuyo tamao
puede variar segn el dispositivo), en cambio los dispositivos
de carcter pueden usar muchos o unos pocos bytes como ellos quieran. %fuzzy. FVD
La mayora de los dispositivos del mundo son de carcter, porque
no necesitan este tipo de \emph{buffering}, y no operan con un tamao de
bloque fijo. Se puede saber cundo un fichero de dispositivo es para un
dispositivo de carcter o de bloque mirando el primer carcter de
la salida de {\tt ls -l}. Si es ``b''  entonces es un dispositivo de bloque,
y si es ``c'' es un dispositivo de carcter.%
\index{ficheros de dispositivo}%
\index{ficheros de dispositivo!carcter}%
\index{ficheros de dispositivo!bloque}%
\index{acceso secuencial}%
\index{secuencial}\index{secuencial!acceso}

Este mdulo est dividido en dos partes separadas: la parte del mdulo
que registra el dispositivo y la parte del controlador del dispositivo. La
funcin {\tt init\_module} llama a {\tt module\_register\_chrdev} para
aadir el controlador de dispositivo a la tabla de controladores de 
dispositivos de carcter del ncleo. Tambin devuelve el nmero mayor
que usar el controlador. La funcin {\tt cleanup\_module}
libera el dispositivo\index{module\_register\_chrdev}%
\index{nmero mayor del dispositivo}%
\index{nmero del dispositivo}\index{nmero del dispositivo!mayor}.

Esto (registrar y liberar algo) es la funcionalidad general
de estas dos funciones. Las cosas en el ncleo no funcionan por %fuzzy.FVD
su propia iniciativa, como los procesos, sino que son llamados por
procesos a travs de las llamadas al sistema, o por los dispositivos
hardware a travs de las interrupciones, o por otras partes
del ncleo (simplemente llamando a funciones especficas). Como 
resultado, cuando aades cdigo al ncleo, se supone que es
para registrarlo como parte de un manejador o para un cierto tipo
de evento y cuando lo quitas, se supone que lo liberas.%
\index{init\_module}\index{init\_module!propsito general}%
\index{cleanup\_module}\index{cleanup\_module!propsito general}.

El controlador del dispositivo se compone de cuatro funciones
device\_$<$accin$>$, que se llaman cuando alguien intenta
hacer algo con un fichero de dispositivo con nuestro nmero mayor. La
forma en que el ncleo sabe cmo llamarlas es a travs de la estructura
{\tt file\_operations}, {\tt Fops}, que se dio cuando el
dispositivo fue registrado, e incluye punteros a esas
cuatro funciones\index{file\_operations structure}%
\index{struct file\_operations}.

Otro punto que hemos de recordar aqu es que podemos permitir que 
el mdulo del ncleo sea borrado cuando \emph{root quiera}. El motivo es que %fuzzy.FVD
si el fichero del dispositivo es abierto por un proceso y entonces quitamos
el mdulo del ncleo, el uso del fichero causara una llamada a la posicin
de memoria donde la funcin apropiada (read/write) usada debera estar. 
Si tenemos suerte, ningn otro cdigo fue cargado all, y obtendremos
un feo mensaje. Si no tenemos suerte, otro mdulo del ncleo fue cargado 
en la misma posicin, lo que significar un salto en mitad de
otra funcin del ncleo. El resultado sera imposible de predecir, pero
no sera positivo\index{rmmod!previniendo}.

Normalmente, cuando no quieres permitir algo, devuelves un cdigo 
de error (un nmero negativo) desde la funcin que se supone que
lo tendra que hacer. Con  {\tt cleanup\_module} esto es imposible porque
es una funcin void. Una vez que se llama a {\tt cleanup\_module}, el mdulo
est muerto. En todo caso, hay un contador que cuenta cuntos otros mdulos
del ncleo estn usando el mdulo, llamado contador de referencia (que es 
el ltimo nmero de la lnea en {\tt /proc/modules}). Si este nmero es distinto de cero, 
{\tt rmmod} fallar. La cuenta de referencia del mdulo est disponible en la
variable {\tt mod\_use\_count\_}. Como hay macros definidas para manejar esta
variable ({\tt MOD\_INC\_USE\_COUNT} y {\tt MOD\_DEC\_USE\_COUNT}), 
preferimos usarlas, mejor que utilizar {\tt mod\_use\_count\_} directamente, por
lo tanto ser ms seguro si la implementacin cambia en el futuro.%
\index{/proc/modules}%
\index{cuenta de referencia}%
\index{mod\_use\_count\_}%
\index{cleanup\_module}%
\index{MOD\_INC\_USE\_COUNT}%
\index{MOD\_DEC\_USE\_COUNT}



sourcesample(chardev.c, 02_chardev)


\section{Ficheros fuente para varias versiones del ncleo}\label{kernel-ver}%
\index{versiones del ncleo}

Las llamadas al sistema, que son el principal interfaz que el ncleo
muestra a los procesos, generalmente permanecen igual de versin
a versin. Se puede aadir una nueva llamada al sistema, pero 
normalmente las antiguas se comportarn igual que de costumbre. 
Esto es necesario para la compatibilidad regresiva; una versin 
nueva del ncleo se supone que {\bf no} romper con los procesos regulares. En 
la mayora de los casos, los ficheros de dispositivo tambin permanecern igual. En
cambio, las interfaces internas dentro del ncleo pueden y de hecho sufren
cambios entre las versiones.  

Las versiones del ncleo Linux estn divididas entre las versiones estables
(n.$<$nmero par$>$.m) y las versiones en desarrollo (n.$<$nmero impar$>$.m).
Las versiones en desarrollo incluyen todas las ideas nuevas,  incluyendo aquellas
que sern consideradas un error, o reimplementadas, en la siguiente versin. Como
resultado, no puedes confiar en que la interfaz permanecer igual en estas
versiones (es por lo que no las tratamos en este libro, es mucho trabajo
y caducarn rpidamente). En las versiones estables, por otro lado, podemos 
esperar que el interfaz permanezca sin cambios sin importar la versin
de correccin de fallos (el nmero m)%
\index{versin en desarrollo}\index{versin en desarrollo!ncleo}%
\index{versin estable}\index{versin estable!ncleo}.

Esta versin de la GPMNL incluye soporte para la versin 2.0.x y la versin
2.2.x del ncleo Linux. Como hay diferencias entre las dos, esto requiere
compilacin condicional dependiendo de la versin del ncleo. La forma con
la que hacemos esto es usando la macro {\tt LINUX\_VERSION\_CODE}. En la versin
a.b.c. del ncleo, el valor de esta macro debera ser $2^{16}a+2^{8}b+c$. 
Para obtener el valor especfico de una versin especfica del ncleo, podemos
usar la macro {\tt KERNEL\_VERSION}. Como no est definida en 2.0.35, la 
definiremos nosotros mismos si es necesario.%
\index{ncleo 2.0.x}\index{ncleo 2.2.x}\index{versiones soportadas}%
\index{compilacin condicionada}%
\index{condicionada}\index{condicionada!compilacin}%
\index{LINUX\_VERSION\_CODE}\index{KERNEL\_VERSION}



\chapter{El sistema de ficheros /proc}\label{proc-fs}%
\index{sistema de ficheros proc}%
\index{sistema de ficheros /proc}%
\index{sistema de ficheros}\index{sistema de ficheros!/proc}

En Linux hay un mecanismo adicional para que el ncleo y los mdulos del ncleo
enven informacin a los procesos: el sistema de ficheros {\tt /proc}.
Originalmente diseado para permitir un fcil acceso a la informacin 
sobre los procesos (de aqu el nombre), ahora lo utiliza cualquier elemento del ncleo
que tiene algo interesante que informar, como {\tt /proc/modules} que tiene
la lista de los mdulos y {\tt /proc/meminfo} que tiene las estadsticas
de uso de la memoria\index{/proc/modules}%
\index{/proc/meminfo}.

El mtodo para usar el sistema de ficheros proc es muy similar al usado
con los controladores de dispositivos: creas una estructura con toda
la informacin que necesita el fichero {\tt /proc}, incluyendo punteros 
a cualquier funcin manejadora (en nuestro caso slo hay una, la que se
llama cuando alguien intenta leer del fichero {\tt /proc}). Entonces, 
{\tt init\_module} registra la estructura con el ncleo y {\tt cleanup\_module}
la libera.

El motivo por el que usamos {\tt proc\_register\_dynamic}\footnote{En la versin
2.0, en la versin 2.2 esto es realizado automticamente para nosotros si
establecemos el inodo a cero.} es porque no queremos determinar el nmero
de inodo usado para nuestro fichero por adelantado, sino permitir al
ncleo que lo determine para prevenir colisiones. Los sistemas de ficheros normales
estn localizados en un disco, en vez de en memoria (que es donde est
{\tt /proc}), y en ese caso el nmero de inodo es un puntero a una posicin
de disco donde el nodo ndice del fichero (abreviadamente inodo) est localizado. 
El inodo contiene informacin sobre el fichero, por ejemplo los permisos del
fichero, junto con un puntero a la posicin o posiciones del disco donde
se pueden encontrar los datos del fichero\index{proc\_register\_dynamic}%
\index{proc\_register}%
\index{inode}.

Como a nosotros no se nos llama cuando el fichero se abre o 
se cierra, no podemos poner {\tt MOD\_INC\_USE\_COUNT} y {\tt MOD\_DEC\_USE\_COUNT}
en este mdulo, ya que si el fichero es abierto y despus el mdulo es borrado, 
no hay forma de evitar las consecuencias. En el siguiente captulo veremos
una forma ms difcil de implementar, pero ms flexible, de tratar con los
ficheros {\tt /proc} que nos permitir protegernos tambin de este problema.


sourcesample(procfs.c, 03_procfs)



\chapter{Usando /proc para la entrada}\label{proc-input}%  %yo cambiara este ttulo. FVD
\index{Entrada}\index{Entrada!usando /proc para}%
\index{/proc}\index{/proc!usando para entrada}%
\index{proc!usando para entrada}

Hasta ahora tenemos dos formas de producir una salida a partir de los mdulos del ncleo: podemos
registrar un controlador de dispositivo y {\tt mknod} el fichero de dispositivo, 
o podemos crear un fichero {\tt /proc}. Esto permite al mdulo del ncleo 
decirnos cualquier cosa que quiera. El nico problema es que no tenemos ninguna forma
de responderle. La primera forma en que enviaremos entrada a los
mdulos del ncleo ser volviendo a escribir en el fichero {\tt /proc}.

Como el sistema de ficheros proc se escribi principalmente para
permitir al ncleo informar de su situacin a los procesos, no hay medidas
especiales para la entrada. La estructura {\tt proc\_dir\_entry} no incluye
un puntero a una funcin de entrada, de la misma forma que incluye un puntero
a una funcin de salida. En vez de esto, para escribir en un fichero {\tt /proc}, 
necesitamos usar el mecanismo estndar del sistema de ficheros%
\index{proc\_dir\_entry structure}%
\index{struct proc\_dir\_entry}.

En Linux hay un mecanismo estndar para el registro de sistemas de ficheros. 
Como cada sistema de ficheros tiene que tener sus propias funciones para
manejar las operaciones de inodos y ficheros\footnote{La diferencia entre ellas
es que las operaciones de ficheros tratan con el propio fichero, y las operaciones
de inodo tratan con las formas de referenciar el fichero, tales como crear
enlaces a l.}, hay una estructura especial para mantener los punteros a todas
estas funciones, {\tt struct inode\_operations}, que incluye un puntero
a {\tt struct file\_operations}. En /proc, cuando registramos un nuevo fichero, 
se nos permite especificar qu {\tt struct inode\_operations} se usar para 
acceder a l. ste es el mecanismo que usaremos, una {\tt struct inode\_operations}
que incluya punteros a nuestras funciones {\tt module\_input} y
{\tt module\_output}%
\index{registro de sistema de ficheros}%
\index{sistema de ficheros!registro}%
\index{struct inode\_operations}%
\index{inode\_operations structure}%
\index{struct file\_operations}%
\index{file\_operations structure}.

Es importante destacar que los papeles estndar de lectura y escritura
estn invertidos en el ncleo. Las funciones de lectura se usan para
la salida, mientras que las funciones de escritura se usan para la entrada.
El motivo de esto es que la lectura y escritura se refieren al punto de
vista del usuario: si un proceso lee algo del ncleo, entonces el 
ncleo necesita sacarlo, y si un proceso escribe algo en el ncleo, 
entonces el ncleo lo recibe como entrada\index{lectura}%
\index{lectura!en el ncleo}%
\index{escritura}\index{escritura!en el ncleo}.

Otro punto interesante aqu es la funcin {\tt module\_permission}. Esta 
funcin se llama cuando un proceso intenta hacer algo con el fichero
{\tt /proc}, y puede decidir si permitir el acceso o no. Ahora mismo
est solamente basado en la operacin y el uid del usuario actual (tal
como est disponible en {\tt current}, un puntero a una estructura
que incluye informacin del proceso actualmente en ejecucin), pero puede
estar basado en cualquier cosa que queramos, como lo que otros
procesos estn haciendo con el mismo fichero, la hora del da, o la ltima
entrada recibida\index{module\_permissions}%
\index{permisos}%
\index{puntero actual}%
\index{actual}\index{actual!puntero}


El motivo para {\tt put\_user} y {\tt get\_user} es que la memoria de Linux
(bajo la arquitectura Intel, quizs sea diferente bajo otros procesadores) 
est segmentada. Esto significa que un puntero, por s mismo, no referencia
una nica posicin en memoria, slo una posicin en un segmento
de memoria, y necesitas saber qu segmento es para poder
usarlo. Hay un segmento de memoria para el ncleo, y uno
para cada proceso\index{put\_user}%
\index{get\_user}%
\index{segmentos de memoria}%
\index{memoria}\index{memoria!segmento}.


El nico segmento de memoria accesible a un proceso es el suyo, por lo
tanto cuando escribimos programas normales para ejecutarse como procesos no
hay necesidad de preocuparse por los segmentos. Cuando escribes un mdulo
del ncleo, normalmente quieres acceder al segmento de memoria del ncleo, 
que es manejado automticamente por el sistema. Sin embargo, cuando el
contenido de un bfer de memoria necesita passarse entre el proceso
actualmente en ejecucin y el ncleo, la funcin del ncleo recibe un puntero 
al bfer de memoria que est en el segmento del proceso. Las macros
{\tt put\_user} y {\tt get\_user} nos permiten acceder a esa memoria.



sourcesample(procfs.c, 04_procfs2)



\chapter{Hablando con los ficheros de dispositivo (escrituras y IOCTLs)}\label{dev-input}%
\index{ficheros de dispositivo!entrada a}%
\index{entrada a ficheros de dispositivos}%
\index{ioctl}%
\index{escritura!a ficheros de dispositivos}

Los ficheros de dispositivos se supone que representan dispositivos
fsicos. La mayora de los dispositivos fsicos se utilizan para
salida y para entrada, por lo tanto tiene que haber algn mecanismo
para que los controladores de dispositivos que estn en el ncleo obtengan la salida
a enviar al dispositivo desde los procesos. Esto se hace abriendo
el fichero del dispositivo para salida y escribiendo en l, igual que se
escribe en un fichero. En el siguiente ejemplo, esto se implementa
mediante {\tt device\_write}.

Esto no es siempre suficiente. Imagnate que tienes un puerto serie conectado
a un mdem (incluso si tienen un mdem interno, todava se implementa desde
la perspectiva de la CPU como un puerto serie conectado a un mdem, por lo
tanto no tienes que hacer que tu imaginacin trabaje mucho). Lo natural sera
usar el fichero del dispositivo para escribir cosas al mdem (tanto comandos del mdem
como datos que se enviarn a travs de la lnea telefnica) y leer cosas desde el mdem
(respuestas a rdenes o datos recibidos a travs de la lnea telefnica).
De todos modos esto deja abierta la pregunta de qu hacer cuando necesitas hablar con
el puerto serie, por ejemplo para enviarle la velocidad a la que los datos
se envan y se reciben\index{puerto serie}\index{mdem}.

La respuesta en Unix es usar una funcin especial llamada {\tt ioctl} (abreviatura
de {\bf i}nput {\bf o}utput {\bf c}on{\bf t}ro{\bf l}). Cada dispositivo tiene
sus propias rdenes {\tt ioctl}, que pueden leer {\tt ioctl}'s (para
enviar informacin desde un proceso al ncleo), escribir {\tt ioctl}'s (para
devolver informacin a un proceso),
\footnote{Ten en cuenta que aqu los papeles de leer y escribir se han intercambiado
{\em otra vez}, por lo tanto en las lecturas {\tt ioctl} se enva informacin
al ncleo y las escrituras reciben informacin desde el ncleo.} ambas o ninguna.
La funcin se llama con tres parmetros; el descriptor del fichero del 
dispositivo apropiado, el nmero de ioctl, y un parmetro, que es 
de tipo long y al que le puedes hacer una conversin (cast) para
usarlo para pasar cualquier cosa.
\footnote{Esto no es exacto. No podrs pasarle una estructura, por
ejemplo, a travs de un ioctl; pero podrs  pasarle un puntero
a la estructura.}

El nmero ioctl codifica el nmero mayor del dispositivo, el tipo de la ioctl, 
la orden y el tipo del parmetro. Este nmero ioctl es normalmente
creado por una llamada a una macro ({\tt \_IO}, {\tt \_IOR}, {\tt \_IOW} o
{\tt \_IOWR}, dependiendo del tipo) en el fichero de cabeceras. Este
fichero de cabeceras debera  ser incluido ({\tt \#include}) tanto en 
los programas que van a usar {\tt ioctl} (para que puedan generar los {\tt ioctl}s
apropiados) como por el mdulo del ncleo (para que lo entienda). En el 
ejemplo siguiente, el fichero de cabeceras es {\tt chardev.h} y el 
programa que lo usa es {\tt ioctl.c}\index{\_IO}%
\index{\_IOR}%
\index{\_IOW}%
\index{\_IOWR}

Si quieres usar {\tt ioctl}s en tus propios mdulos del ncleo, es mejor
recibir un asignacin {\tt ioctl} oficial, por que si accidentalmente coges
los {\tt ioctl}s de alguien, o alguien coge los tuyos, sabrs que algo est mal.
Para ms informacin, consulta el rbol del cdigo fuente del ncleo en
``{\tt Documentation/ioctl-number.txt}''\index{asignacin oficial ioctl}%
\index{ioctl!asignacin oficial}.


sourcesample(chardev.c, 05_devrw)
sourcesample(chardev.h, 05_devrw)%
\index{ioctl!definiendo}%
\index{definiendo ioctls}%
\index{ioctl!fichero de cabeceras para}%
\index{fichero de cabeceras para ioctls}

sourcesample(ioctl.c, 05_devrw)%
\index{ioctl!usndolo en un proceso}


\chapter{Parmetros de inicio}\label{startup-param}% %este captulo se cae en la versin 2.4
\index{parmetros de inicio}%
\index{inicio}\index{inicio!parmetros de}


En muchos ejemplos previos, tuvimos que codificar algo en el mdulo
del ncleo, tal como el nombre del fichero para los ficheros {\tt /proc}
o el nmero mayor del dispositivo para el dispositivo para que pudiramos
hacer ioctls en l. Esto va en contra de la filosofa de Unix, y Linux, 
que es escribir un programa flexible que el usuario pueda configurar%
\index{codificar}.

La forma de decirle a un programa, o a un mdulo del ncleo, algo que
necesitan antes de empezar a trabajar es mediante los parmetros de la lnea de
rdenes. En el caso de los mdulos del ncleo, no disponemos de {\tt argc} 
y {\tt argv}; en cambio tenemos algo mejor. Podemos definir
variables globales en el mdulo del ncleo e {\tt insmod} las rellenar por
nosotros\index{argc}\index{argv}.

En este mdulo del ncleo definimos dos de ellas: {\tt str1} y {\tt str2}.
Todo lo que necesitas hacer es compilar el mdulo del ncleo y entonces
ejecutar {\tt insmod str1=xxx str2=yyy}.
Cuando  se llama a {\tt init\_module}, {\tt str1} apuntar a la cadena de caracteres 
``{\tt xxx}'' y {\tt str2} a la cadena de caracteres ``{\tt yyy}''%
\index{insmod}.

En la versin 2.0 no hay comprobacin de tipos de estos argumentos\footnote{No puede
haberlos, ya que bajo C el fichero objeto slo tiene la localizacin de
las variables globales, no de su tipo. Esto es por lo que los ficheros
de cabeceras son necesarios}. Si el primer carcter de {\tt str1} o {\tt str2}
es un dgito, el ncleo rellenar la variable con el valor del entero, en vez de
con un puntero a la cadena de caracteres. En una situacin de la vida real
tienes que verificar esto\index{comprobacin de tipos}.

En cambio, en la versin 2.2 usas la macro {\tt MACRO\_PARM} para decir
a {\tt insmod} lo que esperas como parmetros, su nombre {\em y su tipo}.
Esto resuelve el problema de los tipos y permite a los mdulos del ncleo 
recibir cadenas de caracteres que empiezan con un dgito, por ejemplo%
\index{MACRO\_PARM}%
\index{insmod}.

sourcesample(param.c, 06_params)



\chapter{Llamadas al sistema}\label{sys-call}%
\index{llamadas al sistema}%
\index{sistema}\index{sistema!llamadas al}

Hasta ahora lo nico que hemos hecho ha sido usar mecanismos bien
definidos del ncleo para registrar ficheros {\tt proc} y manejadores de 
dispositivos. Esto est muy bien si quieres hacer algo que los
programadores del ncleo pensaron que querras hacer, como escribir un 
controlador de dispositivo. Pero y si quieres escribir algo inusual, 
cambiar el comportamiento del sistema de alguna forma? Entonces, te
encuentras solo.

Aqu es dnde la programacin del ncleo se vuelve peligrosa. 
Al escribir el ejemplo siguiente elimin la llamada al sistema {\tt open}.
Esto significa que no podra abrir ningn fichero, no podra ejecutar
ningn programa, y no podra {\tt apagar} la computadora. Tuve que pulsar
el interruptor. Afortunadamente, no se muri ningn fichero. Para asegurate
de que t tampoco pierdas ningn fichero, por favor ejecuta {\tt sync} justo
antes de hacer el {\tt insmod} y el {\tt rmmod}%
\index{sync}%
\index{insmod}%
\index{rmmod}%
\index{shutdown}.

Olvdate de los ficheros {\tt /proc}, olvdate de los ficheros de los dispositivos.
Son slo detalles menores. El mecanismo {\em real} de comunicacin entre
los procesos y el ncleo, el que usan todos los procesos, son las
llamadas al sistema. Cuando un proceso pide un servicio al ncleo (tal como
abrir un fichero, ramificarse en un nuevo proceso o pedir ms memoria), ste es
el mecanismo que se usa. Si quieres cambiar el comportamiento del ncleo de
formas interesantes, ste es el sitio para hacerlo.  Por cierto, si quieres
ver las llamadas al sistema que usa un programa, ejecuta 
{\tt strace {\lbr}orden{\rbr} {\lbr}argumentos{\rbr}}%
\index{strace}.

En general, un proceso se supone que no puede acceder al ncleo. No
puede acceder a la memoria del ncleo y no puede llamar a las funciones del
ncleo. El hardware de la CPU fuerza esto (por eso
se le llama ``modo protegido'').
Las llamadas al sistema son una excepcin a esta regla general. Lo que sucede
es que el proceso rellena los registros con los valores apropiados y entonces
llama a una instruccin especial, que salta a una posicin previamente
definida dentro del ncleo (por supuesto, la posicin es legible por los procesos
de usuario, pero no pueden escribir en ella). Bajo las CPUs de Intel, esto se hace por
medio de la interrupcin 0x80.
El hardware sabe que una vez que saltas a esta localizacin, ya no te estars 
ejecutando en el modo restringido de usuario, sino como el ncleo del sistema
operativo. Y entonces se te permite hacer todo lo que quieras%
\index{interrupcin 0x80}.

A la posicin en el ncleo a la que un proceso puede saltar se le llama {\tt system\_call}.
El procedimiento en esa posicin verifica el nmero de la llamada al sistema, 
que le dice al ncleo qu servicio ha pedido el proceso. Despus mira
en la tabla de llamadas al sistema ({\tt sys\_call\_table}) para ver la direccin
de la funcin del ncleo a llamar. A continuacin llama a la funcin, y despus
de retornar hace unas pocas comprobaciones del sistema y luego regresa al proceso (o a un
proceso diferente, si el tiempo del proceso ha finalizado). Si quieres leer
este cdigo, est en el fichero fuente {\tt arch/$<$architecture$>$/kernel/entry.S}, 
despus de la lnea {\tt ENTRY(system\_call)}%
\index{system\_call}%
\index{ENTRY(system\_call)}%
\index{sys\_call\_table}%
\index{entry.S}.

Por lo tanto, si queremos cambiar la forma en que funciona una cierta
llamada al sistema, lo que tenemos que hacer es escribir nuestra
propia funcin para implementarla (normalmente aadiendo un poco de
nuestro cdigo y despus llamando a la funcin original) y entonces
cambiar el puntero que est en {\tt sys\_call\_table} para que apunte
a nuestra funcin. Como es posible que seamos eliminados ms tarde y
no queremos dejar el sistema en un estado inestable, es importante que
{\tt cleanup\_module} restaure la tabla a su estado original.

El presente cdigo fuente es un ejemplo de mdulo del ncleo. Queremos
``espiar'' a un cierto usuario e imprimir un mensaje (con printk) cuando el
usuario abra un fichero. Para conseguir dicha meta, reemplazamos la llamada
al sistema que abre un fichero con nuestra propia funcin, llamada {\tt our\_sys\_open}.
Esta funcin verifica el uid (identificacin del usuario) del proceso actual, y
si es igual al uid que queremos espiar, llama a {\tt printk} para mostrar el nombre
del fichero que se va a abrir. Luego llama a la funcin original {\tt open} 
con los mismos parmetros, para realmente abrir el fichero\index{abrir}\index{abrir!llamada al sistema}.

La funcin {\tt init\_module} sustituye la localizacin apropiada que est en
{\tt sys\_call\_table} y mantiene el puntero original en una variable. La funcin {\tt cleanup\_module}
utiliza dicha variable para devolver todo a su estado normal. Esta aproximacin
es peligrosa, por la posibilidad de que dos mdulos del ncleo
cambien la misma llamada al sistema. Imagnate que tenemos dos mdulos
del ncleo, A y B. La llamada al sistema de A ser A\_open y la de
B ser B\_open. Ahora, cuando A se inserta en el ncleo, la
llamada al sistema es reemplazada con A\_open, la cual llamar a la 
sys\_open original cuando haya acabado. A continuacin, B es insertado en 
el ncleo, que reemplaza la llamada al sistema con B\_open, que a su vez ejecutar
la llamada al sistema que l piensa que es la original, A\_open, cuando haya terminado. 

Ahora, si B se quita primero, todo estar bien: simplemente
restaurar la llamada al sistema a A\_open, la cual llama a la
original. En cambio, si se quita A  y  despus se quita B, el
sistema se caer. El borrado de A restaurar la llamada original al sistema,
sys\_open, sacando a B fuera del bucle. Entonces, cuando B es borrado, restaurar
la llamada al sistema a la que {\bf l} piensa que es la original, A\_open, que ya
no est en memoria. A primera vista, parece que podramos resolver
este problema particular verificando si la llamada al sistema es igual
a nuestra funcin open y si lo es no cambindola (de forma que
B no cambie la llamada al sistema cuando se borre), lo
que causar un problema peor an. Cuando se borra A, a l le parece que la
llamada al sistema fue cambiada a B\_open y as que ya no apunta a
A\_open, y por lo tanto no la restaurar a sys\_open antes de ser
borrado de memoria. Desgraciadamente B\_open an intentar llamar a
A\_open, que ya no est all, por lo que incluso sin quitar B 
el sistema se caer.
 
Se me ocurren dos formas de prevenir este problema. La primera es restaurar
la llamada al valor original, sys\_open. Desgraciadamente, sys\_open no es
parte de la tabla del sistema del ncleo que est en {\tt /proc/ksyms}, por tanto
no podemos acceder a ella. La otra solucin es usar el contador de referencias
para evitar que root pueda borrar el mdulo una vez cargado. Esto es
bueno para de mdulos de produccin, pero malo para un ejemplo
de aprendizaje (que es por lo que no lo hice aqu%
\index{rmmod}\index{MOD\_INC\_USE\_COUNT}%
\index{sys\_open}).

sourcesample(syscall.c, 07_syscall)


\chapter{Procesos bloqueantes}\label{blocks}%
\index{procesos bloqueantes}%
\index{bloqueantes}\index{bloqueantes!procesos}

Qu puedes hacer cuando alguien te pregunta por algo que no puedes hacer en el acto?
Si eres un humano y ests te est molestando un humano, lo nico
que puedes decir es: ``Ahora no. Estoy ocupado. {\em !`Vete!}''. Pero si eres
un mdulo del ncleo y un proceso te est molestando, tienes otra
posibilidad. Puedes poner el proceso a dormir hasta que lo puedas atender.
Despus de todo, los procesos son puestos a dormir por el ncleo y todos son 
despertados al mismo tiempo (esta es la forma en la que varios procesos
aparentan ejecutarse a la vez en una sola CPU)%
\index{multi tarea}%
\index{ocupado}.

Este mdulo del ncleo es un ejemplo de esto. El fichero (llamado {\tt /proc/sleep})
slo puede ser abierto por un solo proceso a la vez. Si el fichero ya est
abierto, el mdulo del ncleo llama a {\tt module\_interruptible\_sleep\_on}\footnote{
La forma ms fcil de mantener un fichero abierto es con {\tt tail -f}.}. Esta
funcin cambia el estado de la tarea (una tarea es la estructura de datos del
ncleo que mantiene informacin sobre un proceso y la llamada al sistema en
la que est, si es que est en alguna) a {\tt TASK\_INTERRUPTIBLE}, lo que
significa que la tarea no se ejecutar hasta que sea despertada de alguna forma,
y se aade a {\tt WaitQ}, la cola de tareas esperando acceder al fichero.
Entonces, la funcin llama al planificador para hacer un cambio de contexto
a un proceso diferente, uno que tenga alguna utilidad para la CPU%
\index{interruptible\_sleep\_on}%
\index{TASK\_INTERRUPTIBLE}%
\index{dormir}\index{dormir!poniendo lo procesos a}%
\index{procesos}\index{procesos!poniendo a dormir}%
\index{poniendo procesos a dormir}%
\index{task structure}%
\index{estructura}\index{estructura!task}.

Cuando un proceso ha acabado con el fichero, lo cierra, y se llama a {\tt module\_close}.
Esta funcin despierta a todos los procesos en la cola (no hay un
mecanismo para despertar slo a uno de ellos). Entonces retorna y el
proceso que acaba de cerrar el fichero puede continuar ejecutndose. 
A la vez, el planificador decide que ese proceso ya tuvo suficiente tiempo y le da
el control de la CPU a otro proceso. Eventualmente, a uno de los procesos que
estaba en la cola le ser concecido el control de la CPU por parte del planificador.
ste empieza en el punto justo despus de la llamada a {\tt module\_interruptible\_sleep\_on}
\footnote{Esto significa que el proceso an est en modo ncleo; en lo
que concierne al proceso, ste emiti la llamada al sistema {\tt open}
y la llamada al sistema no ha regresado todava. El proceso no conoce a nadie
que usara la CPU durante la mayora del tiempo entre el momento en el que
hizo la llamada y el momento en el que regres.}. Puede proceder a 
establecer un variable global para decirles a todos los dems procesos que el 
fichero an est abierto y seguir con su vida. Cuando los otros procesos obtienen
un poco de CPU, vern la variable global y volvern a dormirse%
\index{despertando procesos}%
\index{procesos!despertando}%
\index{multitarea}%
\index{planificador}.

Para hacer nuestra vida ms interesante, {\tt module\_close} no tiene el
monopolio de despertar a los procesos que estn esperando a
acceder al fichero. Una seal, tal como Ctrl-C ({\tt SIGINT}) tambin
puede despertar a un proceso\footnote{Esto es porque nosotros
usamos {\tt module\_interruptible\_sleep\_on}. Podamos haber usado
{\tt module\_sleep\_on} en vez de ella, pero lo que conseguiramos 
seran usuarios extremadamente enfadados cuyos Ctrl-C's seran ignorados.}
En este caso, queremos regresar inmediatamente con {\tt -EINTR}. Esto es
importante para que los usuarios puedan, por ejemplo, matar el
proceso antes de que reciba el fichero%
\index{module\_wake\_up}%
\index{seal}%
\index{SIGINT}%
\index{ctrl-c}%
\index{EINTR}%
\index{procesos!matando}%
\index{module\_sleep\_on}%
\index{sleep\_on}.

Hay un punto ms que recordar. Algunas veces los procesos no quieren dormir, 
quieren o bien coger lo que quieren inmediatamente, o bien que les digan 
que ello no es posible. Tales procesos usan la bandera {\tt O\_NONBLOCK}
cuando abren el fichero. Se supone que el ncleo responde retornando
con el cdigo de error {\tt -EAGAIN} desde operaciones que en caso
contrario se bloquearan, tales como abrir el fichero en este ejemplo. El programa
cat\_noblock, disponible en el directorio fuente de este captulo, puede 
utilizarse para abrir el fichero con {\tt O\_NONBLOCK}%
\index{O\_NONBLOCK}%
\index{no bloqueante}%
\index{bloqueo, cmo evitarlo}%
\index{EAGAIN}.



sourcesample(sleep.c, 08_sleep)



\chapter{Reemplazando printk's}\label{printk}%
\index{printk!reemplazando}%
\index{reemplazando printk's}

Al principio (captulo~\ref{hello-world}), dije que X y la programacin
de mdulos del ncleo no se mezclaban. Esto es verdad para el desarrollo
de mdulos del ncleo, pero en el uso real quieres poder
enviar mensajes a cualquiera que sea el tty\footnote{{\bf T}ele{\bf ty}pe,
originalmente una combinacin de teclado e impresora usada para comunicarse
con un sistema Unix, y hoy una abstraccin para el flujo de texto
usado para un programa Unix, ya sea un terminal fsico, un xterm, una
pantalla X, una conexin de red usada con telnet, etc.} de donde vino la orden que
carg el mdulo.

%% Esto es importante para identificar errores despus de   % esto se ha cado de la versin final. FVD
%% que el mdulo del ncleo es liberado, porque ser usado por todos ellos.

La forma de hacer esto es usando {\tt current}, un puntero a la
tarea actualmente en ejecucin, para obtener la estructura tty de la
tarea actual. Despus miramos dentro de la estructura tty para encontrar
un puntero a una funcin de escritura de cadenas de caracteres, que usamos
para escribir una cadena de caracteres a la tty%
\index{tarea actual}\index{tarea}\index{tarea!actual}%
\index{tty\_struct}\index{estructura!tty}.


sourcesample(printk.c, 09_printk)



\chapter{Planificando tareas}\label{sched}%
\index{planificando tareas}\index{tareas!planificando}

Muy frecuentemente tenemos tareas ``de labores domsticas'' que tienen
que ser realizadas en un cierto tiempo, o todas frecuentemente.  % every so often ?? FVD
Si la tarea tiene que ser realizada por un proceso, lo haremos
ponindolo en el fichero {\tt crontab}. Si la tarea es realizada por
un mdulo del ncleo, tenemos dos posibilidades. La primera es poner
un proceso en el fichero {\tt crontab} que despertar al mdulo
mediante una llamada al sistema cuando sea necesario, por ejemplo
abriendo un fichero. Sin embargo esto es terriblemente ineficiente:
ejecutamos un proceso a partir de {\tt crontab}, leemos un ejecutable
nuevo hacia la memoria, y todo esto para despertar a un mdulo del
ncleo que de todas formas est en memoria%
\index{domsticas}\index{crontab}.

En vez de hacer eso, podemos crear una funcin que ser llamada una vez
en cada interrupcin del reloj. La forma en la que hacemos esto es
creando una tarea, mantenida en una {\tt estructura tq\_struct}, que
mantendr un puntero a la funcin. Entonces usamos {\tt queue\_task}
para poner esta tarea en una lista de tareas llamada {\tt tq\_timer}, que
es la lista de tareas que han de ejecutarse en la siguiente interrupcin
de reloj. Como queremos que la funcin siga siendo ejecutada, 
necesitamos ponerla otra vez en {\tt tq\_timer} al ser llamada, para
la siguiente interrupcin del reloj%
\index{struct tq\_struct}\index{tq\_struct struct}%
\index{queue\_task}%
\index{tarea}%
\index{tq\_timer}.

Hay un punto ms que necesitamos recordar aqu. Cuando un mdulo es quitado
mediante {\tt rmmod}, primero se verifica su contador de referencias. Si es cero, 
se llama a {\tt module\_cleanup}. Entonces se quita el mdulo de la memoria
con todas sus funciones. Nadie controla si la lista de tareas del
reloj contiene un puntero a una de estas funciones, que ya no estarn
disponibles. Aos despus (desde la perspectiva de la computadora; para
la perspectiva de un humano no es nada, menos de una milsima de segundo), el
ncleo tiene una interrupcin de reloj e intenta llamar a la funcin que est en la lista
de tareas. Desgraciadamente, la funcin ya no est all. En la mayora de
los casos, la pgina de memoria donde resida est sin utilizar, y
obtienes un feo mensaje de error. Pero si algn otro cdigo est ahora
situado en la misma posicin de memoria, las cosas podran ponerse
{\bf muy} feas. Desgraciadamente, no tenemos una forma fcil de eliminar
una tarea de una lista de tareas%
\index{rmmod}%
\index{cuenta de referencia}%
\index{module\_cleanup}.

Como {\tt cleanup\_module} no puede retornar con un cdigo de error (es
una funcin void), la solucin es no dejar que retorne. En vez de ello, 
llama a {\tt sleep\_on} o {\tt module\_sleep\_on}\footnote{Ambas son realmente
lo mismo.} para poner el proceso {\tt rmmod} a dormir. Antes de eso,
informa a la funcin llamada por la interrupcin del reloj para que pare
de apuntarse estableciendo una variable global. Entonces, en la siguiente 
interrupcin del reloj, el proceso {\tt rmmod} ser despertado, cuando nuestra
funcin ya no est en la cola y es seguro quitar el mdulo%
\index{sleep\_on}\index{module\_sleep\_on}.

sourcesample(sched.c, 10_sched)


\chapter{Manejadores de interrupciones}\label{int-handler}%
\index{manejadores de interrupciones}%
\index{interrupcin}\index{interrupcin!manejador}

Excepto para el ltimo captulo, todo lo que hemos hecho hasta ahora en el ncleo ha
sido como respuesta a un proceso que lo pide, ya sea tratando
con un fichero especial, enviando un {\tt ioctl()}, o a travs de una llamada
al sistema. Pero el trabajo del ncleo no es slo responder a las peticiones
de los procesos. Otro trabajo no menos importante es hablar
con el hardware conectado a la mquina.

Hay dos tipos de interaccin entre la CPU y el resto del hardware de la
computadora. El primer tipo es cuando la CPU da rdenes al hardware, el
el otro es cuando el hardware necesita decirle algo a la CPU.
La segunda, llamada interrupcin, es mucho ms difcil de implementar
porque hay que tratar con ella cuando le conviene al hardware, no a la CPU. 
Los dispositivos hardware tpicamente tienen una pequea cantidad de RAM, y
si no lees su informacin cuando est disponible, se pierde.

Bajo Linux, las interrupciones hardware se llaman IRQs (abreviatura de
{\bf I}nterrupt {\bf R}e{\bf q}uests)\footnote{Esta es una nomenclatura
estndar de la arquitectura Intel donde Linux se origin.}.  Hay dos tipos
de IRQs, cortas y largas. Una IRQ corta es la que se espera que dure un
periodo de tiempo {\bf muy} corto, durante el cual el resto de la mquina estar
bloqueado y ninguna otra interrupcin ser manejada. Una IRQ larga es una que 
puede durar ms tiempo, y durante la cual otras interrupciones pueden ocurrir (pero
no interrupciones que vengan del mismo dispositivo). Si es posible, siempre es mejor
declarar un manejador de interrupciones como largo.

Cuando la CPU recibe una interrupcin, detiene lo que quiera que est haciendo
(a menos que se encuentre procesando una interrupcin ms prioritaria, en cuyo
caso tratar con esta interrupcin slo cuando la ms prioritaria se haya
acabado), salva ciertos parmetros en la pila y llama al manejador de interrupciones.
Esto significa que ciertas cosas no se permiten dentro del propio manejador de interrupciones,
porque el sistema se encuentra en un estado desconocido. La solucin a este
problema es que el manejador de interrupciones haga lo que necesite
hacer inmediatamente, normalmente leer algo desde el hardware o 
enviar algo al hardware, y despus planificar el manejo de la nueva informacin
en un tiempo posterior (esto se llama ``bottom half'') y retorna. El ncleo
est garantizado que llamar al bottom half tan pronto como sea posible; y 
cuando lo haga, todo lo que est permitido en los mdulos del ncleo estar 
permitido\index{bottom half}.

La forma de implementar esto es llamar a {\tt request\_irq()} para que se llame
a tu manejador de interrupciones cuando se reciba la IRQ relevante
(hay 15 de ellas, ms una que se utiliza para disponer en cascada
los controladores de interrupcin, en las plataformas Intel). %% ya puestos adaptamos esto de la versin 2.4. FVD
Esta funcin recibe el nmero 
de IRQ, el nombre de la funcin, banderas, un nombre para {\tt /proc/interrupts}
y un parmetro para pasarle al manejador de interrupciones. Las banderas pueden
incluir {\tt SA\_SHIRQ} para indicar que ests permitiendo compartir la IRQ con
otro manejador de interrupciones (normalmente porque un nmero de dispositivos
hardware estn en la misma IRQ) y {\tt SA\_INTERRUPT} para indicar que
esta es una interrupcin rpida. Esta funcin slo tendr xito si no hay ya
un manejador para esta IRQ, o si ya la estais compartiendo%
\index{request\_irq}%
\index{/proc/interrupts}%
\index{SA\_SHIRQ}%
\index{SA\_INTERRUPT}.

Entonces, desde dentro del manejador de interrupciones, nos comunicamos con 
el hardware y despus usamos {\tt queue\_task\_irq()} con {\tt tq\_immediate()}
y {\tt mark\_bh(BH\_IMMEDIATE)} para planificar el bottom half. El motivo por el que no podemos usar
la {\tt queue\_task} estndar en la versin 2.0 es que la interrupcin
podra producirse en el medio de la {\tt queue\_task} de alguien
\footnote{{\tt queue\_task\_irq} est protegida de esto mediante un bloqueo global;
en 2.2 no hay {\tt queue\_task\_irq} y {\tt queue\_task} est protegida por
un bloqueo.}. Necesitamos {\tt mark\_bh} porque las versiones anteriores de 
Linux slo tenan un array de 32 bottom half's, y ahora uno de ellos 
({\tt BH\_IMMEDIATE}) se usa para la lista enlazada de bottom half's para
los controladores que no tenan una entrada de bottom half asignada%
\index{queue\_task\_irq}%
\index{queue\_task}%
\index{tq\_immediate}%
\index{mark\_bh}%
\index{BH\_IMMEDIATE}.


\section{Teclados en la arquitectura Intel}\label{teclado}%
\index{teclado}\index{arquitectura Intel}\index{arquitectura Intel!teclado}

% \bf Atencin:   %  ya no es un warning. FVD
El resto de este captulo es completamente especfico de Intel. Si
no ests trabajando en una plataforma Intel, no funcionar. Ni siquiera intentes
compilar el siguiente cdigo.


Tuve un problema escribiendo el cdigo de ejemplo para este captulo. Por
una parte, para que un ejemplo sea til tiene que ejecutarse en las computadoras de todo
el mundo con resultados significativos. Por otra parte, el ncleo ya incluye
controladores de dispositivo para todos los dispositivos comunes, y esos
controladores de dispositivo no coexistirn con lo que voy a escribir. La
solucin que encontr fue escribir algo para la interrupcin del teclado, y
deshabilitar primero el manejador normal de interrupcin del teclado. Como
est definido como un smbolo esttico en los ficheros fuente del ncleo
(concretamente {\tt drivers/char/keyboard.c}), no hay forma de restaurarlo.
Antes de instalar este cdigo, haz en otro terminal {\tt sleep 120 ; reboot}  % insmodear? FVD
si es que valoras en algo tu sistema de ficheros.

Este cdigo se registra para la IRQ 1, que es la IRQ controlada por
el teclado bajo las arquitecturas Intel. Entonces, cuando recibe una
interrupcin de teclado, lee el estado del teclado (que es el propsito
 de {\tt inb(0x64)}) y el cdigo de barrido (scan code), que es el valor devuelto por el 
teclado. Tan pronto como el ncleo cree que es factible, ejecuta
{\tt got\_char} que da el cdigo de la tecla usada (los siete primeros bits
del cdigo de barrido) y si ha sido presionado (si el octavo bit es cero) 
o soltado (si es uno)\index{inb}.

%jop, hay ms errores que palabras . FVD


sourcesample(intrpt.c, 11_intrp)


\chapter{Multiproceso simtrico}\label{smp}%
\index{SMP}%
\index{multiproceso}%
\index{multiproceso simtrico}%
\index{proceso}\index{proceso!multi}
 
Una de las formas ms fciles y baratas de aumentar el rendimiento del hardware
es poner ms de una CPU en la placa. Esto se puede realizar haciendo que
CPUs diferentes tengan trabajos diferentes (multiproceso asimtrico)
o haciendo que todos se ejecuten en paralelo, realizando el mismo trabajo
(multiproceso simtrico o SMP). El hacer multiproceso 
asimtrico requiere un conocimiento especializado sobre las
tareas que la computadora debe ejecutar, lo que no est a nuestro alcance en
un sistema operativo de propsito general como Linux. En cambio el
multiproceso simtrico es relativamente fcil de implementar%
\index{CPU}\index{CPU!varias}.
 
Por relativamente fcil, quiero decir exactamente eso; no que sea {\em realmente}
fcil. En un entorno de multiproceso simtrico, las CPUs comparten
la misma memoria, y como resultado, el cdigo que corre en una CPU puede
afectar a la memoria usada por otra. Ya no puedes estar seguro de que
una variable que has establecido a un cierto valor en la lnea anterior todava
tenga el mismo valor; la otra CPU quizs haya estado jugando con ella mientras no
mirbamos. Obviamente, es imposible programar algo de esta manera.

En el caso de la programacin de procesos esto no suele ser un 
problema, porque un proceso normalmente slo se ejecutar en
una CPU a la vez\footnote{La excepcin son los procesos con hilos, que pueden
ejecutarse en varias CPUs a la vez.}. El ncleo, sin embargo, podra ser
llamado por diferentes procesos ejecutndose en CPUs diferentes.

En la versin 2.0.x, esto no es un problema porque el ncleo entero
est en un gran ``spinlock''. Esto significa que si una CPU est dentro del ncleo
y otra CPU quiere entrar en l, por ejemplo por una llamada al sistema, tiene
que esperar hasta que la primera CPU haya acabado. Esto es lo que hace al SMP en
Linux seguro\footnote{En el sentido de que es seguro usarlo con SMP}, pero 
terriblemente ineficiente.

En la versin 2.2.x, varias CPUs pueden estar dentro del ncleo al mismo tiempo. Esto
es algo que los escritores de mdulos tienen que tener en cuenta.

% Espero que alguien me d acceso a un equipo SMP, as que espero  %
% que la siguiente versin de este libro incluya ms informacin.  % Esto se ha cado en ver 2.4. FVD

% Desgraciadamente, no tengo acceso a un equipo SMP para probar cosas, por lo
% tanto no puedo escribir un captulo sobre cmo hacerlo correctamente. Si 
% alguien tiene acceso a uno y est deseoso de ayudarme, estar agradecido. Si
% una compaa me suministrara este acceso, les dara un prrafo gratis en
% el comienzo de este captulo.


\chapter{Problemas comunes}\label{bad-ideas}

Antes de enviarte al mundo exterior y escribir mdulos del ncleo, hay algunas
cosas sobre las que te tengo que avisar. Si me equivoco al avisarte
y sucede algo malo, por favor envame el problema para que te devuelva
ntegramente lo que me pagaron por tu copia del libro%
\index{poltica de devolucin}.

\begin{enumerate}

\item{\bf Usar bibliotecas estndar.} No puedes hacer esto. En un mdulo
        del ncleo slo puedes usar las funciones del ncleo, que
        son las funciones que puedes ver en {\tt /proc/ksyms}%
\index{bibliotecas estndar}\index{estndar}\index{estndar!bibliotecas}%
\index{/proc/ksyms}\index{ksyms}\index{ksyms!fichero proc}.

\item{\bf Deshabilitar las interrupciones.} 
        Podras necesitar hacerlo por un momento y es
        correcto, pero si no las habilitas posteriormente, tu sistema se quedar
        muerto y tendrs que apagarlo%
\index{interrupcin!deshabilitando}.

\item{\bf Meter tu cabeza dentro de la boca de un gran carnvoro.} Es algo que probablemente no
        tendra por qu advertirte pero pens que deba hacerlo de
        todas formas, por si acaso.

\end{enumerate}

\appendix

\chapter{Cambios entre 2.0 y 2.2}\label{ver-changes}%
\index{versiones!ncleo}\index{2.2 cambios}

No conozco todo el ncleo tan bien como para documentar todos los cambios.
En el transcurso de la conversin de los ejemplos (o ms bien adaptando los cambios
de Emmanuel Papirakis) me encontr con las siguientes diferencias. Las
relaciono aqu, todas juntas, para ayudar a los programadores de mdulos (especialmente aquellos
que aprendieron de versiones previas de este libro y que estn ms familiarizados
con las tcnicas que utilizo) a convertirse a la nueva versin.

Un recurso adicional para la gente que quiera convertirse a 2.2 est en
{\tt http://www.atnf.csiro.au/\verb'~'rgooch/linux/docs/porting-to-2.2.html}.


\begin{enumerate}

\item{\bf asm/uaccess.h} Si necesitas {\tt put\_user} o {\tt get\_user} 
        tienes que incluir (\#include) sus ficheros de cabeceras%
\index{asm/uaccess.h}\index{uaccess.h!asm}%
\index{get\_user}\index{put\_user}.

\item{\bf get\_user} En la versin 2.2, {\tt get\_user} recibe tanto el
        puntero a la memoria de usuario como la variable en la memoria
        del ncleo para rellenarla con la informacin. El motivo por el 
        que esto es as es que {\tt get\_user} ahora puede leer
        dos o cuatro bytes al mismo tiempo si la variable que 
        leemos es de una longitud de dos o cuatro bytes.

\item{\bf file\_operations} Esta estructura ahora tiene una funcin de borrado
        entre las funciones {\tt open} y {\tt close}%
\index{flush}\index{file\_operations}\index{file\_operations!structure}.

\item{\bf close en file\_operations} En la versin 2.2, la funcin 
        close devuelve un entero, por lo tanto se permite que falle%
\index{close}.

\item{\bf read y write en file\_operations} Las cabeceras de estas funciones
        han cambiado. Ahora devuelven {\tt ssize\_t} en vez de un entero,
        y su lista de parmetros es diferente. El inodo ya no es un parmetro,
        y en cambio s lo es el desplazamiento dentro del fichero%
\index{read}\index{write}\index{ssize\_t}.

\item{\bf proc\_register\_dynamic} Esta funcin ya no existe. En vez de ello, 
        llamas al {\tt proc\_register} normal y pones cero en el campo
        de inodo de la estructura%
\index{proc\_register\_dynamic}\index{proc\_register}.

\item{\bf Seales} Las seales en la estructura de tareas ya no son
        un entero de 32 bits, sino un array de enteros {\tt \_NSIG\_WORDS}%
\index{seales}\index{\_NSIG\_WORDS}.

\item{\bf queue\_task\_irq}  Incluso si quieres planificar una tarea para que
        suceda dentro de un manejador de interrupciones, usa {\tt queue\_task},
        no {\tt queue\_task\_irq}%
\index{queue\_task\_irq}\index{queue\_task}\index{interrupts}%
\index{irqs}.

\item{\bf Parmetros del Mdulo} Ya no hay que simplemente declarar los parmetros del
        mdulo como variables globales. En 2.2 tienes que usar tambin {\tt MODULE\_PARM}
        para declarar su tipo. Esto es una gran mejora, porque permite que el mdulo
        reciba parmetros de cadenas de caracteres que empiezan con un dgito,
        por ejemplo, sin que esto le confunda%
\index{Parmetros}\index{Parmetros!Mdulo}\index{Parmetros de Mdulo}%
\index{MODULE\_PARM}.

\item{\bf Multiproceso simtrico} El ncleo ya no est dentro de un
        solo ``spinlock'' grande, lo que significa que los mdulos del ncleo tienen
        que tener en cuenta el SMP%
\index{SMP}\index{Multiproceso simtrico}.

\end{enumerate}



\chapter{Desde aqu hasta dnde?}\label{where-to}

Podra haber introducido fcilmente unos cuantos captulos ms en este
libro. Podra haber aadido un captulo sobre cmo crear nuevos sistemas de
ficheros, o sobre cmo aadir nuevas pilas de protocolos (como si hubiera
necesidad de esto; tendras que excavar bajo tierra para
encontrar una pila de protocolos que no estn soportados por Linux). Podra haber
aadido explicaciones sobre los mecanismos del ncleo que no hemos tocado,
tales como el arranque o la interfaz de discos.

Sin embargo, he escogido no hacerlo. Mi propsito al escribir
este libro era dar una iniciacin en los misterios de la
programacin de mdulos del ncleo y ensear las tcnicas ms comunes para
ese propsito. Para la gente seriamente interesada en la programacin
del ncleo, recomiendo la lista de recursos del ncleo de Juan-Mariano de Goyeneche que est en
{\tt http://jungla.dit.upm.es/\verb'~'jmseyas/linux/kernel/hackers-docs.html}.
Tambin, como dijo Linus, la mejor forma de aprender el ncleo es leer t 
mismo el cdigo fuente.

Si ests interesado en ms ejemplos de mdulos cortos del ncleo, te
recomiendo la revista Phrack. Incluso si no ests interesado en 
seguridad, y como programador deberas estarlo, los mdulos del ncleo
son buenos ejemplos de lo que puedes hacer dentro del ncleo, y son
lo bastante pequeos como para que su comprensin no requiera demasiado esfuerzo.

Espero haberte ayudado en tu misin de convertirte en un mejor programador, 
o al menos divertirte a travs de la tecnologa. Y, si escribes mdulos
del ncleo tiles, espero que los publiques bajo la GPL, para que yo
tambin pueda utilizarlos.


\chapter{Beneficios y servicios}\label{ads}

Espero que a nadie le importen las presentes promociones descaradas. Todo son
cosas probablemente tiles para los programadores noveles de
mdulos del ncleo Linux.
        
\section{Obteniendo este libro impreso}\label{print-book}

El grupo Coriolis va a imprimir este libro varias veces en el verano del 99. 
Si ya es verano, y quieres este libro impreso, puedes dejar descansar
a tu impresora y comprarlo encuadernado y reluciente.

include(thankme.m4)

include(gpl.m4)

\chapter{Sobre la traduccin}

Este documento es la traduccin de ``Linux Kernel Module Programing Guide 1.1.0''
y el proceso de traduccin ha sido llevado a cabo por:
\begin{itemize}
\item Traductor: Rubn Melcn Faria \verb'<'melkon@terra.es\verb'>'
\item Revisor: scar Sanz Lorenzo \verb'<'gaaldornik@terra.es\verb'>'
\item Encargado de Calidad: Francisco Javier Fernndez \verb'<'franciscojavier.fernandez.serrador@hispalinux.es\verb'>'
\item Traduccin posterior: Francisco Vila \verb'<'francisco.vila@hispalinux.es\verb'>'
\end{itemize}


Documento publicado por el proyecto de documentacin de Linux ({\tldpes}).


Nmero de revisin: 0.15 (Agosto de 2003)


Si tienes comentarios y/o sugerencias sobre la traduccin, ponte en 
contacto con Francisco Javier Fernndez \verb'<'franciscojavier.fernandez.serrador@hispalinux.es\verb'>'

\addcontentsline{toc}{chapter}{ndice}
\input{progmodlinux.ind}
\end{document}
