/* Demonstrates use of MVC for GUI design: interaction
 * *between* components.  The model is a Vector of
 * numbers.  The views are a list of the numbers and
 * the average of the numbers. The Views do not
 * directly listen for changes from the model. Adaptors
 * are used to isolate type information (promoting
 * flexibility) from the model/views.
 *
 * Really the only Swing part is the ChangeListener
 * stuff (plus a BoxLayout).
 */


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;

public class FirstMVC extends JFrame
{

  // The initial width and height of the frame
  public static int WIDTH = 300;
  public static int HEIGHT = 200;

  // a View
  ListView listView = new ListView(5);

  // Another View
  TextField avgView = new TextField(10);

  // the Model
  IntVectorModel model = new IntVectorModel();

  // the Controller
  TextField controller = new TextField(10);

  /**Adaptor mapping IntVector to ListView;
  * Hide specific types in adaptor rather
  * than having view/model know about each other.
  *
  * A real system would allow the model to indicate
  * WHAT had changed (for efficiency of execution
  * and simpler design).
  */

  public FirstMVC(String lab)
  {
    super(lab);

    // Display Controller
    JPanel controlPanel = new JPanel();
    controlPanel.setBorder (
    BorderFactory.createEtchedBorder());
    controlPanel.setLayout(new
    BoxLayout(controlPanel,BoxLayout.Y_AXIS));
    JLabel ctitle = new JLabel("Control");
    ctitle.setHorizontalTextPosition(JLabel.CENTER);
    controlPanel.add(ctitle);
    controlPanel.add(Box.createVerticalStrut(10));
    controlPanel.add(controller);
    Container c = getContentPane();
    c.setLayout (new FlowLayout ());
    c.add(controlPanel);

    c.add(Box.createHorizontalStrut(30));

    // Display Views
    JPanel viewPanel = new JPanel();
    viewPanel.setBorder ( BorderFactory.createEtchedBorder());
    viewPanel.setLayout( new BoxLayout(viewPanel,BoxLayout.Y_AXIS));
    JLabel title = new JLabel("Views");
    viewPanel.add(title);
    title.setHorizontalAlignment(JLabel.CENTER);
    title.setHorizontalTextPosition(JLabel.CENTER);
    viewPanel.add(Box.createVerticalStrut(10));
    viewPanel.add(new JScrollPane(listView));
    viewPanel.add(Box.createVerticalStrut(10));
    viewPanel.add(avgView);
    c.add(viewPanel);

    // Hook the Controller up to the Model
    TextFieldToIntVectorAdaptor CM = new TextFieldToIntVectorAdaptor(controller, model);
    controller.addActionListener(CM);

    // Hook up the simple avg View up to the Model
    IntVectorToAvgViewAdaptor MV1 =  new IntVectorToAvgViewAdaptor(model,avgView);
    model.addChangeListener(MV1);

    // Connect the View to the Model via the adapter,
    // which isolates type information from each other.
    IntVectorToListviewAdaptor MV2 = new IntVectorToListviewAdaptor(model,listView);
    model.addChangeListener(MV2);
  }

  public static void main(String args[])
  {
    FirstMVC frame = new FirstMVC("First MVC Example");

    frame.addWindowListener( new WindowAdapter()
      {
        public void windowClosing(WindowEvent e)
        {
          System.exit(0);
        }
      });

    frame.setSize(WIDTH, HEIGHT);
    frame.setVisible(true);
  }
}