import java.util.*;
import javax.swing.*;
import javax.swing.event.*;

public class IntVectorModel
{
  protected Vector data = new Vector();
  protected EventListenerList changeListeners = new EventListenerList();

  public IntVectorModel()
  {

  }

  public int size( )
  {
    return data.size( );
  }

  public void addElement(int i)
  {
    data.addElement(new Integer(i));
    fireChange();
  }

  public int getElement(int i)
  {
    Integer number = (Integer)data.elementAt( i );
    return number.intValue( );
  }

  public Vector getData() {
    return data;
  }

  public double getAverage( )
  {
    double avg = 0.0;
    Enumeration enum = data.elements();
    while (enum.hasMoreElements())
    {
      Integer i = (Integer)enum.nextElement();
      avg += i.intValue();
    }
    if (data.size()>0)
    {
      avg = avg / data.size();
    }
    return avg;
  }


  // Listener notification support
  public void addChangeListener(ChangeListener x)
  {
    changeListeners.add (ChangeListener.class, x);

    // bring it up to date with current state
   x.stateChanged(new ChangeEvent(this));
  }

  public void removeChangeListener(ChangeListener x)
  {
    changeListeners.remove (ChangeListener.class, x);
  }

  protected void fireChange()
  {
    // Create the event:
    ChangeEvent c = new ChangeEvent(this);
    // Get the listener list
    Object[] listeners =  changeListeners.getListenerList();
    // Process the listeners last to first
    // List is in pairs, Class and instance
    for (int i = listeners.length-2; i >= 0; i -= 2)
    {
      if (listeners[i] == ChangeListener.class)
      {
        ChangeListener cl = (ChangeListener)listeners[i+1];
        cl.stateChanged(c);
      }
    }
  }
}

