/* $XFree86$ */
/*
 * Data and prototypes for init.c
 *
 * Copyright (C) 2001-2004 by Thomas Winischhofer, Vienna, Austria
 *
 * If distributed as part of the Linux kernel, the following license terms
 * apply:
 *
 * * This program is free software; you can redistribute it and/or modify
 * * it under the terms of the GNU General Public License as published by
 * * the Free Software Foundation; either version 2 of the named License,
 * * or any later version.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * * GNU General Public License for more details.
 * *
 * * You should have received a copy of the GNU General Public License
 * * along with this program; if not, write to the Free Software
 * * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
 *
 * Otherwise, the following license terms apply:
 *
 * * Redistribution and use in source and binary forms, with or without
 * * modification, are permitted provided that the following conditions
 * * are met:
 * * 1) Redistributions of source code must retain the above copyright
 * *    notice, this list of conditions and the following disclaimer.
 * * 2) Redistributions in binary form must reproduce the above copyright
 * *    notice, this list of conditions and the following disclaimer in the
 * *    documentation and/or other materials provided with the distribution.
 * * 3) All advertising materials mentioning features or use of this software
 * *    must display the following acknowledgement: "This product includes
 * *    software developed by Thomas Winischhofer, Vienna, Austria."
 * * 4) The name of the author may not be used to endorse or promote products
 * *    derived from this software without specific prior written permission.
 * *
 * * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: 	Thomas Winischhofer <thomas@winischhofer.net>
 *
 */

#ifndef _INIT_
#define _INIT_

#include "osdef.h"

#include "initdef.h"
#include "vgatypes.h"
#include "vstruct.h"

#ifdef LINUX_XF86
#include "xf86.h"
#include "xf86Pci.h"
#include "xf86PciInfo.h"
#include "xf86_OSproc.h"
#include "sis.h"
#include "sis_regs.h"
#endif

#ifdef LINUX_KERNEL
#ifdef SIS_CP
#undef SIS_CP
#endif
#include <linux/config.h>
#include <linux/version.h>
#include <linux/types.h>
#include <asm/io.h>
#include <linux/fb.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
#include <linux/sisfb.h>
#else
#include <video/sisfb.h>
#endif
#endif

/* Mode numbers */
const USHORT  ModeIndex_320x200[]      = {0x59, 0x41, 0x00, 0x4f};
const USHORT  ModeIndex_320x240[]      = {0x50, 0x56, 0x00, 0x53};
const USHORT  ModeIndex_320x240_FSTN[] = {0x5a, 0x5b, 0x00, 0x00};  /* FSTN */
const USHORT  ModeIndex_400x300[]      = {0x51, 0x57, 0x00, 0x54};
const USHORT  ModeIndex_512x384[]      = {0x52, 0x58, 0x00, 0x5c};
const USHORT  ModeIndex_640x400[]      = {0x2f, 0x5d, 0x00, 0x5e};
const USHORT  ModeIndex_640x480[]      = {0x2e, 0x44, 0x00, 0x62};
const USHORT  ModeIndex_720x480[]      = {0x31, 0x33, 0x00, 0x35};
const USHORT  ModeIndex_720x576[]      = {0x32, 0x34, 0x00, 0x36};
const USHORT  ModeIndex_768x576[]      = {0x5f, 0x60, 0x00, 0x61};
const USHORT  ModeIndex_800x480[]      = {0x70, 0x7a, 0x00, 0x76};
const USHORT  ModeIndex_800x600[]      = {0x30, 0x47, 0x00, 0x63};
const USHORT  ModeIndex_848x480[]      = {0x39, 0x3b, 0x00, 0x3e};
const USHORT  ModeIndex_856x480[]      = {0x3f, 0x42, 0x00, 0x45};
const USHORT  ModeIndex_1024x768[]     = {0x38, 0x4a, 0x00, 0x64};
const USHORT  ModeIndex_1024x576[]     = {0x71, 0x74, 0x00, 0x77};
const USHORT  ModeIndex_1024x600[]     = {0x20, 0x21, 0x00, 0x22};  /* 300 series only */
const USHORT  ModeIndex_1280x1024[]    = {0x3a, 0x4d, 0x00, 0x65};
const USHORT  ModeIndex_1280x960[]     = {0x7c, 0x7d, 0x00, 0x7e};
const USHORT  ModeIndex_1152x768[]     = {0x23, 0x24, 0x00, 0x25};  /* 300 series only */
const USHORT  ModeIndex_1152x864[]     = {0x29, 0x2a, 0x00, 0x2b};
const USHORT  ModeIndex_300_1280x768[] = {0x55, 0x5a, 0x00, 0x5b};
const USHORT  ModeIndex_310_1280x768[] = {0x23, 0x24, 0x00, 0x25};
const USHORT  ModeIndex_1280x720[]     = {0x79, 0x75, 0x00, 0x78};
const USHORT  ModeIndex_1360x768[]     = {0x48, 0x4b, 0x00, 0x4e};
const USHORT  ModeIndex_300_1360x1024[]= {0x67, 0x6f, 0x00, 0x72};  /* 300 series, BARCO only */
const USHORT  ModeIndex_1400x1050[]    = {0x26, 0x27, 0x00, 0x28};  /* 315 series only */
const USHORT  ModeIndex_1600x1200[]    = {0x3c, 0x3d, 0x00, 0x66};
const USHORT  ModeIndex_1920x1440[]    = {0x68, 0x69, 0x00, 0x6b};
const USHORT  ModeIndex_300_2048x1536[]= {0x6c, 0x6d, 0x00, 0x00};
const USHORT  ModeIndex_310_2048x1536[]= {0x6c, 0x6d, 0x00, 0x6e};

const USHORT SiS_DRAMType[17][5]={
	{0x0C,0x0A,0x02,0x40,0x39},
	{0x0D,0x0A,0x01,0x40,0x48},
	{0x0C,0x09,0x02,0x20,0x35},
	{0x0D,0x09,0x01,0x20,0x44},
	{0x0C,0x08,0x02,0x10,0x31},
	{0x0D,0x08,0x01,0x10,0x40},
	{0x0C,0x0A,0x01,0x20,0x34},
	{0x0C,0x09,0x01,0x08,0x32},
	{0x0B,0x08,0x02,0x08,0x21},
	{0x0C,0x08,0x01,0x08,0x30},
	{0x0A,0x08,0x02,0x04,0x11},
	{0x0B,0x0A,0x01,0x10,0x28},
	{0x09,0x08,0x02,0x02,0x01},
	{0x0B,0x09,0x01,0x08,0x24},
	{0x0B,0x08,0x01,0x04,0x20},
	{0x0A,0x08,0x01,0x02,0x10},
	{0x09,0x08,0x01,0x01,0x00}
};

const USHORT SiS_SDRDRAM_TYPE[13][5] =
{
	{ 2,12, 9,64,0x35},
	{ 1,13, 9,64,0x44},
	{ 2,12, 8,32,0x31},
	{ 2,11, 9,32,0x25},
	{ 1,12, 9,32,0x34},
	{ 1,13, 8,32,0x40},
	{ 2,11, 8,16,0x21},
	{ 1,12, 8,16,0x30},
	{ 1,11, 9,16,0x24},
	{ 1,11, 8, 8,0x20},
	{ 2, 9, 8, 4,0x01},
	{ 1,10, 8, 4,0x10},
	{ 1, 9, 8, 2,0x00}
};

const USHORT SiS_DDRDRAM_TYPE[4][5] =
{
	{ 2,12, 9,64,0x35},
	{ 2,12, 8,32,0x31},
	{ 2,11, 8,16,0x21},
	{ 2, 9, 8, 4,0x01}
};

const USHORT SiS_MDA_DAC[] =
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
        0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
        0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
        0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
        0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F
};

const USHORT SiS_CGA_DAC[] =
{
        0x00,0x10,0x04,0x14,0x01,0x11,0x09,0x15,
        0x00,0x10,0x04,0x14,0x01,0x11,0x09,0x15,
        0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F,
        0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F,
        0x00,0x10,0x04,0x14,0x01,0x11,0x09,0x15,
        0x00,0x10,0x04,0x14,0x01,0x11,0x09,0x15,
        0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F,
        0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F
};

const USHORT SiS_EGA_DAC[] =
{
        0x00,0x10,0x04,0x14,0x01,0x11,0x05,0x15,
        0x20,0x30,0x24,0x34,0x21,0x31,0x25,0x35,
        0x08,0x18,0x0C,0x1C,0x09,0x19,0x0D,0x1D,
        0x28,0x38,0x2C,0x3C,0x29,0x39,0x2D,0x3D,
        0x02,0x12,0x06,0x16,0x03,0x13,0x07,0x17,
        0x22,0x32,0x26,0x36,0x23,0x33,0x27,0x37,
        0x0A,0x1A,0x0E,0x1E,0x0B,0x1B,0x0F,0x1F,
        0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F
};

const USHORT SiS_VGA_DAC[] =
{
	0x00,0x10,0x04,0x14,0x01,0x11,0x09,0x15,
	0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F,
	0x00,0x05,0x08,0x0B,0x0E,0x11,0x14,0x18,
	0x1C,0x20,0x24,0x28,0x2D,0x32,0x38,0x3F,
	0x00,0x10,0x1F,0x2F,0x3F,0x1F,0x27,0x2F,
	0x37,0x3F,0x2D,0x31,0x36,0x3A,0x3F,0x00,
	0x07,0x0E,0x15,0x1C,0x0E,0x11,0x15,0x18,
	0x1C,0x14,0x16,0x18,0x1A,0x1C,0x00,0x04,
	0x08,0x0C,0x10,0x08,0x0A,0x0C,0x0E,0x10,
	0x0B,0x0C,0x0D,0x0F,0x10
};

static const SiS_StResInfoStruct SiS_StResInfo[]=
{
	{ 640,400},
	{ 640,350},
	{ 720,400},
	{ 720,350},
	{ 640,480}
};

static const SiS_ModeResInfoStruct SiS_ModeResInfo[] =
{
	{  320, 200, 8, 8},   /* 0x00 */
	{  320, 240, 8, 8},   /* 0x01 */
	{  320, 400, 8, 8},   /* 0x02 */
	{  400, 300, 8, 8},   /* 0x03 */
	{  512, 384, 8, 8},   /* 0x04 */
	{  640, 400, 8,16},   /* 0x05 */
	{  640, 480, 8,16},   /* 0x06 */
	{  800, 600, 8,16},   /* 0x07 */
	{ 1024, 768, 8,16},   /* 0x08 */
	{ 1280,1024, 8,16},   /* 0x09 */
	{ 1600,1200, 8,16},   /* 0x0a */
	{ 1920,1440, 8,16},   /* 0x0b */
	{ 2048,1536, 8,16},   /* 0x0c */
	{  720, 480, 8,16},   /* 0x0d */
	{  720, 576, 8,16},   /* 0x0e */
	{ 1280, 960, 8,16},   /* 0x0f */
	{  800, 480, 8,16},   /* 0x10 */
	{ 1024, 576, 8,16},   /* 0x11 */
	{ 1280, 720, 8,16},   /* 0x12 */
	{  856, 480, 8,16},   /* 0x13 */
	{ 1280, 768, 8,16},   /* 0x14 */
	{ 1400,1050, 8,16},   /* 0x15 */
	{ 1152, 864, 8,16},   /* 0x16 */
	{  848, 480, 8,16},   /* 0x17 */
	{ 1360, 768, 8,16},   /* 0x18 */
	{ 1024, 600, 8,16},   /* 0x19 */
	{ 1152, 768, 8,16},   /* 0x1a */
	{  768, 576, 8,16},   /* 0x1b */
	{ 1360,1024, 8,16}    /* 0x1c */
};

static SiS_StandTableStruct SiS_StandTable[]=
{
/* 0x00: MD_0_200 */
 {
  0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x01: MD_1_200 */
 {
  0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x02: MD_2_200 */
 {
  0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x03: MD_3_200 - mode 0x03 - 0 */
 {
  0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x04: MD_4 */
 {
  0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,   /* 0x2c is 2b for 300 */
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff}
 },
/* 0x05: MD_5 */
 {
  0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,   /* 0x2c is 2b for 300 */
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff}
 },
/* 0x06: MD_6 */
 {
  0x50,0x18,0x08,0x4000,
  {0x01,0x01,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,   /* 55,81 is 54,80 for 300 */
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xc2,
   0xff},
  {0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x01,0x00,0x01,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0x00,
   0xff}
 },
/* 0x07: MD_7 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x00,0x03,0x00,0x03},
  0xa6,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x0d,0x63,0xba,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff}
 },
/* 0x08: MDA_DAC */
 {
  0x00,0x00,0x00,0x0000,
  {0x00,0x00,0x00,0x15},
  0x15,
  {0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x00,0x00,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15},
  {0x15,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f}
 },
/* 0x09: CGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x00},
  0x10,
  {0x04,0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x10,
   0x04},
  {0x14,0x01,0x11,0x09,0x15,0x00,0x10,0x04,
   0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,0x2e,
   0x3e,0x2b,0x3b,0x2f},
  {0x3f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f}
 },
/* 0x0a: EGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x05,0x15,0x20},
  0x30,
  {0x24,0x34,0x21,0x31,0x25,0x35,0x08,0x18,
   0x0c,0x1c,0x09,0x19,0x0d,0x1d,0x28,0x38,
   0x2c,0x3c,0x29,0x39,0x2d,0x3d,0x02,0x12,
   0x06},
  {0x16,0x03,0x13,0x07,0x17,0x22,0x32,0x26,
   0x36,0x23,0x33,0x27,0x37,0x0a,0x1a,0x0e,
   0x1e,0x0b,0x1b,0x0f},
  {0x1f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f}
 },
/* 0x0b: VGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x2a},
  0x3a,
  {0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x05,
   0x08,0x0b,0x0e,0x11,0x14,0x18,0x1c,0x20,
   0x24,0x28,0x2d,0x32,0x38,0x3f,0x00,0x10,
   0x1f},
  {0x2f,0x3f,0x1f,0x27,0x2f,0x37,0x3f,0x2d,
   0x31,0x36,0x3a,0x3f,0x00,0x07,0x0e,0x15,
   0x1c,0x0e,0x11,0x15},
  {0x18,0x1c,0x14,0x16,0x18,0x1a,0x1c,0x00,
   0x04}
 },
/* 0x0c */
 {
  0x08,0x0c,0x10,0x0a08,
  {0x0c,0x0e,0x10,0x0b},
  0x0c,
  {0x0d,0x0f,0x10,0x10,0x01,0x08,0x00,0x00,
   0x00,0x00,0x01,0x00,0x02,0x02,0x01,0x00,
   0x04,0x04,0x01,0x00,0x05,0x02,0x05,0x00,
   0x06},
  {0x01,0x06,0x05,0x06,0x00,0x08,0x01,0x08,
   0x00,0x07,0x02,0x07,0x06,0x07,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}
 },
/* 0x0d: MD_D */
 {
  0x28,0x18,0x08,0x2000,
  {0x09,0x0f,0x00,0x06},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,     /* 2c is 2b for 300 */
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x0e: MD_E */
 {
  0x50,0x18,0x08,0x4000,
  {0x01,0x0f,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,     /* 55,81 is 54,80 for 300 */
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x0f: ExtVGATable - modes > 0x13 */
 {
  0x00,0x00,0x00,0x0000,
  {0x01,0x0f,0x00,0x0e},
  0x23,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xea,0x8c,0xdf,0x28,0x40,0xe7,0x04,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x01,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff}
 },
/* 0x10: ROM_SAVEPTR - totally different for 300 */
 {
  0x9f,0x3b,0x00,0x00c0,
  {0x00,0x00,0x00,0x00},
  0x00,
  {0x00,0x00,0x00,0x00,0x00,0x00,0xbb,0x3f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x1a,0x00,0xac,0x3e,0x00,0xc0,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}
 },
/* 0x11: MD_F */
 {
  0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa2,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,    /* 55,81 is 54,80 on 300 */
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x82,0x84,0x5d,0x28,0x0f,0x63,0xba,0xe3,    /* 82,84 is 83,85 on 300 */
   0xff},
  {0x00,0x08,0x00,0x00,0x18,0x18,0x00,0x00,
   0x00,0x08,0x00,0x00,0x00,0x18,0x00,0x00,
   0x0b,0x00,0x05,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x05,
   0xff}
 },
/* 0x12: MD_10 */
 {
  0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,    /* 55,81 is 54,80 on 300 */
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x82,0x84,0x5d,0x28,0x0f,0x63,0xba,0xe3,    /* 82,84 is 83,85 on 300 */
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x13: MD_0_350 */
 {
  0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xb1,0xbf,0x1f,    /* b1 is a0 on 300 */
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x14: MD_1_350 */
 {
  0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x15: MD_2_350 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x16: MD_3_350 - mode 0x03 - 1 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x17: MD_0_1_400 */
 {
  0x28,0x18,0x10,0x0800,
  {0x08,0x03,0x00,0x02},
  0x67,
  {0x2d,0x27,0x28,0x90,0x2b,0xb1,0xbf,0x1f,    /* b1 is a0 on 300 */
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x18: MD_2_3_400 - mode 0x03 - 2 */
 {
  0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x67,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x19: MD_7_400 */
 {
  0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x66,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x0f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff}
 },
/* 0x1a: MD_11 */
 {
  0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,    /* 55,81 is 54,80 on 300 */
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xe9,0x8b,0xdf,0x28,0x00,0xe7,0x04,0xc3,    /* e9,8b is ea,8c on 300 */
   0xff},
  {0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x01,
   0xff}
 },
/* 0x1b: ExtEGATable - Modes <= 0x02 */
 {
  0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,    /* 55,81 is 54,80 on 300 */
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xe9,0x8b,0xdf,0x28,0x00,0xe7,0x04,0xe3,    /* e9,8b is ea,8c on 300 */
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x1c: MD_13 */
 {
  0x28,0x18,0x08,0x2000,
  {0x01,0x0f,0x00,0x0e},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,    /* 55,81 is 54,80 on 300 */
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x40,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x41,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff}
 }
};

/**************************************************************/
/* SIS VIDEO BRIDGE ----------------------------------------- */
/**************************************************************/

static const UCHAR SiS_SoftSetting  = 0x30;   /* RAM setting */

static const UCHAR SiS_OutputSelect = 0x40;

static const UCHAR SiS_NTSCTiming[] = {
	0x17,0x1d,0x03,0x09,0x05,0x06,0x0c,0x0c,
	0x94,0x49,0x01,0x0a,0x06,0x0d,0x04,0x0a,
	0x06,0x14,0x0d,0x04,0x0a,0x00,0x85,0x1b,
	0x0c,0x50,0x00,0x97,0x00,0xda,0x4a,0x17,
	0x7d,0x05,0x4b,0x00,0x00,0xe2,0x00,0x02,
	0x03,0x0a,0x65,0x9d,0x08,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x50,
	0x00,0x40,0x44,0x00,0xdb,0x02,0x3b,0x00
};

static const UCHAR SiS_PALTiming[] = {
	0x19,0x52,0x35,0x6e,0x04,0x38,0x3d,0x70,
	0x94,0x49,0x01,0x12,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0x45,0x2b,
	0x70,0x50,0x00,0x9b,0x00,0xd9,0x5d,0x17,
	0x7d,0x05,0x45,0x00,0x00,0xe8,0x00,0x02,
	0x0d,0x00,0x68,0xb0,0x0b,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x63,
	0x00,0x40,0x3e,0x00,0xe1,0x02,0x28,0x00
};

static const UCHAR SiS_HiTVExtTiming[] = {
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x64,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x64,0x90,0x33,0x8c,0x18,0x36,0x3e,0x13,
	0x2a,0xde,0x2a,0x44,0x40,0x2a,0x44,0x40,
	0x8e,0x8e,0x82,0x07,0x0b,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x3d,
	0x63,0x4f,0x27,0x00,0xfc,0xff,0x6a,0x00
};

static const UCHAR SiS_HiTVSt1Timing[] = {
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x65,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x65,0x90,0x7b,0xa8,0x03,0xf0,0x87,0x03,
	0x11,0x15,0x11,0xcf,0x10,0x11,0xcf,0x10,
	0x35,0x35,0x3b,0x69,0x1d,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x04,0x86,
	0xaf,0x5d,0x0e,0x00,0xfc,0xff,0x2d,0x00
};

static const UCHAR SiS_HiTVSt2Timing[] = {
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x64,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x64,0x90,0x33,0x8c,0x18,0x36,0x3e,0x13,
	0x2a,0xde,0x2a,0x44,0x40,0x2a,0x44,0x40,
	0x8e,0x8e,0x82,0x07,0x0b,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x3d,
	0x63,0x4f,0x27,0x00,0xfc,0xff,0x6a,0x00
};

#if 0
static const UCHAR SiS_HiTVTextTiming[] = {
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x65,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x65,0x90,0xe7,0xbc,0x03,0x0c,0x97,0x03,
	0x14,0x78,0x14,0x08,0x20,0x14,0x08,0x20,
	0xc8,0xc8,0x3b,0xd2,0x26,0x92,0x0f,0x40,
        0x60,0x80,0x14,0x90,0x8c,0x60,0x04,0x96,
	0x72,0x5c,0x11,0x00,0xfc,0xff,0x32,0x00
};
#endif

static const UCHAR SiS_HiTVGroup3Data[] = {
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0x5f,
	0x05,0x21,0xb2,0xb2,0x55,0x77,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x2e,0x58,0x48,0x72,0x44,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x4f,0x7f,0x03,0xa8,0x7d,0x20,0x1a,0xa9,
	0x14,0x05,0x03,0x7e,0x64,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};

static const UCHAR SiS_HiTVGroup3Simu[] = {
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0x95,
	0xdb,0x20,0xb8,0xb8,0x55,0x47,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x15,0x26,0xd3,0xe4,0x11,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x67,0x36,0x01,0x47,0x0e,0x10,0xbe,0xb4,
	0x01,0x05,0x03,0x7e,0x65,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};

#if 0
static const UCHAR SiS_HiTVGroup3Text[] = {
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0xa7,
	0xf5,0x20,0xce,0xce,0x55,0x47,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x18,0x2c,0x0c,0x20,0x22,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x93,0x3c,0x01,0x50,0x2f,0x10,0xf4,0xca,
	0x01,0x05,0x03,0x7e,0x65,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};
#endif

static const UCHAR SiS_NTSCPhase[]    = {0x21,0xed,0xba,0x08};
static const UCHAR SiS_PALPhase[]     = {0x2a,0x05,0xe3,0x00};
static const UCHAR SiS_PALMPhase[]    = {0x21,0xE4,0x2E,0x9B};
static const UCHAR SiS_PALNPhase[]    = {0x21,0xF4,0x3E,0xBA};
static const UCHAR SiS_NTSCPhase2[]   = {0x21,0xF0,0x7B,0xD6};
static const UCHAR SiS_PALPhase2[]    = {0x2a,0x09,0x86,0xe9};
static const UCHAR SiS_PALMPhase2[]   = {0x21,0xE6,0xEF,0xA4};
static const UCHAR SiS_PALNPhase2[]   = {0x21,0xF6,0x94,0x46};
static const UCHAR SiS_SpecialPhase[] = {0x1e,0x8c,0x5c,0x7a};
static const UCHAR SiS_SpecialPhaseM[]= {0x1e,0x83,0x0a,0xe0};
static const UCHAR SiS_SpecialPhaseJ[]= {0x25,0xd4,0xfd,0x5e};

static const SiS_TVDataStruct  SiS_StPALData[] =
{
 {    1,   1, 864, 525,1270, 400, 100,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 350, 100,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
 {    1,   1, 864, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
 {    1,   1, 864, 525,1270, 480,  50,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 600,  50,   0,   0,0xf4,0xff,0x1c,0x22}
};

static const SiS_TVDataStruct  SiS_ExtPALData[] =
{
 {   27,  10, 848, 448,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},  /* 640x400, 320x200 */
 {  108,  35, 848, 398,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},
 {   12,   5, 954, 448,1270, 530,  50,   0,  50,0xf1,0x04,0x1f,0x18},
 {    9,   4, 960, 463,1644, 438,  50,   0,  50,0xf4,0x0b,0x1c,0x0a},
 {    9,   4, 848, 528,1270, 530,   0,   0,  50,0xf5,0xfb,0x1b,0x2a},  /* 640x480, 320x240 */
/*{  36,  25,1060, 648,1316, 530, 438,   0, 438,0xeb,0x05,0x25,0x16},*//* 800x600, 400x300 */
 {   36,  25,1060, 648,1270, 530, 438,   0, 438,0xeb,0x05,0x25,0x16},  /* 800x600, 400x300 - better */
 {    3,   2,1080, 619,1270, 540, 438,   0, 438,0xf3,0x00,0x1d,0x20},  /* 720x576 */
 {    1,   1,1170, 821,1270, 520, 686,   0, 686,0xF3,0x00,0x1D,0x20},  /* 1024x768 */
 {    1,   1,1170, 821,1270, 520, 686,   0, 686,0xF3,0x00,0x1D,0x20}   /* 1024x768 (for NTSC equ) */
};

static const SiS_TVDataStruct  SiS_StNTSCData[] =
{
 {    1,   1, 858, 525,1270, 400,  50,   0, 760,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 350,  50,   0, 640,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
 {    1,   1, 858, 525,1270, 480,   0,   0, 760,0xf1,0x04,0x1f,0x18}
};

static const SiS_TVDataStruct  SiS_ExtNTSCData[] =
{
 {  143,  65, 858, 443,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},    /* 640x400, 320x200 */
 {   88,  35, 858, 393,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
 {  143,  70, 924, 443,1270, 440,  92,   0,  92,0xf1,0x04,0x1f,0x18},
 {  143,  70, 924, 393,1270, 440,  92,   0,  92,0xf4,0x0b,0x1c,0x0a},
 {  143,  76, 836, 523,1270, 440, 224,   0,   0,0xf1,0x05,0x1f,0x16},    /* 640x480, 320x240 */
 {  143, 120,1056, 643,1270, 440,   0, 128,   0,0xf4,0x10,0x1c,0x00},    /* 800x600, 400x300  */
/*{   2,   1, 858, 503,1270, 480,   0, 128,   0,0xee,0x0c,0x22,0x08},*/  /* 720x480  (old, from 650) */
 {  143,  76, 836, 523,1270, 440,   0, 128,   0,0xee,0x0c,0x22,0x08},    /* 720x480 - BETTER (from 300 series) */
/*{  65,  64,1056, 791,1270, 480, 638,   0,   0,0xEE,0x0C,0x22,0x08} */  /* 1024x768 (525i) */
 {    1,   1,1100, 811,1412, 440,   0, 128,   0,0xee,0x0c,0x22,0x08},    /* 1024x768 (525i) CORRECTED */
 {   65,  64,1056, 791,1270, 480, 455,   0,   0,0x00,0x00,0x00,0x00}     /* 1024x768 (525p) */
};

static const SiS_TVDataStruct  SiS_StHiTVData[] =  /* Slave + TVSimu */
{
 {    1,   1, 0x37c,0x233,0x2b2,0x320,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x37c,0x233,0x2b2,0x2bc,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x37c,0x233,0x2b2,0x320,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x37c,0x233,0x2b2,0x2bc,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x37c,0x233,0x2b2,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    8,   5, 0x41a,0x2ab,0x670,0x3c0,0x150,128, 0, 0x00,0x00,0x00,0x00}
};

static const SiS_TVDataStruct  SiS_St2HiTVData[] = /* Slave */
{
 {    3,   1, 0x348,0x1e3,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x37c,0x233,0x2b2,0x2bc, 	  0,  0, 0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x348,0x1e3,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x37c,0x233,0x2b2,0x2bc,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    5,   2, 0x348,0x233,0x670,0x3c0,0x08d,128, 0, 0x00,0x00,0x00,0x00},
 {    8,   5, 0x41a,0x2ab,0x670,0x3c0,0x17c,128, 0, 0x00,0x00,0x00,0x00}
};

static const SiS_TVDataStruct  SiS_ExtHiTVData[] =
{
 {    6,   1, 0x348,0x233,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x3c0,0x233,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    6,   1, 0x348,0x233,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x3c0,0x233,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    5,   1, 0x348,0x233,0x670,0x3c0,0x166,128, 0, 0x00,0x00,0x00,0x00},  /* 640x480   */
 {   16,   5, 0x41a,0x2ab,0x670,0x3c0,0x143,128, 0, 0x00,0x00,0x00,0x00},  /* 800x600   */
 {   25,  12, 0x4ec,0x353,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},  /* 1024x768  */
 {    5,   4, 0x627,0x464,0x670,0x3c0,0x128,  0, 0, 0x00,0x00,0x00,0x00},  /* 1280x1024 */
 {    4,   1, 0x41a,0x233,0x60c,0x3c0,0x143,128, 0, 0x00,0x00,0x00,0x00},  /* 800x480   */
 {    5,   2, 0x578,0x293,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},  /* 1024x576  */
 {    8,   5, 0x6d6,0x323,0x670,0x3c0,0x128,  0, 0, 0x00,0x00,0x00,0x00}   /* 1280x720  */
};

static const SiS_TVDataStruct  SiS_St525pData[] =
{
 {    1,   1, 0x6b4,0x20d,0x4f6,0x190,   50,  0, 0x2f8, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x6b4,0x20d,0x4f6,0x15e,   50,  0, 0x280, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x6b4,0x20d,0x4f6,0x190,   50,  0, 0x2f8, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x6b4,0x20d,0x4f6,0x15e,   50,  0, 0x280, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x6b4,0x20d,0x4f6,0x1e0,    0,  0, 0x2f8, 0x00,0x00,0x00,0x00}
};

static const SiS_TVDataStruct  SiS_St750pData[] =
{
 {    1,   1, 0x672,0x2ee,0x500,0x190,   50,  0, 0x2f8, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x672,0x2ee,0x500,0x15e,   50,  0, 0x280, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x672,0x2ee,0x500,0x190,    0,  0, 0x2d0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x672,0x2ee,0x500,0x15e,    0,  0, 0x2d0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x672,0x2ee,0x500,0x1e0,    0,  0, 0x2f8, 0x00,0x00,0x00,0x00}
};

static const SiS_TVDataStruct  SiS_Ext750pData[] =
{
 {    3,   1, 0x3a7,0x1d6,0x500,0x2a8,   50,  0,     0, 0x00,0x00,0x00,0x00},
 {   24,   7, 0x3a7,0x1a4,0x500,0x2a8,   50,  0,     0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x3a7,0x1d6,0x500,0x2a8,   50,  0,     0, 0x00,0x00,0x00,0x00},
 {   24,   7, 0x3a7,0x1a4,0x500,0x2a8,   50,  0,     0, 0x00,0x00,0x00,0x00},
 {   99,  32, 0x320,0x1fe,0x500,0x2d0,   50,  0,     0, 0x00,0x00,0x00,0x00},  /* 640x480   */
 {    5,   4, 0x5d8,0x29e,0x500,0x2a8,   50,  0,     0, 0x00,0x00,0x00,0x00},  /* 800x600   */
 {    2,   1, 0x35a,0x1f7,0x4f6,0x1e0,    0,128,     0, 0x00,0x00,0x00,0x00},  /* 720x480   */
 {   68,  64, 0x55f,0x346,0x500,0x2a8,0x27e,  0,     0, 0x00,0x00,0x00,0x00},  /* 1024x768  */
};

static const SiS_LCDDataStruct  SiS_LCD1280x960Data[] =
{
	{    9,   2, 800, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{   30,  11,1056, 625,1800,1000},
	{    5,   3,1350, 800,1800,1000},
	{    1,   1,1576,1050,1576,1050},
	{    1,   1,1800,1000,1800,1000}
};

/* 1280x768 panel data from Fujitsu 7911 (VL-17WDX8).
 * Other 1280x768 panels (with clock != 81000, HTxVT != 1688x802)
 * will be treated as custom panels.
 */

static const SiS_LCDDataStruct  SiS_StLCD1280x768Data[] =
{
	{ 211,  100, 2100,  408, 1688,  802 }, /* These values are *wrong* */
	{ 211,   64, 1536,  358, 1688,  802 }, /* (which is why they aren't used yet) */
	{ 211,  100, 2100,  408, 1688,  802 },
	{ 211,   64, 1536,  358, 1688,  802 },
	{ 211,   48,  840,  488, 1688,  802 },
	{ 211,   72, 1008,  609, 1688,  802 },
	{ 211,  128, 1400,  776, 1688,  802 },
	{ 211,  205, 1680, 1041, 1688,  802 },
	{ 1,      1, 1688,  802, 1688,  802 }  /* That's the only one that is correct */
};

static const SiS_LCDDataStruct  SiS_ExtLCD1280x768Data[] =
{
	{ 211,  100, 2100,  408, 1688,  802 }, /* These values are *wrong* */
	{ 211,   64, 1536,  358, 1688,  802 }, /* (which is why they aren't used yet) */
	{ 211,  100, 2100,  408, 1688,  802 },
	{ 211,   64, 1536,  358, 1688,  802 },
	{ 211,   48,  840,  488, 1688,  802 },
	{ 211,   72, 1008,  609, 1688,  802 },
	{ 211,  128, 1400,  776, 1688,  802 },
	{ 211,  205, 1680, 1041, 1688,  802 },
	{ 1,      1, 1688,  802, 1688,  802 }  /* That's the only one that is correct */
};

static const SiS_LCDDataStruct  SiS_NoScaleData1280x768[] =
{
        { 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802}
};

static const SiS_LCDDataStruct  SiS_StLCD1400x1050Data[] =
{
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,   48,  840,  488, 1688, 1066 },
	{ 211,   72, 1008,  609, 1688, 1066 },
	{ 211,  128, 1400,  776, 1688, 1066 },
	{ 211,  205, 1680, 1041, 1688, 1066 },
	{   1,    1, 1688, 1066, 1688, 1066 }
};

static const SiS_LCDDataStruct  SiS_ExtLCD1400x1050Data[] =
{
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,   48,  840,  488, 1688, 1066 },
	{ 211,   72, 1008,  609, 1688, 1066 },
	{ 211,  128, 1400,  776, 1688, 1066 },
	{ 211,  205, 1680, 1041, 1688, 1066 },
	{   1,    1, 1688, 1066, 1688, 1066 }
};

static const SiS_LCDDataStruct  SiS_NoScaleData1400x1050[] =
{
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 }
};

static const SiS_LCDDataStruct  SiS_StLCD1600x1200Data[] =
{
	{27,  4, 800, 500, 2160, 1250 },
	{27,  4, 800, 500, 2160, 1250 },
	{ 6,  1, 900, 500, 2160, 1250 },
	{ 6,  1, 900, 500, 2160, 1250 },
	{27,  1, 800, 500, 2160, 1250 },
	{ 4,  1,1080, 625, 2160, 1250 },
	{ 5,  2,1350, 800, 2160, 1250 },
	{135,88,1600,1100, 2160, 1250 },
	{135,88,1600,1100, 2160, 1250 },
	{ 1,  1,2160,1250, 2160, 1250 }
};

static const SiS_LCDDataStruct  SiS_ExtLCD1600x1200Data[] =
{
	{27, 4, 800, 500, 2160, 1250 },
	{27, 4, 800, 500, 2160, 1250 },
	{ 6, 1, 900, 500, 2160, 1250 },
	{ 6, 1, 900, 500, 2160, 1250 },
	{27, 1, 800, 500, 2160, 1250 },
	{ 4, 1,1080, 625, 2160, 1250 },
	{ 5, 2,1350, 800, 2160, 1250 },
	{27,16,1500,1064, 2160, 1250 },
	{27,16,1500,1064, 2160, 1250 },
	{ 1, 1,2160,1250, 2160, 1250 }
};

static const SiS_LCDDataStruct  SiS_NoScaleData1600x1200[] =
{
        {1,  1, 2160, 1250, 2048, 1250},
	{1,  1, 2160, 1250, 2048, 1250},
	{1,  1, 2160, 1250, 2048, 1250},
	{1,  1, 2160, 1250, 2048, 1250},
	{1,  1, 2160, 1250, 2048, 1250},
	{1,  1, 2160, 1250, 2048, 1250},
	{1,  1, 2160, 1250, 2048, 1250},
	{1,  1, 2160, 1250, 2048, 1250},
	{1,  1, 2160, 1250, 2048, 1250},
	{1,  1, 2160, 1250, 2048, 1250},
};

static const SiS_LCDDataStruct  SiS_NoScaleData[] =
{
	{ 1, 1, 800, 449, 800, 449 },
	{ 1, 1, 800, 449, 800, 449 },
	{ 1, 1, 900, 449, 900, 449 },
	{ 1, 1, 900, 449, 900, 449 },
	{ 1, 1, 800, 525, 800, 525 },
	{ 1, 1,1056, 628,1056, 628 },
	{ 1, 1,1344, 806,1344, 806 },
	{ 1, 1,1688,1066,1688,1066 },
        { 1, 1,1688, 802,1688, 802 },  /* 1280x768: 802 was 806 in both cases */
        { 1, 1,2160,1250,2160,1250 },  /* 1600x1200 */
	{ 1, 1,1800,1000,1800,1000 }   /* 1280x960 */
};

/* *** LCDA *** */

static const SiS_LVDSDataStruct  SiS_LCDA1024x768Data_1[]=
{
	{  960, 438,1344, 806},
	{  960, 388,1344, 806},
	{ 1040, 438,1344, 806},
	{ 1040, 388,1344, 806},
	{  960, 518,1344, 806},   /* 640x480 */
	{ 1120, 638,1344, 806},   /* 800x600 */
	{ 1344, 806,1344, 806},   /* 1024x768 */
#if 0
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 518,1344, 806},   /* 640x480 */
	{1050, 638,1344, 806},   /* 800x600 */
	{1344, 806,1344, 806},   /* 1024x768 */
#endif
};

static const SiS_LVDSDataStruct  SiS_LCDA1024x768Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
};

static const SiS_LVDSDataStruct  SiS_LCDA1280x1024Data_1[]=
{ /* Acer, Compaq */
	{1048, 442,1688,1066},
	{1048, 392,1688,1066},
	{1128, 442,1688,1066},
	{1128, 392,1688,1066},
	{1048, 522,1688,1066},
	{1208, 642,1688,1066},
	{1432, 810,1688,1066},
	{1688,1066,1688,1066}
};

static const SiS_LVDSDataStruct  SiS_LCDA1280x1024Data_2[]=
{ /* Corrected (illegal in Acer, correct in Compaq) */
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066}
};

static const SiS_LVDSDataStruct  SiS_LCDA1400x1050Data_1[]=
{ /* Clevo */
        { 928, 416, 1688,1066},
	{ 928, 366, 1688,1066},
	{1008, 416, 1688,1066},
	{1008, 366, 1688,1066},
	{1200, 530, 1688,1066},
	{1088, 616, 1688,1066},
	{1312, 784, 1688,1066},
	{1568,1040, 1688,1066},
	{1688,1066, 1688,1066}
};

static const SiS_LVDSDataStruct  SiS_LCDA1400x1050Data_2[]=
{ /* Clevo */
    	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066}
};

static const SiS_LVDSDataStruct  SiS_LCDA1600x1200Data_1[]=
{ /* Clevo (Temporary data)  */
	{1200, 450, 2048,1250},
	{1200, 400, 2048,1250},
	{1280, 450, 2048,1250},
	{1280, 400, 2048,1250},
	{1200, 530, 2048,1250},
	{1360, 650, 2048,1250},
	{1584, 818, 2048,1250},
	{1688,1066, 2048,1250},
	{1688,1066, 2048,1250},
	{2048,1250, 2048,1250}   /* this should be correct */
#if 0
	{2160,1250, 2048,1250}   /* ? */
#endif
};

static const SiS_LVDSDataStruct  SiS_LCDA1600x1200Data_2[]=
{ /* Clevo (Temporary data. Seems invalid.) */
	{2160,1250, 2160,1250},
	{2160,1250, 2160,1250},
	{2160,1250, 2160,1250},
	{2160,1250, 2160,1250},
	{2160,1250, 2160,1250},
	{2160,1250, 2160,1250},
	{2160,1250, 2160,1250},
	{2160,1250, 2160,1250},
	{2160,1250, 2160,1250},
	{2160,1250, 2160,1250}
};

/* LVDS SKEW for LCDA */

static const SiS_LVDSDesStruct SiS_PanelType1076_1[]=
{  /* 1024x768 */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},   /* 805; was 0, 0 -> top line cut away (26/09/03) */
};

static const SiS_LVDSDesStruct SiS_PanelType1076_2[]=
{  /* 1024x768; not expanded */
	{ 1184, 622 },
	{ 1184, 597 },
	{ 1184, 622 },
	{ 1184, 597 },
	{ 1152, 650 },  /* 622 */
	{ 1232, 722 },
	{    0, 0   },  /* 805; was 0, 0 -> top line cut away (26/09/03) */
};

static const SiS_LVDSDesStruct SiS_PanelType1210_1[]=
{  /* 1280x1024 */
	{ 0 ,    0},
	{ 0 ,    0},
	{ 0 ,    0},
	{ 0 ,    0},
	{ 0 ,    0},
	{ 0 ,    0},
	{ 0 ,    0},
	{ 0 , 1065},  /* Acer */
	{ 0 ,    0}
};

static const SiS_LVDSDesStruct SiS_PanelType1210_2[]=
{  /* 1280x1024; not expanded */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS_LVDSDesStruct SiS_PanelType1296_1[]=
{  /* 1400x1050 */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 1065}   /* Was 0,0 */
};

static const SiS_LVDSDesStruct SiS_PanelType1296_2[]=
{  /* 1400x1050; not expanded */
	{ 1308, 741 },
	{ 1308, 716 },
	{ 1308, 741 },
	{ 1308, 716 },
	{ 1308, 781 },
	{ 1388, 841 },
	{ 1500, 925 },
	{ 1628,1053 },
	{    0,1065 }
#if 0
	{ 808 , 740},
	{ 0   , 715},
	{ 632 , 740},
	{ 632 , 715},
	{ 1307, 780},
	{ 1387,1157},
	{ 1499, 924},
	{ 1627,1052},
	{ 0 , 0}
#endif
};

static const SiS_LVDSDesStruct SiS_PanelType1600_1[]=
{  /* 1600x1200 */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS_LVDSDesStruct SiS_PanelType1600_2[]=
{  /* 1600x1200; not expanded */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

#ifdef SIS315H

/* LCDA CRT1 custom data */

static const SiS_LCDACRT1DataStruct  Compaq1280x1024_LCDACRT1_1[]=
{
 {{0x7e,0x4f,0x4f,0x82,0x58,0x06,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x06,0x86,0x1f,
   0x5e,0x82,0x5d,0x5d,0x87,0x10,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x06,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x06,0x86,0x1f,
   0x5e,0x82,0x5d,0x5d,0x87,0x10,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x06,0x08,0x3e,
   0xe0,0x84,0xdf,0xdf,0x09,0x00,0x00,0x06,
   0x00}},
 {{0x92,0x63,0x63,0x96,0x6c,0x1a,0x80,0xf0,
   0x58,0x8c,0x57,0x57,0x81,0x20,0x00,0x06,
   0x01}},
 {{0xae,0x7f,0x7f,0x92,0x88,0x96,0x28,0xf5,
   0x00,0x84,0xff,0xff,0x29,0x10,0x00,0x02,
   0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa8,0x16,0x28,0x5a,
   0x00,0x84,0xff,0xff,0x29,0x01,0x00,0x07,
   0x01}}
};

static const SiS_LCDACRT1DataStruct  Compaq1280x1024_LCDACRT1_1_H[]=
{
 {{0x56,0x27,0x27,0x9a,0x30,0x1e,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x3c,0x4f,0x4f,0x82,0x58,0x06,0x86,0xd1,
   0xbc,0x80,0xbb,0xbb,0xe5,0x00,0x00,0x06,
   0x01}},
 {{0x56,0x27,0x27,0x9a,0x30,0x1e,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x3c,0x4f,0x4f,0x82,0x58,0x06,0x86,0xd1,
   0xbc,0x80,0xbb,0xbb,0xe5,0x00,0x00,0x06,
   0x01}},
 {{0x56,0x27,0x27,0x9a,0x30,0x1e,0x08,0x3e,
   0xe0,0x84,0xdf,0xdf,0x09,0x00,0x00,0x05,
   0x00}},
 {{0x60,0x31,0x31,0x84,0x3a,0x88,0x80,0xf0,
   0x58,0x8c,0x57,0x57,0x81,0x20,0x00,0x01,
   0x01}},
 {{0x6e,0x3f,0x3f,0x92,0x48,0x96,0x28,0xf5,
   0x00,0x84,0xff,0xff,0x29,0x10,0x00,0x01,
   0x01}}
};

static const SiS_LCDACRT1DataStruct  Clevo1024x768_LCDACRT1_1[]=
{
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0x97,0x1f,
   0x60,0x87,0x5d,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0x97,0x1f,
   0x60,0x87,0x5d,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0x04,0x3e,
   0xE2,0x89,0xDf,0xDf,0x05,0x00,0x00,0x05,
   0x00}},
 {{0x87,0x63,0x63,0x8B,0x69,0x1A,0x7c,0xf0,
   0x5A,0x8F,0x57,0x57,0x7D,0x20,0x00,0x26,
   0x01}},
 {{0xA3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xFf,0xFf,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS_LCDACRT1DataStruct  Clevo1024x768_LCDACRT1_1_H[]=
{
 {{0x4b,0x27,0x27,0x8f,0x2b,0x03,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x44,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x2b,0x03,0x97,0x1f,
   0x60,0x87,0x5D,0x5D,0x83,0x01,0x00,0x44,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x2b,0x03,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x44,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x2b,0x03,0x97,0x1f,
   0x60,0x87,0x5D,0x5D,0x83,0x01,0x00,0x44,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x32,0x1b,0x04,0x3e,
   0xE2,0x89,0xDf,0xDf,0x05,0x00,0x00,0x45,
   0x00}},
 {{0x55,0x31,0x31,0x99,0x46,0x1d,0x7c,0xf0,
   0x5A,0x8F,0x57,0x57,0x7D,0x20,0x00,0x55,
   0x01}},
 {{0x63,0x3F,0x3F,0x87,0x4A,0x93,0x24,0xF5,
   0x02,0x88,0xFF,0xFF,0x25,0x10,0x00,0x01,
   0x01}}
};

static const SiS_LCDACRT1DataStruct  Clevo1024x768_LCDACRT1_2[]=
{
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x72,0x88,0xdf,0xdf,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x63,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xae,0x84,0x57,0x57,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS_LCDACRT1DataStruct  Clevo1024x768_LCDACRT1_2_H[]=
{
 {{0x7b,0x27,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x57,0x8e,0x8f,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x3e,0x85,0x5d,0x5d,0x25,0x10,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x57,0x8e,0x8f,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x3e,0x85,0x5d,0x5d,0x25,0x10,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x7f,0x86,0xdf,0xdf,0x25,0x10,0x00,0x01,
   0x00 }},
 {{0x71,0x31,0x31,0x95,0x46,0x97,0x24,0xf1,
   0xbb,0x82,0x57,0x57,0x25,0x10,0x00,0x01,
   0x01 }},
 {{0x63,0x3f,0x3f,0x87,0x46,0x97,0x24,0xf5,
   0x0f,0x86,0xff,0xff,0x25,0x30,0x00,0x01,
   0x01 }}
};

#endif  /* 315 */

/**************************************************************/
/* LVDS ----------------------------------------------------- */
/**************************************************************/

static const SiS_LVDSDataStruct  SiS_LVDS320x480Data_1[]=
{
	{ 848, 433, 400, 525},
	{ 848, 389, 400, 525},
	{ 848, 433, 400, 525},
	{ 848, 389, 400, 525},
	{ 848, 518, 400, 525},
	{1056, 628, 400, 525},
	{ 400, 525, 400, 525},
	{ 800, 449,1000, 644},
	{ 800, 525,1000, 635}
};

static const SiS_LVDSDataStruct  SiS_LVDS640x480Data_1[]=
{
	{ 800, 445, 800, 525},   /* 800, 449, 800, 449 */
	{ 800, 395, 800, 525},
	{ 800, 445, 800, 525},
	{ 800, 395, 800, 525},
	{ 800, 525, 800, 525},
	{ 800, 525, 800, 525},   /* pseudo */
	{ 800, 525, 800, 525}    /* pseudo */
};

/* FSTN 320x240 */
static const SiS_LVDSDataStruct  SiS_LVDS640x480Data_2[]=
{
	{ 800, 445, 800, 525},
	{ 800, 395, 800, 525},
	{ 800, 445, 800, 525},
	{ 800, 395, 800, 525},
	{ 800, 525, 800, 525},
        { 800, 525, 800, 525},   /* pseudo */
	{ 800, 525, 800, 525}    /* pseudo */
};


static const SiS_LVDSDataStruct  SiS_LVDS800x600Data_1[]=
{
	{ 848, 433,1060, 629},
	{ 848, 389,1060, 629},
	{ 848, 433,1060, 629},
	{ 848, 389,1060, 629},
	{ 848, 518,1060, 629},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{ 800, 449,1000, 644},
	{ 800, 525,1000, 635}
};

static const SiS_LVDSDataStruct  SiS_LVDS800x600Data_2[]=
{
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{ 800, 449,1000, 644},
	{ 800, 525,1000, 635}
};

static const SiS_LVDSDataStruct  SiS_LVDS1024x768Data_1[]=
{
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 518,1344, 806},   /* 640x480 */
	{1050, 638,1344, 806},   /* 800x600 */
	{1344, 806,1344, 806},   /* 1024x768 */
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LVDS1024x768Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};


static const SiS_LVDSDataStruct  SiS_LVDS1280x1024Data_1[]=
{
	{1048, 442,1688,1066},
	{1048, 392,1688,1066},
	{1048, 442,1688,1066},
	{1048, 392,1688,1066},
	{1048, 522,1688,1066},
	{1208, 642,1688,1066},
	{1432, 810,1688,1066},
	{1688,1066,1688,1066}
};

static const SiS_LVDSDataStruct  SiS_LVDS1280x1024Data_2[]=
{
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066}
};

static const SiS_LVDSDataStruct  SiS_LVDS1400x1050Data_1[]=
{
        { 928, 416, 1688,1066},
	{ 928, 366, 1688,1066},
	{ 928, 416, 1688,1066},
	{ 928, 366, 1688,1066},
	{ 928, 496, 1688,1066},
	{1088, 616, 1688,1066},
	{1312, 784, 1688,1066},
	{1568,1040, 1688,1066},
	{1688,1066, 1688,1066}
};

static const SiS_LVDSDataStruct  SiS_LVDS1400x1050Data_2[]=
{
        {1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
};

static const SiS_LVDSDataStruct  SiS_LVDS1600x1200Data_1[]=
{
   	{1088, 520, 2048,1320},
	{1088, 470, 2048,1320},
	{1088, 520, 2048,1320},
	{1088, 470, 2048,1320},
	{1088, 600, 2048,1320},
	{1248, 720, 2048,1320},
	{1472, 888, 2048,1320},
	{1728,1144, 2048,1320},
	{1848,1170, 2048,1320},
	{2048,1320, 2048,1320}
#if 0
        {1088, 450, 2048,1250},
	{1088, 400, 2048,1250},
	{1088, 450, 2048,1250},
	{1088, 400, 2048,1250},
	{1088, 530, 2048,1250},
	{1248, 650, 2048,1250},
	{1472, 818, 2048,1250},
	{1728,1066, 2048,1250},
	{1848,1066, 2048,1250},
	{2048,1250, 2048,1250}
#endif
};

static const SiS_LVDSDataStruct  SiS_LVDS1600x1200Data_2[]=
{
        {2048,1320, 2048,1320},
	{2048,1320, 2048,1320},
	{2048,1320, 2048,1320},
	{2048,1320, 2048,1320},
	{2048,1320, 2048,1320},
	{2048,1320, 2048,1320},
	{2048,1320, 2048,1320},
	{2048,1320, 2048,1320},
	{2048,1320, 2048,1320},
	{2048,1320, 2048,1320}
};

static const SiS_LVDSDataStruct  SiS_LVDS1280x960Data_1[]=
{
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LVDS1280x960Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LVDS1280x768Data_1[]=
{
	{ 768, 438, 1408, 806},
	{ 768, 388, 1408, 806},
	{ 768, 438, 1408, 806},
	{ 768, 388, 1408, 806},
	{ 768, 518, 1408, 806},
	{ 928, 638, 1408, 806},
	{1152, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806}
};

static const SiS_LVDSDataStruct  SiS_LVDS1280x768Data_2[]=
{
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806}
};

static const SiS_LVDSDataStruct  SiS_LVDS1024x600Data_1[] =
{
	{ 840, 604,1344, 800},
	{ 840, 560,1344, 800},
	{ 840, 604,1344, 800},
	{ 840, 560,1344, 800},
	{ 840, 689,1344, 800},
	{1050, 800,1344, 800},
	{1344, 800,1344, 800},
	{ 800, 449,1280, 789},
	{ 800, 525,1280, 785}
};

static const SiS_LVDSDataStruct  SiS_LVDS1024x600Data_2[] =
{
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LVDS1152x768Data_1[] =
{
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LVDS1152x768Data_2[] =
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

/* Pass 1:1 data */
static const SiS_LVDSDataStruct  SiS_LVDSXXXxXXXData_1[]=
{
        { 800, 449,  800, 449},
	{ 800, 449,  800, 449},
	{ 900, 449,  900, 449},
	{ 900, 449,  900, 449},
	{ 800, 525,  800, 525},  /*  640x480   */
	{1056, 628, 1056, 628},  /*  800x600   */
	{1344, 806, 1344, 806},  /* 1024x768   */
	{1344,1066, 1344,1066},  /* 1280x1024  */  /* INSERTED ! */
 	{1688, 806, 1688, 806},  /* 1280x768   */
	/* No other panels ! */
};

/* Custom data for Barco iQ R series */
static const SiS_LVDSDataStruct  SiS_LVDSBARCO1366Data_1[]=
{
	{ 832, 438,1331, 806},
	{ 832, 388,1331, 806},
	{ 832, 438,1331, 806},
	{ 832, 388,1331, 806},
	{ 832, 518,1331, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066}   /* 1360x1024 */
};

/* Custom data for Barco iQ R series */
static const SiS_LVDSDataStruct  SiS_LVDSBARCO1366Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066}   /* 1360x1024 */
};

/* Custom data for Barco iQ G series */
static const SiS_LVDSDataStruct  SiS_LVDSBARCO1024Data_1[]=
{
	{ 832, 438,1331, 806},
	{ 832, 409,1331, 806},
	{ 832, 438,1331, 806},
	{ 832, 409,1331, 806},
	{ 832, 518,1331, 806},   /* 640x480 */
	{1050, 638,1344, 806},   /* 800x600 */
	{1344, 806,1344, 806},   /* 1024x768 */
};

/* Custom data for Barco iQ G series */
static const SiS_LVDSDataStruct  SiS_LVDSBARCO1024Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
};

/* Custom data for 848x480 parallel panel */
static const SiS_LVDSDataStruct  SiS_LVDS848x480Data_1[]=
{
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{1088, 525,1088, 525},  /* 640x480 TODO */
	{1088, 525,1088, 525},  /* 800x600 TODO */
	{1088, 525,1088, 525},  /* 1024x768 TODO */
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{1088, 525,1088, 525},  /* 848x480 */
	{1088, 525,1088, 525}   /* 1360x768 TODO */
};

/* Custom data for 848x480 parallel panel */
static const SiS_LVDSDataStruct  SiS_LVDS848x480Data_2[]=
{
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{1088, 525,1088, 525},  /*  640x480 */
	{1088, 525,1088, 525},  /*  800x600 */
	{1088, 525,1088, 525},  /* 1024x768 */
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{   0,   0,   0,   0},
	{1088, 525,1088, 525},  /* 848x480 */
	{1088, 525,1088, 525}	/* 1360x768 TODO */
};

static const SiS_LVDSDataStruct  SiS_CHTVUNTSCData[]=
{
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 784, 600, 784, 600},
	{1064, 750,1064, 750},
        {1160, 945,1160, 945}
};

static const SiS_LVDSDataStruct  SiS_CHTVONTSCData[]=
{
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 784, 525, 784, 525},
	{1040, 700,1040, 700},
        {1160, 840,1160, 840}
};

/* LVDS Skew */

static const SiS_LVDSDesStruct  SiS_PanelTypeNS_1[]=
{
	{ 8,   0},
	{ 8,   0},
	{ 8,   0},
	{ 8,   0},
	{ 8,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0, 806},
	{ 0,   0}
};

static const SiS_LVDSDesStruct  SiS_PanelTypeNS_2[] =
{
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

/* Chrontel TV Skew */

static const SiS_LVDSDesStruct  SiS_CHTVUNTSCDesData[]=
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS_LVDSDesStruct  SiS_CHTVONTSCDesData[]=
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS_LVDSDesStruct  SiS_CHTVUPALDesData[]=
{
	{256,   0},
	{256,   0},
	{256,   0},
	{256,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS_LVDSDesStruct  SiS_CHTVOPALDesData[]=
{
	{256,   0},
	{256,   0},
	{256,   0},
	{256,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

/* CRT1 CRTC data for slave modes */

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1320x480_1[] =
{
 {{0x65,0x4f,0x89,0x56,0x83,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x54,0x9f,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x04,0x3e,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00 }},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01 }},
 {{0x2d,0x27,0x90,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00 }}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1640x480_1[] =
{
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x30,0x00,0x05,
   0x00}},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1640x480_1_H[] =
{
 {{0x2d,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x00,0x00,0x00,
   0x00}},
 {{0x2d,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x83,0x85,0x63,0xba,0x00,0x00,0x00,
   0x00}},
 {{0x2d,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x00,0x00,0x00,
   0x00}},
 {{0x2d,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x83,0x85,0x63,0xba,0x00,0x00,0x00,
   0x00}},
 {{0x2d,0x28,0x90,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1640x480_2[] =
{
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x30,0x00,0x05,
   0x00}},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01}},
 {{0x2d,0x27,0x90,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1640x480_2_H[] =
{
 {{0x65,0x4f,0x89,0x56,0x83,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00}},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00}},
 {{0x65,0x4f,0x89,0x54,0x9f,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00}},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00}},
 {{0x65,0x4f,0x89,0x56,0x83,0x04,0x3e,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00}},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01}},
 {{0x2d,0x27,0x90,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1640x480_3[] =
{
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x00,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x00,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x00,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x00,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0x04,0x00,0x00,0x05,
   0x00}},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01}},
 {{0x2d,0x27,0x90,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1640x480_3_H[] =
{
 {{0x65,0x4f,0x89,0x56,0x83,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00}},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00}},
 {{0x65,0x4f,0x89,0x54,0x9f,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00}},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00}},
 {{0x65,0x4f,0x89,0x56,0x83,0x04,0x3e,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00}},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01}},
 {{0x2d,0x27,0x90,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11024x600_1[] =
{
 {{0x64,0x4f,0x88,0x54,0x9f,0x5a,0x3e,
   0xe8,0x8f,0x8f,0x5b,0x00,0x00,0x01,
   0x00}},
 {{0x64,0x4f,0x88,0x54,0x9f,0x2e,0x3e,
   0xb9,0x80,0x5d,0x2f,0x00,0x00,0x01,
   0x00}},
 {{0x64,0x4f,0x88,0x54,0x9f,0x5a,0x3e,
   0xe8,0x8f,0x8f,0x5b,0x00,0x00,0x01,
   0x00}},
 {{0x64,0x4f,0x88,0x54,0x9f,0x2e,0x3e,
   0xb9,0x80,0x5d,0x2f,0x00,0x00,0x01,
   0x00}},
 {{0x64,0x4f,0x88,0x54,0x9f,0xaf,0xba,
   0x3b,0x82,0xdf,0xb0,0x00,0x00,0x01,
   0x00}},
 {{0x7e,0x63,0x82,0x68,0x15,0x1e,0xf1,
   0xae,0x85,0x57,0x1f,0x30,0x00,0x26,
   0x01}},
 {{0xa3,0x7f,0x87,0x86,0x97,0x1e,0xf1,
   0xae,0x85,0x57,0x1f,0x30,0x00,0x02,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11024x600_1_H[] =
{
 {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
   0x00}},
 {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
   0x00}},
 {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
   0x00}},
 {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
   0x00}},
 {{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
   0xe2,0x89,0xdf,0x05,0x00,0x00,0x44,
   0x00}},
 {{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
   0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
   0x01}},
 {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11024x600_2[] =
{
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11024x600_2_H[] =
{
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00}},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00}},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00}},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00}},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
   0x00}},
 {{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x01,
   0x01}},
 {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11152x768_1[] =
{
 {{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00}},
 {{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
   0x00}},
 {{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00}},
 {{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
   0x00}},
 {{0x64,0x4f,0x88,0x54,0x9f,0x04,0x3e,
   0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
   0x00}},
 {{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
   0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
   0x01}},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11152x768_1_H[] =
{
 {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
   0x00}},
 {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
   0x00}},
 {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
   0x00}},
 {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
   0x00}},
 {{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
   0xe2,0x89,0xdf,0x05,0x00,0x00,0x44,
   0x00}},
 {{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
   0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
   0x01}},
 {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11152x768_2[] =
{
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11152x768_2_H[] =
{
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00}},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00}},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00}},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00}},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
   0x00}},
 {{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x01,
   0x01}},
 {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11280x768_1[] =
{
 {{0x5b,0x4f,0x9f,0x55,0x19,0xb4,0x1f,
   0x9c,0x8e,0x8f,0xb5,0x10,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0x82,0x1f,
   0x6a,0x8c,0x5d,0x83,0x30,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0xb4,0x1f,
   0x9c,0x8e,0x8f,0xb5,0x10,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0x82,0x1f,
   0x6a,0x8c,0x5d,0x83,0x30,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0x04,0x3e,
   0xec,0x8e,0xdf,0x05,0x20,0x00,0x01,
   0x00}},
 {{0x6f,0x63,0x93,0x69,0x8d,0x7c,0xf0,
   0x64,0x86,0x57,0x7d,0x20,0x00,0x05,
   0x01}},
 {{0x8b,0x7f,0x8f,0x85,0x09,0x24,0xf5,
   0x0c,0x8e,0xff,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xab,0x9f,0x8f,0xa5,0x89,0x24,0xf5,
   0x0c,0x8e,0xff,0x25,0x30,0x00,0x06,
   0x01}},
 {{0xab,0x9f,0x8f,0xa5,0x89,0x24,0xf5,
   0x0c,0x8e,0xff,0x25,0x30,0x00,0x06,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11280x768_1_H[] =
{
 {{0x47,0x27,0x8b,0x2c,0x1a,0x9e,0x1f,
   0x93,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x30,0x1e,0x9e,0x1f,
   0x92,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0xee,0x1f,
   0xe2,0x86,0xdf,0xef,0x10,0x00,0x05,
   0x00}},
 {{0x51,0x31,0x95,0x36,0x04,0x66,0xf0,
   0x5a,0x8e,0x57,0x67,0x20,0x00,0x01,
   0x01}},
 {{0x5f,0x3f,0x83,0x44,0x92,0x0e,0xf5,
   0x02,0x86,0xff,0x0f,0x10,0x00,0x01,
   0x01}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x05,
   0x01}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x05,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11280x768_2[] =
{
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xb3,
   0x7c,0x8e,0x03,0x02,0x10,0x00,0x02,
   0x01}},
 {{0xab,0x63,0x8f,0x8a,0x8e,0x24,0xf1,
   0xb6,0x88,0x57,0x25,0x10,0x00,0x02,
   0x01}},
 {{0xab,0x7f,0x8f,0x98,0x9c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11280x768_2_H[] =
{
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xb3,
   0x7c,0x8e,0x03,0x02,0x10,0x00,0x01,
   0x01}},
 {{0x79,0x31,0x9d,0x58,0x9c,0x24,0xf1,
   0xb6,0x88,0x57,0x25,0x10,0x00,0x01,
   0x01}},
 {{0x6b,0x3f,0x8f,0x58,0x9c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x01,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1XXXxXXX_1[] =
{
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x05,
   0x00}},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01}},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01}},
 {{0xce,0x9f,0x92,0xa8,0x14,0x28,0x5a,
   0x00,0x84,0xff,0x29,0x09,0x00,0x07,
   0x01}},
 {{0xce,0x9f,0x92,0xa9,0x17,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x07,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1XXXxXXX_1_H[] =
{
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00}},
 {{0x4d,0x31,0x91,0x3b,0x03,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x01,
   0x01}},
 {{0x63,0x3f,0x87,0x4a,0x92,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01}}
};


/**************************************************************/
/* COMMON --------------------------------------------------- */
/**************************************************************/

#define SIS_PL_HSYNCP 0x01
#define SIS_PL_HSYNCN 0x02
#define SIS_PL_VSYNCP 0x04
#define SIS_PL_VSYNCN 0x08
#define SIS_PL_DVI    0x80

typedef struct _SiS_PlasmaModes
{
  const char *name;
  ULONG  clock;
  USHORT HDisplay, HTotal, HFrontPorch, HSyncWidth;
  USHORT VDisplay, VTotal, VFrontPorch, VSyncWidth;
  UCHAR  SyncFlags;
} SiS_PlasmaModes;

typedef struct _SiS_PlasmaTables
{
   USHORT vendor;
   UCHAR  productnum;
   USHORT product[5];
   const char *DDCnames[5];
   const char *plasmaname;
   UCHAR  modenum;
   UCHAR  plasmamodes[20];  /* | 0x80 = DVI-capable, | 0x40 = analog */
} SiS_PlasmaTables;

static const SiS_PlasmaModes SiS_PlasmaMode[] = {
   {  "640x400",		/* 00: IBM 400@70 */
      25175,
       640,  800, 17,  64,
       400,  449, 13,   2,
      SIS_PL_HSYNCN | SIS_PL_VSYNCN },
   {  "640x480",		/* 01: VESA 480@72 */
      31500,
       640,  832, 24,  40,
       480,  520,  9,   3,
      SIS_PL_HSYNCN | SIS_PL_VSYNCN },
   {  "800x600",		/* 02: VESA 600@72 */
      50000,
       800, 1040, 56, 120,
       600,  666, 37,   6,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "864x480",		/* 03: Cereb wide 1 */
      42526,
       864, 1134, 22,  86,
       480,  500,  1,   3,
      SIS_PL_HSYNCP | SIS_PL_VSYNCN },
   {  "848x480",		/* 04: VESA wide (NEC1) */
      33750,
       848, 1088, 16, 112,
       480,  517,  6,   8,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "1024x576",		/* 05: VESA wide (NEC2) */
      47250,
      1024, 1320, 16, 144,
       576,  596,  2,   4,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "1280x720",		/* 06: VESA wide (NEC3) */
      76500,
      1280, 1696, 48, 176,
       720,  750,  4,   8,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "1360x765",		/* 07: VESA wide (NEC4) */
      85500,
      1360, 1792, 64, 176,
       765,  795,  4,   8,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "1024x600",		/* 08: CEREB wide 2 */
      51200,
      1024, 1352, 51, 164,
       600,  628,  1,   4,
      SIS_PL_HSYNCN | SIS_PL_VSYNCP },
   {  "1024x768",		/* 09: VESA 768@75 */
      78750,
      1024, 1312,  16, 96,
       768,  800,   1,  3,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "1152x864",		/* 10: VESA 1152x864@75 */
      108000,
      1152, 1600, 64, 128,
       864,  900,  1,   3,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "1280x1024",		/* 11: VESA 1024@60 */
      108000,
      1280, 1688, 48, 112,
      1024, 1066,  1,   3,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "1280x768",		/* 12: W_XGA */
      81000,
      1280, 1688, 48, 112,
       768,  802,  3,   6,
      SIS_PL_HSYNCP | SIS_PL_VSYNCN },
   {  "1280x768",		/* 13: I/O Data W_XGA@56Hz */
      76064,
      1280, 1688, 48, 112,
       768,  802,  2,   3,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "1376x768",		/* 14: I/O Wide XGA */
      87340,
      1376, 1808, 32, 128,
       768,  806,  3,   6,
      SIS_PL_HSYNCN | SIS_PL_VSYNCP },
   {  "1280x960",		/* 15: VESA 960@60 */
      108000,
      1280, 1800, 96, 112,
       960, 1000,  1,   3,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "1400x1050",		/* 16: VESA 1050@60Hz */
      108000,
      1400, 1688, 48, 112,
      1050, 1066,  1,   3,
      SIS_PL_HSYNCN | SIS_PL_VSYNCN },
   {  "1360x768",		/* 17: VESA wide (NEC4/2) */
      85500,
      1360, 1792, 64, 112,
       765,  795,  3,   6,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "800x600",		/* 18: VESA 600@56 */
      36000,
       800, 1024, 24,   2,
       600,  625,  1,   2,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "1072x600",		/* 19: Panasonic 1072x600 (sync?) */
      54100,
       1072, 1424, 48, 176,
        600,  628, 16,   1,
      SIS_PL_HSYNCP | SIS_PL_VSYNCP },
   {  "848x480",		/* 20: Panasonic 848x480 (sync?) */
      33070,			/* is 852x480, but we can't use 852 */
        848, 1068, 20,  40,	/* differs from DDC data, better centered */
        480,  516,  3,   5,	/* won't work assumingly, because data is % 8 */
      SIS_PL_HSYNCN | SIS_PL_VSYNCN },
};

static const SiS_PlasmaTables SiS_PlasmaTable[] = {
#if 0  /* Product IDs missing */
   { 0x38a3, 4,
     { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "NEC PlasmaSync 42VP4/42VP4D/42VP4G/42VP4DG",
     11,   /* All DVI, except 0, 7, 13 */
     { 0|0x40, 1|0xc0, 2|0xc0, 4|0xc0, 7|0x40, 9|0xc0,10|0xc0,11|0xc0,13|0x40,14|0xc0,
      17|0xc0, 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
#endif
#if 0  /* Product IDs missing */
   { 0x38a3, 3,
     { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "NEC PlasmaSync 42PD1/50PD1/50PD2",
     5,   /* DVI entirely unknown */
     { 0|0x40, 1|0xc0, 2|0xc0, 4|0xc0, 9|0xc0, 0     , 0     , 0     , 0     , 0     ,
       0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
   { 0x38a3, 1,
     { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "NEC PlasmaSync 42PD3",
     10,   /* DVI entirely unknown */
     { 0|0x40, 1|0xc0, 2|0xc0, 3|0xc0, 4|0xc0, 5|0xc0, 6|0xc0, 7|0x40, 8|0xc0, 9|0xc0,
       0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
   { 0x38a3, 2,
     { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "NEC PlasmaSync 42VM3/61XM1",
     11,  /* DVI entirely unknown */
     { 0|0x40, 1|0xc0, 2|0xc0, 3|0xc0, 4|0xc0, 5|0xc0, 6|0xc0, 8|0xc0, 9|0xc0,11|0xc0,
      17|0xc0, 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
   { 0x38a3, 2,
     { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "NEC PlasmaSync 42MP1/42MP2",
     6,   /* DVI entirely unknown */
     { 0|0x40, 1|0xc0, 2|0xc0, 4|0xc0, 9|0xc0,11|0xc0, 0     , 0     , 0     , 0     ,
       0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
   { 0x38a3, 1,
     { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "NEC PlasmaSync 50MP1",
     10,   /* DVI entirely unknown */
     { 0|0x40, 1|0xc0, 2|0xc0, 4|0xc0, 7|0x40, 9|0xc0,10|0xc0,11|0xc0,13|0x40,14|0xc0,
       0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
#endif
   { 0x38a3, 4,
     { 0xa482, 0xa483, 0x0000, 0x0000, 0x0000 },
     { "PX-42VM", "", "", "", "" },
     "NEC PlasmaSync 42MP3/42MP4/50MP2/61MP1",
     11,   /* All DVI except 0, 7, 13, 17 */
     { 0|0x40, 1|0xc0, 2|0xc0, 4|0xc0, 7|0x40, 9|0xc0,10|0xc0,11|0xc0,13|0x40,14|0xc0,
      17|0x40, 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
#if 0  /* Product IDs missing */
   { 0x38a3, 1,
     { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "NEC PlasmaSync 3300W",
     3,
     { 0|0x40, 1|0xc0,18|0xc0, 0     , 0     , 0     , 0     , 0     , 0     , 0     ,
       0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
   { 0x38a3, 1,
     { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "NEC PlasmaSync 4200W",
     4,   /* DVI entirely unknown */
     { 0|0x40, 1|0xc0, 2|0xc0, 4|0xc0, 0     , 0     , 0     , 0     , 0     , 0     ,
       0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
   { 0x38a3, 1,
     { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "NEC PlasmaSync 4210W",
     6,   /* DVI entirely unknown */
     { 0|0x40, 1|0xc0, 2|0xc0, 4|0xc0, 9|0xc0,11|0xc0, 0     , 0     , 0     , 0     ,
       0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
   { 0x38a3, 1,
     { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "NEC PlasmaSync 5000W",
     7,   /* DVI entirely unknown */
     { 0|0x40, 1|0xc0, 2|0xc0, 4|0xc0, 7|0x40, 9|0xc0,11|0xc0, 0     , 0     , 0     ,
       0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
#endif
   { 0x412f, 2,
     { 0x000c, 0x000b, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "Pioneer 503CMX/PDA-5002",
     6,   /* DVI unknown */
     { 1|0xc0, 2|0xc0, 9|0xc0,11|0xc0,12|0xc0,15|0xc0, 0     , 0     , 0     , 0     ,
       0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
   { 0x34a9, 1,
     { 0xa00e, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "", "", "", "", "" },
     "Panasonic TH-42",
     5,   /* No DVI output */
     { 1|0x40, 2|0x40, 4|0x40, 9|0x40,15|0x40, 0     , 0     , 0     , 0     , 0     ,
       0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
   { 0x34a9, 1,
     { 0xa005, 0x0000, 0x0000, 0x0000, 0x0000 },
     { "TH-42PW*4", "", "", "", "" },
     "Panasonic TH-42PW5",
     1,   /* No special modes otherwise; no DVI. */
     {20|0x40,19|0x40, 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     ,
       0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0     , 0       }
   },
   { 0x0000 }
};

USHORT  SiS_GetModeID(int VGAEngine, ULONG VBFlags, int HDisplay, int VDisplay, int Depth, BOOLEAN FSTN);
USHORT  SiS_GetModeID_LCD(int VGAEngine, ULONG VBFlags, int HDisplay, int VDisplay, int Depth, BOOLEAN FSTN,
                          USHORT CustomT, int LCDwith, int LCDheight);
USHORT  SiS_GetModeID_TV(int VGAEngine, ULONG VBFlags, int HDisplay, int VDisplay, int Depth);
USHORT  SiS_GetModeID_VGA2(int VGAEngine, ULONG VBFlags, int HDisplay, int VDisplay, int Depth);

void 	SiS_SetReg(SISIOADDRESS port, USHORT index, USHORT data);
void 	SiS_SetRegByte(SISIOADDRESS port, USHORT data);
void  	SiS_SetRegShort(SISIOADDRESS port, USHORT data);
void	SiS_SetRegLong(SISIOADDRESS port, ULONG data);
UCHAR	SiS_GetReg(SISIOADDRESS port, USHORT index);
UCHAR 	SiS_GetRegByte(SISIOADDRESS port);
USHORT	SiS_GetRegShort(SISIOADDRESS port);
ULONG	SiS_GetRegLong(SISIOADDRESS port);
void	SiS_SetRegANDOR(SISIOADDRESS Port,USHORT Index,USHORT DataAND,USHORT DataOR);
void 	SiS_SetRegAND(SISIOADDRESS Port,USHORT Index,USHORT DataAND);
void	SiS_SetRegOR(SISIOADDRESS Port,USHORT Index,USHORT DataOR);
void	SiS_DisplayOn(SiS_Private *SiS_Pr);
void	SiS_DisplayOff(SiS_Private *SiS_Pr);
void	SiSRegInit(SiS_Private *SiS_Pr, SISIOADDRESS BaseAddr);
void	SiSSetLVDSetc(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo);
void	SiS_SetEnableDstn(SiS_Private *SiS_Pr, int enable);
void	SiS_SetEnableFstn(SiS_Private *SiS_Pr, int enable);
void	SiS_GetVBType(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo);
USHORT	SiS_GetMCLK(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo);
BOOLEAN	SiS_SearchModeID(SiS_Private *SiS_Pr, USHORT *ModeNo, USHORT *ModeIdIndex);
UCHAR	SiS_GetModePtr(SiS_Private *SiS_Pr, USHORT ModeNo, USHORT ModeIdIndex);
USHORT	SiS_GetColorDepth(SiS_Private *SiS_Pr, USHORT ModeNo, USHORT ModeIdIndex);
USHORT	SiS_GetOffset(SiS_Private *SiS_Pr,USHORT ModeNo,USHORT ModeIdIndex,
              USHORT RefreshRateTableIndex,PSIS_HW_INFO HwInfo);
void	SiS_LoadDAC(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo, USHORT ModeNo, USHORT ModeIdIndex);
#ifdef LINUX_XF86
BOOLEAN	SiSSetMode(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo,ScrnInfoPtr pScrn,USHORT ModeNo, BOOLEAN dosetpitch);
BOOLEAN	SiSBIOSSetMode(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo, ScrnInfoPtr pScrn,
               DisplayModePtr mode, BOOLEAN IsCustom);
BOOLEAN	SiSBIOSSetModeCRT2(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo, ScrnInfoPtr pScrn,
               DisplayModePtr mode, BOOLEAN IsCustom);
BOOLEAN	SiSBIOSSetModeCRT1(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo, ScrnInfoPtr pScrn,
               DisplayModePtr mode, BOOLEAN IsCustom);
int	SiSTranslateToVESA(ScrnInfoPtr pScrn, int modenumber);
BOOLEAN	SiS_GetPanelID(SiS_Private *SiS_Pr, PSIS_HW_INFO);
USHORT 	SiS_CheckBuildCustomMode(ScrnInfoPtr pScrn, DisplayModePtr mode, int VBFlags);
DisplayModePtr SiSBuildBuiltInModeList(ScrnInfoPtr pScrn, BOOLEAN includelcdmodes, BOOLEAN isfordvi);
#else
BOOLEAN	SiSSetMode(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo,USHORT ModeNo);
#endif
#ifdef LINUX_KERNEL
int    sisfb_mode_rate_to_dclock(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo,
			      unsigned char modeno, unsigned char rateindex);
int    sisfb_mode_rate_to_ddata(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo,
			 unsigned char modeno, unsigned char rateindex,
			 ULONG *left_margin, ULONG *right_margin,
			 ULONG *upper_margin, ULONG *lower_margin,
			 ULONG *hsync_len, ULONG *vsync_len,
			 ULONG *sync, ULONG *vmode);
BOOLEAN sisfb_gettotalfrommode(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo,
		       unsigned char modeno, int *htotal, int *vtotal, unsigned char rateindex);
#endif

extern void      SiS_GetVBInfo(SiS_Private *SiS_Pr, USHORT ModeNo, USHORT ModeIdIndex,
			       PSIS_HW_INFO HwInfo, int chkcrt2mode);
extern void      SiS_GetLCDResInfo(SiS_Private *SiS_Pr, USHORT ModeNo, USHORT ModeIdIndex,
			           PSIS_HW_INFO HwInfo);
extern void      SiS_SetYPbPr(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo);
extern void 	 SiS_SetTVMode(SiS_Private *SiS_Pr, USHORT ModeNo, USHORT ModeIdIndex, PSIS_HW_INFO HwInfo);
extern void      SiS_UnLockCRT2(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo);
extern void      SiS_LockCRT2(SiS_Private *SiS_Pr, PSIS_HW_INFO HwInfo);
extern void      SiS_DisableBridge(SiS_Private *, PSIS_HW_INFO);
extern BOOLEAN   SiS_SetCRT2Group(SiS_Private *, PSIS_HW_INFO, USHORT);
extern USHORT    SiS_GetRatePtr(SiS_Private *SiS_Pr, USHORT ModeNo, USHORT ModeIdIndex,
                                PSIS_HW_INFO HwInfo);
extern void      SiS_WaitRetrace1(SiS_Private *SiS_Pr);
extern USHORT    SiS_GetResInfo(SiS_Private *SiS_Pr, USHORT ModeNo, USHORT ModeIdIndex);
extern USHORT    SiS_GetCH700x(SiS_Private *SiS_Pr, USHORT tempax);
extern USHORT    SiS_GetVCLK2Ptr(SiS_Private *SiS_Pr, USHORT ModeNo, USHORT ModeIdIndex,
                                 USHORT RefreshRateTableIndex, PSIS_HW_INFO HwInfo);
extern BOOLEAN   SiS_IsVAMode(SiS_Private *, PSIS_HW_INFO);
extern BOOLEAN   SiS_IsDualEdge(SiS_Private *, PSIS_HW_INFO);

#ifdef LINUX_XF86
extern int      SiS_compute_vclk(int Clock, int *out_n, int *out_dn, int *out_div,
	     	 		 int *out_sbit, int *out_scale);
extern void 	SiSCalcClock(ScrnInfoPtr pScrn, int clock, int max_VLD, unsigned int *vclk);

extern unsigned char SiS_GetSetBIOSScratch(ScrnInfoPtr pScrn, USHORT offset, unsigned char value);
extern unsigned char SiS_GetSetModeID(ScrnInfoPtr pScrn, unsigned char id);
extern USHORT 	     SiS_CalcModeIndex(ScrnInfoPtr pScrn, DisplayModePtr mode, unsigned long VBFlags,
					BOOLEAN hcm);
#endif

#endif

