/*
 * This is where we statically allocate and initialize the initial
 * task.
 *
 * Copyright (C) 1999, 2002-2003 Hewlett-Packard Co
 *	David Mosberger-Tang <davidm@hpl.hp.com>
 */

#include <linux/init.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/init_task.h>
#include <linux/mqueue.h>

#include <linux/uaccess.h>
#include <asm/pgtable.h>

static struct signal_struct init_signals = INIT_SIGNALS(init_signals);
static struct sighand_struct init_sighand = INIT_SIGHAND(init_sighand);
/*
 * Initial task structure.
 *
 * We need to make sure that this is properly aligned due to the way process stacks are
 * handled. This is done by having a special ".data..init_task" section...
 */
#define init_thread_info	init_task_mem.s.thread_info
#define init_stack		init_task_mem.stack

union {
	struct {
		struct task_struct task;
		struct thread_info thread_info;
	} s;
	unsigned long stack[KERNEL_STACK_SIZE/sizeof (unsigned long)];
} init_task_mem asm ("init_task") __init_task_data =
	{{
	.task =		INIT_TASK(init_task_mem.s.task),
	.thread_info =	INIT_THREAD_INFO(init_task_mem.s.task)
}};

EXPORT_SYMBOL(init_task);
