/*	$NetBSD: spleen32x64.h,v 1.8 2020/07/31 20:39:50 fcambus Exp $ */
/*	$OpenBSD: spleen32x64.h,v 1.2 2019/03/08 10:53:59 fcambus Exp $ */

/*
 * Copyright (c) 2018-2020 Frederic Cambus <fcambus@openbsd.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

static u_char spleen32x64_data[];

struct wsdisplay_font spleen32x64 = {
	.name		= "Spleen 32x64",
	.firstchar	= ' ',
	.numchars	= 256 - ' ',
	.encoding	= WSDISPLAY_FONTENC_ISO,
	.fontwidth	= 32,
	.fontheight	= 64,
	.stride		= 4,
	.bitorder	= WSDISPLAY_FONTORDER_L2R,
	.byteorder	= WSDISPLAY_FONTORDER_L2R,
	.data		= spleen32x64_data
};

static u_char spleen32x64_data[] = {
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc3, 0xc0, 0x00, 	/* .....*****....****.............. */
	0x0f, 0x83, 0xc0, 0x00, 	/* ....*****.....****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x83, 0xc0, 0x00, 	/* ....*****.....****.............. */
	0x07, 0xc3, 0xc0, 0x00, 	/* .....*****....****.............. */
	0x07, 0xff, 0xfe, 0x00, 	/* .....******************......... */
	0x03, 0xff, 0xff, 0x80, 	/* ......*******************....... */
	0x01, 0xff, 0xff, 0xc0, 	/* .......*******************...... */
	0x00, 0x7f, 0xff, 0xe0, 	/* .........******************..... */
	0x00, 0x03, 0xc3, 0xe0, 	/* ..............****....*****..... */
	0x00, 0x03, 0xc1, 0xf0, 	/* ..............****.....*****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc1, 0xf0, 	/* ..............****.....*****.... */
	0x00, 0x03, 0xc3, 0xe0, 	/* ..............****....*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x01, 0xe0, 	/* .......................****..... */
	0x00, 0x00, 0x01, 0xe0, 	/* .......................****..... */
	0x01, 0xf8, 0x03, 0xe0, 	/* .......******.........*****..... */
	0x03, 0xfc, 0x03, 0xe0, 	/* ......********........*****..... */
	0x07, 0x9e, 0x07, 0xc0, 	/* .....****..****......*****...... */
	0x07, 0x9e, 0x07, 0xc0, 	/* .....****..****......*****...... */
	0x07, 0x9e, 0x0f, 0x80, 	/* .....****..****.....*****....... */
	0x07, 0x9e, 0x0f, 0x80, 	/* .....****..****.....*****....... */
	0x07, 0x9e, 0x1f, 0x00, 	/* .....****..****....*****........ */
	0x07, 0x9e, 0x1f, 0x00, 	/* .....****..****....*****........ */
	0x03, 0xfc, 0x3e, 0x00, 	/* ......********....*****......... */
	0x01, 0xf8, 0x3e, 0x00, 	/* .......******.....*****......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x7c, 0x1f, 0x80, 	/* .........*****.....******....... */
	0x00, 0x7c, 0x3f, 0xc0, 	/* .........*****....********...... */
	0x00, 0xf8, 0x79, 0xe0, 	/* ........*****....****..****..... */
	0x00, 0xf8, 0x79, 0xe0, 	/* ........*****....****..****..... */
	0x01, 0xf0, 0x79, 0xe0, 	/* .......*****.....****..****..... */
	0x01, 0xf0, 0x79, 0xe0, 	/* .......*****.....****..****..... */
	0x03, 0xe0, 0x79, 0xe0, 	/* ......*****......****..****..... */
	0x03, 0xe0, 0x79, 0xe0, 	/* ......*****......****..****..... */
	0x07, 0xc0, 0x3f, 0xc0, 	/* .....*****........********...... */
	0x07, 0xc0, 0x1f, 0x80, 	/* .....*****.........******....... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x01, 0xf0, 0x0f, 0x80, 	/* .......*****........*****....... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x01, 0xf0, 0x0f, 0x80, 	/* .......*****........*****....... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x3f, 0xf8, 0x00, 	/* ..........***********........... */
	0x01, 0xff, 0xc0, 0x00, 	/* .......***********.............. */
	0x07, 0xff, 0xc0, 0x00, 	/* .....*************.............. */
	0x0f, 0xff, 0xe0, 0x00, 	/* ....***************............. */
	0x1f, 0xff, 0xf0, 0x00, 	/* ...*****************............ */
	0x1f, 0x00, 0xf8, 0x70, 	/* ...*****........*****....***.... */
	0x3e, 0x00, 0x7c, 0xf0, 	/* ..*****..........*****..****.... */
	0x3c, 0x00, 0x3f, 0xf0, 	/* ..****............**********.... */
	0x3c, 0x00, 0x1f, 0xe0, 	/* ..****.............********..... */
	0x3c, 0x00, 0x0f, 0xc0, 	/* ..****..............******...... */
	0x3c, 0x00, 0x0f, 0x80, 	/* ..****..............*****....... */
	0x3c, 0x00, 0x0f, 0x00, 	/* ..****..............****........ */
	0x3c, 0x00, 0x0f, 0x00, 	/* ..****..............****........ */
	0x3c, 0x00, 0x0f, 0x80, 	/* ..****..............*****....... */
	0x3c, 0x00, 0x0f, 0xc0, 	/* ..****..............******...... */
	0x3e, 0x00, 0x1f, 0xe0, 	/* ..*****............********..... */
	0x1f, 0x00, 0x3f, 0xf0, 	/* ...*****..........**********.... */
	0x1f, 0xff, 0xfc, 0xf8, 	/* ...*******************..*****... */
	0x0f, 0xff, 0xfc, 0x7c, 	/* ....******************...*****.. */
	0x07, 0xff, 0xf8, 0x3c, 	/* .....****************.....****.. */
	0x01, 0xff, 0xe0, 0x1c, 	/* .......************........***.. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x0f, 0xf0, 	/* ....................********.... */
	0x00, 0x00, 0x3f, 0xf0, 	/* ..................**********.... */
	0x00, 0x00, 0xff, 0xf0, 	/* ................************.... */
	0x00, 0x01, 0xff, 0xf0, 	/* ...............*************.... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x07, 0xf0, 0x00, 	/* .............*******............ */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x7c, 0x00, 0x00, 	/* .........*****.................. */
	0x00, 0x7c, 0x00, 0x00, 	/* .........*****.................. */
	0x00, 0xf8, 0x00, 0x00, 	/* ........*****................... */
	0x00, 0xf8, 0x00, 0x00, 	/* ........*****................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x00, 0xf8, 0x00, 0x00, 	/* ........*****................... */
	0x00, 0xf8, 0x00, 0x00, 	/* ........*****................... */
	0x00, 0x7c, 0x00, 0x00, 	/* .........*****.................. */
	0x00, 0x7c, 0x00, 0x00, 	/* .........*****.................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xf0, 0x00, 	/* .............*******............ */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x01, 0xff, 0xf0, 	/* ...............*************.... */
	0x00, 0x00, 0xff, 0xf0, 	/* ................************.... */
	0x00, 0x00, 0x3f, 0xf0, 	/* ..................**********.... */
	0x00, 0x00, 0x0f, 0xf0, 	/* ....................********.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x07, 0xf8, 0x00, 0x00, 	/* .....********................... */
	0x07, 0xfe, 0x00, 0x00, 	/* .....**********................. */
	0x07, 0xff, 0x80, 0x00, 	/* .....************............... */
	0x07, 0xff, 0xc0, 0x00, 	/* .....*************.............. */
	0x00, 0x1f, 0xe0, 0x00, 	/* ...........********............. */
	0x00, 0x07, 0xf0, 0x00, 	/* .............*******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xe0, 	/* .......................****..... */
	0x00, 0x00, 0x01, 0xe0, 	/* .......................****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x01, 0xe0, 	/* .......................****..... */
	0x00, 0x00, 0x01, 0xe0, 	/* .......................****..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x07, 0xf0, 0x00, 	/* .............*******............ */
	0x00, 0x1f, 0xe0, 0x00, 	/* ...........********............. */
	0x07, 0xff, 0xc0, 0x00, 	/* .....*************.............. */
	0x07, 0xff, 0x80, 0x00, 	/* .....************............... */
	0x07, 0xfe, 0x00, 0x00, 	/* .....**********................. */
	0x07, 0xf8, 0x00, 0x00, 	/* .....********................... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x3f, 0x80, 0x00, 	/* ..........*******............... */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x38, 0x00, 0x00, 	/* ..........***................... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x3c, 	/* ..........................****.. */
	0x00, 0x00, 0x00, 0x3c, 	/* ..........................****.. */
	0x00, 0x00, 0x00, 0x7c, 	/* .........................*****.. */
	0x00, 0x00, 0x00, 0x7c, 	/* .........................*****.. */
	0x00, 0x00, 0x00, 0xf8, 	/* ........................*****... */
	0x00, 0x00, 0x00, 0xf8, 	/* ........................*****... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x7c, 0x00, 0x00, 	/* .........*****.................. */
	0x00, 0x7c, 0x00, 0x00, 	/* .........*****.................. */
	0x00, 0xf8, 0x00, 0x00, 	/* ........*****................... */
	0x00, 0xf8, 0x00, 0x00, 	/* ........*****................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x1f, 0x00, 0x00, 0x00, 	/* ...*****........................ */
	0x1f, 0x00, 0x00, 0x00, 	/* ...*****........................ */
	0x3e, 0x00, 0x00, 0x00, 	/* ..*****......................... */
	0x3e, 0x00, 0x00, 0x00, 	/* ..*****......................... */
	0x3c, 0x00, 0x00, 0x00, 	/* ..****.......................... */
	0x3c, 0x00, 0x00, 0x00, 	/* ..****.......................... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x03, 0xf0, 	/* ....****..............******.... */
	0x0f, 0x00, 0x07, 0xf0, 	/* ....****.............*******.... */
	0x0f, 0x00, 0x0f, 0xf0, 	/* ....****............********.... */
	0x0f, 0x00, 0x1f, 0xf0, 	/* ....****...........*********.... */
	0x0f, 0x00, 0x3f, 0xf0, 	/* ....****..........**********.... */
	0x0f, 0x00, 0x7e, 0xf0, 	/* ....****.........******.****.... */
	0x0f, 0x00, 0xfc, 0xf0, 	/* ....****........******..****.... */
	0x0f, 0x01, 0xf8, 0xf0, 	/* ....****.......******...****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x07, 0xe0, 0xf0, 	/* ....****.....******.....****.... */
	0x0f, 0x0f, 0xc0, 0xf0, 	/* ....****....******......****.... */
	0x0f, 0x1f, 0x80, 0xf0, 	/* ....****...******.......****.... */
	0x0f, 0x3f, 0x00, 0xf0, 	/* ....****..******........****.... */
	0x0f, 0x7e, 0x00, 0xf0, 	/* ....****.******.........****.... */
	0x0f, 0xfc, 0x00, 0xf0, 	/* ....**********..........****.... */
	0x0f, 0xf8, 0x00, 0xf0, 	/* ....*********...........****.... */
	0x0f, 0xf0, 0x00, 0xf0, 	/* ....********............****.... */
	0x0f, 0xe0, 0x00, 0xf0, 	/* ....*******.............****.... */
	0x0f, 0xc0, 0x00, 0xf0, 	/* ....******..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0xc0, 0x00, 	/* ...........*******.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x7f, 0xc0, 0x00, 	/* .........*********.............. */
	0x00, 0xfb, 0xc0, 0x00, 	/* ........*****.****.............. */
	0x01, 0xf3, 0xc0, 0x00, 	/* .......*****..****.............. */
	0x03, 0xe3, 0xc0, 0x00, 	/* ......*****...****.............. */
	0x03, 0xc3, 0xc0, 0x00, 	/* ......****....****.............. */
	0x03, 0x83, 0xc0, 0x00, 	/* ......***.....****.............. */
	0x03, 0x03, 0xc0, 0x00, 	/* ......**......****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xe0, 	/* .......................****..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x7c, 0x00, 0x00, 	/* .........*****.................. */
	0x00, 0xf8, 0x00, 0x00, 	/* ........*****................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xe0, 	/* .......................****..... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x3f, 0xff, 0x80, 	/* ..........***************....... */
	0x00, 0x3f, 0xff, 0x00, 	/* ..........**************........ */
	0x00, 0x3f, 0xff, 0x00, 	/* ..........**************........ */
	0x00, 0x3f, 0xff, 0x80, 	/* ..........***************....... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x01, 0xe0, 	/* .......................****..... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x07, 0x80, 0x01, 0xe0, 	/* .....****..............****..... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x07, 0x80, 0x01, 0xe0, 	/* .....****..............****..... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x3f, 0x80, 0x00, 	/* ..........*******............... */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x38, 0x00, 0x00, 	/* ..........***................... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x03, 0xf0, 	/* ......................******.... */
	0x00, 0x00, 0x07, 0xe0, 	/* .....................******..... */
	0x00, 0x00, 0x0f, 0xc0, 	/* ....................******...... */
	0x00, 0x00, 0x1f, 0x80, 	/* ...................******....... */
	0x00, 0x00, 0x3f, 0x00, 	/* ..................******........ */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x7e, 0x00, 0x00, 	/* .........******................. */
	0x00, 0xfc, 0x00, 0x00, 	/* ........******.................. */
	0x01, 0xf8, 0x00, 0x00, 	/* .......******................... */
	0x03, 0xf0, 0x00, 0x00, 	/* ......******.................... */
	0x07, 0xe0, 0x00, 0x00, 	/* .....******..................... */
	0x0f, 0xc0, 0x00, 0x00, 	/* ....******...................... */
	0x0f, 0xc0, 0x00, 0x00, 	/* ....******...................... */
	0x0f, 0xc0, 0x00, 0x00, 	/* ....******...................... */
	0x0f, 0xc0, 0x00, 0x00, 	/* ....******...................... */
	0x07, 0xe0, 0x00, 0x00, 	/* .....******..................... */
	0x03, 0xf0, 0x00, 0x00, 	/* ......******.................... */
	0x01, 0xf8, 0x00, 0x00, 	/* .......******................... */
	0x00, 0xfc, 0x00, 0x00, 	/* ........******.................. */
	0x00, 0x7e, 0x00, 0x00, 	/* .........******................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x00, 0x3f, 0x00, 	/* ..................******........ */
	0x00, 0x00, 0x1f, 0x80, 	/* ...................******....... */
	0x00, 0x00, 0x0f, 0xc0, 	/* ....................******...... */
	0x00, 0x00, 0x07, 0xe0, 	/* .....................******..... */
	0x00, 0x00, 0x03, 0xf0, 	/* ......................******.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xc0, 0x00, 0x00, 	/* ....******...................... */
	0x07, 0xe0, 0x00, 0x00, 	/* .....******..................... */
	0x03, 0xf0, 0x00, 0x00, 	/* ......******.................... */
	0x01, 0xf8, 0x00, 0x00, 	/* .......******................... */
	0x00, 0xfc, 0x00, 0x00, 	/* ........******.................. */
	0x00, 0x7e, 0x00, 0x00, 	/* .........******................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x00, 0x3f, 0x00, 	/* ..................******........ */
	0x00, 0x00, 0x1f, 0x80, 	/* ...................******....... */
	0x00, 0x00, 0x0f, 0xc0, 	/* ....................******...... */
	0x00, 0x00, 0x07, 0xe0, 	/* .....................******..... */
	0x00, 0x00, 0x03, 0xf0, 	/* ......................******.... */
	0x00, 0x00, 0x03, 0xf0, 	/* ......................******.... */
	0x00, 0x00, 0x03, 0xf0, 	/* ......................******.... */
	0x00, 0x00, 0x03, 0xf0, 	/* ......................******.... */
	0x00, 0x00, 0x07, 0xe0, 	/* .....................******..... */
	0x00, 0x00, 0x0f, 0xc0, 	/* ....................******...... */
	0x00, 0x00, 0x1f, 0x80, 	/* ...................******....... */
	0x00, 0x00, 0x3f, 0x00, 	/* ..................******........ */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x7e, 0x00, 0x00, 	/* .........******................. */
	0x00, 0xfc, 0x00, 0x00, 	/* ........******.................. */
	0x01, 0xf8, 0x00, 0x00, 	/* .......******................... */
	0x03, 0xf0, 0x00, 0x00, 	/* ......******.................... */
	0x07, 0xe0, 0x00, 0x00, 	/* .....******..................... */
	0x0f, 0xc0, 0x00, 0x00, 	/* ....******...................... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xe0, 	/* .......................****..... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x07, 0x80, 	/* .....................****....... */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x1e, 0x00, 	/* ...................****......... */
	0x00, 0x00, 0x3c, 0x00, 	/* ..................****.......... */
	0x00, 0x00, 0x78, 0x00, 	/* .................****........... */
	0x00, 0x00, 0x78, 0x00, 	/* .................****........... */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x01, 0xe0, 0x00, 	/* ...............****............. */
	0x00, 0x01, 0xe0, 0x00, 	/* ...............****............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x03, 0xff, 0xf0, 	/* ....****......**************.... */
	0x0f, 0x03, 0xff, 0xf0, 	/* ....****......**************.... */
	0x0f, 0x03, 0xff, 0xf0, 	/* ....****......**************.... */
	0x0f, 0x03, 0xff, 0xf0, 	/* ....****......**************.... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xc0, 	/* .....*********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0xc0, 	/* .......*******************...... */
	0x00, 0x7f, 0xff, 0xc0, 	/* .........*****************...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xe0, 	/* ....****...............****..... */
	0x0f, 0x00, 0x03, 0xc0, 	/* ....****..............****...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0x00, 0x03, 0xc0, 	/* ....****..............****...... */
	0x0f, 0x00, 0x01, 0xe0, 	/* ....****...............****..... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0xff, 0xf0, 	/* ....****........************.... */
	0x0f, 0x00, 0xff, 0xf0, 	/* ....****........************.... */
	0x0f, 0x00, 0xff, 0xf0, 	/* ....****........************.... */
	0x0f, 0x00, 0xff, 0xf0, 	/* ....****........************.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x3f, 0xff, 0x80, 0x00, 	/* ..***************............... */
	0x3f, 0xff, 0x00, 0x00, 	/* ..**************................ */
	0x3f, 0xfe, 0x00, 0x00, 	/* ..*************................. */
	0x3f, 0xf8, 0x00, 0x00, 	/* ..***********................... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x07, 0xc0, 	/* ....****.............*****...... */
	0x0f, 0x00, 0x0f, 0x80, 	/* ....****............*****....... */
	0x0f, 0x00, 0x1f, 0x00, 	/* ....****...........*****........ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0x00, 0x1f, 0x00, 	/* ....****...........*****........ */
	0x0f, 0x00, 0x0f, 0x80, 	/* ....****............*****....... */
	0x0f, 0x00, 0x07, 0xc0, 	/* ....****.............*****...... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0xc0, 0x03, 0xf0, 	/* ....******............******.... */
	0x0f, 0xe0, 0x07, 0xf0, 	/* ....*******..........*******.... */
	0x0f, 0xf0, 0x0f, 0xf0, 	/* ....********........********.... */
	0x0f, 0xf8, 0x1f, 0xf0, 	/* ....*********......*********.... */
	0x0f, 0xfc, 0x3f, 0xf0, 	/* ....**********....**********.... */
	0x0f, 0x7e, 0x7e, 0xf0, 	/* ....****.******..******.****.... */
	0x0f, 0x3f, 0xfc, 0xf0, 	/* ....****..************..****.... */
	0x0f, 0x1f, 0xf8, 0xf0, 	/* ....****...**********...****.... */
	0x0f, 0x0f, 0xf0, 0xf0, 	/* ....****....********....****.... */
	0x0f, 0x07, 0xe0, 0xf0, 	/* ....****.....******.....****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x01, 0x80, 0xf0, 	/* ....****.......**.......****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0xc0, 0x00, 0xf0, 	/* ....******..............****.... */
	0x0f, 0xc0, 0x00, 0xf0, 	/* ....******..............****.... */
	0x0f, 0xe0, 0x00, 0xf0, 	/* ....*******.............****.... */
	0x0f, 0xe0, 0x00, 0xf0, 	/* ....*******.............****.... */
	0x0f, 0xf0, 0x00, 0xf0, 	/* ....********............****.... */
	0x0f, 0xf0, 0x00, 0xf0, 	/* ....********............****.... */
	0x0f, 0xf8, 0x00, 0xf0, 	/* ....*********...........****.... */
	0x0f, 0xf8, 0x00, 0xf0, 	/* ....*********...........****.... */
	0x0f, 0x7c, 0x00, 0xf0, 	/* ....****.*****..........****.... */
	0x0f, 0x7c, 0x00, 0xf0, 	/* ....****.*****..........****.... */
	0x0f, 0x3e, 0x00, 0xf0, 	/* ....****..*****.........****.... */
	0x0f, 0x3e, 0x00, 0xf0, 	/* ....****..*****.........****.... */
	0x0f, 0x1f, 0x00, 0xf0, 	/* ....****...*****........****.... */
	0x0f, 0x1f, 0x00, 0xf0, 	/* ....****...*****........****.... */
	0x0f, 0x0f, 0x80, 0xf0, 	/* ....****....*****.......****.... */
	0x0f, 0x0f, 0x80, 0xf0, 	/* ....****....*****.......****.... */
	0x0f, 0x07, 0xc0, 0xf0, 	/* ....****.....*****......****.... */
	0x0f, 0x07, 0xc0, 0xf0, 	/* ....****.....*****......****.... */
	0x0f, 0x03, 0xe0, 0xf0, 	/* ....****......*****.....****.... */
	0x0f, 0x03, 0xe0, 0xf0, 	/* ....****......*****.....****.... */
	0x0f, 0x01, 0xf0, 0xf0, 	/* ....****.......*****....****.... */
	0x0f, 0x01, 0xf0, 0xf0, 	/* ....****.......*****....****.... */
	0x0f, 0x00, 0xf8, 0xf0, 	/* ....****........*****...****.... */
	0x0f, 0x00, 0xf8, 0xf0, 	/* ....****........*****...****.... */
	0x0f, 0x00, 0x7c, 0xf0, 	/* ....****.........*****..****.... */
	0x0f, 0x00, 0x7c, 0xf0, 	/* ....****.........*****..****.... */
	0x0f, 0x00, 0x3e, 0xf0, 	/* ....****..........*****.****.... */
	0x0f, 0x00, 0x3e, 0xf0, 	/* ....****..........*****.****.... */
	0x0f, 0x00, 0x1f, 0xf0, 	/* ....****...........*********.... */
	0x0f, 0x00, 0x1f, 0xf0, 	/* ....****...........*********.... */
	0x0f, 0x00, 0x0f, 0xf0, 	/* ....****............********.... */
	0x0f, 0x00, 0x0f, 0xf0, 	/* ....****............********.... */
	0x0f, 0x00, 0x07, 0xf0, 	/* ....****.............*******.... */
	0x0f, 0x00, 0x07, 0xf0, 	/* ....****.............*******.... */
	0x0f, 0x00, 0x03, 0xf0, 	/* ....****..............******.... */
	0x0f, 0x00, 0x03, 0xf0, 	/* ....****..............******.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xe0, 0xf0, 	/* ....****......*****.....****.... */
	0x0f, 0x03, 0xe0, 0xf0, 	/* ....****......*****.....****.... */
	0x0f, 0x01, 0xf0, 0xf0, 	/* ....****.......*****....****.... */
	0x0f, 0x01, 0xf0, 0xf0, 	/* ....****.......*****....****.... */
	0x0f, 0x80, 0xf9, 0xf0, 	/* ....*****.......*****..*****.... */
	0x07, 0xc0, 0xfb, 0xe0, 	/* .....*****......*****.*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x07, 0xc0, 	/* ....****.............*****...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0x00, 0x07, 0xc0, 	/* ....****.............*****...... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xfe, 0x00, 	/* .....******************......... */
	0x03, 0xff, 0xff, 0x80, 	/* ......*******************....... */
	0x01, 0xff, 0xff, 0xc0, 	/* .......*******************...... */
	0x00, 0x7f, 0xff, 0xe0, 	/* .........******************..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0xc0, 0x03, 0xf0, 	/* ....******............******.... */
	0x07, 0xe0, 0x07, 0xe0, 	/* .....******..........******..... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x01, 0x80, 0xf0, 	/* ....****.......**.......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x07, 0xe0, 0xf0, 	/* ....****.....******.....****.... */
	0x0f, 0x0f, 0xf0, 0xf0, 	/* ....****....********....****.... */
	0x0f, 0x1f, 0xf8, 0xf0, 	/* ....****...**********...****.... */
	0x0f, 0x3f, 0xfc, 0xf0, 	/* ....****..************..****.... */
	0x0f, 0x7e, 0x7e, 0xf0, 	/* ....****.******..******.****.... */
	0x0f, 0xfc, 0x3f, 0xf0, 	/* ....**********....**********.... */
	0x0f, 0xf8, 0x1f, 0xf0, 	/* ....*********......*********.... */
	0x0f, 0xf0, 0x0f, 0xf0, 	/* ....********........********.... */
	0x0f, 0xe0, 0x07, 0xf0, 	/* ....*******..........*******.... */
	0x0f, 0xc0, 0x03, 0xf0, 	/* ....******............******.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0xc0, 0x03, 0xf0, 	/* ....******............******.... */
	0x07, 0xe0, 0x07, 0xe0, 	/* .....******..........******..... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x07, 0xe0, 0x07, 0xe0, 	/* .....******..........******..... */
	0x0f, 0xc0, 0x03, 0xf0, 	/* ....******............******.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x7c, 0x00, 0x00, 	/* .........*****.................. */
	0x00, 0xf8, 0x00, 0x00, 	/* ........*****................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xff, 0xff, 0xf0, 	/* ........********************.... */
	0x00, 0xff, 0xff, 0xf0, 	/* ........********************.... */
	0x00, 0xff, 0xff, 0xf0, 	/* ........********************.... */
	0x00, 0xff, 0xff, 0xf0, 	/* ........********************.... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xff, 0xff, 0xf0, 	/* ........********************.... */
	0x00, 0xff, 0xff, 0xf0, 	/* ........********************.... */
	0x00, 0xff, 0xff, 0xf0, 	/* ........********************.... */
	0x00, 0xff, 0xff, 0xf0, 	/* ........********************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x3c, 0x00, 0x00, 0x00, 	/* ..****.......................... */
	0x3c, 0x00, 0x00, 0x00, 	/* ..****.......................... */
	0x3e, 0x00, 0x00, 0x00, 	/* ..*****......................... */
	0x3e, 0x00, 0x00, 0x00, 	/* ..*****......................... */
	0x1f, 0x00, 0x00, 0x00, 	/* ...*****........................ */
	0x1f, 0x00, 0x00, 0x00, 	/* ...*****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x00, 0xf8, 0x00, 0x00, 	/* ........*****................... */
	0x00, 0xf8, 0x00, 0x00, 	/* ........*****................... */
	0x00, 0x7c, 0x00, 0x00, 	/* .........*****.................. */
	0x00, 0x7c, 0x00, 0x00, 	/* .........*****.................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf8, 	/* ........................*****... */
	0x00, 0x00, 0x00, 0xf8, 	/* ........................*****... */
	0x00, 0x00, 0x00, 0x7c, 	/* .........................*****.. */
	0x00, 0x00, 0x00, 0x7c, 	/* .........................*****.. */
	0x00, 0x00, 0x00, 0x3c, 	/* ..........................****.. */
	0x00, 0x00, 0x00, 0x3c, 	/* ..........................****.. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x07, 0xe0, 0x07, 0xe0, 	/* .....******..........******..... */
	0x0f, 0xc0, 0x03, 0xf0, 	/* ....******............******.... */
	0x1f, 0x80, 0x01, 0xf8, 	/* ...******..............******... */
	0x3f, 0x00, 0x00, 0xfc, 	/* ..******................******.. */
	0x3e, 0x00, 0x00, 0x7c, 	/* ..*****..................*****.. */
	0x3c, 0x00, 0x00, 0x3c, 	/* ..****....................****.. */
	0x38, 0x00, 0x00, 0x1c, 	/* ..***......................***.. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x3f, 0xff, 0xff, 0xfc, 	/* ..****************************.. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x38, 0x00, 0x00, 	/* ..........***................... */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0x3c, 0x00, 	/* ..................****.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xfe, 0x00, 	/* ......*****************......... */
	0x03, 0xff, 0xff, 0x80, 	/* ......*******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xe0, 	/* ......*********************..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x01, 0xff, 0xc0, 	/* ...............***********...... */
	0x00, 0x07, 0xff, 0xc0, 	/* .............*************...... */
	0x00, 0x0f, 0xff, 0xc0, 	/* ............**************...... */
	0x00, 0x1f, 0xff, 0xc0, 	/* ...........***************...... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x03, 0xff, 0xfc, 0x00, 	/* ......****************.......... */
	0x03, 0xff, 0xfc, 0x00, 	/* ......****************.......... */
	0x03, 0xff, 0xfc, 0x00, 	/* ......****************.......... */
	0x03, 0xff, 0xfc, 0x00, 	/* ......****************.......... */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xc0, 	/* .....*********************...... */
	0x03, 0xff, 0xff, 0x80, 	/* ......*******************....... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xff, 0xc0, 	/* .........*****************...... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xe0, 	/* .......................****..... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x03, 0xff, 0x80, 0x00, 	/* ......***********............... */
	0x03, 0xff, 0x00, 0x00, 	/* ......**********................ */
	0x03, 0xfe, 0x00, 0x00, 	/* ......*********................. */
	0x03, 0xf8, 0x00, 0x00, 	/* ......*******................... */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x07, 0x00, 	/* ......****...........***........ */
	0x03, 0xc0, 0x0f, 0x00, 	/* ......****..........****........ */
	0x03, 0xc0, 0x1f, 0x00, 	/* ......****.........*****........ */
	0x03, 0xc0, 0x3e, 0x00, 	/* ......****........*****......... */
	0x03, 0xc0, 0x7c, 0x00, 	/* ......****.......*****.......... */
	0x03, 0xc0, 0xf8, 0x00, 	/* ......****......*****........... */
	0x03, 0xc1, 0xf0, 0x00, 	/* ......****.....*****............ */
	0x03, 0xc3, 0xe0, 0x00, 	/* ......****....*****............. */
	0x03, 0xc7, 0xc0, 0x00, 	/* ......****...*****.............. */
	0x03, 0xcf, 0x80, 0x00, 	/* ......****..*****............... */
	0x03, 0xff, 0x00, 0x00, 	/* ......**********................ */
	0x03, 0xff, 0x00, 0x00, 	/* ......**********................ */
	0x03, 0xff, 0x00, 0x00, 	/* ......**********................ */
	0x03, 0xff, 0x00, 0x00, 	/* ......**********................ */
	0x03, 0xcf, 0x80, 0x00, 	/* ......****..*****............... */
	0x03, 0xc7, 0xc0, 0x00, 	/* ......****...*****.............. */
	0x03, 0xc3, 0xe0, 0x00, 	/* ......****....*****............. */
	0x03, 0xc1, 0xf0, 0x00, 	/* ......****.....*****............ */
	0x03, 0xc0, 0xf8, 0x00, 	/* ......****......*****........... */
	0x03, 0xc0, 0x7c, 0x00, 	/* ......****.......*****.......... */
	0x03, 0xc0, 0x3e, 0x00, 	/* ......****........*****......... */
	0x03, 0xc0, 0x1f, 0x00, 	/* ......****.........*****........ */
	0x03, 0xc0, 0x0f, 0x80, 	/* ......****..........*****....... */
	0x03, 0xc0, 0x07, 0xc0, 	/* ......****...........*****...... */
	0x03, 0xc0, 0x03, 0xe0, 	/* ......****............*****..... */
	0x03, 0xc0, 0x01, 0xf0, 	/* ......****.............*****.... */
	0x03, 0xc0, 0x00, 0xf0, 	/* ......****..............****.... */
	0x03, 0xc0, 0x00, 0x70, 	/* ......****...............***.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x1f, 0xff, 0xc0, 	/* ...........***************...... */
	0x00, 0x0f, 0xff, 0xc0, 	/* ............**************...... */
	0x00, 0x07, 0xff, 0xc0, 	/* .............*************...... */
	0x00, 0x01, 0xff, 0xc0, 	/* ...............***********...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xfc, 0x3e, 0x00, 	/* ....**********....*****......... */
	0x0f, 0xfc, 0x3f, 0x80, 	/* ....**********....*******....... */
	0x0f, 0xfc, 0x3f, 0xc0, 	/* ....**********....********...... */
	0x0f, 0xfc, 0x3f, 0xe0, 	/* ....**********....*********..... */
	0x0f, 0x03, 0xc3, 0xe0, 	/* ....****......****....*****..... */
	0x0f, 0x03, 0xc1, 0xf0, 	/* ....****......****.....*****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xfe, 0x00, 	/* .....******************......... */
	0x03, 0xff, 0xff, 0x80, 	/* ......*******************....... */
	0x01, 0xff, 0xff, 0xc0, 	/* .......*******************...... */
	0x00, 0x7f, 0xff, 0xe0, 	/* .........******************..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x03, 0xff, 0xfc, 0x00, 	/* ......****************.......... */
	0x03, 0xff, 0xfc, 0x00, 	/* ......****************.......... */
	0x03, 0xff, 0xfc, 0x00, 	/* ......****************.......... */
	0x03, 0xff, 0xfc, 0x00, 	/* ......****************.......... */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x1f, 0xff, 0xc0, 	/* ...........***************...... */
	0x00, 0x0f, 0xff, 0xc0, 	/* ............**************...... */
	0x00, 0x07, 0xff, 0xc0, 	/* .............*************...... */
	0x00, 0x01, 0xff, 0xc0, 	/* ...............***********...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0xc0, 0x00, 0xf0, 	/* ....******..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0xff, 0xff, 0xf0, 	/* ........********************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x01, 0xf0, 0x0f, 0x80, 	/* .......*****........*****....... */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x00, 0x7c, 0x3e, 0x00, 	/* .........*****....*****......... */
	0x00, 0x3e, 0x7c, 0x00, 	/* ..........*****..*****.......... */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x83, 0xc0, 0xf0, 	/* ....*****.....****......****.... */
	0x07, 0xc3, 0xc0, 0xf0, 	/* .....*****....****......****.... */
	0x07, 0xfc, 0x3f, 0xf0, 	/* .....*********....**********.... */
	0x03, 0xfc, 0x3f, 0xf0, 	/* ......********....**********.... */
	0x01, 0xfc, 0x3f, 0xf0, 	/* .......*******....**********.... */
	0x00, 0x7c, 0x3f, 0xf0, 	/* .........*****....**********.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x01, 0xf0, 0x0f, 0x80, 	/* .......*****........*****....... */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x00, 0x7c, 0x3e, 0x00, 	/* .........*****....*****......... */
	0x00, 0x3e, 0x7c, 0x00, 	/* ..........*****..*****.......... */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3e, 0x7c, 0x00, 	/* ..........*****..*****.......... */
	0x00, 0x7c, 0x3e, 0x00, 	/* .........*****....*****......... */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x01, 0xf0, 0x0f, 0x80, 	/* .......*****........*****....... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x7c, 0x00, 0x00, 	/* .........*****.................. */
	0x00, 0xf8, 0x00, 0x00, 	/* ........*****................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x7f, 0xf0, 	/* .................***********.... */
	0x00, 0x01, 0xff, 0xf0, 	/* ...............*************.... */
	0x00, 0x03, 0xff, 0xf0, 	/* ..............**************.... */
	0x00, 0x07, 0xff, 0xf0, 	/* .............***************.... */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x7e, 0x00, 0x00, 	/* .........******................. */
	0x0f, 0xfc, 0x00, 0x00, 	/* ....**********.................. */
	0x0f, 0xf8, 0x00, 0x00, 	/* ....*********................... */
	0x0f, 0xf0, 0x00, 0x00, 	/* ....********.................... */
	0x0f, 0xf0, 0x00, 0x00, 	/* ....********.................... */
	0x0f, 0xf0, 0x00, 0x00, 	/* ....********.................... */
	0x0f, 0xf0, 0x00, 0x00, 	/* ....********.................... */
	0x0f, 0xf8, 0x00, 0x00, 	/* ....*********................... */
	0x0f, 0xfc, 0x00, 0x00, 	/* ....**********.................. */
	0x00, 0x7e, 0x00, 0x00, 	/* .........******................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x07, 0xff, 0xf0, 	/* .............***************.... */
	0x00, 0x03, 0xff, 0xf0, 	/* ..............**************.... */
	0x00, 0x01, 0xff, 0xf0, 	/* ...............*************.... */
	0x00, 0x00, 0x7f, 0xf0, 	/* .................***********.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xfe, 0x00, 0x00, 	/* ....***********................. */
	0x0f, 0xff, 0x80, 0x00, 	/* ....*************............... */
	0x0f, 0xff, 0xc0, 0x00, 	/* ....**************.............. */
	0x0f, 0xff, 0xe0, 0x00, 	/* ....***************............. */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x00, 0x3f, 0xf0, 	/* ..................**********.... */
	0x00, 0x00, 0x1f, 0xf0, 	/* ...................*********.... */
	0x00, 0x00, 0x0f, 0xf0, 	/* ....................********.... */
	0x00, 0x00, 0x0f, 0xf0, 	/* ....................********.... */
	0x00, 0x00, 0x0f, 0xf0, 	/* ....................********.... */
	0x00, 0x00, 0x0f, 0xf0, 	/* ....................********.... */
	0x00, 0x00, 0x1f, 0xf0, 	/* ...................*********.... */
	0x00, 0x00, 0x3f, 0xf0, 	/* ..................**********.... */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x0f, 0xff, 0xe0, 0x00, 	/* ....***************............. */
	0x0f, 0xff, 0xc0, 0x00, 	/* ....**************.............. */
	0x0f, 0xff, 0x80, 0x00, 	/* ....*************............... */
	0x0f, 0xfe, 0x00, 0x00, 	/* ....***********................. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x78, 0x00, 0xf0, 	/* .........****...........****.... */
	0x01, 0xfe, 0x00, 0xf0, 	/* .......********.........****.... */
	0x03, 0xff, 0x00, 0xf0, 	/* ......**********........****.... */
	0x07, 0xff, 0x80, 0xf0, 	/* .....************.......****.... */
	0x0f, 0xcf, 0xc1, 0xf0, 	/* ....******..******.....*****.... */
	0x0f, 0x87, 0xe3, 0xf0, 	/* ....*****....******...******.... */
	0x0f, 0x03, 0xff, 0xe0, 	/* ....****......*************..... */
	0x0f, 0x01, 0xff, 0xc0, 	/* ....****.......***********...... */
	0x0f, 0x00, 0xff, 0x80, 	/* ....****........*********....... */
	0x0f, 0x00, 0x3e, 0x00, 	/* ....****..........*****......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0xf0, 0x00, 	/* .....*****......****............ */
	0x0f, 0x80, 0xf0, 0x00, 	/* ....*****.......****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x80, 0xf0, 0x00, 	/* ....*****.......****............ */
	0x07, 0xc0, 0xf0, 0x00, 	/* .....*****......****............ */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x07, 0xf8, 0x00, 	/* .............********........... */
	0x00, 0x1f, 0xfe, 0x00, 	/* ...........************......... */
	0x00, 0x3f, 0xff, 0x00, 	/* ..........**************........ */
	0x00, 0x7f, 0xff, 0x80, 	/* .........****************....... */
	0x00, 0x7c, 0x0f, 0x80, 	/* .........*****......*****....... */
	0x00, 0xf8, 0x07, 0xc0, 	/* ........*****........*****...... */
	0x00, 0xf0, 0x03, 0xc0, 	/* ........****..........****...... */
	0x00, 0xf0, 0x03, 0xc0, 	/* ........****..........****...... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x0f, 0xff, 0xff, 0x00, 	/* ....********************........ */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x01, 0xe0, 0x00, 0x00, 	/* .......****..................... */
	0x01, 0xe0, 0x00, 0x00, 	/* .......****..................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x07, 0x80, 0x01, 0xe0, 	/* .....****..............****..... */
	0x07, 0x80, 0x01, 0xe0, 	/* .....****..............****..... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x01, 0xe0, 0x07, 0x80, 	/* .......****..........****....... */
	0x01, 0xe0, 0x07, 0x80, 	/* .......****..........****....... */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x78, 0x1e, 0x00, 	/* .........****......****......... */
	0x00, 0x78, 0x1e, 0x00, 	/* .........****......****......... */
	0x00, 0x3c, 0x3c, 0x00, 	/* ..........****....****.......... */
	0x00, 0x3c, 0x3c, 0x00, 	/* ..........****....****.......... */
	0x00, 0x1e, 0x78, 0x00, 	/* ...........****..****........... */
	0x00, 0x1e, 0x78, 0x00, 	/* ...........****..****........... */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x1f, 0xf0, 0x00, 	/* ...........*********............ */
	0x00, 0x7f, 0xfc, 0x00, 	/* .........*************.......... */
	0x00, 0xff, 0xfe, 0x00, 	/* ........***************......... */
	0x01, 0xff, 0xfe, 0x00, 	/* .......****************......... */
	0x01, 0xf0, 0x3f, 0x00, 	/* .......*****......******........ */
	0x03, 0xe0, 0x1f, 0x00, 	/* ......*****........*****........ */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xe0, 0x00, 0x00, 	/* ......*****..................... */
	0x01, 0xf0, 0x00, 0x00, 	/* .......*****.................... */
	0x01, 0xf8, 0x00, 0x00, 	/* .......******................... */
	0x00, 0xfc, 0x00, 0x00, 	/* ........******.................. */
	0x00, 0x7f, 0xf8, 0x00, 	/* .........************........... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x01, 0xf0, 0x0f, 0x80, 	/* .......*****........*****....... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x01, 0xf0, 0x0f, 0x80, 	/* .......*****........*****....... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x1f, 0xfe, 0x00, 	/* ...........************......... */
	0x00, 0x00, 0x3f, 0x00, 	/* ..................******........ */
	0x00, 0x00, 0x1f, 0x80, 	/* ...................******....... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0xf8, 0x07, 0xc0, 	/* ........*****........*****...... */
	0x00, 0xfc, 0x0f, 0x80, 	/* ........******......*****....... */
	0x00, 0x7f, 0xff, 0x80, 	/* .........****************....... */
	0x00, 0x7f, 0xff, 0x00, 	/* .........***************........ */
	0x00, 0x3f, 0xfe, 0x00, 	/* ..........*************......... */
	0x00, 0x0f, 0xf8, 0x00, 	/* ............*********........... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x03, 0xfc, 0xf0, 	/* ....****......********..****.... */
	0x0f, 0x0f, 0xfc, 0xf0, 	/* ....****....**********..****.... */
	0x0f, 0x1f, 0xfc, 0xf0, 	/* ....****...***********..****.... */
	0x0f, 0x1f, 0xfc, 0xf0, 	/* ....****...***********..****.... */
	0x0f, 0x3e, 0x00, 0xf0, 	/* ....****..*****.........****.... */
	0x0f, 0x3c, 0x00, 0xf0, 	/* ....****..****..........****.... */
	0x0f, 0x3c, 0x00, 0xf0, 	/* ....****..****..........****.... */
	0x0f, 0x3c, 0x00, 0xf0, 	/* ....****..****..........****.... */
	0x0f, 0x3c, 0x00, 0xf0, 	/* ....****..****..........****.... */
	0x0f, 0x3c, 0x00, 0xf0, 	/* ....****..****..........****.... */
	0x0f, 0x3c, 0x00, 0xf0, 	/* ....****..****..........****.... */
	0x0f, 0x3e, 0x00, 0xf0, 	/* ....****..*****.........****.... */
	0x0f, 0x1f, 0xfc, 0xf0, 	/* ....****...***********..****.... */
	0x0f, 0x1f, 0xfc, 0xf0, 	/* ....****...***********..****.... */
	0x0f, 0x0f, 0xfc, 0xf0, 	/* ....****....**********..****.... */
	0x0f, 0x03, 0xfc, 0xf0, 	/* ....****......********..****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3f, 0xe0, 0x00, 	/* ..........*********............. */
	0x00, 0x3f, 0xf8, 0x00, 	/* ..........***********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x3f, 0xfe, 0x00, 	/* ..........*************......... */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x0f, 0xff, 0x00, 	/* ............************........ */
	0x00, 0x3f, 0xff, 0x00, 	/* ..........**************........ */
	0x00, 0x7f, 0xff, 0x00, 	/* .........***************........ */
	0x00, 0x7f, 0xff, 0x00, 	/* .........***************........ */
	0x00, 0xf8, 0x0f, 0x00, 	/* ........*****.......****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf8, 0x0f, 0x00, 	/* ........*****.......****........ */
	0x00, 0x7f, 0xff, 0x00, 	/* .........***************........ */
	0x00, 0x7f, 0xff, 0x00, 	/* .........***************........ */
	0x00, 0x3f, 0xff, 0x00, 	/* ..........**************........ */
	0x00, 0x0f, 0xff, 0x00, 	/* ............************........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x0f, 0xc3, 0xf0, 	/* ............******....******.... */
	0x00, 0x1f, 0x87, 0xe0, 	/* ...........******....******..... */
	0x00, 0x3f, 0x0f, 0xc0, 	/* ..........******....******...... */
	0x00, 0x7e, 0x1f, 0x80, 	/* .........******....******....... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x01, 0xf8, 0x7e, 0x00, 	/* .......******....******......... */
	0x03, 0xf0, 0xfc, 0x00, 	/* ......******....******.......... */
	0x07, 0xe1, 0xf8, 0x00, 	/* .....******....******........... */
	0x0f, 0xc3, 0xf0, 0x00, 	/* ....******....******............ */
	0x1f, 0x87, 0xe0, 0x00, 	/* ...******....******............. */
	0x1f, 0x87, 0xe0, 0x00, 	/* ...******....******............. */
	0x0f, 0xc3, 0xf0, 0x00, 	/* ....******....******............ */
	0x07, 0xe1, 0xf8, 0x00, 	/* .....******....******........... */
	0x03, 0xf0, 0xfc, 0x00, 	/* ......******....******.......... */
	0x01, 0xf8, 0x7e, 0x00, 	/* .......******....******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x00, 0x7e, 0x1f, 0x80, 	/* .........******....******....... */
	0x00, 0x3f, 0x0f, 0xc0, 	/* ..........******....******...... */
	0x00, 0x1f, 0x87, 0xe0, 	/* ...........******....******..... */
	0x00, 0x0f, 0xc3, 0xf0, 	/* ............******....******.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x3f, 0xf0, 0xf0, 	/* ....****..**********....****.... */
	0x0f, 0x3f, 0xf8, 0xf0, 	/* ....****..***********...****.... */
	0x0f, 0x3f, 0xfc, 0xf0, 	/* ....****..************..****.... */
	0x0f, 0x3f, 0xfc, 0xf0, 	/* ....****..************..****.... */
	0x0f, 0x3c, 0x3c, 0xf0, 	/* ....****..****....****..****.... */
	0x0f, 0x3c, 0x3c, 0xf0, 	/* ....****..****....****..****.... */
	0x0f, 0x3f, 0xfc, 0xf0, 	/* ....****..************..****.... */
	0x0f, 0x3f, 0xfc, 0xf0, 	/* ....****..************..****.... */
	0x0f, 0x3f, 0xf8, 0xf0, 	/* ....****..***********...****.... */
	0x0f, 0x3f, 0xf0, 0xf0, 	/* ....****..**********....****.... */
	0x0f, 0x3c, 0x78, 0xf0, 	/* ....****..****...****...****.... */
	0x0f, 0x3c, 0x3c, 0xf0, 	/* ....****..****....****..****.... */
	0x0f, 0x3c, 0x3c, 0xf0, 	/* ....****..****....****..****.... */
	0x0f, 0x3c, 0x3c, 0xf0, 	/* ....****..****....****..****.... */
	0x0f, 0x3c, 0x3c, 0xf0, 	/* ....****..****....****..****.... */
	0x0f, 0x3c, 0x3c, 0xf0, 	/* ....****..****....****..****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x7c, 0x3e, 0x00, 	/* .........*****....*****......... */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x00, 0x7c, 0x3e, 0x00, 	/* .........*****....*****......... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0xf8, 0x1e, 0x00, 	/* ........*****......****......... */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x1e, 0x00, 	/* ...................****......... */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x3e, 0x0f, 0x00, 	/* ..........*****.....****........ */
	0x00, 0x7c, 0x0f, 0x00, 	/* .........*****......****........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0xf8, 0x1e, 0x00, 	/* ........*****......****......... */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x03, 0xfe, 0x00, 	/* ..............*********......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfe, 0x00, 	/* ..............*********......... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf8, 0x1e, 0x00, 	/* ........*****......****......... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x07, 0x00, 	/* .....................***........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x3f, 0x00, 	/* ..................******........ */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x80, 0x1f, 0x80, 	/* ....*****..........******....... */
	0x0f, 0xc0, 0x3f, 0xc0, 	/* ....******........********...... */
	0x0f, 0xff, 0xff, 0xfc, 	/* ....**************************.. */
	0x0f, 0xff, 0xff, 0xfc, 	/* ....**************************.. */
	0x0f, 0x7f, 0xf9, 0xfc, 	/* ....****.************..*******.. */
	0x0f, 0x1f, 0xe0, 0x7c, 	/* ....****...********......*****.. */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc3, 0xc0, 0xf0, 	/* .....*****....****......****.... */
	0x0f, 0x83, 0xc0, 0xf0, 	/* ....*****.....****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x03, 0xc0, 0xf0, 	/* ....****......****......****.... */
	0x0f, 0x83, 0xc0, 0xf0, 	/* ....*****.....****......****.... */
	0x07, 0xc3, 0xc0, 0xf0, 	/* .....*****....****......****.... */
	0x07, 0xff, 0xc0, 0xf0, 	/* .....*************......****.... */
	0x03, 0xff, 0xc0, 0xf0, 	/* ......************......****.... */
	0x01, 0xff, 0xc0, 0xf0, 	/* .......***********......****.... */
	0x00, 0x7f, 0xc0, 0xf0, 	/* .........*********......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x3f, 0x80, 0x00, 	/* ..........*******............... */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x38, 0x00, 0x00, 	/* ..........***................... */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0xc0, 0x00, 	/* ...........*******.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3b, 0xc0, 0x00, 	/* ..........***.****.............. */
	0x00, 0x33, 0xc0, 0x00, 	/* ..........**..****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x7c, 0x3e, 0x00, 	/* .........*****....*****......... */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x00, 0x7c, 0x3e, 0x00, 	/* .........*****....*****......... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0xff, 0xff, 0x00, 	/* ........****************........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xc3, 0xf0, 0x00, 	/* ....******....******............ */
	0x07, 0xe1, 0xf8, 0x00, 	/* .....******....******........... */
	0x03, 0xf0, 0xfc, 0x00, 	/* ......******....******.......... */
	0x01, 0xf8, 0x7e, 0x00, 	/* .......******....******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x00, 0x7e, 0x1f, 0x80, 	/* .........******....******....... */
	0x00, 0x3f, 0x0f, 0xc0, 	/* ..........******....******...... */
	0x00, 0x1f, 0x87, 0xe0, 	/* ...........******....******..... */
	0x00, 0x0f, 0xc3, 0xf0, 	/* ............******....******.... */
	0x00, 0x07, 0xe1, 0xf8, 	/* .............******....******... */
	0x00, 0x07, 0xe1, 0xf8, 	/* .............******....******... */
	0x00, 0x0f, 0xc3, 0xf0, 	/* ............******....******.... */
	0x00, 0x1f, 0x87, 0xe0, 	/* ...........******....******..... */
	0x00, 0x3f, 0x0f, 0xc0, 	/* ..........******....******...... */
	0x00, 0x7e, 0x1f, 0x80, 	/* .........******....******....... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x01, 0xf8, 0x7e, 0x00, 	/* .......******....******......... */
	0x03, 0xf0, 0xfc, 0x00, 	/* ......******....******.......... */
	0x07, 0xe1, 0xf8, 0x00, 	/* .....******....******........... */
	0x0f, 0xc3, 0xf0, 0x00, 	/* ....******....******............ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0xc0, 0x00, 0x00, 	/* ....******...................... */
	0x1f, 0xc0, 0x00, 0x00, 	/* ...*******...................... */
	0x3f, 0xc0, 0x00, 0x00, 	/* ..********...................... */
	0x3f, 0xc0, 0x00, 0x00, 	/* ..********...................... */
	0x3b, 0xc0, 0x00, 0x00, 	/* ..***.****...................... */
	0x33, 0xc0, 0x00, 0x00, 	/* ..**..****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x3c, 	/* ......****................****.. */
	0x03, 0xc0, 0x00, 0x7c, 	/* ......****...............*****.. */
	0x03, 0xc0, 0x00, 0xfc, 	/* ......****..............******.. */
	0x03, 0xc0, 0x01, 0xfc, 	/* ......****.............*******.. */
	0x03, 0xc0, 0x03, 0xf8, 	/* ......****............*******... */
	0x03, 0xc0, 0x07, 0xf0, 	/* ......****...........*******.... */
	0x3f, 0xfc, 0x0f, 0xe0, 	/* ..************......*******..... */
	0x3f, 0xfc, 0x1f, 0xc0, 	/* ..************.....*******...... */
	0x3f, 0xfc, 0x3f, 0x80, 	/* ..************....*******....... */
	0x3f, 0xfc, 0x7f, 0x00, 	/* ..************...*******........ */
	0x00, 0x00, 0xfe, 0x00, 	/* ................*******......... */
	0x00, 0x01, 0xfc, 0x00, 	/* ...............*******.......... */
	0x00, 0x03, 0xf8, 0x00, 	/* ..............*******........... */
	0x00, 0x07, 0xf0, 0x00, 	/* .............*******............ */
	0x00, 0x0f, 0xe0, 0x00, 	/* ............*******............. */
	0x00, 0x1f, 0xc0, 0x00, 	/* ...........*******.............. */
	0x00, 0x3f, 0x80, 0x00, 	/* ..........*******............... */
	0x00, 0x7f, 0x00, 0x00, 	/* .........*******................ */
	0x00, 0xfe, 0x00, 0x00, 	/* ........*******................. */
	0x01, 0xfc, 0x00, 0x00, 	/* .......*******.................. */
	0x03, 0xfb, 0xc0, 0x00, 	/* ......*******.****.............. */
	0x07, 0xf3, 0xc0, 0x00, 	/* .....*******..****.............. */
	0x0f, 0xe3, 0xc0, 0x00, 	/* ....*******...****.............. */
	0x1f, 0xc3, 0xc0, 0x00, 	/* ...*******....****.............. */
	0x3f, 0x83, 0xc3, 0xc0, 	/* ..*******.....****....****...... */
	0x3f, 0x03, 0xc3, 0xc0, 	/* ..******......****....****...... */
	0x3e, 0x03, 0xc3, 0xc0, 	/* ..*****.......****....****...... */
	0x3c, 0x03, 0xc3, 0xc0, 	/* ..****........****....****...... */
	0x00, 0x03, 0xc3, 0xc0, 	/* ..............****....****...... */
	0x00, 0x03, 0xc3, 0xc0, 	/* ..............****....****...... */
	0x00, 0x03, 0xc3, 0xc0, 	/* ..............****....****...... */
	0x00, 0x03, 0xc3, 0xc0, 	/* ..............****....****...... */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0xc0, 0x00, 0x00, 	/* ....******...................... */
	0x1f, 0xc0, 0x00, 0x00, 	/* ...*******...................... */
	0x3f, 0xc0, 0x00, 0x00, 	/* ..********...................... */
	0x3f, 0xc0, 0x00, 0x00, 	/* ..********...................... */
	0x3b, 0xc0, 0x00, 0x00, 	/* ..***.****...................... */
	0x33, 0xc0, 0x00, 0x00, 	/* ..**..****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x03, 0xc0, 0x00, 0x3c, 	/* ......****................****.. */
	0x03, 0xc0, 0x00, 0x7c, 	/* ......****...............*****.. */
	0x03, 0xc0, 0x00, 0xfc, 	/* ......****..............******.. */
	0x03, 0xc0, 0x01, 0xfc, 	/* ......****.............*******.. */
	0x03, 0xc0, 0x03, 0xf8, 	/* ......****............*******... */
	0x03, 0xc0, 0x07, 0xf0, 	/* ......****...........*******.... */
	0x3f, 0xfc, 0x0f, 0xe0, 	/* ..************......*******..... */
	0x3f, 0xfc, 0x1f, 0xc0, 	/* ..************.....*******...... */
	0x3f, 0xfc, 0x3f, 0x80, 	/* ..************....*******....... */
	0x3f, 0xfc, 0x7f, 0x00, 	/* ..************...*******........ */
	0x00, 0x00, 0xfe, 0x00, 	/* ................*******......... */
	0x00, 0x01, 0xfc, 0x00, 	/* ...............*******.......... */
	0x00, 0x03, 0xf8, 0x00, 	/* ..............*******........... */
	0x00, 0x07, 0xf0, 0x00, 	/* .............*******............ */
	0x00, 0x0f, 0xe0, 0x00, 	/* ............*******............. */
	0x00, 0x1f, 0xc0, 0x00, 	/* ...........*******.............. */
	0x00, 0x3f, 0x80, 0x00, 	/* ..........*******............... */
	0x00, 0x7f, 0x00, 0x00, 	/* .........*******................ */
	0x00, 0xfe, 0x1f, 0x80, 	/* ........*******....******....... */
	0x01, 0xfc, 0x7f, 0xe0, 	/* .......*******...**********..... */
	0x03, 0xf8, 0xff, 0xf0, 	/* ......*******...************.... */
	0x07, 0xf1, 0xff, 0xf8, 	/* .....*******...**************... */
	0x0f, 0xe3, 0xe0, 0x78, 	/* ....*******...*****......****... */
	0x1f, 0xc3, 0xc0, 0x3c, 	/* ...*******....****........****.. */
	0x3f, 0x80, 0x00, 0x3c, 	/* ..*******.................****.. */
	0x3f, 0x00, 0x00, 0x3c, 	/* ..******..................****.. */
	0x3e, 0x00, 0x00, 0x3c, 	/* ..*****...................****.. */
	0x3c, 0x00, 0x00, 0x78, 	/* ..****...................****... */
	0x00, 0x00, 0x00, 0xf8, 	/* ........................*****... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x07, 0xc0, 	/* .....................*****...... */
	0x00, 0x00, 0x0f, 0x80, 	/* ....................*****....... */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x3e, 0x00, 	/* ..................*****......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xf8, 0x3c, 	/* ................*****.....****.. */
	0x00, 0x01, 0xf0, 0x3c, 	/* ...............*****......****.. */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x01, 0xf8, 0x00, 0x00, 	/* .......******................... */
	0x07, 0xfe, 0x00, 0x00, 	/* .....**********................. */
	0x0f, 0xff, 0x00, 0x00, 	/* ....************................ */
	0x1f, 0xff, 0x80, 0x00, 	/* ...**************............... */
	0x3e, 0x07, 0x80, 0x00, 	/* ..*****......****............... */
	0x3c, 0x03, 0xc0, 0x00, 	/* ..****........****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xc0, 0x00, 	/* .............*****.............. */
	0x00, 0xff, 0x80, 0x00, 	/* ........*********............... */
	0x00, 0xff, 0x00, 0x00, 	/* ........********................ */
	0x00, 0xff, 0x00, 0x00, 	/* ........********................ */
	0x00, 0xff, 0x80, 0x00, 	/* ........*********............... */
	0x00, 0x07, 0xc0, 0x3c, 	/* .............*****........****.. */
	0x00, 0x03, 0xc0, 0x7c, 	/* ..............****.......*****.. */
	0x00, 0x03, 0xc0, 0xfc, 	/* ..............****......******.. */
	0x00, 0x03, 0xc1, 0xfc, 	/* ..............****.....*******.. */
	0x3c, 0x03, 0xc3, 0xf8, 	/* ..****........****....*******... */
	0x3e, 0x07, 0x87, 0xf0, 	/* ..*****......****....*******.... */
	0x1f, 0xff, 0x8f, 0xe0, 	/* ...**************...*******..... */
	0x0f, 0xff, 0x1f, 0xc0, 	/* ....************...*******...... */
	0x07, 0xfe, 0x3f, 0x80, 	/* .....**********...*******....... */
	0x01, 0xf8, 0x7f, 0x00, 	/* .......******....*******........ */
	0x00, 0x00, 0xfe, 0x00, 	/* ................*******......... */
	0x00, 0x01, 0xfc, 0x00, 	/* ...............*******.......... */
	0x00, 0x03, 0xf8, 0x00, 	/* ..............*******........... */
	0x00, 0x07, 0xf0, 0x00, 	/* .............*******............ */
	0x00, 0x0f, 0xe0, 0x00, 	/* ............*******............. */
	0x00, 0x1f, 0xc0, 0x00, 	/* ...........*******.............. */
	0x00, 0x3f, 0x80, 0x00, 	/* ..........*******............... */
	0x00, 0x7f, 0x00, 0x00, 	/* .........*******................ */
	0x00, 0xfe, 0x00, 0x00, 	/* ........*******................. */
	0x01, 0xfc, 0x00, 0x00, 	/* .......*******.................. */
	0x03, 0xfb, 0xc0, 0x00, 	/* ......*******.****.............. */
	0x07, 0xf3, 0xc0, 0x00, 	/* .....*******..****.............. */
	0x0f, 0xe3, 0xc0, 0x00, 	/* ....*******...****.............. */
	0x1f, 0xc3, 0xc0, 0x00, 	/* ...*******....****.............. */
	0x3f, 0x83, 0xc3, 0xc0, 	/* ..*******.....****....****...... */
	0x3f, 0x03, 0xc3, 0xc0, 	/* ..******......****....****...... */
	0x3e, 0x03, 0xc3, 0xc0, 	/* ..*****.......****....****...... */
	0x3c, 0x03, 0xc3, 0xc0, 	/* ..****........****....****...... */
	0x00, 0x03, 0xc3, 0xc0, 	/* ..............****....****...... */
	0x00, 0x03, 0xc3, 0xc0, 	/* ..............****....****...... */
	0x00, 0x03, 0xc3, 0xc0, 	/* ..............****....****...... */
	0x00, 0x03, 0xc3, 0xc0, 	/* ..............****....****...... */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x03, 0xff, 0xfc, 	/* ..............****************.. */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x03, 0xc0, 	/* ......................****...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0x80, 0x00, 	/* .............****............... */
	0x00, 0x07, 0x80, 0x00, 	/* .............****............... */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x1e, 0x00, 0x00, 	/* ...........****................. */
	0x00, 0x1e, 0x00, 0x00, 	/* ...........****................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x78, 0x00, 0x00, 	/* .........****................... */
	0x00, 0xf0, 0x00, 0x00, 	/* ........****.................... */
	0x01, 0xe0, 0x00, 0x00, 	/* .......****..................... */
	0x03, 0xc0, 0x00, 0x00, 	/* ......****...................... */
	0x07, 0x80, 0x00, 0x00, 	/* .....****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7e, 0x00, 0xf0, 	/* .........******.........****.... */
	0x01, 0xff, 0x80, 0xf0, 	/* .......**********.......****.... */
	0x03, 0xff, 0xc1, 0xf0, 	/* ......************.....*****.... */
	0x07, 0xff, 0xe3, 0xf0, 	/* .....**************...******.... */
	0x0f, 0xc7, 0xff, 0xe0, 	/* ....******...**************..... */
	0x0f, 0x83, 0xff, 0xc0, 	/* ....*****.....************...... */
	0x0f, 0x01, 0xff, 0x80, 	/* ....****.......**********....... */
	0x0f, 0x00, 0x7e, 0x00, 	/* ....****.........******......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3c, 0x3c, 0x00, 	/* ..........****....****.......... */
	0x00, 0x3c, 0x3c, 0x00, 	/* ..........****....****.......... */
	0x00, 0x3c, 0x3c, 0x00, 	/* ..........****....****.......... */
	0x00, 0x3c, 0x3c, 0x00, 	/* ..........****....****.......... */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0xf0, 0x00, 	/* .....*****......****............ */
	0x0f, 0x80, 0xf0, 0x00, 	/* ....*****.......****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xf0, 0x00, 	/* ....****........****............ */
	0x0f, 0x00, 0xff, 0xf0, 	/* ....****........************.... */
	0x0f, 0x00, 0xff, 0xf0, 	/* ....****........************.... */
	0x0f, 0x00, 0xff, 0xf0, 	/* ....****........************.... */
	0x0f, 0x00, 0xff, 0xf0, 	/* ....****........************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x0f, 0xe0, 0x00, 	/* ............*******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x0e, 0x00, 0x00, 	/* ............***................. */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0xff, 0xfc, 0x00, 	/* ....******************.......... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0xff, 0xff, 0x00, 0xf0, 	/* ****************........****.... */
	0xff, 0xff, 0x00, 0xf0, 	/* ****************........****.... */
	0xff, 0xff, 0x00, 0xf0, 	/* ****************........****.... */
	0xff, 0xff, 0x00, 0xf0, 	/* ****************........****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7e, 0x00, 0xf0, 	/* .........******.........****.... */
	0x01, 0xff, 0x80, 0xf0, 	/* .......**********.......****.... */
	0x03, 0xff, 0xc1, 0xf0, 	/* ......************.....*****.... */
	0x07, 0xff, 0xe3, 0xf0, 	/* .....**************...******.... */
	0x0f, 0xc7, 0xff, 0xe0, 	/* ....******...**************..... */
	0x0f, 0x83, 0xff, 0xc0, 	/* ....*****.....************...... */
	0x0f, 0x01, 0xff, 0x80, 	/* ....****.......**********....... */
	0x0f, 0x00, 0x7e, 0x00, 	/* ....****.........******......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0xc0, 0x00, 0xf0, 	/* ....******..............****.... */
	0x0f, 0xc0, 0x00, 0xf0, 	/* ....******..............****.... */
	0x0f, 0xe0, 0x00, 0xf0, 	/* ....*******.............****.... */
	0x0f, 0xe0, 0x00, 0xf0, 	/* ....*******.............****.... */
	0x0f, 0xf0, 0x00, 0xf0, 	/* ....********............****.... */
	0x0f, 0xf0, 0x00, 0xf0, 	/* ....********............****.... */
	0x0f, 0xf8, 0x00, 0xf0, 	/* ....*********...........****.... */
	0x0f, 0xf8, 0x00, 0xf0, 	/* ....*********...........****.... */
	0x0f, 0x7c, 0x00, 0xf0, 	/* ....****.*****..........****.... */
	0x0f, 0x7c, 0x00, 0xf0, 	/* ....****.*****..........****.... */
	0x0f, 0x3e, 0x00, 0xf0, 	/* ....****..*****.........****.... */
	0x0f, 0x3e, 0x00, 0xf0, 	/* ....****..*****.........****.... */
	0x0f, 0x1f, 0x00, 0xf0, 	/* ....****...*****........****.... */
	0x0f, 0x1f, 0x00, 0xf0, 	/* ....****...*****........****.... */
	0x0f, 0x0f, 0x80, 0xf0, 	/* ....****....*****.......****.... */
	0x0f, 0x0f, 0x80, 0xf0, 	/* ....****....*****.......****.... */
	0x0f, 0x07, 0xc0, 0xf0, 	/* ....****.....*****......****.... */
	0x0f, 0x07, 0xc0, 0xf0, 	/* ....****.....*****......****.... */
	0x0f, 0x03, 0xe0, 0xf0, 	/* ....****......*****.....****.... */
	0x0f, 0x03, 0xe0, 0xf0, 	/* ....****......*****.....****.... */
	0x0f, 0x01, 0xf0, 0xf0, 	/* ....****.......*****....****.... */
	0x0f, 0x01, 0xf0, 0xf0, 	/* ....****.......*****....****.... */
	0x0f, 0x00, 0xf8, 0xf0, 	/* ....****........*****...****.... */
	0x0f, 0x00, 0xf8, 0xf0, 	/* ....****........*****...****.... */
	0x0f, 0x00, 0x7c, 0xf0, 	/* ....****.........*****..****.... */
	0x0f, 0x00, 0x7c, 0xf0, 	/* ....****.........*****..****.... */
	0x0f, 0x00, 0x3e, 0xf0, 	/* ....****..........*****.****.... */
	0x0f, 0x00, 0x3e, 0xf0, 	/* ....****..........*****.****.... */
	0x0f, 0x00, 0x1f, 0xf0, 	/* ....****...........*********.... */
	0x0f, 0x00, 0x1f, 0xf0, 	/* ....****...........*********.... */
	0x0f, 0x00, 0x0f, 0xf0, 	/* ....****............********.... */
	0x0f, 0x00, 0x0f, 0xf0, 	/* ....****............********.... */
	0x0f, 0x00, 0x07, 0xf0, 	/* ....****.............*******.... */
	0x0f, 0x00, 0x07, 0xf0, 	/* ....****.............*******.... */
	0x0f, 0x00, 0x03, 0xf0, 	/* ....****..............******.... */
	0x0f, 0x00, 0x03, 0xf0, 	/* ....****..............******.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7e, 0x00, 0xf0, 	/* .........******.........****.... */
	0x01, 0xff, 0x80, 0xf0, 	/* .......**********.......****.... */
	0x03, 0xff, 0xc1, 0xf0, 	/* ......************.....*****.... */
	0x07, 0xff, 0xe3, 0xf0, 	/* .....**************...******.... */
	0x0f, 0xc7, 0xff, 0xe0, 	/* ....******...**************..... */
	0x0f, 0x83, 0xff, 0xc0, 	/* ....*****.....************...... */
	0x0f, 0x01, 0xff, 0x80, 	/* ....****.......**********....... */
	0x0f, 0x00, 0x7e, 0x00, 	/* ....****.........******......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0e, 0x00, 0x00, 0x70, 	/* ....***..................***.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0xc0, 0x03, 0xf0, 	/* ....******............******.... */
	0x07, 0xe0, 0x07, 0xe0, 	/* .....******..........******..... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x07, 0xe0, 0x07, 0xe0, 	/* .....******..........******..... */
	0x0f, 0xc0, 0x03, 0xf0, 	/* ....******............******.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0e, 0x00, 0x00, 0x70, 	/* ....***..................***.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x7f, 0xff, 0xe0, 	/* .........******************..... */
	0x01, 0xff, 0xff, 0xe0, 	/* .......********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x0f, 0xf0, 	/* .....*****..........********.... */
	0x0f, 0x80, 0x0f, 0xf0, 	/* ....*****...........********.... */
	0x0f, 0x00, 0x1f, 0xf0, 	/* ....****...........*********.... */
	0x0f, 0x00, 0x1f, 0xf0, 	/* ....****...........*********.... */
	0x0f, 0x00, 0x3e, 0xf0, 	/* ....****..........*****.****.... */
	0x0f, 0x00, 0x3e, 0xf0, 	/* ....****..........*****.****.... */
	0x0f, 0x00, 0x7c, 0xf0, 	/* ....****.........*****..****.... */
	0x0f, 0x00, 0x7c, 0xf0, 	/* ....****.........*****..****.... */
	0x0f, 0x00, 0xf8, 0xf0, 	/* ....****........*****...****.... */
	0x0f, 0x00, 0xf8, 0xf0, 	/* ....****........*****...****.... */
	0x0f, 0x01, 0xf0, 0xf0, 	/* ....****.......*****....****.... */
	0x0f, 0x01, 0xf0, 0xf0, 	/* ....****.......*****....****.... */
	0x0f, 0x03, 0xe0, 0xf0, 	/* ....****......*****.....****.... */
	0x0f, 0x03, 0xe0, 0xf0, 	/* ....****......*****.....****.... */
	0x0f, 0x07, 0xc0, 0xf0, 	/* ....****.....*****......****.... */
	0x0f, 0x07, 0xc0, 0xf0, 	/* ....****.....*****......****.... */
	0x0f, 0x0f, 0x80, 0xf0, 	/* ....****....*****.......****.... */
	0x0f, 0x0f, 0x80, 0xf0, 	/* ....****....*****.......****.... */
	0x0f, 0x1f, 0x00, 0xf0, 	/* ....****...*****........****.... */
	0x0f, 0x1f, 0x00, 0xf0, 	/* ....****...*****........****.... */
	0x0f, 0x3e, 0x00, 0xf0, 	/* ....****..*****.........****.... */
	0x0f, 0x3e, 0x00, 0xf0, 	/* ....****..*****.........****.... */
	0x0f, 0x7c, 0x00, 0xf0, 	/* ....****.*****..........****.... */
	0x0f, 0x7c, 0x00, 0xf0, 	/* ....****.*****..........****.... */
	0x0f, 0xf8, 0x00, 0xf0, 	/* ....*********...........****.... */
	0x0f, 0xf8, 0x00, 0xf0, 	/* ....*********...........****.... */
	0x0f, 0xf0, 0x00, 0xf0, 	/* ....********............****.... */
	0x0f, 0xf0, 0x00, 0xf0, 	/* ....********............****.... */
	0x0f, 0xe0, 0x00, 0xf0, 	/* ....*******.............****.... */
	0x0f, 0xe0, 0x00, 0xf0, 	/* ....*******.............****.... */
	0x0f, 0xc0, 0x01, 0xf0, 	/* ....******.............*****.... */
	0x0f, 0xc0, 0x03, 0xe0, 	/* ....******............*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x1e, 0x00, 0x00, 0x00, 	/* ...****......................... */
	0x1e, 0x00, 0x00, 0x00, 	/* ...****......................... */
	0x3c, 0x00, 0x00, 0x00, 	/* ..****.......................... */
	0x3c, 0x00, 0x00, 0x00, 	/* ..****.......................... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xf8, 0x00, 	/* ................*****........... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x00, 0xf8, 0x1f, 0x00, 	/* ........*****......*****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x1f, 0x00, 0x00, 	/* ...........*****................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xe0, 0x00, 	/* .........**********............. */
	0x01, 0xff, 0xf8, 0x00, 	/* .......**************........... */
	0x03, 0xff, 0xfc, 0x00, 	/* ......****************.......... */
	0x07, 0xff, 0xfe, 0x00, 	/* .....******************......... */
	0x07, 0xc0, 0x3e, 0x00, 	/* .....*****........*****......... */
	0x0f, 0x80, 0x1f, 0x00, 	/* ....*****..........*****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x0f, 0x00, 	/* ....****............****........ */
	0x0f, 0x00, 0x1f, 0x00, 	/* ....****...........*****........ */
	0x0f, 0x00, 0x1f, 0x00, 	/* ....****...........*****........ */
	0x0f, 0x00, 0x3e, 0x00, 	/* ....****..........*****......... */
	0x0f, 0x00, 0xfe, 0x00, 	/* ....****........*******......... */
	0x0f, 0x0f, 0xfc, 0x00, 	/* ....****....**********.......... */
	0x0f, 0x0f, 0xff, 0x00, 	/* ....****....************........ */
	0x0f, 0x0f, 0xff, 0x80, 	/* ....****....*************....... */
	0x0f, 0x0f, 0xff, 0xc0, 	/* ....****....**************...... */
	0x0f, 0x00, 0x0f, 0xe0, 	/* ....****............*******..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x3c, 0x00, 0xf0, 	/* ....****..****..........****.... */
	0x0f, 0x3c, 0x00, 0xf0, 	/* ....****..****..........****.... */
	0x0f, 0x3e, 0x01, 0xf0, 	/* ....****..*****........*****.... */
	0x0f, 0x3f, 0x03, 0xf0, 	/* ....****..******......******.... */
	0x0f, 0x1f, 0xff, 0xe0, 	/* ....****...****************..... */
	0x0f, 0x1f, 0xff, 0xe0, 	/* ....****...****************..... */
	0x0f, 0x0f, 0xff, 0xc0, 	/* ....****....**************...... */
	0x0f, 0x03, 0xff, 0x00, 	/* ....****......**********........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x38, 0x00, 0x00, 	/* ..........***................... */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0x3c, 0x00, 	/* ..................****.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xfe, 0x00, 	/* ......*****************......... */
	0x03, 0xff, 0xff, 0x80, 	/* ......*******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xe0, 	/* ......*********************..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x07, 0x00, 	/* .....................***........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x3f, 0x00, 	/* ..................******........ */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xfe, 0x00, 	/* ......*****************......... */
	0x03, 0xff, 0xff, 0x80, 	/* ......*******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xe0, 	/* ......*********************..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0x80, 0x01, 0xc0, 	/* ......***..............***...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xfe, 0x00, 	/* ......*****************......... */
	0x03, 0xff, 0xff, 0x80, 	/* ......*******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xe0, 	/* ......*********************..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x78, 0x00, 0xf0, 	/* .........****...........****.... */
	0x01, 0xfe, 0x00, 0xf0, 	/* .......********.........****.... */
	0x03, 0xff, 0x00, 0xf0, 	/* ......**********........****.... */
	0x07, 0xff, 0x80, 0xf0, 	/* .....************.......****.... */
	0x0f, 0xcf, 0xc1, 0xf0, 	/* ....******..******.....*****.... */
	0x0f, 0x87, 0xe3, 0xf0, 	/* ....*****....******...******.... */
	0x0f, 0x03, 0xff, 0xe0, 	/* ....****......*************..... */
	0x0f, 0x01, 0xff, 0xc0, 	/* ....****.......***********...... */
	0x0f, 0x00, 0xff, 0x80, 	/* ....****........*********....... */
	0x0f, 0x00, 0x3e, 0x00, 	/* ....****..........*****......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xfe, 0x00, 	/* ......*****************......... */
	0x03, 0xff, 0xff, 0x80, 	/* ......*******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xe0, 	/* ......*********************..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xfe, 0x00, 	/* ......*****************......... */
	0x03, 0xff, 0xff, 0x80, 	/* ......*******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xe0, 	/* ......*********************..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x01, 0xe0, 0x00, 	/* ...............****............. */
	0x00, 0x07, 0xf8, 0x00, 	/* .............********........... */
	0x00, 0x0f, 0xfc, 0x00, 	/* ............**********.......... */
	0x00, 0x1f, 0xfe, 0x00, 	/* ...........************......... */
	0x00, 0x1e, 0x1e, 0x00, 	/* ...........****....****......... */
	0x00, 0x3c, 0x0f, 0x00, 	/* ..........****......****........ */
	0x00, 0x3c, 0x0f, 0x00, 	/* ..........****......****........ */
	0x00, 0x3c, 0x0f, 0x00, 	/* ..........****......****........ */
	0x00, 0x3c, 0x0f, 0x00, 	/* ..........****......****........ */
	0x00, 0x1e, 0x1e, 0x00, 	/* ...........****....****......... */
	0x00, 0x1f, 0xfe, 0x00, 	/* ...........************......... */
	0x00, 0x0f, 0xfc, 0x00, 	/* ............**********.......... */
	0x00, 0x07, 0xf8, 0x00, 	/* .............********........... */
	0x00, 0x01, 0xe0, 0x00, 	/* ...............****............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xfe, 0x00, 	/* ......*****************......... */
	0x03, 0xff, 0xff, 0x80, 	/* ......*******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xe0, 	/* ......*********************..... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xfc, 0x3f, 0xf0, 	/* ......********....**********.... */
	0x03, 0xfe, 0x7f, 0xf0, 	/* ......*********..***********.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x00, 0x0f, 0xf0, 0xf0, 	/* ............********....****.... */
	0x00, 0x07, 0xe0, 0xf0, 	/* .............******.....****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x03, 0xc0, 0xf0, 	/* ..............****......****.... */
	0x00, 0x7f, 0xc0, 0xf0, 	/* .........*********......****.... */
	0x01, 0xff, 0xc0, 0xf0, 	/* .......***********......****.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc3, 0xff, 0xf0, 	/* .....*****....**************.... */
	0x0f, 0x83, 0xff, 0xf0, 	/* ....*****.....**************.... */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x03, 0xc0, 0x00, 	/* ....****......****.............. */
	0x0f, 0x83, 0xe0, 0x00, 	/* ....*****.....*****............. */
	0x07, 0xc7, 0xf0, 0x00, 	/* .....*****...*******............ */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xfe, 0x7f, 0xf0, 	/* .......********..***********.... */
	0x00, 0x7c, 0x3f, 0xf0, 	/* .........*****....**********.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x00, 0xf0, 0x00, 	/* ................****............ */
	0x00, 0x01, 0xf0, 0x00, 	/* ...............*****............ */
	0x00, 0x03, 0xe0, 0x00, 	/* ..............*****............. */
	0x00, 0x0f, 0xe0, 0x00, 	/* ............*******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x0e, 0x00, 0x00, 	/* ............***................. */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x38, 0x00, 0x00, 	/* ..........***................... */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0x3c, 0x00, 	/* ..................****.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x07, 0x00, 	/* .....................***........ */
	0x00, 0x00, 0x0f, 0x00, 	/* ....................****........ */
	0x00, 0x00, 0x1f, 0x00, 	/* ...................*****........ */
	0x00, 0x00, 0x3f, 0x00, 	/* ..................******........ */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x0f, 0x80, 0x00, 	/* ............*****............... */
	0x00, 0x0f, 0x00, 0x00, 	/* ............****................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0x80, 0x01, 0xc0, 	/* ......***..............***...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0xff, 0xff, 0xf0, 	/* ....************************.... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x80, 0x00, 0x00, 	/* ....*****....................... */
	0x07, 0xc0, 0x00, 0x00, 	/* .....*****...................... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x38, 0x00, 0x00, 	/* ..........***................... */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0x3c, 0x00, 	/* ..................****.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x1c, 0x00, 	/* ...................***.......... */
	0x00, 0x00, 0x3c, 0x00, 	/* ..................****.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0x80, 0x01, 0xc0, 	/* ......***..............***...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x3f, 0xc0, 0x00, 	/* ..........********.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x03, 0xfc, 0x00, 	/* ..............********.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xc3, 0xc0, 0x00, 	/* ......****....****.............. */
	0x03, 0xe7, 0xc0, 0x00, 	/* ......*****..*****.............. */
	0x03, 0xff, 0xc0, 0x00, 	/* ......************.............. */
	0x01, 0xff, 0x80, 0x00, 	/* .......**********............... */
	0x00, 0xff, 0x00, 0x00, 	/* ........********................ */
	0x00, 0x7e, 0x00, 0x00, 	/* .........******................. */
	0x00, 0xff, 0x00, 0x00, 	/* ........********................ */
	0x01, 0xff, 0x80, 0x00, 	/* .......**********............... */
	0x03, 0xff, 0xc0, 0x00, 	/* ......************.............. */
	0x03, 0xf7, 0xe0, 0x00, 	/* ......******.******............. */
	0x03, 0xe3, 0xf0, 0x00, 	/* ......*****...******............ */
	0x03, 0xc1, 0xf8, 0x00, 	/* ......****.....******........... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0x7e, 0x00, 	/* .................******......... */
	0x00, 0x7f, 0xff, 0x00, 	/* .........***************........ */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x78, 0x00, 0xf0, 	/* .........****...........****.... */
	0x01, 0xfe, 0x00, 0xf0, 	/* .......********.........****.... */
	0x03, 0xff, 0x00, 0xf0, 	/* ......**********........****.... */
	0x07, 0xff, 0x80, 0xf0, 	/* .....************.......****.... */
	0x0f, 0xcf, 0xc1, 0xf0, 	/* ....******..******.....*****.... */
	0x0f, 0x87, 0xe3, 0xf0, 	/* ....*****....******...******.... */
	0x0f, 0x03, 0xff, 0xe0, 	/* ....****......*************..... */
	0x0f, 0x01, 0xff, 0xc0, 	/* ....****.......***********...... */
	0x0f, 0x00, 0xff, 0x80, 	/* ....****........*********....... */
	0x0f, 0x00, 0x3e, 0x00, 	/* ....****..........*****......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x38, 0x00, 0x00, 	/* ..........***................... */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0x3c, 0x00, 	/* ..................****.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x1c, 0x00, 	/* ...................***.......... */
	0x00, 0x00, 0x3c, 0x00, 	/* ..................****.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0x80, 0x01, 0xc0, 	/* ......***..............***...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x78, 0x00, 0xf0, 	/* .........****...........****.... */
	0x01, 0xfe, 0x00, 0xf0, 	/* .......********.........****.... */
	0x03, 0xff, 0x00, 0xf0, 	/* ......**********........****.... */
	0x07, 0xff, 0x80, 0xf0, 	/* .....************.......****.... */
	0x0f, 0xcf, 0xc1, 0xf0, 	/* ....******..******.....*****.... */
	0x0f, 0x87, 0xe3, 0xf0, 	/* ....*****....******...******.... */
	0x0f, 0x03, 0xff, 0xe0, 	/* ....****......*************..... */
	0x0f, 0x01, 0xff, 0xc0, 	/* ....****.......***********...... */
	0x0f, 0x00, 0xff, 0x80, 	/* ....****........*********....... */
	0x0f, 0x00, 0x3e, 0x00, 	/* ....****..........*****......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x01, 0xf0, 	/* ....*****..............*****.... */
	0x07, 0xc0, 0x03, 0xe0, 	/* .....*****............*****..... */
	0x07, 0xff, 0xff, 0xe0, 	/* .....**********************..... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x01, 0xff, 0xff, 0x80, 	/* .......******************....... */
	0x00, 0x7f, 0xfe, 0x00, 	/* .........**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x03, 0xff, 0xff, 0xc0, 	/* ......********************...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x7f, 0xfe, 0x1c, 	/* .........**************....***.. */
	0x01, 0xff, 0xff, 0xbc, 	/* .......******************.****.. */
	0x03, 0xff, 0xff, 0xfc, 	/* ......************************.. */
	0x07, 0xff, 0xff, 0xf8, 	/* .....************************... */
	0x07, 0xc0, 0x03, 0xf0, 	/* .....*****............******.... */
	0x0f, 0x80, 0x03, 0xf0, 	/* ....*****.............******.... */
	0x0f, 0x00, 0x07, 0xf0, 	/* ....****.............*******.... */
	0x0f, 0x00, 0x0f, 0xf0, 	/* ....****............********.... */
	0x0f, 0x00, 0x1f, 0xf0, 	/* ....****...........*********.... */
	0x0f, 0x00, 0x3f, 0xf0, 	/* ....****..........**********.... */
	0x0f, 0x00, 0x7e, 0xf0, 	/* ....****.........******.****.... */
	0x0f, 0x00, 0xfc, 0xf0, 	/* ....****........******..****.... */
	0x0f, 0x01, 0xf8, 0xf0, 	/* ....****.......******...****.... */
	0x0f, 0x03, 0xf0, 0xf0, 	/* ....****......******....****.... */
	0x0f, 0x07, 0xe0, 0xf0, 	/* ....****.....******.....****.... */
	0x0f, 0x0f, 0xc0, 0xf0, 	/* ....****....******......****.... */
	0x0f, 0x1f, 0x80, 0xf0, 	/* ....****...******.......****.... */
	0x0f, 0x3f, 0x00, 0xf0, 	/* ....****..******........****.... */
	0x0f, 0x7e, 0x00, 0xf0, 	/* ....****.******.........****.... */
	0x0f, 0xfc, 0x00, 0xf0, 	/* ....**********..........****.... */
	0x0f, 0xf8, 0x00, 0xf0, 	/* ....*********...........****.... */
	0x0f, 0xf0, 0x00, 0xf0, 	/* ....********............****.... */
	0x0f, 0xe0, 0x01, 0xf0, 	/* ....*******............*****.... */
	0x0f, 0xc0, 0x03, 0xe0, 	/* ....******............*****..... */
	0x1f, 0xff, 0xff, 0xe0, 	/* ...************************..... */
	0x3f, 0xff, 0xff, 0xc0, 	/* ..************************...... */
	0x3d, 0xff, 0xff, 0x80, 	/* ..****.******************....... */
	0x38, 0x7f, 0xfe, 0x00, 	/* ..***....**************......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x38, 0x00, 0x00, 	/* ..........***................... */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0x3c, 0x00, 	/* ..................****.......... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x1c, 0x00, 	/* ...................***.......... */
	0x00, 0x00, 0x3c, 0x00, 	/* ..................****.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x03, 0xc0, 0x00, 	/* ..............****.............. */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xf0, 0x00, 	/* ............********............ */
	0x00, 0x1f, 0xf8, 0x00, 	/* ...........**********........... */
	0x00, 0x3f, 0xfc, 0x00, 	/* ..........************.......... */
	0x00, 0x7e, 0x7e, 0x00, 	/* .........******..******......... */
	0x00, 0xfc, 0x3f, 0x00, 	/* ........******....******........ */
	0x01, 0xf8, 0x1f, 0x80, 	/* .......******......******....... */
	0x03, 0xf0, 0x0f, 0xc0, 	/* ......******........******...... */
	0x03, 0xe0, 0x07, 0xc0, 	/* ......*****..........*****...... */
	0x03, 0xc0, 0x03, 0xc0, 	/* ......****............****...... */
	0x03, 0x80, 0x01, 0xc0, 	/* ......***..............***...... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x1c, 0x00, 	/* ...................***.......... */
	0x00, 0x00, 0x3c, 0x00, 	/* ..................****.......... */
	0x00, 0x00, 0x7c, 0x00, 	/* .................*****.......... */
	0x00, 0x00, 0xfc, 0x00, 	/* ................******.......... */
	0x00, 0x01, 0xf8, 0x00, 	/* ...............******........... */
	0x00, 0x03, 0xf0, 0x00, 	/* ..............******............ */
	0x00, 0x07, 0xe0, 0x00, 	/* .............******............. */
	0x00, 0x0f, 0xc0, 0x00, 	/* ............******.............. */
	0x00, 0x1f, 0x80, 0x00, 	/* ...........******............... */
	0x00, 0x3f, 0x00, 0x00, 	/* ..........******................ */
	0x00, 0x3e, 0x00, 0x00, 	/* ..........*****................. */
	0x00, 0x3c, 0x00, 0x00, 	/* ..........****.................. */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x01, 0xf0, 	/* ....****...............*****.... */
	0x0f, 0x00, 0x03, 0xe0, 	/* ....****..............*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */
	0x0f, 0x00, 0x00, 0x00, 	/* ....****........................ */

	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0xf0, 0x0f, 0x00, 	/* ........****........****........ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x00, 0x00, 0x00, 0x00, 	/* ................................ */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x00, 0x00, 0xf0, 	/* ....****................****.... */
	0x0f, 0x80, 0x00, 0xf0, 	/* ....*****...............****.... */
	0x07, 0xc0, 0x00, 0xf0, 	/* .....*****..............****.... */
	0x07, 0xff, 0xff, 0xf0, 	/* .....***********************.... */
	0x03, 0xff, 0xff, 0xf0, 	/* ......**********************.... */
	0x01, 0xff, 0xff, 0xf0, 	/* .......*********************.... */
	0x00, 0x7f, 0xff, 0xf0, 	/* .........*******************.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x00, 0xf0, 	/* ........................****.... */
	0x00, 0x00, 0x01, 0xf0, 	/* .......................*****.... */
	0x00, 0x00, 0x03, 0xe0, 	/* ......................*****..... */
	0x0f, 0xff, 0xff, 0xe0, 	/* ....***********************..... */
	0x0f, 0xff, 0xff, 0xc0, 	/* ....**********************...... */
	0x0f, 0xff, 0xff, 0x80, 	/* ....*********************....... */
	0x0f, 0xff, 0xfe, 0x00, 	/* ....*******************......... */
};
