/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchAdvisor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;

public class IDEApplication
implements IPlatformRunnable,
IExecutableExtension {
    private static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "1";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final Integer EXIT_RELAUNCH = new Integer(24);
    private static final int MIN_JVM_VERSION_MAJOR = 1;
    private static final int MIN_JVM_VERSION_MINOR = 4;
    private static final int MIN_JVM_VERSION_SERVICE = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(Object args) throws Exception {
        Display display = this.createDisplay();
        try {
            Shell shell = new Shell(display, 16384);
            if (!this.checkJavaRuntimeVersion(shell)) {
                Platform.endSplash();
                Integer n = IPlatformRunnable.EXIT_OK;
                return n;
            }
            try {
                if (!this.checkInstanceLocation(shell)) {
                    Platform.endSplash();
                    Integer n = IPlatformRunnable.EXIT_OK;
                    return n;
                }
            }
            finally {
                if (shell != null) {
                    shell.dispose();
                }
            }
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new IDEWorkbenchAdvisor());
            if (returnCode != 1) {
                Integer n = IPlatformRunnable.EXIT_OK;
                return n;
            }
            Integer n = EXIT_RELAUNCH.equals(Integer.getInteger(PROP_EXIT_CODE)) ? EXIT_RELAUNCH : IPlatformRunnable.EXIT_RESTART;
            return n;
        }
        finally {
            if (display != null) {
                display.dispose();
            }
        }
    }

    protected Display createDisplay() {
        return PlatformUI.createDisplay();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private boolean checkJavaRuntimeVersion(Shell shell) {
        try {
            if (IDEApplication.isCompatibleVersion(System.getProperty("java.version"))) {
                return true;
            }
            String reqVersion = Integer.toString(1) + '.' + 4 + '.' + 1;
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.incompatibleJVMTitle"), (String)IDEWorkbenchMessages.format("IDEApplication.incompatibleJVMMessage", new Object[]{reqVersion}));
            return false;
        }
        catch (SecurityException e) {
            return true;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    private boolean checkInstanceLocation(Shell shell) {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceMandatoryTitle"), (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceMandatoryMessage"));
            return false;
        }
        if (instanceLoc.isSet()) {
            if (!this.checkValidWorkspace(shell, instanceLoc.getURL())) {
                return false;
            }
            try {
                if (instanceLoc.lock()) {
                    IDEApplication.writeWorkspaceVersion();
                    return true;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceCannotLockTitle"), (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceCannotLockMessage"));
            return false;
        }
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(instanceLoc.getDefault());
        boolean force = false;
        URL workspaceUrl;
        while ((workspaceUrl = this.promptForWorkspace(shell, launchData, force)) != null) {
            force = true;
            try {
                if (instanceLoc.setURL(workspaceUrl, true)) {
                    launchData.writePersistedData();
                    IDEApplication.writeWorkspaceVersion();
                    return true;
                }
            }
            catch (IllegalStateException e) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceCannotBeSetTitle"), (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceCannotBeSetMessage"));
                return false;
            }
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceInUseTitle"), (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceInUseMessage"));
        }
        return false;
    }

    private static boolean isCompatibleVersion(String vmVersion) {
        if (vmVersion == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(vmVersion, " ._");
        try {
            if (!tokenizer.hasMoreTokens()) {
                return true;
            }
            int major = Integer.parseInt(tokenizer.nextToken());
            if (major != 1) {
                return major > 4;
            }
            if (!tokenizer.hasMoreTokens()) {
                return true;
            }
            int minor = Integer.parseInt(tokenizer.nextToken());
            if (minor != 4) {
                return minor > 4;
            }
            if (!tokenizer.hasMoreTokens()) {
                return true;
            }
            int service = Integer.parseInt(tokenizer.nextToken());
            return service >= 1;
        }
        catch (SecurityException e) {
            return true;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    private URL promptForWorkspace(Shell shell, ChooseWorkspaceData launchData, boolean force) {
        URL url = null;
        do {
            new ChooseWorkspaceDialog(shell, launchData, false).prompt(force);
            String instancePath = launchData.getSelection();
            if (instancePath == null) {
                return null;
            }
            force = true;
            File workspace = new File(instancePath);
            if (!workspace.exists()) {
                workspace.mkdir();
            }
            try {
                String path = workspace.getAbsolutePath().replace(File.separatorChar, '/');
                url = new URL("file", null, path);
            }
            catch (MalformedURLException e) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceInvalidTitle"), (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceInvalidMessage"));
            }
        } while (!this.checkValidWorkspace(shell, url));
        return url;
    }

    private boolean checkValidWorkspace(Shell shell, URL url) {
        String version = IDEApplication.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ide_version = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspace_version = Integer.parseInt(version);
        if (workspace_version == ide_version) {
            return true;
        }
        String title = IDEWorkbenchMessages.getString("IDEApplication.versionTitle");
        String message = IDEWorkbenchMessages.format("IDEApplication.versionMessage", new Object[]{url.getFile()});
        MessageBox mbox = new MessageBox(shell, 65832);
        mbox.setText(title);
        mbox.setMessage(message);
        return mbox.open() == 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = IDEApplication.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(versionFile);
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log("Could not read version file", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void writeWorkspaceVersion() {
        block13: {
            Location instanceLoc = Platform.getInstanceLocation();
            if (instanceLoc == null || instanceLoc.isReadOnly()) {
                return;
            }
            File versionFile = IDEApplication.getVersionFile(instanceLoc.getURL(), true);
            if (versionFile == null) {
                return;
            }
            FileOutputStream output = null;
            String versionLine = "org.eclipse.core.runtime=1";
            output = new FileOutputStream(versionFile);
            ((OutputStream)output).write(versionLine.getBytes("UTF-8"));
            Object var5_5 = null;
            try {
                if (output != null) {
                    ((OutputStream)output).close();
                }
                break block13;
            }
            catch (IOException e2) {}
            break block13;
            {
                catch (IOException e) {
                    IDEWorkbenchPlugin.log("Could not write version file", StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
                    Object var5_6 = null;
                    try {
                        if (output != null) {
                            ((OutputStream)output).close();
                        }
                        break block13;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (output != null) {
                        ((OutputStream)output).close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        if (workspaceUrl == null) {
            return null;
        }
        try {
            File metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
            if (!(metaDir.exists() || create && metaDir.mkdir())) {
                return null;
            }
            File versionFile = new File(metaDir, VERSION_FILENAME);
            if (!(versionFile.exists() || create && versionFile.createNewFile())) {
                return null;
            }
            return versionFile;
        }
        catch (IOException e) {
            return null;
        }
    }
}

