/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;

public class ThrottlingProgressMonitor
extends ProgressMonitorWrapper {
    private float fThrottleRatio;
    private long fLastCalled;
    private long fSubMilis;

    public ThrottlingProgressMonitor(IProgressMonitor wrapped, float throttleRatio) {
        super(wrapped);
        this.fThrottleRatio = throttleRatio;
        this.fSubMilis = 0L;
        this.fLastCalled = 0L;
    }

    public void internalWorked(double work) {
        super.internalWorked(work);
        if (this.fLastCalled != 0L) {
            long sleepTime = System.currentTimeMillis() - this.fLastCalled;
            sleepTime = (long)((float)sleepTime * this.fThrottleRatio);
            if ((sleepTime = Math.min(100L, sleepTime)) < 1L) {
                ++this.fSubMilis;
                if (this.fSubMilis > 50L) {
                    sleepTime = 1L;
                    this.fSubMilis = 0L;
                }
            }
            this.fLastCalled = System.currentTimeMillis();
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {}
            } else {
                Thread.yield();
            }
        } else {
            this.fLastCalled = System.currentTimeMillis();
        }
    }
}

