/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkingSetManager;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public class WorkingSet
implements IAdaptable,
IWorkingSet {
    static final String FACTORY_ID = "org.eclipse.ui.internal.WorkingSetFactory";
    private String name;
    private ArrayList elements;
    private String editPageId;
    private IMemento workingSetMemento;
    static /* synthetic */ Class class$org$eclipse$ui$IWorkingSet;
    static /* synthetic */ Class class$org$eclipse$ui$IPersistableElement;

    public WorkingSet(String name, IAdaptable[] elements) {
        Assert.isNotNull((Object)name, (String)"name must not be null");
        this.name = name;
        this.internalSetElements(elements);
    }

    WorkingSet(String name, IMemento memento) {
        Assert.isNotNull((Object)name, (String)"name must not be null");
        this.name = name;
        this.workingSetMemento = memento;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WorkingSet) {
            WorkingSet workingSet = (WorkingSet)object;
            String objectPageId = workingSet.getId();
            String pageId = this.getId();
            boolean pageIdEqual = objectPageId == null && pageId == null || objectPageId != null && objectPageId.equals(pageId);
            return workingSet.getName().equals(this.getName()) && workingSet.getElementsArray().equals(this.getElementsArray()) && pageIdEqual;
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == (class$org$eclipse$ui$IWorkingSet == null ? (class$org$eclipse$ui$IWorkingSet = WorkingSet.class$("org.eclipse.ui.IWorkingSet")) : class$org$eclipse$ui$IWorkingSet) || adapter == (class$org$eclipse$ui$IPersistableElement == null ? (class$org$eclipse$ui$IPersistableElement = WorkingSet.class$("org.eclipse.ui.IPersistableElement")) : class$org$eclipse$ui$IPersistableElement)) {
            return this;
        }
        return null;
    }

    public IAdaptable[] getElements() {
        ArrayList list = this.getElementsArray();
        return list.toArray(new IAdaptable[list.size()]);
    }

    private ArrayList getElementsArray() {
        if (this.elements == null) {
            this.restoreWorkingSet();
            this.workingSetMemento = null;
        }
        return this.elements;
    }

    public String getFactoryId() {
        return FACTORY_ID;
    }

    public String getId() {
        return this.editPageId;
    }

    public ImageDescriptor getImage() {
        WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        WorkingSetDescriptor descriptor = null;
        if (this.editPageId != null) {
            descriptor = registry.getWorkingSetDescriptor(this.editPageId);
        }
        if (descriptor == null) {
            return null;
        }
        return descriptor.getIcon();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode() & this.getElementsArray().hashCode();
        if (this.editPageId != null) {
            hashCode &= this.editPageId.hashCode();
        }
        return hashCode;
    }

    private void restoreWorkingSet() {
        IMemento[] itemMementos = this.workingSetMemento.getChildren("item");
        HashSet<IAdaptable> items = new HashSet<IAdaptable>();
        for (int i = 0; i < itemMementos.length; ++i) {
            IMemento itemMemento = itemMementos[i];
            String factoryID = itemMemento.getString("factoryID");
            if (factoryID == null) {
                WorkbenchPlugin.log("Unable to restore working set item - no factory ID.");
                continue;
            }
            IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryID);
            if (factory == null) {
                WorkbenchPlugin.log("Unable to restore working set item - cannot instantiate factory: " + factoryID);
                continue;
            }
            IAdaptable item = factory.createElement(itemMemento);
            if (item == null) {
                WorkbenchPlugin.log("Unable to restore working set item - cannot instantiate item: " + factoryID);
                continue;
            }
            items.add(item);
        }
        this.internalSetElements(items.toArray(new IAdaptable[items.size()]));
    }

    public void saveState(IMemento memento) {
        if (this.workingSetMemento != null) {
            memento.putMemento(this.workingSetMemento);
        } else {
            memento.putString("name", this.name);
            memento.putString("editPageId", this.editPageId);
            Iterator iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                IAdaptable adaptable = (IAdaptable)iterator.next();
                IPersistableElement persistable = (IPersistableElement)adaptable.getAdapter(class$org$eclipse$ui$IPersistableElement == null ? WorkingSet.class$("org.eclipse.ui.IPersistableElement") : class$org$eclipse$ui$IPersistableElement);
                if (persistable == null) continue;
                IMemento itemMemento = memento.createChild("item");
                itemMemento.putString("factoryID", persistable.getFactoryId());
                persistable.saveState(itemMemento);
            }
        }
    }

    public void setElements(IAdaptable[] newElements) {
        this.internalSetElements(newElements);
        WorkingSetManager workingSetManager = (WorkingSetManager)WorkbenchPlugin.getDefault().getWorkingSetManager();
        workingSetManager.workingSetChanged(this, "workingSetContentChange");
    }

    private void internalSetElements(IAdaptable[] newElements) {
        Assert.isNotNull((Object)newElements, (String)"Working set elements array must not be null");
        this.elements = new ArrayList(newElements.length);
        for (int i = 0; i < newElements.length; ++i) {
            this.elements.add(newElements[i]);
        }
    }

    public void setId(String pageId) {
        this.editPageId = pageId;
    }

    public void setName(String newName) {
        Assert.isNotNull((Object)newName, (String)"Working set name must not be null");
        this.name = newName;
        WorkingSetManager workingSetManager = (WorkingSetManager)WorkbenchPlugin.getDefault().getWorkingSetManager();
        workingSetManager.workingSetChanged(this, "workingSetNameChange");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

