/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.indexing.BinarySmallObject;
import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Convert;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.Index;
import org.eclipse.core.internal.indexing.IndexAnchor;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexNode;
import org.eclipse.core.internal.indexing.IndexedStoreContext;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.IndexedStoreObjectPolicy;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.StoredObject;

public class IndexedStore {
    private static final int CurrentVersion = 1;
    private static final int MetadataID = 2;
    private static final Map registry = Collections.synchronizedMap(new HashMap());
    private static final ObjectAddress ContextAddress10 = new ObjectAddress(1, 0);
    private static final ObjectAddress ContextAddress11 = new ObjectAddress(1, 1);
    private ObjectAddress objectDirectoryAddress;
    private Index objectDirectory;
    private IndexCursor objectDirectoryCursor;
    private ObjectAddress indexDirectoryAddress;
    private Index indexDirectory;
    private IndexCursor indexDirectoryCursor;
    private ObjectAddress contextAddress;
    private ObjectStore objectStore;
    private String name;

    IndexAnchor acquireAnchor(ObjectAddress address) throws IndexedStoreException {
        return (IndexAnchor)this.acquireObject(address);
    }

    IndexedStoreContext acquireContext(ObjectAddress address) {
        try {
            return (IndexedStoreContext)this.acquireObject(address);
        }
        catch (IndexedStoreException e) {
            return null;
        }
    }

    IndexNode acquireNode(ObjectAddress address) throws IndexedStoreException {
        return (IndexNode)this.acquireObject(address);
    }

    private StoredObject acquireObject(ObjectAddress address) throws IndexedStoreException {
        StoredObject object;
        try {
            object = this.objectStore.acquireObject(address);
        }
        catch (ObjectStoreException e) {
            throw new IndexedStoreException(14, (Throwable)e);
        }
        return object;
    }

    BinarySmallObject acquireBinarySmallObject(ObjectAddress address) throws IndexedStoreException {
        return (BinarySmallObject)this.acquireObject(address);
    }

    private void checkMetadata() throws IndexedStoreException {
        Buffer metadata = this.getMetadataArea(2);
        Field versionField = metadata.getField(0, 4);
        int version = versionField.getInt();
        if (version == 0) {
            versionField.put(1);
            this.putMetadataArea(2, metadata);
            return;
        }
        if (version == 1) {
            return;
        }
        this.convert(version);
    }

    public synchronized void close() throws IndexedStoreException {
        if (this.name == null) {
            return;
        }
        try {
            this.commit();
            if (this.objectDirectoryCursor != null) {
                this.objectDirectoryCursor.close();
            }
            if (this.indexDirectoryCursor != null) {
                this.indexDirectoryCursor.close();
            }
        }
        catch (IndexedStoreException e) {
            try {
                this.objectStore.close();
            }
            catch (ObjectStoreException objectStoreException) {
                // empty catch block
            }
            throw e;
        }
        try {
            this.objectStore.close();
        }
        catch (ObjectStoreException e) {
            throw new IndexedStoreException(26, (Throwable)e);
        }
        registry.remove(this.name);
        this.name = null;
        this.objectDirectory = null;
        this.objectDirectoryAddress = null;
        this.objectDirectoryCursor = null;
        this.indexDirectory = null;
        this.indexDirectoryAddress = null;
        this.indexDirectoryCursor = null;
    }

    public synchronized void commit() throws IndexedStoreException {
        try {
            this.objectStore.commit();
        }
        catch (Exception e) {
            throw new IndexedStoreException(36, (Throwable)e);
        }
    }

    private void convert(int fromVersion) throws IndexedStoreException {
        throw new IndexedStoreException(34);
    }

    public static synchronized void create(String name) throws IndexedStoreException {
        ObjectStore store = new ObjectStore(new IndexedStoreObjectPolicy());
        try {
            ObjectStore.create(name);
            store.open(name);
            ObjectAddress contextAddress = store.insertObject(new IndexedStoreContext());
            IndexedStoreContext context = (IndexedStoreContext)store.acquireObject(contextAddress);
            IndexAnchor anchor = new IndexAnchor();
            ObjectAddress address = store.insertObject(anchor);
            context.setIndexDirectoryAddress(address);
            anchor = new IndexAnchor();
            address = store.insertObject(anchor);
            context.setObjectDirectoryAddress(address);
            context.release();
            store.commit();
            store.close();
        }
        catch (Exception e1) {
            try {
                store.close();
            }
            catch (ObjectStoreException objectStoreException) {
                // empty catch block
            }
            ObjectStore.delete(name);
            throw new IndexedStoreException(24, (Throwable)e1);
        }
    }

    public synchronized Index createIndex(String indexName) throws IndexedStoreException {
        Index index = null;
        this.indexDirectoryCursor.find(indexName);
        if (this.indexDirectoryCursor.keyMatches(indexName)) {
            throw new IndexedStoreException(9);
        }
        ObjectAddress address = this.insertObject(new IndexAnchor());
        this.indexDirectory.insert(indexName, address.toByteArray());
        index = new Index(this, address);
        return index;
    }

    public synchronized ObjectID createObject(byte[] b) throws IndexedStoreException {
        ObjectAddress address = this.insertObject(new BinarySmallObject(b));
        ObjectID id = this.getNextObjectID();
        this.objectDirectory.insert(id.toByteArray(), address.toByteArray());
        return id;
    }

    public synchronized ObjectID createObject(String s) throws IndexedStoreException {
        return this.createObject(Convert.toUTF8(s));
    }

    public synchronized ObjectID createObject(Insertable anObject) throws IndexedStoreException {
        return this.createObject(anObject.toByteArray());
    }

    public static synchronized void delete(String filename) {
        ObjectStore.delete(filename);
    }

    public static synchronized boolean exists(String filename) {
        return ObjectStore.exists(filename);
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized IndexedStore find(String name) {
        return (IndexedStore)registry.get(name);
    }

    public synchronized void flush() throws IndexedStoreException {
        try {
            this.objectStore.commit();
        }
        catch (Exception e) {
            throw new IndexedStoreException(27, (Throwable)e);
        }
    }

    public synchronized Index getIndex(String indexName) throws IndexedStoreException {
        byte[] key = Convert.toUTF8(indexName);
        this.indexDirectoryCursor.find(key);
        if (!this.indexDirectoryCursor.keyMatches(key)) {
            throw new IndexedStoreException(11);
        }
        ObjectAddress address = this.indexDirectoryCursor.getValueAsObjectAddress();
        Index index = new Index(this, address);
        return index;
    }

    private Buffer getMetadataArea(int i) throws IndexedStoreException {
        try {
            return this.objectStore.getMetadataArea(i);
        }
        catch (ObjectStoreException e) {
            throw new IndexedStoreException(32, (Throwable)e);
        }
    }

    public synchronized String getName() {
        return this.name;
    }

    private ObjectID getNextObjectID() throws IndexedStoreException {
        IndexedStoreContext context = this.acquireContext(this.contextAddress);
        if (context == null) {
            throw new IndexedStoreException(30);
        }
        long objectNumber = context.getNextObjectNumber();
        context.release();
        return new ObjectID(objectNumber);
    }

    public synchronized byte[] getObject(ObjectID id) throws IndexedStoreException {
        this.objectDirectoryCursor.find(id.toByteArray());
        ObjectAddress address = this.objectDirectoryCursor.getValueAsObjectAddress();
        BinarySmallObject object = this.acquireBinarySmallObject(address);
        byte[] b = object.getValue();
        object.release();
        return b;
    }

    public synchronized String getObjectAsString(ObjectID id) throws IndexedStoreException {
        String s = Convert.fromUTF8(this.getObject(id));
        int i = s.indexOf(0);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i);
    }

    public synchronized ObjectStore getObjectStore() {
        return this.objectStore;
    }

    ObjectAddress insertObject(StoredObject object) throws IndexedStoreException {
        try {
            ObjectAddress address = this.objectStore.insertObject(object);
            return address;
        }
        catch (ObjectStoreException e) {
            throw new IndexedStoreException(20, (Throwable)e);
        }
    }

    public synchronized void open(String name) throws IndexedStoreException {
        if (registry.get(name) != null) {
            throw new IndexedStoreException(35);
        }
        if (!IndexedStore.exists(name)) {
            IndexedStore.create(name);
        }
        try {
            this.objectStore = new ObjectStore(new IndexedStoreObjectPolicy());
            this.objectStore.open(name);
            this.checkMetadata();
            this.contextAddress = ContextAddress10;
            IndexedStoreContext context = this.acquireContext(this.contextAddress);
            if (context == null) {
                this.contextAddress = ContextAddress11;
                context = this.acquireContext(this.contextAddress);
            }
            if (context == null) {
                throw new IndexedStoreException(23);
            }
            this.indexDirectoryAddress = context.getIndexDirectoryAddress();
            this.objectDirectoryAddress = context.getObjectDirectoryAddress();
            context.release();
            this.indexDirectory = new Index(this, this.indexDirectoryAddress);
            this.indexDirectoryCursor = this.indexDirectory.open();
            this.objectDirectory = new Index(this, this.objectDirectoryAddress);
            this.objectDirectoryCursor = this.objectDirectory.open();
            this.name = name;
            registry.put(name, this);
        }
        catch (IndexedStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IndexedStoreException(0, (Throwable)e);
        }
    }

    private void putMetadataArea(int i, Buffer b) throws IndexedStoreException {
        try {
            this.objectStore.putMetadataArea(i, b);
        }
        catch (ObjectStoreException e) {
            throw new IndexedStoreException(32, (Throwable)e);
        }
    }

    public synchronized void removeIndex(String indexName) throws IndexedStoreException {
        byte[] key = Convert.toUTF8(indexName);
        this.indexDirectoryCursor.find(key);
        if (!this.indexDirectoryCursor.keyMatches(key)) {
            throw new IndexedStoreException(11);
        }
        ObjectAddress address = this.indexDirectoryCursor.getValueAsObjectAddress();
        IndexAnchor anchor = this.acquireAnchor(address);
        anchor.destroyChildren();
        anchor.release();
        this.removeObject(address);
        this.indexDirectoryCursor.remove();
    }

    void removeObject(ObjectAddress address) throws IndexedStoreException {
        try {
            this.objectStore.removeObject(address);
        }
        catch (ObjectStoreException e) {
            throw new IndexedStoreException(18, (Throwable)e);
        }
    }

    public synchronized void removeObject(ObjectID id) throws IndexedStoreException {
        byte[] key = id.toByteArray();
        this.objectDirectoryCursor.find(key);
        if (!this.objectDirectoryCursor.keyMatches(key)) {
            throw new IndexedStoreException(16);
        }
        ObjectAddress address = this.objectDirectoryCursor.getValueAsObjectAddress();
        this.objectDirectoryCursor.remove();
        this.removeObject(address);
    }

    public synchronized void rollback() throws IndexedStoreException {
        try {
            this.objectStore.rollback();
        }
        catch (ObjectStoreException e) {
            throw new IndexedStoreException(37, (Throwable)e);
        }
    }

    public synchronized void updateObject(ObjectID id, byte[] b) throws IndexedStoreException {
        byte[] key = id.toByteArray();
        this.objectDirectoryCursor.find(key);
        if (!this.objectDirectoryCursor.keyMatches(key)) {
            throw new IndexedStoreException(16);
        }
        ObjectAddress oldAddress = this.objectDirectoryCursor.getValueAsObjectAddress();
        ObjectAddress newAddress = this.insertObject(new BinarySmallObject(b));
        this.objectDirectoryCursor.updateValue(newAddress.toByteArray());
        this.removeObject(oldAddress);
    }

    public synchronized void updateObject(ObjectID id, String s) throws IndexedStoreException {
        this.updateObject(id, Convert.toUTF8(s));
    }

    public synchronized void updateObject(ObjectID id, Insertable anObject) throws IndexedStoreException {
        this.updateObject(id, anObject.toByteArray());
    }
}

