/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

public class Semaphore {
    protected long notifications;
    protected Runnable runnable;

    public Semaphore(Runnable runnable) {
        this.runnable = runnable;
        this.notifications = 0L;
    }

    public synchronized void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        while (this.notifications <= 0L) {
            this.wait();
        }
        --this.notifications;
    }

    public boolean equals(Object obj) {
        return this.runnable == ((Semaphore)obj).runnable;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public int hashCode() {
        return this.runnable.hashCode();
    }

    public synchronized void release() {
        ++this.notifications;
        this.notifyAll();
    }

    public String toString() {
        return String.valueOf(this.runnable);
    }
}

