/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.osgi.framework.ServiceReference;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLRootHandler
extends DefaultHandler
implements LexicalHandler {
    private boolean checkRoot;
    private String dtdFound = null;
    private String elementFound = null;
    private SAXParserFactory factory;
    private boolean factoryFailed = false;

    public XMLRootHandler(boolean checkRoot) {
        this.checkRoot = checkRoot;
    }

    public final void comment(char[] ch, int start, int length) {
    }

    private final SAXParser createParser(SAXParserFactory parserFactory) throws ParserConfigurationException, SAXException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        try {
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
            // empty catch block
        }
        return parser;
    }

    public final void endCDATA() {
    }

    public final void endDTD() {
    }

    public final void endEntity(String name) {
    }

    public String getDTD() {
        return this.dtdFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SAXParserFactory getFactory() {
        XMLRootHandler xMLRootHandler = this;
        synchronized (xMLRootHandler) {
            if (this.factoryFailed) {
                return null;
            }
            if (this.factory != null) {
                return this.factory;
            }
            ServiceReference parserReference = InternalPlatform.getDefault().getBundleContext().getServiceReference("javax.xml.parsers.SAXParserFactory");
            if (parserReference == null) {
                return null;
            }
            this.factory = (SAXParserFactory)InternalPlatform.getDefault().getBundleContext().getService(parserReference);
            if (this.factory == null) {
                return null;
            }
            this.factory.setNamespaceAware(true);
        }
        return this.factory;
    }

    public String getRootName() {
        return this.elementFound;
    }

    public boolean parseContents(InputSource contents) throws IOException, ParserConfigurationException, SAXException {
        try {
            this.factory = this.getFactory();
            if (this.factory == null) {
                return false;
            }
            SAXParser parser = this.createParser(this.factory);
            contents.setSystemId("/");
            parser.parse(contents, (DefaultHandler)this);
        }
        catch (StopParsingException stopParsingException) {
            // empty catch block
        }
        return true;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    public final void startCDATA() {
    }

    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.dtdFound = systemId;
        if (!this.checkRoot) {
            throw new StopParsingException();
        }
    }

    public final void startElement(String uri, String elementName, String qualifiedName, Attributes attributes) throws SAXException {
        this.elementFound = elementName;
        throw new StopParsingException();
    }

    public final void startEntity(String name) {
    }

    private class StopParsingException
    extends SAXException {
        public StopParsingException() {
            super((String)null);
        }
    }
}

