/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TemplateSet {
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String CONTEXT_ATTRIBUTE = "context";
    private List fTemplates = new ArrayList();
    private String fTemplateTag;
    private static final int TEMPLATE_PARSE_EXCEPTION = 10002;
    private static final int TEMPLATE_IO_EXCEPTION = 10005;
    private ContextTypeRegistry fRegistry;

    public TemplateSet(String templateTag, ContextTypeRegistry registry) {
        this.fTemplateTag = templateTag;
        this.fRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addFromFile(File file, boolean allowDuplicates, ResourceBundle bundle) throws CoreException {
        block11: {
            FileInputStream stream = null;
            stream = new FileInputStream(file);
            this.addFromStream(stream, allowDuplicates, false, bundle);
            Object var7_5 = null;
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
                break block11;
            }
            catch (IOException e2) {}
            break block11;
            {
                catch (IOException e) {
                    TemplateSet.throwReadException(e);
                    Object var7_6 = null;
                    try {
                        if (stream != null) {
                            ((InputStream)stream).close();
                        }
                        break block11;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String getTemplateTag() {
        return this.fTemplateTag;
    }

    public void addFromStream(InputStream stream, boolean allowDuplicates, boolean doTranslations, ResourceBundle bundle) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(new InputSource(stream));
            NodeList elements = document.getElementsByTagName(this.getTemplateTag());
            int count = elements.getLength();
            for (int i = 0; i != count; ++i) {
                Template template;
                String message;
                Node node = elements.item(i);
                NamedNodeMap attributes = node.getAttributes();
                if (attributes == null) continue;
                String name = this.getAttributeValue(attributes, NAME_ATTRIBUTE);
                String description = this.getAttributeValue(attributes, DESCRIPTION_ATTRIBUTE);
                if (name == null || description == null) continue;
                if (doTranslations) {
                    description = this.translateString(description, bundle);
                }
                String context = this.getAttributeValue(attributes, CONTEXT_ATTRIBUTE);
                if (name == null || description == null || context == null) {
                    throw new SAXException(JavaTemplateMessages.getString("TemplateSet.error.missing.attribute"));
                }
                StringBuffer buffer = new StringBuffer();
                NodeList children = node.getChildNodes();
                for (int j = 0; j != children.getLength(); ++j) {
                    String value = children.item(j).getNodeValue();
                    if (value == null) continue;
                    buffer.append(value);
                }
                String pattern = buffer.toString().trim();
                if (doTranslations) {
                    pattern = this.translateString(pattern, bundle);
                }
                if ((message = this.validateTemplate(template = new Template(name, description, context, pattern))) == null) {
                    if (!allowDuplicates) {
                        Template[] templates = this.getTemplates(name);
                        for (int k = 0; k < templates.length; ++k) {
                            this.remove(templates[k]);
                        }
                    }
                    this.add(template);
                    continue;
                }
                TemplateSet.throwReadException(null);
            }
        }
        catch (ParserConfigurationException e) {
            TemplateSet.throwReadException(e);
        }
        catch (IOException e) {
            TemplateSet.throwReadException(e);
        }
        catch (SAXException e) {
            TemplateSet.throwReadException(e);
        }
    }

    private String translateString(String str, ResourceBundle bundle) {
        int idx = str.indexOf(37);
        if (idx == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        int k = 0;
        while (idx != -1) {
            buf.append(str.substring(k, idx));
            for (k = idx + 1; k < str.length() && !Character.isWhitespace(str.charAt(k)); ++k) {
            }
            String key = str.substring(idx + 1, k);
            buf.append(this.getBundleString(key, bundle));
            idx = str.indexOf(37, k);
        }
        buf.append(str.substring(k));
        return buf.toString();
    }

    private String getBundleString(String key, ResourceBundle bundle) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                return '!' + key + '!';
            }
        }
        return JavaTemplateMessages.getString(key);
    }

    protected String validateTemplate(Template template) {
        TemplateContextType type = this.fRegistry.getContextType(template.getContextTypeId());
        if (type == null) {
            return "Unknown context type: " + template.getContextTypeId();
        }
        try {
            type.validate(template.getPattern());
            return null;
        }
        catch (TemplateException e) {
            return e.getMessage();
        }
    }

    private String getAttributeValue(NamedNodeMap attributes, String name) {
        Node node = attributes.getNamedItem(name);
        return node == null ? null : node.getNodeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveToFile(File file) throws CoreException {
        block11: {
            FileOutputStream stream = null;
            stream = new FileOutputStream(file);
            this.saveToStream(stream);
            Object var5_3 = null;
            try {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
                break block11;
            }
            catch (IOException e2) {}
            break block11;
            {
                catch (IOException e) {
                    TemplateSet.throwWriteException(e);
                    Object var5_4 = null;
                    try {
                        if (stream != null) {
                            ((OutputStream)stream).close();
                        }
                        break block11;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (stream != null) {
                        ((OutputStream)stream).close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void saveToStream(OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("templates");
            document.appendChild(root);
            for (int i = 0; i != this.fTemplates.size(); ++i) {
                Template template = (Template)this.fTemplates.get(i);
                Element node = document.createElement(this.getTemplateTag());
                root.appendChild(node);
                NamedNodeMap attributes = node.getAttributes();
                Attr name = document.createAttribute(NAME_ATTRIBUTE);
                name.setValue(template.getName());
                attributes.setNamedItem(name);
                Attr description = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                description.setValue(template.getDescription());
                attributes.setNamedItem(description);
                Attr context = document.createAttribute(CONTEXT_ATTRIBUTE);
                context.setValue(template.getContextTypeId());
                attributes.setNamedItem(context);
                Text pattern = document.createTextNode(template.getPattern());
                node.appendChild(pattern);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            TemplateSet.throwWriteException(e);
        }
        catch (TransformerException e) {
            TemplateSet.throwWriteException(e);
        }
    }

    private static void throwReadException(Throwable t) throws CoreException {
        int code = t instanceof SAXException ? 10002 : 10005;
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jface.text", code, JavaTemplateMessages.getString("TemplateSet.error.read"), t));
    }

    private static void throwWriteException(Throwable t) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jface.text", 10005, JavaTemplateMessages.getString("TemplateSet.error.write"), t));
    }

    public void add(Template template) {
        if (this.exists(template)) {
            return;
        }
        this.fTemplates.add(template);
    }

    private boolean exists(Template template) {
        Iterator iterator = this.fTemplates.iterator();
        while (iterator.hasNext()) {
            Template anotherTemplate = (Template)iterator.next();
            if (!template.equals((Object)anotherTemplate)) continue;
            return true;
        }
        return false;
    }

    public void remove(Template template) {
        this.fTemplates.remove(template);
    }

    public void clear() {
        this.fTemplates.clear();
    }

    public Template[] getTemplates() {
        return this.fTemplates.toArray(new Template[this.fTemplates.size()]);
    }

    public Template[] getTemplates(String name) {
        ArrayList<Template> res = new ArrayList<Template>();
        Iterator iterator = this.fTemplates.iterator();
        while (iterator.hasNext()) {
            Template curr = (Template)iterator.next();
            if (!curr.getName().equals(name)) continue;
            res.add(curr);
        }
        return res.toArray(new Template[res.size()]);
    }

    public Template getFirstTemplate(String name) {
        Iterator iterator = this.fTemplates.iterator();
        while (iterator.hasNext()) {
            Template curr = (Template)iterator.next();
            if (!curr.getName().equals(name)) continue;
            return curr;
        }
        return null;
    }
}

