/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import java.util.LinkedList;
import org.eclipse.jdt.internal.ui.text.comment.CommentRange;
import org.eclipse.jdt.internal.ui.text.comment.CommentRegion;
import org.eclipse.jdt.internal.ui.text.comment.IBorderAttributes;

public abstract class CommentLine
implements IBorderAttributes {
    protected static final String NON_FORMAT_START_PREFIX = "/*-";
    private int fAttributes = 0;
    private final CommentRegion fParent;
    private final LinkedList fRanges = new LinkedList();

    protected CommentLine(CommentRegion parent) {
        this.fParent = parent;
    }

    protected abstract void adapt(CommentLine var1);

    protected void append(CommentRange range) {
        this.fRanges.add(range);
    }

    protected CommentRange formatLine(CommentLine predecessor, CommentRange last, String indentation, int line) {
        int offset = 0;
        int length = 0;
        CommentRange next = last;
        CommentRange previous = null;
        int stop = this.fRanges.size() - 1;
        int end = this.fParent.getSize() - 1;
        for (int index = stop; index >= 0; --index) {
            previous = next;
            if (!this.fParent.canFormat(previous, next = (CommentRange)this.fRanges.get(index))) continue;
            offset = next.getOffset() + next.getLength();
            length = previous.getOffset() - offset;
            if (index == stop && line != end) {
                this.fParent.logEdit(this.fParent.getDelimiter(predecessor, this, previous, next, indentation), offset, length);
                continue;
            }
            this.fParent.logEdit(this.fParent.getDelimiter(previous, next), offset, length);
        }
        return next;
    }

    protected void formatLowerBorder(CommentRange range, String indentation, int length) {
        int offset = range.getOffset() + range.getLength();
        StringBuffer buffer = new StringBuffer(length);
        String end = this.getEndingPrefix();
        String delimiter = this.fParent.getDelimiter();
        if (this.fParent.isSingleLine() && this.fParent.getSize() == 1) {
            buffer.append(end);
        } else {
            String filler = this.getContentPrefix().trim();
            buffer.append(delimiter);
            buffer.append(indentation);
            if (this.fParent.hasBorder(1)) {
                buffer.append(' ');
                for (int character = 0; character < length; ++character) {
                    buffer.append(filler);
                }
                buffer.append(end.trim());
            } else {
                buffer.append(end);
            }
        }
        this.fParent.logEdit(buffer.toString(), offset, this.fParent.getLength() - offset);
    }

    protected void formatUpperBorder(CommentRange range, String indentation, int length) {
        StringBuffer buffer = new StringBuffer(length);
        String start = this.getStartingPrefix();
        String content = this.getContentPrefix();
        if (this.fParent.isSingleLine() && this.fParent.getSize() == 1) {
            buffer.append(start);
        } else {
            String trimmed = start.trim();
            String filler = content.trim();
            buffer.append(trimmed);
            if (this.fParent.hasBorder(2)) {
                for (int character = 0; character < length - trimmed.length() + start.length(); ++character) {
                    buffer.append(filler);
                }
            }
            buffer.append(this.fParent.getDelimiter());
            buffer.append(indentation);
            buffer.append(content);
        }
        this.fParent.logEdit(buffer.toString(), 0, range.getOffset());
    }

    protected abstract String getContentPrefix();

    protected abstract String getEndingPrefix();

    protected final CommentRange getFirst() {
        return (CommentRange)this.fRanges.getFirst();
    }

    protected String getIndentationReference() {
        return "";
    }

    protected final CommentRange getLast() {
        return (CommentRange)this.fRanges.getLast();
    }

    protected final CommentRegion getParent() {
        return this.fParent;
    }

    protected final int getSize() {
        return this.fRanges.size();
    }

    protected abstract String getStartingPrefix();

    protected final boolean hasAttribute(int attribute) {
        return (this.fAttributes & attribute) == attribute;
    }

    protected abstract void scanLine(int var1);

    protected final void setAttribute(int attribute) {
        this.fAttributes |= attribute;
    }

    protected void tokenizeLine(int line) {
        int offset;
        int index = offset = 0;
        CommentRange range = (CommentRange)this.fRanges.get(0);
        int begin = range.getOffset();
        String content = this.fParent.getText(begin, range.getLength());
        int length = content.length();
        while (offset < length) {
            while (offset < length && Character.isWhitespace(content.charAt(offset))) {
                ++offset;
            }
            for (index = offset; index < length && !Character.isWhitespace(content.charAt(index)); ++index) {
            }
            if (index - offset <= 0) continue;
            this.fParent.append(new CommentRange(begin + offset, index - offset));
            offset = index;
        }
    }
}

