/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.TransformationMethodVisitor;
import org.jetbrains.kotlin.codegen.optimization.CapturedVarsOptimizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.ConstantConditionEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.DeadCodeEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.FixStackWithLabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.MethodVerifier;
import org.jetbrains.kotlin.codegen.optimization.RedundantCheckCastEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantGotoMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantNopsCleanupMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.UninitializedStoresMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.PopBackwardPropagationTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.StackPeepholeOptimizationsTransformer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.RedundantNullCheckMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.transformer.CompositeMethodTransformer;
import org.jetbrains.kotlin.config.JVMConstructorCallNormalizationMode;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000b\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor;", "Lorg/jetbrains/kotlin/codegen/TransformationMethodVisitor;", "delegate", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "disableOptimization", "", "constructorCallNormalizationMode", "Lorg/jetbrains/kotlin/config/JVMConstructorCallNormalizationMode;", "access", "", "name", "", "desc", "signature", "exceptions", "", "(Lorg/jetbrains/org/objectweb/asm/MethodVisitor;ZLorg/jetbrains/kotlin/config/JVMConstructorCallNormalizationMode;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "constructorCallNormalizationTransformer", "Lorg/jetbrains/kotlin/codegen/optimization/UninitializedStoresMethodTransformer;", "performTransformations", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "Companion", "backend"})
public final class OptimizationMethodVisitor
extends TransformationMethodVisitor {
    private final UninitializedStoresMethodTransformer constructorCallNormalizationTransformer;
    private final boolean disableOptimization;
    private final JVMConstructorCallNormalizationMode constructorCallNormalizationMode;
    private static final int MEMORY_LIMIT_BY_METHOD_MB = 50;
    @NotNull
    private static final CompositeMethodTransformer normalizationMethodTransformer;
    @NotNull
    private static final CompositeMethodTransformer optimizationTransformer;
    public static final Companion Companion;

    @Override
    protected void performTransformations(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        Companion.getNormalizationMethodTransformer().transform("fake", methodNode);
        this.constructorCallNormalizationTransformer.transform("fake", methodNode);
        if (Companion.canBeOptimized(methodNode) && !this.disableOptimization) {
            Companion.getOptimizationTransformer().transform("fake", methodNode);
        }
        UtilKt.prepareForEmitting(methodNode);
    }

    public OptimizationMethodVisitor(@NotNull MethodVisitor delegate, boolean disableOptimization, @NotNull JVMConstructorCallNormalizationMode constructorCallNormalizationMode, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        Intrinsics.checkParameterIsNotNull((Object)((Object)constructorCallNormalizationMode), (String)"constructorCallNormalizationMode");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        super(delegate, access, name, desc, signature, exceptions);
        this.disableOptimization = disableOptimization;
        this.constructorCallNormalizationMode = constructorCallNormalizationMode;
        this.constructorCallNormalizationTransformer = new UninitializedStoresMethodTransformer(this.constructorCallNormalizationMode);
    }

    static {
        Companion = new Companion(null);
        MEMORY_LIMIT_BY_METHOD_MB = 50;
        normalizationMethodTransformer = new CompositeMethodTransformer(new FixStackWithLabelNormalizationMethodTransformer(), new MethodVerifier("AFTER mandatory stack transformations"));
        optimizationTransformer = new CompositeMethodTransformer(new CapturedVarsOptimizationMethodTransformer(), new RedundantNullCheckMethodTransformer(), new RedundantCheckCastEliminationMethodTransformer(), new ConstantConditionEliminationMethodTransformer(), new RedundantBoxingMethodTransformer(), new StackPeepholeOptimizationsTransformer(), new PopBackwardPropagationTransformer(), new DeadCodeEliminationMethodTransformer(), new RedundantGotoMethodTransformer(), new RedundantNopsCleanupMethodTransformer(), new MethodVerifier("AFTER optimizations"));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor$Companion;", "", "()V", "MEMORY_LIMIT_BY_METHOD_MB", "", "getMEMORY_LIMIT_BY_METHOD_MB", "()I", "normalizationMethodTransformer", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/CompositeMethodTransformer;", "getNormalizationMethodTransformer", "()Lorg/jetbrains/kotlin/codegen/optimization/transformer/CompositeMethodTransformer;", "optimizationTransformer", "getOptimizationTransformer", "canBeOptimized", "", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "canBeOptimizedUsingSourceInterpreter", "backend"})
    public static final class Companion {
        private final int getMEMORY_LIMIT_BY_METHOD_MB() {
            return MEMORY_LIMIT_BY_METHOD_MB;
        }

        @NotNull
        public final CompositeMethodTransformer getNormalizationMethodTransformer() {
            return normalizationMethodTransformer;
        }

        @NotNull
        public final CompositeMethodTransformer getOptimizationTransformer() {
            return optimizationTransformer;
        }

        public final boolean canBeOptimized(@NotNull MethodNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            int totalFramesSizeMb = node.instructions.size() * (node.maxLocals + node.maxStack) / 0x100000;
            return totalFramesSizeMb < this.getMEMORY_LIMIT_BY_METHOD_MB();
        }

        public final boolean canBeOptimizedUsingSourceInterpreter(@NotNull MethodNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            int frameSize = node.maxLocals + node.maxStack;
            long methodSize = node.instructions.size();
            long totalFramesSizeMb = methodSize * methodSize * (long)frameSize / (long)0x100000;
            return totalFramesSizeMb < (long)this.getMEMORY_LIMIT_BY_METHOD_MB();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

