/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.ClosedStreamChecker;
import com.github.marschall.memoryfilesystem.MemoryContents;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class BlockInputStream
extends InputStream {
    private static final int MAX_SKIP_SIZE = 2048;
    static final AtomicLongFieldUpdater<BlockInputStream> POSITION_UPDATER = AtomicLongFieldUpdater.newUpdater(BlockInputStream.class, "position");
    private final MemoryContents memoryContents;
    private final ClosedStreamChecker checker;
    private volatile long position;
    private final Path path;
    private final boolean deleteOnClose;

    BlockInputStream(MemoryContents memoryContents, boolean deleteOnClose, Path path) {
        this.memoryContents = memoryContents;
        this.deleteOnClose = deleteOnClose;
        this.checker = new ClosedStreamChecker();
        POSITION_UPDATER.set(this, 0L);
        this.path = path;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checker.check(this.path);
        boolean success = false;
        int read = 0;
        while (!success) {
            long positionBefore = POSITION_UPDATER.get(this);
            read = this.memoryContents.read(b, positionBefore, off, len);
            if (read == -1) {
                return read;
            }
            success = POSITION_UPDATER.compareAndSet(this, positionBefore, positionBefore + (long)read);
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checker.check(this.path);
        long fileSize = this.memoryContents.size();
        long skipped = 0L;
        boolean success = false;
        while (!success) {
            long positionBefore = POSITION_UPDATER.get(this);
            skipped = Math.min(Math.min(n, fileSize - positionBefore), 2048L);
            if (skipped < 0L) {
                fileSize = this.memoryContents.size();
                continue;
            }
            success = POSITION_UPDATER.compareAndSet(this, positionBefore, positionBefore + skipped);
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        this.checker.check(this.path);
        long available = this.memoryContents.size() - POSITION_UPDATER.get(this);
        if (available > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (available > 1L) {
            return (int)(available - 1L);
        }
        return (int)available;
    }

    @Override
    public void close() throws IOException {
        if (this.checker.close()) {
            this.memoryContents.accessed();
            this.memoryContents.closedStream(this.path, this.deleteOnClose);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] data = new byte[1];
        int read = this.read(data);
        if (read == -1) {
            return read;
        }
        return data[0] & 0xFF;
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        this.checker.check(this.path);
        long positionBefore = POSITION_UPDATER.get(this);
        long written = this.memoryContents.transferTo(out, positionBefore);
        POSITION_UPDATER.set(this, this.memoryContents.size());
        return written;
    }
}

