/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

final class CompositeList<E>
extends AbstractList<E>
implements RandomAccess {
    private final List<E> first;
    private final List<E> second;

    private CompositeList(List<E> first, List<E> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public E get(int index) {
        int firstSize = this.first.size();
        if (index < firstSize) {
            return this.first.get(index);
        }
        return this.second.get(index - firstSize);
    }

    @Override
    public int size() {
        return this.first.size() + this.second.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        int firstSize = this.first.size();
        int size = this.size();
        if (fromIndex == 0 && toIndex == size) {
            return this;
        }
        if (toIndex == fromIndex) {
            return Collections.emptyList();
        }
        if (toIndex - fromIndex == 1) {
            return Collections.singletonList(this.get(fromIndex));
        }
        if (toIndex <= firstSize) {
            if (fromIndex == 0 && toIndex == firstSize) {
                return this.first;
            }
            return this.first.subList(fromIndex, toIndex);
        }
        if (fromIndex >= firstSize) {
            if (fromIndex == firstSize && toIndex == size) {
                return this.second;
            }
            return this.second.subList(fromIndex - firstSize, toIndex - firstSize);
        }
        return super.subList(fromIndex, toIndex);
    }

    static <E> List<E> create(List<E> first, List<E> second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        return new CompositeList<E>(first, second);
    }
}

