/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.EntryCreationContext;
import com.github.marschall.memoryfilesystem.MemoryDirectoryStream;
import com.github.marschall.memoryfilesystem.MemoryEntry;
import com.github.marschall.memoryfilesystem.MemoryEntryAttributes;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MemoryDirectory
extends MemoryEntry {
    private final Map<String, MemoryEntry> entries = new HashMap<String, MemoryEntry>();
    private static final Set<PosixFilePermission> EXECUTE = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE);

    MemoryDirectory(String originalName) {
        this(originalName, EntryCreationContext.empty());
    }

    MemoryDirectory(String originalName, EntryCreationContext context) {
        super(originalName, context);
    }

    @Override
    MemoryEntryAttributes newMemoryEntryAttributes(EntryCreationContext context) {
        return new MemoryDirectoryAttributes(context);
    }

    private static Set<PosixFilePermission> addExecute(Set<PosixFilePermission> perms) {
        EnumSet<PosixFilePermission> copy = EnumSet.copyOf(perms);
        copy.addAll(EXECUTE);
        return copy;
    }

    DirectoryStream<Path> newDirectoryStream(Path basePath, DirectoryStream.Filter<? super Path> filter) throws AccessDeniedException {
        this.checkAccess(AccessMode.EXECUTE);
        ArrayList<String> elements = new ArrayList<String>(this.entries.size());
        for (MemoryEntry entry : this.entries.values()) {
            elements.add(entry.getOriginalName());
        }
        return new MemoryDirectoryStream(basePath, filter, elements);
    }

    MemoryEntry getEntry(String name) {
        return this.entries.get(name);
    }

    MemoryEntry getEntryOrException(String name, Path path) throws IOException {
        MemoryEntry entry = this.getEntry(name);
        if (entry == null) {
            throw new NoSuchFileException(path.toString());
        }
        return entry;
    }

    boolean isEmpty() {
        return this.entries.isEmpty();
    }

    void checkEmpty(Path path) throws IOException {
        if (!this.isEmpty()) {
            throw new DirectoryNotEmptyException(path.toString());
        }
    }

    void addEntry(String name, MemoryEntry entry, Path originalPath) throws IOException {
        MemoryEntry previous = this.entries.put(name, entry);
        if (previous != null) {
            this.entries.put(name, previous);
            throw new FileAlreadyExistsException(originalPath.toString());
        }
        this.modified();
    }

    public String toString() {
        return "directory(" + this.getOriginalName() + ')';
    }

    void removeEntry(String name) throws AccessDeniedException {
        this.entries.remove(name);
        this.modified();
    }

    static final class MemoryDirectoryAttributes
    extends MemoryEntryAttributes {
        MemoryDirectoryAttributes(EntryCreationContext context) {
            super(context);
        }

        @Override
        BasicFileAttributeView newBasicFileAttributeView() {
            return new MemoryEntryAttributes.MemoryDirectoryFileAttributesView();
        }

        @Override
        long size() {
            return -1L;
        }
    }
}

