/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.health;

import org.jitsi.utils.StringUtils;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;

public class HealthStatusPacketExt
extends AbstractPacketExtension {
    public static final String NAMESPACE = "http://jitsi.org/protocol/health";
    public static final String ELEMENT_NAME = "health-status";
    private static final String HEALTH_ATTRIBUTE = "status";

    public HealthStatusPacketExt() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    public static void registerExtensionProvider() {
        ProviderManager.addExtensionProvider((String)ELEMENT_NAME, (String)NAMESPACE, new DefaultPacketExtensionProvider<HealthStatusPacketExt>(HealthStatusPacketExt.class));
    }

    public Health getStatus() {
        return Health.parse(this.getAttributeAsString(HEALTH_ATTRIBUTE));
    }

    public void setStatus(Health health) {
        this.setAttribute(HEALTH_ATTRIBUTE, (Object)health);
    }

    public static enum Health {
        HEALTHY("healthy"),
        UNHEALTHY("unhealthy"),
        UNDEFINED("undefined");

        private String health;

        private Health(String health) {
            this.health = health;
        }

        public String toString() {
            return this.health;
        }

        public static Health parse(String health) {
            if (StringUtils.isNullOrEmpty((String)health)) {
                return UNDEFINED;
            }
            try {
                return Health.valueOf(health.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }
    }
}

