/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.jitsi.utils.StringUtils;
import org.jivesoftware.smack.packet.IQ;

public class LogoutIq
extends IQ {
    public static final String ELEMENT_NAME = "logout";
    public static final String NAMESPACE = "http://jitsi.org/protocol/focus";
    public static final String SESSION_ID_ATTR = "session-id";
    public static final String LOGOUT_URL_ATTR = "logout-url";
    private String sessionId;
    private String logoutUrl;

    public LogoutIq() {
        super(ELEMENT_NAME, NAMESPACE);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.optAttribute(SESSION_ID_ATTR, this.sessionId);
        if (!StringUtils.isNullOrEmpty((String)this.logoutUrl)) {
            try {
                String encodedUrl = URLEncoder.encode(this.logoutUrl, "UTF-8");
                xml.attribute(LOGOUT_URL_ATTR, encodedUrl);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        xml.setEmptyElement();
        return xml;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        try {
            this.logoutUrl = logoutUrl != null ? URLDecoder.decode(logoutUrl, "UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

