/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecord;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="use-releases", threadSafe=true)
public class UseReleasesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="allowRangeMatching", defaultValue="false")
    private boolean allowRangeMatching;
    @Parameter(property="failIfNotReplaced", defaultValue="false")
    protected boolean failIfNotReplaced;

    @Inject
    public UseReleasesMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        try {
            DependencyManagement dependencyManagement;
            if (this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                this.useReleases(pom, dependencyManagement.getDependencies(), ChangeRecord.ChangeKind.DEPENDENCY_MANAGEMENT);
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useReleases(pom, this.getProject().getDependencies(), ChangeRecord.ChangeKind.DEPENDENCY);
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.useReleases(pom, Collections.singletonList(this.getParentDependency()), ChangeRecord.ChangeKind.PARENT);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void useReleases(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies, ChangeRecord.ChangeKind changeKind) throws XMLStreamException, MojoExecutionException, VersionRetrievalException {
        for (Dependency dep : dependencies) {
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            if (version == null) {
                this.getLog().info((CharSequence)("Ignoring dependency with no version: " + this.toString(dep)));
                continue;
            }
            Matcher versionMatcher = SNAPSHOT_REGEX.matcher(version);
            if (!versionMatcher.matches()) continue;
            String releaseVersion = versionMatcher.group(1);
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            this.getLog().debug((CharSequence)("Looking for a release of " + this.toString(dep)));
            artifact.setVersion(releaseVersion);
            Optional<String> targetVersion = this.findReleaseVersion(pom, dep, version, releaseVersion, this.getHelper().lookupArtifactVersions(artifact, false));
            if (targetVersion.isPresent()) {
                this.updateDependencyVersion(pom, dep, targetVersion.get(), changeKind);
                continue;
            }
            this.getLog().info((CharSequence)("No matching release of " + this.toString(dep) + " to update."));
            if (!this.failIfNotReplaced) continue;
            throw new MojoExecutionException("No matching release of " + this.toString(dep) + " found for update");
        }
    }

    private Optional<String> findReleaseVersion(ModifiedPomXMLEventReader pom, Dependency dep, String version, String releaseVersion, ArtifactVersions versions) {
        return !this.allowRangeMatching ? (versions.containsVersion(releaseVersion) ? Optional.of(releaseVersion) : Optional.empty()) : Arrays.stream(versions.getVersions(false)).sorted((v1, v2) -> -v1.compareTo(v2)).filter(v -> v.toString().startsWith(releaseVersion)).findFirst().map(Object::toString);
    }
}

