/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.vp8;

import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.logging.Logger;

public class DePacketizer
extends AbstractCodec2 {
    private static final Logger logger = Logger.getLogger(DePacketizer.class);
    private static final boolean TRACE = logger.isTraceEnabled();
    private SortedMap<Integer, Container> data = new TreeMap<Integer, Container>(RTPUtils.sequenceNumberComparator);
    private Queue<Container> free = new ArrayBlockingQueue<Container>(100);
    private int firstSeq = -1;
    private int lastSeq = -1;
    private int pictureId = -1;
    private long timestamp = -1L;
    private boolean empty = true;
    private boolean haveEnd = false;
    private boolean haveStart = false;
    private int frameLength = 0;
    private int lastSentSeq = -1;

    public DePacketizer() {
        super("VP8 RTP DePacketizer", VideoFormat.class, (Format[])new VideoFormat[]{new VideoFormat("VP8")});
        this.inputFormats = new VideoFormat[]{new VideoFormat("VP8/rtp")};
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Opened VP8 depacketizer");
        }
    }

    private void reinit() {
        this.lastSeq = -1;
        this.firstSeq = -1;
        this.timestamp = -1L;
        this.pictureId = -1;
        this.empty = true;
        this.haveStart = false;
        this.haveEnd = false;
        this.frameLength = 0;
        Iterator<Map.Entry<Integer, Container>> it = this.data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Container> e = it.next();
            this.free.offer(e.getValue());
            it.remove();
        }
    }

    private boolean frameComplete() {
        return this.haveStart && this.haveEnd && !this.haveMissing();
    }

    private boolean haveMissing() {
        Set<Integer> seqs = this.data.keySet();
        int s = this.firstSeq;
        while (s != this.lastSeq) {
            if (!seqs.contains(s)) {
                return true;
            }
            s = s + 1 & 0xFFFF;
        }
        return false;
    }

    @Override
    protected int doProcess(Buffer inBuffer, Buffer outBuffer) {
        int inLength;
        int inOffset;
        byte[] inData = (byte[])inBuffer.getData();
        if (!VP8PayloadDescriptor.isValid(inData, inOffset = inBuffer.getOffset(), inLength = inBuffer.getLength())) {
            logger.warn((Object)"Invalid RTP/VP8 packet discarded.");
            outBuffer.setDiscard(true);
            return 1;
        }
        int inSeq = (int)inBuffer.getSequenceNumber();
        long inRtpTimestamp = inBuffer.getRtpTimeStamp();
        int inPictureId = VP8PayloadDescriptor.getPictureId(inData, inOffset);
        boolean inMarker = (inBuffer.getFlags() & 0x800) != 0;
        boolean inIsStartOfFrame = VP8PayloadDescriptor.isStartOfFrame(inData, inOffset);
        int inPdSize = VP8PayloadDescriptor.getSize(inData, inOffset, inLength);
        int inPayloadLength = inLength - inPdSize;
        if (this.empty && this.lastSentSeq != -1 && RTPUtils.sequenceNumberComparator.compare((Integer)inSeq, (Integer)this.lastSentSeq) != 1) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Discarding old packet (while empty) " + inSeq));
            }
            outBuffer.setDiscard(true);
            return 0;
        }
        if (!this.empty && (inPictureId != -1 && this.pictureId != -1 && inPictureId != this.pictureId) | (this.timestamp != -1L && inRtpTimestamp != -1L && inRtpTimestamp != this.timestamp)) {
            if (RTPUtils.sequenceNumberComparator.compare((Integer)inSeq, (Integer)this.firstSeq) != 1) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Discarding old packet " + inSeq));
                }
                outBuffer.setDiscard(true);
                return 0;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Discarding saved packets on arrival of a packet for a subsequent frame: " + inSeq));
            }
            this.reinit();
        }
        if (this.empty && inMarker && inIsStartOfFrame) {
            byte[] outData = DePacketizer.validateByteArraySize(outBuffer, inPayloadLength, false);
            System.arraycopy(inData, inOffset + inPdSize, outData, 0, inPayloadLength);
            outBuffer.setOffset(0);
            outBuffer.setLength(inPayloadLength);
            outBuffer.setRtpTimeStamp(inBuffer.getRtpTimeStamp());
            if (TRACE) {
                logger.trace((Object)("Out PictureID=" + inPictureId));
            }
            this.lastSentSeq = inSeq;
            return 0;
        }
        Container container = this.free.poll();
        if (container == null) {
            container = new Container();
        }
        if (container.buf == null || container.buf.length < inPayloadLength) {
            Container.access$102(container, new byte[inPayloadLength]);
        }
        if (this.data.get(inSeq) != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("(Probable) duplicate packet detected, discarding " + inSeq));
            }
            outBuffer.setDiscard(true);
            return 0;
        }
        System.arraycopy(inData, inOffset + inPdSize, container.buf, 0, inPayloadLength);
        container.len = inPayloadLength;
        this.data.put(inSeq, container);
        this.frameLength += inPayloadLength;
        if (this.firstSeq == -1 || RTPUtils.sequenceNumberComparator.compare((Integer)this.firstSeq, (Integer)inSeq) == 1) {
            this.firstSeq = inSeq;
        }
        if (this.lastSeq == -1 || RTPUtils.sequenceNumberComparator.compare((Integer)inSeq, (Integer)this.lastSeq) == 1) {
            this.lastSeq = inSeq;
        }
        if (this.empty) {
            this.empty = false;
            this.timestamp = inRtpTimestamp;
            this.pictureId = inPictureId;
        }
        if (inMarker) {
            this.haveEnd = true;
        }
        if (inIsStartOfFrame) {
            this.haveStart = true;
        }
        if (this.frameComplete()) {
            byte[] outData = DePacketizer.validateByteArraySize(outBuffer, this.frameLength, false);
            int ptr = 0;
            for (Map.Entry<Integer, Container> entry : this.data.entrySet()) {
                Container b = entry.getValue();
                System.arraycopy(b.buf, 0, outData, ptr, b.len);
                ptr += b.len;
            }
            outBuffer.setOffset(0);
            outBuffer.setLength(this.frameLength);
            outBuffer.setRtpTimeStamp(inBuffer.getRtpTimeStamp());
            if (TRACE) {
                logger.trace((Object)("Out PictureID=" + inPictureId));
            }
            this.lastSentSeq = this.lastSeq;
            this.reinit();
            return 0;
        }
        outBuffer.setDiscard(true);
        return 4;
    }

    public static boolean isKeyFrame(byte[] buf, int off, int len) {
        if (!VP8PayloadDescriptor.isValid(buf, off, len)) {
            return false;
        }
        if (!VP8PayloadDescriptor.isStartOfFrame(buf, off)) {
            return false;
        }
        int szVP8PayloadDescriptor = VP8PayloadDescriptor.getSize(buf, off, len);
        return VP8PayloadHeader.isKeyFrame(buf, off + szVP8PayloadDescriptor);
    }

    private static class Container {
        private byte[] buf;
        private int len = 0;

        private Container() {
        }

        static /* synthetic */ byte[] access$102(Container x0, byte[] x1) {
            x0.buf = x1;
            return x1;
        }
    }

    public static class VP8KeyframeHeader {
        public static int getHeight(byte[] buf, int off) {
            return ((buf[off + 6] & 0xFF) << 8 | buf[off + 5] & 0xFF) & 0x3FFF;
        }
    }

    public static class VP8PayloadHeader {
        private static final byte S_BIT = 1;

        public static boolean isKeyFrame(byte[] input, int offset) {
            return (input[offset] & 1) == 0;
        }
    }

    public static class VP8PayloadDescriptor {
        public static final int TL0PICIDX_MASK = 255;
        public static final int EXTENDED_PICTURE_ID_MASK = Short.MAX_VALUE;
        private static final byte I_BIT = -128;
        private static final byte K_BIT = 16;
        private static final byte L_BIT = 64;
        private static final byte M_BIT = -128;
        public static final int MAX_LENGTH = 6;
        private static final byte S_BIT = 16;
        private static final byte T_BIT = 32;
        private static final byte X_BIT = -128;
        private static final byte N_BIT = 32;

        public static int getTemporalLayerIndex(byte[] buf, int off, int len) {
            if (buf == null || buf.length < off + len || len < 2) {
                return -1;
            }
            if ((buf[off] & 0xFFFFFF80) == 0 || (buf[off + 1] & 0x20) == 0) {
                return -1;
            }
            int sz = VP8PayloadDescriptor.getSize(buf, off, len);
            if (buf.length < off + sz || sz < 1) {
                return -1;
            }
            return (buf[off + sz - 1] & 0xC0) >> 6;
        }

        public static byte[] create(boolean startOfPartition) {
            byte[] pd = new byte[]{startOfPartition ? (byte)16 : 0};
            return pd;
        }

        public static int getSize(ByteArrayBuffer baf) {
            if (baf == null) {
                return -1;
            }
            return VP8PayloadDescriptor.getSize(baf.getBuffer(), baf.getOffset(), baf.getLength());
        }

        public static int getSize(byte[] input, int offset, int length) {
            if (!VP8PayloadDescriptor.isValid(input, offset, length)) {
                return -1;
            }
            if ((input[offset] & 0xFFFFFF80) == 0) {
                return 1;
            }
            int size = 2;
            if ((input[offset + 1] & 0xFFFFFF80) != 0) {
                ++size;
                if ((input[offset + 2] & 0xFFFFFF80) != 0) {
                    ++size;
                }
            }
            if ((input[offset + 1] & 0x40) != 0) {
                ++size;
            }
            if ((input[offset + 1] & 0x30) != 0) {
                ++size;
            }
            return size;
        }

        public static boolean hasPictureId(byte[] buf, int off, int len) {
            return VP8PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 0xFFFFFF80) != 0 && (buf[off + 1] & 0xFFFFFF80) != 0;
        }

        public static boolean hasExtendedPictureId(byte[] buf, int off, int len) {
            return VP8PayloadDescriptor.hasPictureId(buf, off, len) && (buf[off + 2] & 0xFFFFFF80) != 0;
        }

        public static int getPictureId(byte[] input, int offset) {
            boolean isLong;
            if (input == null || !VP8PayloadDescriptor.hasPictureId(input, offset, input.length - offset)) {
                return -1;
            }
            boolean bl = isLong = (input[offset + 2] & 0xFFFFFF80) != 0;
            if (isLong) {
                return (input[offset + 2] & 0x7F) << 8 | input[offset + 3] & 0xFF;
            }
            return input[offset + 2] & 0x7F;
        }

        public static boolean setExtendedPictureId(byte[] buf, int off, int len, int val) {
            if (!VP8PayloadDescriptor.hasExtendedPictureId(buf, off, len)) {
                return false;
            }
            buf[off + 2] = (byte)(0x80 | val >> 8 & 0x7F);
            buf[off + 3] = (byte)(val & 0xFF);
            return true;
        }

        public static boolean setTL0PICIDX(byte[] buf, int off, int len, int val) {
            if (!VP8PayloadDescriptor.isValid(buf, off, len) || (buf[off] & 0xFFFFFF80) == 0 || (buf[off + 1] & 0x40) == 0) {
                return false;
            }
            int offTL0PICIDX = 2;
            if ((buf[off + 1] & 0xFFFFFF80) != 0) {
                ++offTL0PICIDX;
                if ((buf[off + 2] & 0xFFFFFF80) != 0) {
                    ++offTL0PICIDX;
                }
            }
            buf[off + offTL0PICIDX] = (byte)val;
            return true;
        }

        public static boolean isValid(byte[] buf, int off, int len) {
            return buf != null && buf.length >= off + len && off > -1 && len > 0;
        }

        public static boolean isStartOfPartition(byte[] input, int offset) {
            return (input[offset] & 0x10) != 0;
        }

        public static boolean isStartOfFrame(byte[] input, int offset) {
            return VP8PayloadDescriptor.isStartOfPartition(input, offset) && VP8PayloadDescriptor.getPartitionId(input, offset) == 0;
        }

        public static int getPartitionId(byte[] input, int offset) {
            return input[offset] & 7;
        }

        public static boolean isReference(byte[] buf, int off, int len) {
            return (buf[off] & 0x20) == 0;
        }

        public static int getTL0PICIDX(byte[] buf, int off, int len) {
            int sz = VP8PayloadDescriptor.getSize(buf, off, len);
            if (sz < 1) {
                return -1;
            }
            return buf[off + sz - 2] & 0xFF;
        }
    }
}

