/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.utils.ArrayUtils;
import org.jitsi.utils.MediaType;

public class MediaStreamTrackDesc {
    private final RTPEncodingDesc[] rtpEncodings;
    private final MediaStreamTrackReceiver mediaStreamTrackReceiver;
    private final String owner;

    public MediaStreamTrackDesc(MediaStreamTrackReceiver mediaStreamTrackReceiver, RTPEncodingDesc[] rtpEncodings) {
        this(mediaStreamTrackReceiver, rtpEncodings, null);
    }

    public MediaStreamTrackDesc(MediaStreamTrackReceiver mediaStreamTrackReceiver, RTPEncodingDesc[] rtpEncodings, String owner) {
        this.rtpEncodings = rtpEncodings;
        this.mediaStreamTrackReceiver = mediaStreamTrackReceiver;
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public MediaType getMediaType() {
        return this.getMediaStreamTrackReceiver().getStream().getMediaType();
    }

    public RTPEncodingDesc[] getRTPEncodings() {
        return this.rtpEncodings;
    }

    public MediaStreamTrackReceiver getMediaStreamTrackReceiver() {
        return this.mediaStreamTrackReceiver;
    }

    public long getBps(int idx) {
        if (ArrayUtils.isNullOrEmpty((Object[])this.rtpEncodings)) {
            return 0L;
        }
        if (idx > -1) {
            long nowMs = System.currentTimeMillis();
            for (int i = idx; i > -1; --i) {
                long bps = this.rtpEncodings[i].getLastStableBitrateBps(nowMs);
                if (bps <= 0L) continue;
                return bps;
            }
        }
        return 0L;
    }

    RTPEncodingDesc findRTPEncodingDesc(RawPacket pkt) {
        if (ArrayUtils.isNullOrEmpty((Object[])this.rtpEncodings)) {
            return null;
        }
        for (RTPEncodingDesc encoding : this.rtpEncodings) {
            if (!encoding.matches(pkt)) continue;
            return encoding;
        }
        return null;
    }

    RTPEncodingDesc findRTPEncodingDesc(long ssrc) {
        if (ArrayUtils.isNullOrEmpty((Object[])this.rtpEncodings)) {
            return null;
        }
        for (RTPEncodingDesc encoding : this.rtpEncodings) {
            if (!encoding.matches(ssrc)) continue;
            return encoding;
        }
        return null;
    }

    public boolean matches(long ssrc) {
        return this.rtpEncodings[0].getPrimarySSRC() == ssrc;
    }
}

