/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack;

import java.io.EOFException;
import java.net.SocketException;
import org.dom4j.Element;
import org.dom4j.io.XPPPacketReader;
import org.jivesoftware.whack.ExternalComponent;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;
import org.xmpp.packet.Roster;

class SocketReadThread
extends Thread {
    private ExternalComponent component;
    private boolean shutdown = false;
    XPPPacketReader reader = null;

    public SocketReadThread(ExternalComponent component, XPPPacketReader reader) {
        super("Component socket reader");
        this.component = component;
        this.reader = reader;
    }

    public void run() {
        try {
            this.readStream();
        }
        catch (EOFException eOFException) {
        }
        catch (SocketException se) {
            if (!this.shutdown) {
                this.component.getManager().getLog().error(se);
                this.component.connectionLost();
            }
        }
        catch (XmlPullParserException ie) {
            this.component.getManager().getLog().error(ie);
        }
        catch (Exception e) {
            this.component.getManager().getLog().warn(e);
        }
    }

    private void readStream() throws Exception {
        while (!this.shutdown) {
            Message packet;
            Element doc = this.reader.parseDocument().getRootElement();
            if (doc == null) {
                return;
            }
            String tag = doc.getName();
            if ("message".equals(tag)) {
                packet = new Message(doc);
            } else if ("presence".equals(tag)) {
                packet = new Presence(doc);
            } else if ("iq".equals(tag)) {
                packet = this.getIQ(doc);
            } else {
                throw new XmlPullParserException("Unknown packet type was read: " + tag);
            }
            this.component.processPacket((Packet)packet);
        }
    }

    private IQ getIQ(Element doc) {
        Element query = doc.element("query");
        if (query != null && "jabber:iq:roster".equals(query.getNamespaceURI())) {
            return new Roster(doc);
        }
        return new IQ(doc);
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

