/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.ddclient;

import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDClient;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.ConfigUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    public static final String DDCLIENT_PREFIX_PNAME = "org.jitsi.ddclient.prefix";
    public static final String DDCLIENT_HOST_PNAME = "org.jitsi.ddclient.host";
    public static final String DDCLIENT_PORT_PNAME = "org.jitsi.ddclient.port";
    private static final String DEFAULT_PREFIX = "";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8125;
    private StatsDClient client;
    private ServiceRegistration<StatsDClient> serviceRegistration;
    protected ConfigurationService cfg;

    public void start(BundleContext context) throws Exception {
        if (this.client != null) {
            return;
        }
        this.cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)context, ConfigurationService.class);
        String prefix = ConfigUtils.getString((ConfigurationService)this.cfg, (String)DDCLIENT_PREFIX_PNAME, (String)DEFAULT_PREFIX);
        if (prefix.isEmpty()) {
            return;
        }
        String host = ConfigUtils.getString((ConfigurationService)this.cfg, (String)DDCLIENT_HOST_PNAME, (String)DEFAULT_HOST);
        int port = ConfigUtils.getInt((ConfigurationService)this.cfg, (String)DDCLIENT_PORT_PNAME, (int)8125);
        this.client = new NonBlockingStatsDClient(prefix, host, port);
        this.serviceRegistration = context.registerService(StatsDClient.class, (Object)this.client, null);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        if (this.client != null) {
            this.client.stop();
            this.client = null;
        }
    }
}

