/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rest;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.sip.communicator.util.ServiceUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.jitsi.service.version.Version;
import org.jitsi.service.version.VersionService;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.json.simple.JSONObject;
import org.osgi.framework.BundleContext;

public abstract class AbstractJSONHandler
extends AbstractHandler {
    private static final String DEFAULT_JSON_TARGET = null;
    protected static final String GET_HTTP_METHOD = "GET";
    private static final String HEALTH_TARGET = "/about/health";
    protected static final String PATCH_HTTP_METHOD = "PATCH";
    protected static final String POST_HTTP_METHOD = "POST";
    private static final String VERSION_TARGET = "/about/version";
    protected final BundleContext bundleContext;
    private final String jsonTarget;

    protected static int getHttpStatusCodeForResultIq(IQ responseIQ) {
        XMPPError.Condition condition = responseIQ.getError().getCondition();
        if (XMPPError.Condition.not_authorized.equals((Object)condition)) {
            return 401;
        }
        if (XMPPError.Condition.service_unavailable.equals((Object)condition)) {
            return 503;
        }
        return 500;
    }

    protected AbstractJSONHandler(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        String jsonTarget = DEFAULT_JSON_TARGET;
        if (jsonTarget != null && !jsonTarget.startsWith(".")) {
            jsonTarget = "." + jsonTarget;
        }
        this.jsonTarget = jsonTarget;
    }

    protected void beginResponse(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
        this.beginResponse(target, baseRequest, request, response, "application/json;charset=UTF-8");
    }

    protected void beginResponse(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response, String contentType) {
        response.setContentType(contentType);
        response.setHeader("Access-Control-Allow-Origin", "*");
    }

    protected void doGetHealthJSON(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    protected void doGetVersionJSON(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VersionService versionService;
        this.beginResponse(null, baseRequest, request, response);
        BundleContext bundleContext = this.getBundleContext();
        int status = 503;
        if (bundleContext != null && (versionService = (VersionService)ServiceUtils.getService((BundleContext)bundleContext, VersionService.class)) != null) {
            Version version = versionService.getCurrentVersion();
            JSONObject versionJSONObject = new JSONObject();
            versionJSONObject.put((Object)"name", (Object)version.getApplicationName());
            versionJSONObject.put((Object)"version", (Object)version.toString());
            versionJSONObject.put((Object)"os", (Object)System.getProperty("os.name"));
            PrintWriter writer = response.getWriter();
            status = 200;
            response.setStatus(200);
            versionJSONObject.writeJSONString((Writer)writer);
        }
        if (response.getStatus() != status) {
            response.setStatus(status);
        }
        this.endResponse(null, baseRequest, request, response);
    }

    protected void endResponse(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
        if (!baseRequest.isHandled()) {
            if (response.getStatus() == 0) {
                response.setStatus(404);
            }
            baseRequest.setHandled(true);
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public <T> T getService(Class<T> serviceClass) {
        BundleContext bundleContext = this.getBundleContext();
        Object service = bundleContext == null ? null : ServiceUtils.getService((BundleContext)bundleContext, serviceClass);
        return (T)service;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (target != null) {
            int jsonTargetLength;
            int n = jsonTargetLength = this.jsonTarget == null ? 0 : this.jsonTarget.length();
            if (jsonTargetLength == 0 || target.endsWith(this.jsonTarget)) {
                target = target.substring(0, target.length() - jsonTargetLength);
                this.handleJSON(target, baseRequest, request, response);
            }
        }
    }

    protected void handleHealthJSON(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (GET_HTTP_METHOD.equals(request.getMethod())) {
            this.doGetHealthJSON(baseRequest, request, response);
        } else {
            response.setStatus(405);
        }
    }

    protected void handleJSON(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (HEALTH_TARGET.equals(target)) {
            target = target.substring(HEALTH_TARGET.length());
            this.handleHealthJSON(target, baseRequest, request, response);
        } else if (VERSION_TARGET.equals(target)) {
            target = target.substring(VERSION_TARGET.length());
            this.handleVersionJSON(target, baseRequest, request, response);
        }
    }

    protected void handleVersionJSON(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (GET_HTTP_METHOD.equals(request.getMethod())) {
            this.doGetVersionJSON(baseRequest, request, response);
        } else {
            response.setStatus(405);
        }
    }
}

