/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.jitsi.impl.neomedia.codec.REDBlock;
import org.jitsi.utils.logging.Logger;

public class REDBlockIterator
implements Iterator<REDBlock> {
    private static final Logger logger = Logger.getLogger(REDBlockIterator.class);
    private final byte[] buffer;
    private final int offset;
    private final int length;
    private int cntRemainingBlocks = -1;
    private int offNextBlockHeader = -1;
    private int offNextBlockPayload = -1;

    public static REDBlock matchFirst(Predicate<REDBlock> predicate, byte[] buffer, int offset, int length) {
        if (REDBlockIterator.isMultiBlock(buffer, offset, length)) {
            REDBlockIterator it = new REDBlockIterator(buffer, offset, length);
            while (it.hasNext()) {
                REDBlock b = it.next();
                if (b == null || !predicate.test(b)) continue;
                return b;
            }
            return null;
        }
        REDBlock b = REDBlockIterator.getPrimaryBlock(buffer, offset, length);
        if (b != null && predicate.test(b)) {
            return b;
        }
        return null;
    }

    public static REDBlock getPrimaryBlock(byte[] buffer, int offset, int length) {
        if (REDBlockIterator.isMultiBlock(buffer, offset, length)) {
            REDBlock block = null;
            REDBlockIterator redBlockIterator = new REDBlockIterator(buffer, offset, length);
            while (redBlockIterator.hasNext()) {
                block = redBlockIterator.next();
            }
            if (block == null) {
                logger.warn((Object)"No primary block found.");
            }
            return block;
        }
        if (buffer == null || offset < 0 || length < 1 || buffer.length < offset + length) {
            logger.warn((Object)("Prevented an array out of bounds exception. offset: " + offset + ", length: " + length));
            return null;
        }
        byte blockPT = (byte)(buffer[offset] & 0x7F);
        int blockOff = offset + 1;
        int blockLen = length - 1;
        return new REDBlock(buffer, blockOff, blockLen, blockPT);
    }

    public static boolean isMultiBlock(byte[] buffer, int offset, int length) {
        if (buffer == null || buffer.length == 0) {
            logger.warn((Object)"The buffer appears to be empty.");
            return false;
        }
        if (offset < 0 || buffer.length <= offset) {
            logger.warn((Object)"Prevented array out of bounds exception.");
            return false;
        }
        return (buffer[offset] & 0x80) != 0;
    }

    public REDBlockIterator(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        this.initialize();
    }

    @Override
    public boolean hasNext() {
        return this.cntRemainingBlocks > 0;
    }

    @Override
    public REDBlock next() {
        int blockLen;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        --this.cntRemainingBlocks;
        if (this.buffer == null || this.buffer.length <= this.offNextBlockHeader) {
            logger.warn((Object)"Prevented an array out of bounds exception.");
            return null;
        }
        byte blockPT = (byte)(this.buffer[this.offNextBlockHeader] & 0x7F);
        if (this.hasNext()) {
            if (this.buffer.length < this.offNextBlockHeader + 4) {
                logger.warn((Object)"Prevented an array out of bounds exception.");
                return null;
            }
            blockLen = (this.buffer[this.offNextBlockHeader + 2] & 3) << 8 | this.buffer[this.offNextBlockHeader + 3] & 0xFF;
            this.offNextBlockHeader += 4;
            this.offNextBlockPayload += blockLen;
        } else {
            blockLen = this.length - (this.offNextBlockPayload + 1);
            this.offNextBlockHeader = -1;
            this.offNextBlockPayload = -1;
        }
        return new REDBlock(this.buffer, this.offNextBlockPayload, blockLen, blockPT);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void initialize() {
        if (this.buffer == null || this.buffer.length == 0) {
            return;
        }
        this.offNextBlockHeader = this.offset;
        this.cntRemainingBlocks = 0;
        while ((this.buffer[this.offNextBlockHeader] & 0x80) != 0) {
            ++this.cntRemainingBlocks;
            this.offNextBlockHeader += 4;
        }
        if (this.buffer.length >= this.offNextBlockHeader + 8) {
            ++this.cntRemainingBlocks;
        }
        this.offNextBlockHeader = this.offset;
        if (this.cntRemainingBlocks > 0) {
            this.offNextBlockPayload = this.offNextBlockHeader + (this.cntRemainingBlocks - 1) * 4 + 1;
        }
    }
}

