/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.PlugInManager;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.HResultException;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.IMMNotificationClient;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.MMNotificationClient;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.NativelySupportedAudioFormat;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.VoiceCaptureDSP;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.WASAPI;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.WASAPIRenderer;
import org.jitsi.service.neomedia.codec.Constants;
import org.jitsi.utils.logging.Logger;

public class WASAPISystem
extends AudioSystem {
    private static String audioSessionGuid;
    public static final long DEFAULT_BUFFER_DURATION = 20L;
    public static final long DEFAULT_DEVICE_PERIOD = 10L;
    private static final String LOCATOR_PROTOCOL = "wasapi";
    private static final Logger logger;
    private long aecIMediaObject;
    private List<AudioFormat> aecSupportedFormats;
    private long iMMDeviceEnumerator;
    private IMMNotificationClient pNotify;
    private long waveformatex;

    public static int CoInitializeEx() throws HResultException {
        int hr;
        try {
            hr = WASAPI.CoInitializeEx(0L, 0);
        }
        catch (HResultException hre) {
            hr = hre.getHResult();
            switch (hr) {
                case -2147417850: {
                    hr = 1;
                }
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw hre;
                }
            }
        }
        return hr;
    }

    public static AudioFormat[] getFormatsToInitializeIAudioClient(AudioFormat format) {
        int channels;
        switch (format.getChannels()) {
            case 1: {
                channels = 2;
                break;
            }
            case 2: {
                channels = 1;
                break;
            }
            default: {
                return new AudioFormat[]{format};
            }
        }
        return new AudioFormat[]{format, new AudioFormat(format.getEncoding(), format.getSampleRate(), format.getSampleSizeInBits(), channels, 0, 1, -1, -1.0, format.getDataType())};
    }

    public static int getSampleSizeInBytes(AudioFormat format) {
        int sampleSizeInBits = format.getSampleSizeInBits();
        switch (sampleSizeInBits) {
            case 8: {
                return 1;
            }
            case 16: {
                return 2;
            }
        }
        return sampleSizeInBits / 8;
    }

    public static void WAVEFORMATEX_fill(long waveformatex, AudioFormat audioFormat) {
        if (!"LINEAR".equals(audioFormat.getEncoding())) {
            throw new IllegalArgumentException("audioFormat.encoding");
        }
        int channels = audioFormat.getChannels();
        if (channels == -1) {
            throw new IllegalArgumentException("audioFormat.channels");
        }
        int sampleRate = (int)audioFormat.getSampleRate();
        if (sampleRate == -1) {
            throw new IllegalArgumentException("audioFormat.sampleRate");
        }
        int sampleSizeInBits = audioFormat.getSampleSizeInBits();
        if (sampleSizeInBits == -1) {
            throw new IllegalArgumentException("audioFormat.sampleSizeInBits");
        }
        char nBlockAlign = (char)(channels * sampleSizeInBits / 8);
        WASAPI.WAVEFORMATEX_fill(waveformatex, '\u0001', (char)channels, sampleRate, sampleRate * nBlockAlign, nBlockAlign, (char)sampleSizeInBits, '\u0000');
    }

    WASAPISystem() throws Exception {
        super(LOCATOR_PROTOCOL, 31);
    }

    private void configureSupportedFormats(int dataFlow, List<AudioFormat> formats) {
        switch (dataFlow) {
            case 1: {
                List<AudioFormat> aecSupportedFormats = this.getAECSupportedFormats();
                if (aecSupportedFormats.isEmpty()) break;
                for (AudioFormat format : aecSupportedFormats) {
                    if (formats.contains(format)) continue;
                    formats.add(format);
                }
                break;
            }
            case 0: {
                int count = formats.size();
                for (int i = 0; i < count; ++i) {
                    AudioFormat outFormat = formats.get(i);
                    AudioFormat inFormat = new AudioFormat("LINEAR", -1.0, -1, outFormat.getChannels(), AbstractAudioRenderer.NATIVE_AUDIO_FORMAT_ENDIAN, 1, -1, -1.0, Format.byteArray);
                    Vector classNames = PlugInManager.getPlugInList((Format)inFormat, (Format)outFormat, (int)2);
                    if (classNames == null || classNames.isEmpty()) continue;
                    for (String className : classNames) {
                        try {
                            Codec codec = (Codec)Class.forName(className).newInstance();
                            Format[] inFormats = codec.getSupportedInputFormats();
                            if (inFormats == null) continue;
                            for (Format aInFormat : inFormats) {
                                if (!(aInFormat instanceof AudioFormat) || !inFormat.matches(aInFormat)) continue;
                                Format[] outFormats = codec.getSupportedOutputFormats(aInFormat);
                                boolean add = false;
                                if (outFormats != null) {
                                    for (Format aOutFormat : outFormats) {
                                        if (!outFormat.matches(aOutFormat)) continue;
                                        add = true;
                                        break;
                                    }
                                }
                                if (!add || formats.contains(aInFormat)) continue;
                                formats.add((AudioFormat)aInFormat);
                            }
                        }
                        catch (Throwable t) {
                            if (!(t instanceof ThreadDeath)) continue;
                            throw (ThreadDeath)t;
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("dataFlow");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInitialize() throws Exception {
        ArrayList<CaptureDeviceInfo2> playbackDevices;
        ArrayList<CaptureDeviceInfo2> captureDevices;
        WASAPISystem wASAPISystem = this;
        synchronized (wASAPISystem) {
            block20: {
                long iMMDeviceCollection;
                WASAPISystem.CoInitializeEx();
                if (this.iMMDeviceEnumerator == 0L) {
                    this.iMMDeviceEnumerator = WASAPI.CoCreateInstance("{bcde0395-e52f-467c-8e3d-c4579291692e}", 0L, 23, "{a95664d2-9614-4f35-a746-de8db63617e6}");
                    if (this.iMMDeviceEnumerator == 0L) {
                        throw new IllegalStateException("iMMDeviceEnumerator");
                    }
                    MMNotificationClient.RegisterEndpointNotificationCallback(this.pNotify);
                }
                if ((iMMDeviceCollection = WASAPI.IMMDeviceEnumerator_EnumAudioEndpoints(this.iMMDeviceEnumerator, 2, 1)) == 0L) {
                    throw new RuntimeException("IMMDeviceEnumerator_EnumAudioEndpoints");
                }
                try {
                    int count = WASAPI.IMMDeviceCollection_GetCount(iMMDeviceCollection);
                    captureDevices = new ArrayList<CaptureDeviceInfo2>(count);
                    playbackDevices = new ArrayList<CaptureDeviceInfo2>(count);
                    if (count <= 0) break block20;
                    this.maybeInitializeAEC();
                    try {
                        for (int i = 0; i < count; ++i) {
                            long iMMDevice = WASAPI.IMMDeviceCollection_Item(iMMDeviceCollection, i);
                            if (iMMDevice == 0L) {
                                throw new RuntimeException("IMMDeviceCollection_Item");
                            }
                            try {
                                this.doInitializeIMMDevice(iMMDevice, captureDevices, playbackDevices);
                                continue;
                            }
                            catch (Throwable t) {
                                if (t instanceof ThreadDeath) {
                                    throw (ThreadDeath)t;
                                }
                                logger.error((Object)("Failed to doInitialize for IMMDevice at index " + i), t);
                                continue;
                            }
                            finally {
                                WASAPI.IMMDevice_Release(iMMDevice);
                            }
                        }
                    }
                    finally {
                        this.maybeUninitializeAEC();
                    }
                }
                finally {
                    WASAPI.IMMDeviceCollection_Release(iMMDeviceCollection);
                }
            }
        }
        this.setCaptureDevices(captureDevices);
        this.setPlaybackDevices(playbackDevices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitializeIMMDevice(long iMMDevice, List<CaptureDeviceInfo2> captureDevices, List<CaptureDeviceInfo2> playbackDevices) throws HResultException {
        List<AudioFormat> formats;
        String id = WASAPI.IMMDevice_GetId(iMMDevice);
        if (id == null) {
            throw new RuntimeException("IMMDevice_GetId");
        }
        long iAudioClient = WASAPI.IMMDevice_Activate(iMMDevice, "{1cb9ad4c-dbfa-4c32-b178-c2f568a703b2}", 23, 0L);
        if (iAudioClient == 0L) {
            throw new RuntimeException("IMMDevice_Activate");
        }
        try {
            formats = this.getIAudioClientSupportedFormats(iAudioClient);
        }
        finally {
            WASAPI.IAudioClient_Release(iAudioClient);
        }
        if (formats != null && !formats.isEmpty()) {
            List<CaptureDeviceInfo2> devices;
            String name = null;
            try {
                name = this.getIMMDeviceFriendlyName(iMMDevice);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.warn((Object)("Failed to retrieve the PKEY_Device_FriendlyName of IMMDevice " + id), t);
            }
            if (name == null || name.length() == 0) {
                name = id;
            }
            int dataFlow = this.getIMMDeviceDataFlow(iMMDevice);
            switch (dataFlow) {
                case 1: {
                    devices = captureDevices;
                    break;
                }
                case 0: {
                    devices = playbackDevices;
                    break;
                }
                default: {
                    devices = null;
                    logger.error((Object)("Failed to retrieve dataFlow from IMMEndpoint " + id));
                }
            }
            if (devices != null) {
                this.configureSupportedFormats(dataFlow, formats);
                if (!formats.isEmpty()) {
                    CaptureDeviceInfo2 cdi2 = new CaptureDeviceInfo2(name, new MediaLocator("wasapi:" + id), formats.toArray(new Format[formats.size()]), id, null, null);
                    devices.add(cdi2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            WASAPISystem wASAPISystem = this;
            synchronized (wASAPISystem) {
                if (this.iMMDeviceEnumerator != 0L) {
                    WASAPI.IMMDeviceEnumerator_Release(this.iMMDeviceEnumerator);
                    this.iMMDeviceEnumerator = 0L;
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    public List<AudioFormat> getAECSupportedFormats() {
        List<Object> aecSupportedFormats = this.aecSupportedFormats;
        if (aecSupportedFormats == null) {
            aecSupportedFormats = Collections.emptyList();
        }
        return aecSupportedFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AudioFormat> getIAudioClientSupportedFormats(long iAudioClient) throws HResultException {
        char cbSize = '\u0000';
        ArrayList<AudioFormat> supportedFormats = new ArrayList<AudioFormat>();
        for (char nChannels = '\u0001'; nChannels <= '\u0002'; nChannels = (char)((char)(nChannels + 1))) {
            for (int i = 0; i < Constants.AUDIO_SAMPLE_RATES.length; ++i) {
                int nSamplesPerSec = (int)Constants.AUDIO_SAMPLE_RATES[i];
                for (char wBitsPerSample = '\u0010'; wBitsPerSample > '\u0000'; wBitsPerSample = (char)(wBitsPerSample - 8)) {
                    char nBlockAlign = (char)(nChannels * wBitsPerSample / 8);
                    WASAPI.WAVEFORMATEX_fill(this.waveformatex, '\u0001', nChannels, nSamplesPerSec, nSamplesPerSec * nBlockAlign, nBlockAlign, wBitsPerSample, cbSize);
                    long pClosestMatch = WASAPI.IAudioClient_IsFormatSupported(iAudioClient, 0, this.waveformatex);
                    if (pClosestMatch == 0L) continue;
                    try {
                        NativelySupportedAudioFormat supportedFormat;
                        if (pClosestMatch != this.waveformatex) {
                            if (WASAPI.WAVEFORMATEX_getWFormatTag(pClosestMatch) != '\u0001') continue;
                            nChannels = WASAPI.WAVEFORMATEX_getNChannels(pClosestMatch);
                            nSamplesPerSec = WASAPI.WAVEFORMATEX_getNSamplesPerSec(pClosestMatch);
                            wBitsPerSample = WASAPI.WAVEFORMATEX_getWBitsPerSample(pClosestMatch);
                        }
                        if (nChannels == '\u0002' && !supportedFormats.contains((Object)(supportedFormat = new NativelySupportedAudioFormat("LINEAR", nSamplesPerSec, wBitsPerSample, 1, AbstractAudioRenderer.NATIVE_AUDIO_FORMAT_ENDIAN, 1, -1, -1.0, Format.byteArray)))) {
                            supportedFormats.add(supportedFormat);
                        }
                        if (supportedFormats.contains((Object)(supportedFormat = new NativelySupportedAudioFormat("LINEAR", nSamplesPerSec, wBitsPerSample, nChannels, AbstractAudioRenderer.NATIVE_AUDIO_FORMAT_ENDIAN, 1, -1, -1.0, Format.byteArray)))) continue;
                        supportedFormats.add(supportedFormat);
                        continue;
                    }
                    finally {
                        if (pClosestMatch != this.waveformatex) {
                            WASAPI.CoTaskMemFree(pClosestMatch);
                        }
                    }
                }
            }
        }
        return supportedFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AudioFormat> getIMediaObjectSupportedFormats(long iMediaObject) throws HResultException {
        ArrayList<AudioFormat> supportedFormats = new ArrayList<AudioFormat>();
        long pmt = VoiceCaptureDSP.MoCreateMediaType(0);
        if (pmt == 0L) {
            throw new OutOfMemoryError("MoCreateMediaType");
        }
        try {
            char cbSize = '\u0000';
            int cbFormat = WASAPI.WAVEFORMATEX_sizeof() + cbSize;
            int hresult = VoiceCaptureDSP.DMO_MEDIA_TYPE_fill(pmt, "{73647561-0000-0010-8000-00aa00389b71}", "{00000001-0000-0010-8000-00AA00389B71}", true, false, 0, "{05589f81-c356-11ce-bf01-00aa0055595a}", 0L, cbFormat, this.waveformatex);
            if (WASAPI.FAILED(hresult)) {
                throw new HResultException(hresult, "DMO_MEDIA_TYPE_fill");
            }
            for (char nChannels = '\u0001'; nChannels <= '\u0002'; nChannels = (char)((char)(nChannels + 1))) {
                for (int i = 0; i < Constants.AUDIO_SAMPLE_RATES.length; ++i) {
                    int nSamplesPerSec = (int)Constants.AUDIO_SAMPLE_RATES[i];
                    for (char wBitsPerSample = '\u0010'; wBitsPerSample > '\u0000'; wBitsPerSample = (char)(wBitsPerSample - 8)) {
                        AudioFormat supportedFormat;
                        char nBlockAlign = (char)(nChannels * wBitsPerSample / 8);
                        WASAPI.WAVEFORMATEX_fill(this.waveformatex, '\u0001', nChannels, nSamplesPerSec, nSamplesPerSec * nBlockAlign, nBlockAlign, wBitsPerSample, cbSize);
                        VoiceCaptureDSP.DMO_MEDIA_TYPE_setLSampleSize(pmt, wBitsPerSample / 8);
                        try {
                            hresult = VoiceCaptureDSP.IMediaObject_SetOutputType(iMediaObject, 0, pmt, 1);
                        }
                        catch (HResultException hre) {
                            hresult = hre.getHResult();
                        }
                        if (0 != hresult || supportedFormats.contains(supportedFormat = new AudioFormat("LINEAR", (double)nSamplesPerSec, (int)wBitsPerSample, (int)nChannels, AbstractAudioRenderer.NATIVE_AUDIO_FORMAT_ENDIAN, 1, -1, -1.0, Format.byteArray))) continue;
                        supportedFormats.add(supportedFormat);
                    }
                }
            }
        }
        finally {
            VoiceCaptureDSP.DMO_MEDIA_TYPE_setCbFormat(pmt, 0);
            VoiceCaptureDSP.DMO_MEDIA_TYPE_setFormattype(pmt, "{0f6417d6-c318-11d0-a43f-00a0c9223196}");
            VoiceCaptureDSP.DMO_MEDIA_TYPE_setPbFormat(pmt, 0L);
            VoiceCaptureDSP.MoDeleteMediaType(pmt);
        }
        return supportedFormats;
    }

    public synchronized long getIMMDevice(String id) throws HResultException {
        long iMMDeviceEnumerator = this.iMMDeviceEnumerator;
        if (iMMDeviceEnumerator == 0L) {
            throw new IllegalStateException("iMMDeviceEnumerator");
        }
        return WASAPI.IMMDeviceEnumerator_GetDevice(iMMDeviceEnumerator, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIMMDeviceDataFlow(long iMMDevice) throws HResultException {
        int dataFlow;
        long iMMEndpoint = WASAPI.IMMDevice_QueryInterface(iMMDevice, "{1be09788-6894-4089-8586-9a2a6c265ac5}");
        if (iMMEndpoint == 0L) {
            throw new RuntimeException("IMMDevice_QueryInterface");
        }
        try {
            dataFlow = WASAPI.IMMEndpoint_GetDataFlow(iMMEndpoint);
        }
        finally {
            WASAPI.IMMEndpoint_Release(iMMEndpoint);
        }
        switch (dataFlow) {
            case 0: 
            case 1: 
            case 2: {
                return dataFlow;
            }
        }
        throw new RuntimeException("IMMEndpoint_GetDataFlow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIMMDeviceFriendlyName(long iMMDevice) throws HResultException {
        String deviceFriendlyName;
        long iPropertyStore = WASAPI.IMMDevice_OpenPropertyStore(iMMDevice, 0);
        if (iPropertyStore == 0L) {
            throw new RuntimeException("IMMDevice_OpenPropertyStore");
        }
        try {
            deviceFriendlyName = WASAPI.IPropertyStore_GetString(iPropertyStore, WASAPI.PKEY_Device_FriendlyName);
        }
        finally {
            WASAPI.IPropertyStore_Release(iPropertyStore);
        }
        return deviceFriendlyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getIMMDeviceIndex(String id, int dataFlow) throws HResultException {
        int iMMDeviceIndex;
        block10: {
            long iMMDeviceEnumerator = this.iMMDeviceEnumerator;
            if (iMMDeviceEnumerator == 0L) {
                throw new IllegalStateException("iMMDeviceEnumerator");
            }
            long iMMDeviceCollection = WASAPI.IMMDeviceEnumerator_EnumAudioEndpoints(iMMDeviceEnumerator, dataFlow, 1);
            if (iMMDeviceCollection == 0L) {
                throw new RuntimeException("IMMDeviceEnumerator_EnumAudioEndpoints");
            }
            iMMDeviceIndex = -1;
            try {
                int count = WASAPI.IMMDeviceCollection_GetCount(iMMDeviceCollection);
                if (count <= 0) break block10;
                for (int i = 0; i < count; ++i) {
                    String iMMDeviceID;
                    long iMMDevice = WASAPI.IMMDeviceCollection_Item(iMMDeviceCollection, i);
                    if (iMMDevice == 0L) {
                        throw new RuntimeException("IMMDeviceCollection_Item");
                    }
                    try {
                        iMMDeviceID = WASAPI.IMMDevice_GetId(iMMDevice);
                    }
                    finally {
                        WASAPI.IMMDevice_Release(iMMDevice);
                    }
                    if (!id.equalsIgnoreCase(iMMDeviceID)) continue;
                    iMMDeviceIndex = i;
                    break;
                }
            }
            finally {
                WASAPI.IMMDeviceCollection_Release(iMMDeviceCollection);
            }
        }
        return iMMDeviceIndex;
    }

    @Override
    protected String getRendererClassName() {
        return WASAPIRenderer.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long initializeAEC() throws Exception {
        long iMediaObject = 0L;
        long iPropertyStore = 0L;
        long aecIMediaObject = 0L;
        WASAPISystem.CoInitializeEx();
        try {
            iMediaObject = WASAPI.CoCreateInstance("{745057c7-f353-4f2d-a7ee-58434477730e}", 0L, 23, "{d8ad0f58-5494-4102-97c5-ec798e59bcf4}");
            if (iMediaObject == 0L) {
                throw new RuntimeException("CoCreateInstance");
            }
            iPropertyStore = VoiceCaptureDSP.IMediaObject_QueryInterface(iMediaObject, "{886d8eeb-8cf2-4446-8d02-cdba1dbdcf99}");
            if (iPropertyStore == 0L) {
                throw new RuntimeException("IMediaObject_QueryInterface");
            }
            int hresult = VoiceCaptureDSP.IPropertyStore_SetValue(iPropertyStore, VoiceCaptureDSP.MFPKEY_WMAAECMA_SYSTEM_MODE, 0);
            if (WASAPI.FAILED(hresult)) {
                throw new HResultException(hresult, "IPropertyStore_SetValue MFPKEY_WMAAECMA_SYSTEM_MODE");
            }
            aecIMediaObject = iMediaObject;
            iMediaObject = 0L;
        }
        finally {
            if (iPropertyStore != 0L) {
                WASAPI.IPropertyStore_Release(iPropertyStore);
            }
            if (iMediaObject != 0L) {
                VoiceCaptureDSP.IMediaObject_Release(iMediaObject);
            }
        }
        return aecIMediaObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long initializeIAudioClient(MediaLocator locator, AudioSystem.DataFlow dataFlow, int streamFlags, long eventHandle, long hnsBufferDuration, AudioFormat[] formats) throws HResultException {
        WASAPISystem.CoInitializeEx();
        String id = locator.getRemainder();
        long iMMDevice = this.getIMMDevice(id);
        if (iMMDevice == 0L) {
            throw new RuntimeException("Failed to retrieve audio endpoint device with endpoint ID string " + id);
        }
        long ret = 0L;
        try {
            int iMMDeviceDataFlow = this.getIMMDeviceDataFlow(iMMDevice);
            switch (dataFlow) {
                case CAPTURE: {
                    if (iMMDeviceDataFlow == 2 || iMMDeviceDataFlow == 1) break;
                    throw new IllegalArgumentException("dataFlow");
                }
                case NOTIFY: 
                case PLAYBACK: {
                    if (iMMDeviceDataFlow == 2 || iMMDeviceDataFlow == 0) break;
                    throw new IllegalArgumentException("dataFlow");
                }
            }
            long iAudioClient = WASAPI.IMMDevice_Activate(iMMDevice, "{1cb9ad4c-dbfa-4c32-b178-c2f568a703b2}", 23, 0L);
            if (iAudioClient == 0L) {
                throw new RuntimeException("IMMDevice_Activate");
            }
            try {
                long waveformatex = WASAPI.WAVEFORMATEX_alloc();
                if (waveformatex == 0L) {
                    throw new OutOfMemoryError("WAVEFORMATEX_alloc");
                }
                try {
                    int hresult;
                    int shareMode = 0;
                    int waveformatexIsInitialized = -1;
                    for (int i = 0; i < formats.length; ++i) {
                        WASAPISystem.WAVEFORMATEX_fill(waveformatex, formats[i]);
                        long pClosestMatch = WASAPI.IAudioClient_IsFormatSupported(iAudioClient, shareMode, waveformatex);
                        if (pClosestMatch == 0L) continue;
                        try {
                            if (pClosestMatch != waveformatex) continue;
                            waveformatexIsInitialized = i;
                            break;
                        }
                        finally {
                            if (pClosestMatch != waveformatex) {
                                WASAPI.CoTaskMemFree(pClosestMatch);
                            }
                        }
                    }
                    if (waveformatexIsInitialized < 0 || waveformatexIsInitialized >= formats.length) {
                        this.logUnsupportedFormats(dataFlow, locator, (Format[])formats);
                        throw new IllegalArgumentException("formats");
                    }
                    Arrays.fill(formats, 0, waveformatexIsInitialized, null);
                    streamFlags |= 0x80000;
                    if (eventHandle != 0L) {
                        streamFlags |= 0x40000;
                    }
                    if (hnsBufferDuration == -1L && (hnsBufferDuration = WASAPI.IAudioClient_GetDefaultDevicePeriod(iAudioClient) / 10000L) <= 1L) {
                        hnsBufferDuration = 10L;
                    }
                    if ((hresult = WASAPI.IAudioClient_Initialize(iAudioClient, shareMode, streamFlags, 3L * hnsBufferDuration * 10000L, 0L, waveformatex, audioSessionGuid)) != 0) {
                        throw new HResultException(hresult);
                    }
                    if ((streamFlags & 0x40000) == 262144 && eventHandle != 0L) {
                        WASAPI.IAudioClient_SetEventHandle(iAudioClient, eventHandle);
                    }
                    ret = iAudioClient;
                    iAudioClient = 0L;
                }
                finally {
                    WASAPI.CoTaskMemFree(waveformatex);
                }
            }
            finally {
                if (iAudioClient != 0L) {
                    WASAPI.IAudioClient_Release(iAudioClient);
                }
            }
        }
        finally {
            WASAPI.IMMDevice_Release(iMMDevice);
        }
        return ret;
    }

    private void logUnsupportedFormats(AudioSystem.DataFlow dataFlow, MediaLocator locator, Format[] unsupportedFormats) {
        Object[] supportedFormats;
        StringBuilder msg = new StringBuilder();
        msg.append("Unsupported formats: ");
        msg.append(Arrays.toString(unsupportedFormats));
        msg.append('.');
        try {
            supportedFormats = this.getDevice(dataFlow, locator).getFormats();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            supportedFormats = null;
        }
        msg.append("Supported formats: ");
        msg.append(Arrays.toString(supportedFormats));
        msg.append('.');
        logger.error((Object)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInitializeAEC() {
        if (this.aecIMediaObject != 0L || this.aecSupportedFormats != null) {
            return;
        }
        try {
            long iMediaObject = this.initializeAEC();
            try {
                List<AudioFormat> supportedFormats = this.getIMediaObjectSupportedFormats(iMediaObject);
                if (!supportedFormats.isEmpty()) {
                    this.aecIMediaObject = iMediaObject;
                    iMediaObject = 0L;
                    this.aecSupportedFormats = Collections.unmodifiableList(supportedFormats);
                }
            }
            finally {
                if (iMediaObject != 0L) {
                    VoiceCaptureDSP.IMediaObject_Release(iMediaObject);
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"Failed to initialize acoustic echo cancellation (AEC)", t);
        }
    }

    private void maybeUninitializeAEC() {
        try {
            if (this.aecIMediaObject != 0L) {
                VoiceCaptureDSP.IMediaObject_Release(this.aecIMediaObject);
                this.aecIMediaObject = 0L;
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"Failed to uninitialize acoustic echo cancellation (AEC)", t);
        }
    }

    @Override
    protected void postInitialize() throws Exception {
        try {
            super.postInitialize();
        }
        finally {
            if (this.waveformatex != 0L) {
                WASAPI.CoTaskMemFree(this.waveformatex);
                this.waveformatex = 0L;
            }
        }
    }

    @Override
    protected void preInitialize() throws Exception {
        super.preInitialize();
        if (this.waveformatex != 0L) {
            WASAPI.CoTaskMemFree(this.waveformatex);
            this.waveformatex = 0L;
        }
        this.waveformatex = WASAPI.WAVEFORMATEX_alloc();
        if (this.waveformatex == 0L) {
            throw new OutOfMemoryError("WAVEFORMATEX_alloc");
        }
        if (this.pNotify == null) {
            this.pNotify = new IMMNotificationClient(){

                @Override
                public void OnDefaultDeviceChanged(int flow, int role, String pwstrDefaultDevice) {
                }

                @Override
                public void OnDeviceAdded(String pwstrDeviceId) {
                    WASAPISystem.this.reinitialize(pwstrDeviceId);
                }

                @Override
                public void OnDeviceRemoved(String pwstrDeviceId) {
                    WASAPISystem.this.reinitialize(pwstrDeviceId);
                }

                @Override
                public void OnDeviceStateChanged(String pwstrDeviceId, int dwNewState) {
                    WASAPISystem.this.reinitialize(pwstrDeviceId);
                }

                @Override
                public void OnPropertyValueChanged(String pwstrDeviceId, long key) {
                }
            };
        }
        if (audioSessionGuid == null) {
            try {
                audioSessionGuid = WASAPI.CoCreateGuid();
            }
            catch (HResultException hre) {
                logger.warn((Object)"Failed to generate a new audio session GUID", (Throwable)hre);
            }
        }
    }

    private void reinitialize(String deviceId) {
        try {
            WASAPISystem.invokeDeviceSystemInitialize(this, true);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to reinitialize " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "Windows Audio Session API (WASAPI)";
    }

    static {
        logger = Logger.getLogger(WASAPISystem.class);
    }
}

