/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.format.AudioMediaFormatImpl;
import org.jitsi.impl.neomedia.format.MediaFormatImpl;
import org.jitsi.impl.neomedia.format.VideoMediaFormatImpl;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.neomedia.format.MediaFormatFactory;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.Logger;

public class MediaFormatFactoryImpl
implements MediaFormatFactory {
    private static final Logger logger = Logger.getLogger(MediaFormatFactoryImpl.class);

    @Override
    public MediaFormat createUnknownMediaFormat(MediaType type) {
        VideoFormat unknown = null;
        if (type.equals((Object)MediaType.AUDIO)) {
            unknown = new VideoFormat("unknown");
        } else if (type.equals((Object)MediaType.VIDEO)) {
            unknown = new AudioFormat("unknown");
        }
        return MediaFormatImpl.createInstance((Format)unknown);
    }

    @Override
    public MediaFormat createMediaFormat(String encoding) {
        return this.createMediaFormat(encoding, -1.0);
    }

    @Override
    public MediaFormat createMediaFormat(byte rtpPayloadType) {
        for (MediaFormat rtpPayloadTypeMediaFormat : MediaUtils.getMediaFormats(rtpPayloadType)) {
            MediaFormat mediaFormat = this.createMediaFormat(rtpPayloadTypeMediaFormat.getEncoding(), rtpPayloadTypeMediaFormat.getClockRate());
            if (mediaFormat == null) continue;
            return mediaFormat;
        }
        return null;
    }

    @Override
    public MediaFormat createMediaFormat(String encoding, double clockRate) {
        return this.createMediaFormat(encoding, clockRate, 1);
    }

    @Override
    public MediaFormat createMediaFormat(String encoding, double clockRate, int channels) {
        return this.createMediaFormat(encoding, clockRate, channels, null);
    }

    private MediaFormat createMediaFormat(String encoding, double clockRate, int channels, Map<String, String> fmtps) {
        for (MediaFormat format : this.getSupportedMediaFormats(encoding, clockRate)) {
            if (!format.matches(format.getMediaType(), format.getEncoding(), format.getClockRate(), channels, fmtps)) continue;
            return format;
        }
        return null;
    }

    @Override
    public MediaFormat createMediaFormat(String encoding, double clockRate, Map<String, String> formatParams, Map<String, String> advancedParams) {
        return this.createMediaFormat(encoding, clockRate, 1, -1.0f, formatParams, advancedParams);
    }

    @Override
    public MediaFormat createMediaFormat(String encoding, double clockRate, int channels, float frameRate, Map<String, String> formatParams, Map<String, String> advancedParams) {
        MediaFormat mediaFormat = this.createMediaFormat(encoding, clockRate, channels, formatParams);
        if (mediaFormat == null) {
            return null;
        }
        Map<String, String> formatParameters = null;
        Map<String, String> advancedParameters = null;
        if (formatParams != null && !formatParams.isEmpty()) {
            formatParameters = formatParams;
        }
        if (advancedParams != null && !advancedParams.isEmpty()) {
            advancedParameters = advancedParams;
        }
        if (formatParameters != null || advancedParameters != null) {
            switch (mediaFormat.getMediaType()) {
                case AUDIO: {
                    mediaFormat = new AudioMediaFormatImpl((AudioFormat)((AudioMediaFormatImpl)mediaFormat).getFormat(), formatParameters, advancedParameters);
                    break;
                }
                case VIDEO: {
                    VideoMediaFormatImpl videoMediaFormatImpl = (VideoMediaFormatImpl)mediaFormat;
                    mediaFormat = new VideoMediaFormatImpl((VideoFormat)videoMediaFormatImpl.getFormat(), videoMediaFormatImpl.getClockRate(), frameRate, formatParameters, advancedParameters);
                    break;
                }
                default: {
                    mediaFormat = null;
                }
            }
        }
        return mediaFormat;
    }

    @Override
    public MediaFormat createMediaFormat(byte rtpPayloadType, String encoding, double clockRate, int channels, float frameRate, Map<String, String> formatParams, Map<String, String> advancedParams) {
        MediaFormat[] rtpPayloadTypeMediaFormats;
        if (-1 != rtpPayloadType && (encoding == null || -1.0 == clockRate) && (rtpPayloadTypeMediaFormats = MediaUtils.getMediaFormats(rtpPayloadType)).length > 0) {
            if (encoding == null) {
                encoding = rtpPayloadTypeMediaFormats[0].getEncoding();
            }
            if (-1.0 == clockRate) {
                clockRate = rtpPayloadTypeMediaFormats[0].getClockRate();
            } else {
                boolean clockRateIsValid = false;
                for (MediaFormat rtpPayloadTypeMediaFormat : rtpPayloadTypeMediaFormats) {
                    if (!rtpPayloadTypeMediaFormat.getEncoding().equals(encoding) || rtpPayloadTypeMediaFormat.getClockRate() != clockRate) continue;
                    clockRateIsValid = true;
                    break;
                }
                if (!clockRateIsValid) {
                    return null;
                }
            }
        }
        return this.createMediaFormat(encoding, clockRate, channels, frameRate, formatParams, advancedParams);
    }

    private List<MediaFormat> getMatchingMediaFormats(MediaFormat[] mediaFormats, String encoding, double clockRate) {
        if ("G722".equalsIgnoreCase(encoding) && 16000.0 == clockRate) {
            clockRate = 8000.0;
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Suppressing erroneous 16000 announcement for G.722");
            }
        }
        ArrayList<MediaFormat> supportedMediaFormats = new ArrayList<MediaFormat>();
        for (MediaFormat mediaFormat : mediaFormats) {
            if (!mediaFormat.getEncoding().equalsIgnoreCase(encoding) || -1.0 != clockRate && mediaFormat.getClockRate() != clockRate) continue;
            supportedMediaFormats.add(mediaFormat);
        }
        return supportedMediaFormats;
    }

    private List<MediaFormat> getSupportedMediaFormats(String encoding, double clockRate) {
        EncodingConfiguration encodingConfiguration = NeomediaServiceUtils.getMediaServiceImpl().getCurrentEncodingConfiguration();
        List<MediaFormat> supportedMediaFormats = this.getMatchingMediaFormats(encodingConfiguration.getAllEncodings(MediaType.AUDIO), encoding, clockRate);
        if (supportedMediaFormats.isEmpty()) {
            supportedMediaFormats = this.getMatchingMediaFormats(encodingConfiguration.getAllEncodings(MediaType.VIDEO), encoding, clockRate);
        }
        return supportedMediaFormats;
    }
}

