/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.notify;

import java.io.IOException;
import java.io.InputStream;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.audio.speex.SpeexResampler;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.service.audionotifier.AbstractSCAudioClip;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.utils.logging.Logger;

public class AudioSystemClipImpl
extends AbstractSCAudioClip {
    private static final int DEFAULT_BUFFER_DATA_LENGTH = 8192;
    private static final Logger logger = Logger.getLogger(AudioSystemClipImpl.class);
    private static final long MIN_AUDIO_STREAM_DURATION = 200L;
    private final AudioSystem audioSystem;
    private Buffer buffer;
    private byte[] bufferData;
    private final boolean playback;
    private Renderer renderer;

    public AudioSystemClipImpl(String url, AudioNotifierService audioNotifier, AudioSystem audioSystem, boolean playback) throws IOException {
        super(url, audioNotifier);
        this.audioSystem = audioSystem;
        this.playback = playback;
    }

    @Override
    protected void enterRunInPlayThread() {
        this.buffer = new Buffer();
        this.bufferData = new byte[8192];
        this.buffer.setData((Object)this.bufferData);
        this.renderer = this.audioSystem.createRenderer(this.playback);
    }

    @Override
    protected void exitRunInPlayThread() {
        this.buffer = null;
        this.bufferData = null;
        this.renderer = null;
    }

    @Override
    protected void exitRunOnceInPlayThread() {
        try {
            this.renderer.stop();
        }
        finally {
            this.renderer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected boolean runOnceInPlayThread() {
        AudioFormat resamplerFormat;
        AudioFormat rendererFormat;
        if (this.renderer == null) return false;
        if (this.buffer == null) {
            return false;
        }
        InputStream audioStream = null;
        try {
            audioStream = this.audioSystem.getAudioInputStream(this.uri);
        }
        catch (IOException ioex) {
            logger.error((Object)("Failed to get audio stream " + this.uri), (Throwable)ioex);
        }
        if (audioStream == null) {
            return false;
        }
        Object resampler = null;
        boolean success = true;
        AudioFormat audioStreamFormat = null;
        int audioStreamLength = 0;
        long rendererProcessStartTime = 0L;
        try {
            rendererFormat = audioStreamFormat = this.audioSystem.getFormat(audioStream);
            if (rendererFormat == null) {
                boolean bl = false;
                return bl;
            }
            resamplerFormat = null;
            if (this.renderer.setInputFormat((Format)rendererFormat) == null) {
                resampler = new SpeexResampler();
                resamplerFormat = rendererFormat;
                resampler.setInputFormat((Format)resamplerFormat);
                Format[] supportedResamplerFormats = resampler.getSupportedOutputFormats((Format)resamplerFormat);
                block35: for (Format supportedRendererFormat : this.renderer.getSupportedInputFormats()) {
                    for (Format supportedResamplerFormat : supportedResamplerFormats) {
                        if (!supportedRendererFormat.matches(supportedResamplerFormat)) continue;
                        rendererFormat = supportedRendererFormat;
                        resampler.setOutputFormat((Format)rendererFormat);
                        this.renderer.setInputFormat((Format)rendererFormat);
                        continue block35;
                    }
                }
            }
        }
        catch (ResourceUnavailableException ruex) {
            if (resampler == null) return success;
            logger.error((Object)("Failed to open " + resampler.getClass().getName()), (Throwable)ruex);
            success = false;
            return success;
        }
        Buffer rendererBuffer = this.buffer;
        rendererBuffer.setFormat((Format)rendererFormat);
        if (resampler == null) {
            Object var11_40 = null;
        } else {
            Buffer buffer = new Buffer();
            int bufferDataLength = 8192;
            if (resamplerFormat instanceof AudioFormat) {
                AudioFormat af = resamplerFormat;
                int frameSize = af.getSampleSizeInBits() / 8 * af.getChannels();
                bufferDataLength = bufferDataLength / frameSize * frameSize;
            }
            this.bufferData = new byte[bufferDataLength];
            buffer.setData((Object)this.bufferData);
            buffer.setFormat((Format)resamplerFormat);
            resampler.open();
        }
        try {
            this.renderer.open();
            this.renderer.start();
            block37: while (this.isStarted()) {
                int rendererProcess;
                int bufferLength = audioStream.read(this.bufferData);
                if (bufferLength == -1) return success;
                audioStreamLength += bufferLength;
                if (resampler == null) {
                    rendererBuffer.setLength(bufferLength);
                    rendererBuffer.setOffset(0);
                } else {
                    void var11_42;
                    var11_42.setLength(bufferLength);
                    var11_42.setOffset(0);
                    rendererBuffer.setLength(0);
                    rendererBuffer.setOffset(0);
                    resampler.process((Buffer)var11_42, rendererBuffer);
                }
                if (rendererProcessStartTime == 0L) {
                    rendererProcessStartTime = System.currentTimeMillis();
                }
                do {
                    if ((rendererProcess = this.renderer.process(rendererBuffer)) != 1) continue;
                    logger.error((Object)("Failed to render audio stream " + this.uri));
                    success = false;
                    continue block37;
                } while ((rendererProcess & 2) == 2);
            }
            return success;
        }
        catch (IOException ioex) {
            logger.error((Object)("Failed to read from audio stream " + this.uri), (Throwable)ioex);
            return false;
        }
        catch (ResourceUnavailableException ruex) {
            logger.error((Object)("Failed to open " + this.renderer.getClass().getName()), (Throwable)ruex);
            return false;
        }
        finally {
            long audioStreamDuration;
            try {
                audioStream.close();
            }
            catch (IOException ruex) {}
            if (resampler != null) {
                resampler.close();
            }
            if (success && audioStreamFormat != null && audioStreamLength > 0 && rendererProcessStartTime > 0L && this.isStarted() && (audioStreamDuration = (audioStreamFormat.computeDuration((long)audioStreamLength) + 999999L) / 1000000L) > 0L) {
                audioStreamDuration += 200L;
                boolean interrupted = false;
                Object object = this.sync;
            }
        }
    }
}

