/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import org.jitsi.impl.neomedia.rtcp.RTCPSenderInfoUtils;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTPUtils;

public class ResumableStreamRewriter {
    int seqnumDelta = 0;
    private long timestampDelta = 0L;
    int highestSequenceNumberSent = -1;
    private long highestTimestampSent = -1L;

    public boolean rewriteRTP(boolean accept, byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len) {
            return false;
        }
        int sequenceNumber = RawPacket.getSequenceNumber(buf, off, len);
        int newSequenceNumber = this.rewriteSequenceNumber(accept, sequenceNumber);
        long timestamp = RawPacket.getTimestamp(buf, off, len);
        long newTimestamp = this.rewriteTimestamp(accept, timestamp);
        boolean modified = false;
        if (sequenceNumber != newSequenceNumber) {
            RawPacket.setSequenceNumber(buf, off, newSequenceNumber);
            modified = true;
        }
        if (timestamp != newTimestamp) {
            RawPacket.setTimestamp(buf, off, len, newTimestamp);
            modified = true;
        }
        return modified;
    }

    public boolean processRTCP(boolean rewrite, byte[] buf, int off, int len) {
        if (this.timestampDelta == 0L) {
            return false;
        }
        long ts = RTCPSenderInfoUtils.getTimestamp(buf, off, len);
        if (ts == -1L) {
            return false;
        }
        long newTs = rewrite ? ts - this.timestampDelta & 0xFFFFFFFFL : ts + this.timestampDelta & 0xFFFFFFFFL;
        int ret = RTCPSenderInfoUtils.setTimestamp(buf, off, len, (int)newTs);
        return ret > 0;
    }

    int rewriteSequenceNumber(boolean accept, int sequenceNumber) {
        int newDelta;
        if (accept) {
            int newSequenceNumber = RTPUtils.subtractNumber(sequenceNumber, this.seqnumDelta);
            if (this.highestSequenceNumberSent == -1 || RTPUtils.getSequenceNumberDelta(newSequenceNumber, this.highestSequenceNumberSent) > 0) {
                this.highestSequenceNumberSent = newSequenceNumber;
            }
            return newSequenceNumber;
        }
        if (this.highestSequenceNumberSent != -1 && RTPUtils.getSequenceNumberDelta(newDelta = RTPUtils.subtractNumber(sequenceNumber, this.highestSequenceNumberSent), this.seqnumDelta) > 0) {
            this.seqnumDelta = newDelta;
        }
        return sequenceNumber;
    }

    private long rewriteTimestamp(boolean accept, long timestamp) {
        long newDelta;
        if (accept) {
            long newTimestamp = timestamp - this.timestampDelta & 0xFFFFFFFFL;
            if (this.highestTimestampSent == -1L || RTPUtils.rtpTimestampDiff(newTimestamp, this.highestTimestampSent) > 0L) {
                this.highestTimestampSent = newTimestamp;
            }
            return newTimestamp;
        }
        if (this.highestTimestampSent != -1L && RTPUtils.rtpTimestampDiff(newDelta = timestamp - this.highestTimestampSent & 0xFFFFFFFFL, this.timestampDelta) > 0L) {
            this.timestampDelta = newDelta;
        }
        return timestamp;
    }
}

