/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class StringCache<T> {
    private final Map<String, SoftReference<T>> stringCache = new ConcurrentHashMap<String, SoftReference<T>>();

    protected abstract T process(String var1);

    public boolean containsKey(String input) {
        return this.stringCache.containsKey(input);
    }

    public void put(String input, T value) {
        this.stringCache.put(input, new SoftReference<T>(value));
    }

    public T get(String input) {
        T out;
        if (input == null) {
            return null;
        }
        SoftReference<T> ref = this.stringCache.get(input);
        if (ref == null || ref.get() == null) {
            out = this.process(input);
            ref = new SoftReference<T>(out);
            this.stringCache.put(input, ref);
        } else {
            out = ref.get();
        }
        return out;
    }
}

