/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class WebSocketCodec {
    private static StackLogger logger = CommonLogger.getLogger(WebSocketCodec.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private int fragmentedFramesCount;
    private boolean frameFinalFlag;
    private int frameRsv;
    private int frameOpcode;
    private long framePayloadLength;
    private byte[] maskingKey = new byte[4];
    private final boolean allowExtensions;
    private final boolean maskedPayload;
    private boolean closeOpcodeReceived;
    private int payloadStartIndex = -1;
    private byte[] buffer = new byte[66000];
    private int writeIndex = 0;
    private int readIndex;
    private long totalPacketLength = -1L;

    public WebSocketCodec(boolean maskedPayload, boolean allowExtensions) {
        this.maskedPayload = maskedPayload;
        this.allowExtensions = allowExtensions;
    }

    private byte readNextByte() {
        if (this.readIndex >= this.writeIndex) {
            throw new IllegalStateException();
        }
        return this.buffer[this.readIndex++];
    }

    public byte[] decode(InputStream is) throws Exception {
        int bytesRead = is.read(this.buffer, this.writeIndex, this.buffer.length - this.writeIndex);
        if (bytesRead < 0) {
            bytesRead = 0;
        }
        this.writeIndex += bytesRead;
        this.readIndex = 0;
        if (this.writeIndex < 4) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Abort decode. Write index is at " + this.writeIndex);
            }
            return null;
        }
        byte b = this.readNextByte();
        this.frameFinalFlag = (b & 0x80) != 0;
        this.frameRsv = (b & 0x70) >> 4;
        this.frameOpcode = b & 0xF;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Decoding WebSocket Frame opCode=" + this.frameOpcode);
        }
        if (this.frameOpcode == 8) {
            this.closeOpcodeReceived = true;
        }
        boolean frameMasked = ((b = this.readNextByte()) & 0x80) != 0;
        int framePayloadLen1 = b & 0x7F;
        if (this.frameRsv != 0 && !this.allowExtensions) {
            this.protocolViolation("RSV != 0 and no extension negotiated, RSV:" + this.frameRsv);
            return null;
        }
        if (this.maskedPayload && !frameMasked) {
            this.protocolViolation("unmasked client to server frame");
            return null;
        }
        this.protocolChecks();
        try {
            if (framePayloadLen1 == 126) {
                int byte1 = 0xFF & this.readNextByte();
                int byte2 = 0xFF & this.readNextByte();
                int value = byte1 << 8 | byte2;
                this.framePayloadLength = value;
            } else if (framePayloadLen1 == 127) {
                long value = 0L;
                for (int q = 0; q < 8; ++q) {
                    value &= (long)((0xFF & this.readNextByte()) << 7 - q);
                }
                this.framePayloadLength = value;
                if (this.framePayloadLength < 65536L) {
                    this.protocolViolation("invalid data frame length (not using minimal length encoding): " + this.framePayloadLength);
                    return null;
                }
            } else {
                this.framePayloadLength = framePayloadLen1;
            }
            if (this.framePayloadLength < 0L) {
                this.protocolViolation("Negative payload size: " + this.framePayloadLength);
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Decoding WebSocket Frame length=" + this.framePayloadLength);
            }
            if (frameMasked) {
                for (int q = 0; q < 4; ++q) {
                    this.maskingKey[q] = this.readNextByte();
                }
            }
        }
        catch (IllegalStateException e) {
            return null;
        }
        this.payloadStartIndex = this.readIndex;
        this.totalPacketLength = (long)this.readIndex + this.framePayloadLength;
        if ((long)this.writeIndex < this.totalPacketLength) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Abort decode. Write index is at " + this.writeIndex + " and totalPacketLength is " + this.totalPacketLength);
            }
            return null;
        }
        if (frameMasked) {
            this.unmask(this.buffer, this.payloadStartIndex, (int)((long)this.payloadStartIndex + this.framePayloadLength));
        }
        byte[] plainTextBytes = new byte[(int)this.framePayloadLength];
        System.arraycopy(this.buffer, this.payloadStartIndex, plainTextBytes, 0, (int)this.framePayloadLength);
        int q = 1;
        while ((long)q < (long)this.writeIndex - this.totalPacketLength) {
            this.buffer[q] = this.buffer[(int)this.totalPacketLength + q];
            ++q;
        }
        this.writeIndex = (int)((long)this.writeIndex - this.totalPacketLength);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("writeIndex = " + this.writeIndex + " " + this.totalPacketLength);
        }
        return plainTextBytes;
    }

    protected static byte[] encode(byte[] msg, int rsv, boolean fin, boolean maskPayload) throws Exception {
        return WebSocketCodec.encode(msg, rsv, fin, maskPayload, (byte)1);
    }

    protected static byte[] encode(byte[] msg, int rsv, boolean fin, boolean maskPayload, byte opcode) throws Exception {
        ByteArrayOutputStream frame = new ByteArrayOutputStream();
        int length = msg.length;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Encoding WebSocket Frame opCode=" + opcode + " length=" + length);
        }
        int b0 = 0;
        if (fin) {
            b0 |= 0x80;
        }
        b0 |= rsv % 8 << 4;
        b0 |= opcode % 128;
        if (length <= 125) {
            frame.write(b0);
            byte b = maskPayload ? (byte)(0x80 | (byte)length) : (byte)length;
            frame.write(b);
        } else if (length <= 65535) {
            frame.write(b0);
            frame.write(maskPayload ? 254 : 126);
            frame.write(length >>> 8 & 0xFF);
            frame.write(length & 0xFF);
        } else {
            frame.write(b0);
            frame.write(maskPayload ? 255 : 127);
            for (int q = 0; q < 8; ++q) {
                frame.write(0xFF & length >> q);
            }
        }
        if (maskPayload) {
            byte[] mask = new byte[]{1, 1, 1, 1};
            frame.write(mask);
            WebSocketCodec.applyMask(msg, 0, msg.length, mask);
        }
        frame.write(msg);
        return frame.toByteArray();
    }

    private void unmask(byte[] frame, int startIndex, int endIndex) {
        WebSocketCodec.applyMask(frame, startIndex, endIndex, this.maskingKey);
    }

    public static void applyMask(byte[] frame, int startIndex, int endIndex, byte[] mask) {
        for (int i = 0; i < endIndex - startIndex; ++i) {
            frame[startIndex + i] = (byte)(frame[startIndex + i] ^ mask[i % 4]);
        }
    }

    private void protocolViolation(String reason) {
        throw new RuntimeException(reason);
    }

    private void protocolChecks() {
        if (this.frameOpcode > 7) {
            if (!this.frameFinalFlag) {
                this.protocolViolation("fragmented control frame");
            }
            if (this.frameOpcode != 8 && this.frameOpcode != 9 && this.frameOpcode != 10) {
                this.protocolViolation("control frame using reserved opcode " + this.frameOpcode);
            }
        } else {
            if (this.frameOpcode != 0 && this.frameOpcode != 1 && this.frameOpcode != 2) {
                this.protocolViolation("data frame using reserved opcode " + this.frameOpcode);
            }
            if (this.fragmentedFramesCount == 0 && this.frameOpcode == 0) {
                this.protocolViolation("received continuation data frame outside fragmented message");
            }
            if (this.fragmentedFramesCount != 0 && this.frameOpcode != 0 && this.frameOpcode != 9) {
                this.protocolViolation("received non-continuation data frame while inside fragmented message");
            }
        }
    }

    public boolean isCloseOpcodeReceived() {
        return this.closeOpcodeReceived;
    }
}

