/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.HasName;
import io.github.classgraph.ObjectTypedValueWrapper;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanResultObject;
import java.lang.reflect.Array;
import java.util.Objects;
import java.util.Set;

public class AnnotationParameterValue
extends ScanResultObject
implements HasName,
Comparable<AnnotationParameterValue> {
    private String name;
    private ObjectTypedValueWrapper value;

    AnnotationParameterValue() {
    }

    AnnotationParameterValue(String name, Object value) {
        this.name = name;
        this.value = new ObjectTypedValueWrapper(value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value == null ? null : this.value.get();
    }

    void setValue(Object newValue) {
        this.value = new ObjectTypedValueWrapper(newValue);
    }

    @Override
    protected String getClassName() {
        throw new IllegalArgumentException("getClassName() cannot be called here");
    }

    @Override
    protected ClassInfo getClassInfo() {
        throw new IllegalArgumentException("getClassInfo() cannot be called here");
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.value != null) {
            this.value.setScanResult(scanResult);
        }
    }

    @Override
    void findReferencedClassNames(Set<String> referencedClassNames) {
        if (this.value != null) {
            this.value.findReferencedClassNames(referencedClassNames);
        }
    }

    void convertWrapperArraysToPrimitiveArrays(ClassInfo annotationClassInfo) {
        if (this.value != null) {
            this.value.convertWrapperArraysToPrimitiveArrays(annotationClassInfo, this.name);
        }
    }

    Object instantiate(ClassInfo annotationClassInfo) {
        return this.value.instantiateOrGet(annotationClassInfo, this.name);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    void toString(StringBuilder buf) {
        buf.append(this.name);
        buf.append(" = ");
        this.toStringParamValueOnly(buf);
    }

    void toStringParamValueOnly(StringBuilder buf) {
        if (this.value == null) {
            buf.append("null");
        } else {
            Object paramVal = this.value.get();
            Class<?> valClass = paramVal.getClass();
            if (valClass.isArray()) {
                buf.append('{');
                int n = Array.getLength(paramVal);
                for (int j = 0; j < n; ++j) {
                    Object elt;
                    if (j > 0) {
                        buf.append(", ");
                    }
                    buf.append((elt = Array.get(paramVal, j)) == null ? "null" : elt.toString());
                }
                buf.append('}');
            } else if (paramVal instanceof String) {
                buf.append('\"');
                buf.append(paramVal.toString().replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r"));
                buf.append('\"');
            } else if (paramVal instanceof Character) {
                buf.append('\'');
                buf.append(paramVal.toString().replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r"));
                buf.append('\'');
            } else {
                buf.append(paramVal.toString());
            }
        }
    }

    @Override
    public int compareTo(AnnotationParameterValue o) {
        int diff = this.name.compareTo(o.getName());
        if (diff != 0) {
            return diff;
        }
        Object p0 = this.getValue();
        Object p1 = o.getValue();
        return p0 == null || p1 == null ? (p0 == null ? 0 : 1) - (p1 == null ? 0 : 1) : p0.toString().compareTo(p1.toString());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotationParameterValue)) {
            return false;
        }
        AnnotationParameterValue o = (AnnotationParameterValue)obj;
        return this.compareTo(o) == 0 && this.value == null == (o.value == null) && (this.value == null || this.value.equals(o.value));
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }
}

