/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.concurrency;

import io.github.classgraph.ClassGraphException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import nonapi.io.github.classgraph.utils.LogNode;

public abstract class SingletonMap<K, V> {
    private final ConcurrentMap<K, SingletonHolder<V>> map = new ConcurrentHashMap<K, SingletonHolder<V>>();

    public abstract V newInstance(K var1, LogNode var2) throws Exception, InterruptedException;

    public V get(K key, LogNode log) throws Exception, InterruptedException {
        SingletonHolder singletonHolder = (SingletonHolder)this.map.get(key);
        Object instance = null;
        if (singletonHolder != null) {
            instance = singletonHolder.get();
        } else {
            SingletonHolder<Object> newSingletonHolder = new SingletonHolder<Object>();
            SingletonHolder oldSingletonHolder = this.map.putIfAbsent(key, newSingletonHolder);
            if (oldSingletonHolder != null) {
                instance = oldSingletonHolder.get();
            } else {
                try {
                    instance = this.newInstance(key, log);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    ((SingletonHolder)newSingletonHolder).exception = e;
                    throw e;
                }
                finally {
                    newSingletonHolder.set(instance);
                }
            }
        }
        if (instance == null) {
            throw new NullPointerException("newInstance returned null for key " + key);
        }
        return instance;
    }

    public List<V> values() throws InterruptedException {
        ArrayList entries = new ArrayList(this.map.size());
        for (Map.Entry ent : this.map.entrySet()) {
            Object entryValue = ((SingletonHolder)ent.getValue()).getOrNull();
            if (entryValue == null) continue;
            entries.add(entryValue);
        }
        return entries;
    }

    public void clear() {
        this.map.clear();
    }

    private static class SingletonHolder<V> {
        private V singleton;
        private Exception exception;
        private final CountDownLatch initialized = new CountDownLatch(1);

        private SingletonHolder() {
        }

        void set(V singleton) throws ClassGraphException {
            if (this.initialized.getCount() < 1L) {
                throw new ClassGraphException("Singleton already initialized");
            }
            this.singleton = singleton;
            this.initialized.countDown();
            if (this.initialized.getCount() != 0L) {
                throw new ClassGraphException("Singleton initialized more than once");
            }
        }

        V get() throws Exception {
            this.initialized.await();
            if (this.exception != null) {
                throw this.exception;
            }
            return this.singleton;
        }

        V getOrNull() throws InterruptedException {
            this.initialized.await();
            return this.singleton;
        }
    }
}

